/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class InventorySubcontainer
implements IInventory,
AutoRecipeOutput {
    private final int b;
    public final NonNullList<ItemStack> c;
    @Nullable
    private List<IInventoryListener> d;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    protected InventoryHolder bukkitOwner;

    @Override
    public List<ItemStack> getContents() {
        return this.c;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int M_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i2) {
        this.maxStack = i2;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.bukkitOwner;
    }

    @Override
    public Location getLocation() {
        return null;
    }

    public InventorySubcontainer(InventorySubcontainer original) {
        this(original.b);
        for (int slot = 0; slot < original.b; ++slot) {
            this.c.set(slot, original.c.get(slot).m());
        }
    }

    public InventorySubcontainer(int size) {
        this(size, null);
    }

    public InventorySubcontainer(int i2, InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.b = i2;
        this.c = NonNullList.a(i2, ItemStack.b);
    }

    public InventorySubcontainer(ItemStack ... items) {
        this.b = items.length;
        this.c = NonNullList.a(ItemStack.b, items);
    }

    public void a(IInventoryListener listener) {
        if (this.d == null) {
            this.d = Lists.newArrayList();
        }
        this.d.add(listener);
    }

    public void b(IInventoryListener listener) {
        if (this.d != null) {
            this.d.remove(listener);
        }
    }

    @Override
    public ItemStack a(int slot) {
        return slot >= 0 && slot < this.c.size() ? this.c.get(slot) : ItemStack.b;
    }

    public List<ItemStack> f() {
        List<ItemStack> list = this.c.stream().filter(itemstack -> !itemstack.b()).collect(Collectors.toList());
        this.a();
        return list;
    }

    @Override
    public ItemStack a(int slot, int amount) {
        ItemStack itemstack = ContainerUtil.a(this.c, slot, amount);
        if (!itemstack.b()) {
            this.e();
        }
        return itemstack;
    }

    public ItemStack a(Item item, int count) {
        ItemStack itemstack = new ItemStack(item, 0);
        for (int j2 = this.b - 1; j2 >= 0; --j2) {
            ItemStack itemstack1 = this.a(j2);
            if (!itemstack1.c().equals(item)) continue;
            int k2 = count - itemstack.I();
            ItemStack itemstack2 = itemstack1.a(k2);
            itemstack.f(itemstack2.I());
            if (itemstack.I() == count) break;
        }
        if (!itemstack.b()) {
            this.e();
        }
        return itemstack;
    }

    public ItemStack a(ItemStack stack) {
        ItemStack itemstack1 = stack.m();
        this.d(itemstack1);
        if (itemstack1.b()) {
            return ItemStack.b;
        }
        this.c(itemstack1);
        return itemstack1.b() ? ItemStack.b : itemstack1;
    }

    public boolean b(ItemStack stack) {
        boolean flag = false;
        for (ItemStack itemstack1 : this.c) {
            if (!itemstack1.b() && (!ItemStack.e(itemstack1, stack) || itemstack1.I() >= itemstack1.d())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack b(int slot) {
        ItemStack itemstack = this.c.get(slot);
        if (itemstack.b()) {
            return ItemStack.b;
        }
        this.c.set(slot, ItemStack.b);
        return itemstack;
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.c.set(slot, stack);
        if (!stack.b() && stack.I() > this.M_()) {
            stack.e(this.M_());
        }
        this.e();
    }

    @Override
    public int b() {
        return this.b;
    }

    @Override
    public boolean c() {
        ItemStack itemstack;
        Iterator iterator = this.c.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public void e() {
        if (this.d != null) {
            for (IInventoryListener iinventorylistener : this.d) {
                iinventorylistener.a(this);
            }
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    @Override
    public void a() {
        this.c.clear();
        this.e();
    }

    @Override
    public void a(AutoRecipeStackManager finder) {
        for (ItemStack itemstack : this.c) {
            finder.b(itemstack);
        }
    }

    public String toString() {
        return this.c.stream().filter(itemstack -> !itemstack.b()).collect(Collectors.toList()).toString();
    }

    private void c(ItemStack stack) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            ItemStack itemstack1 = this.a(i2);
            if (!itemstack1.b()) continue;
            this.a(i2, stack.m());
            stack.e(0);
            return;
        }
    }

    private void d(ItemStack stack) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            ItemStack itemstack1 = this.a(i2);
            if (!ItemStack.e(itemstack1, stack)) continue;
            this.a(stack, itemstack1);
            if (!stack.b()) continue;
            return;
        }
    }

    private void a(ItemStack source, ItemStack target) {
        int i2 = Math.min(this.M_(), target.d());
        int j2 = Math.min(source.I(), i2 - target.I());
        if (j2 > 0) {
            target.f(j2);
            source.g(j2);
            this.e();
        }
    }

    public void a(NBTTagList nbtList) {
        for (int i2 = 0; i2 < nbtList.size(); ++i2) {
            ItemStack itemstack = ItemStack.a(nbtList.a(i2));
            if (itemstack.b()) continue;
            this.a(itemstack);
        }
    }

    public NBTTagList g() {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i2 = 0; i2 < this.b(); ++i2) {
            ItemStack itemstack = this.a(i2);
            if (itemstack.b()) continue;
            nbttaglist.add(itemstack.b(new NBTTagCompound()));
        }
        return nbttaglist;
    }
}

