/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataConverterTrappedChest
extends DataFix {
    private static final Logger a = LogManager.getLogger();
    private static final int b = 4096;
    private static final short c = 12;

    public DataConverterTrappedChest(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.c);
        Type type2 = type.findFieldType("Level");
        Type type3 = type2.findFieldType("TileEntities");
        if (!(type3 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType listType = (List.ListType)type3;
        OpticFinder opticFinder = DSL.fieldFinder((String)"TileEntities", (Type)listType);
        Type type4 = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder2 = type4.findField("Level");
        OpticFinder opticFinder3 = opticFinder2.type().findField("Sections");
        Type type5 = opticFinder3.type();
        if (!(type5 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        Type type6 = ((List.ListType)type5).getElement();
        OpticFinder opticFinder4 = DSL.typeFinder((Type)type6);
        return TypeRewriteRule.seq((TypeRewriteRule)new DataConverterAddChoices(this.getOutputSchema(), "AddTrappedChestFix", DataConverterTypes.l).makeRule(), (TypeRewriteRule)this.fixTypeEverywhereTyped("Trapped Chest fix", type4, typed2 -> typed2.updateTyped(opticFinder2, typed -> {
            Optional optional = typed.getOptionalTyped(opticFinder3);
            if (!optional.isPresent()) {
                return typed;
            }
            List list = ((Typed)optional.get()).getAllTyped(opticFinder4);
            IntOpenHashSet intSet = new IntOpenHashSet();
            for (Typed typed2 : list) {
                a trappedChestSection = new a(typed2, this.getInputSchema());
                if (trappedChestSection.b()) continue;
                for (int i2 = 0; i2 < 4096; ++i2) {
                    int j2 = trappedChestSection.c(i2);
                    if (!trappedChestSection.a(j2)) continue;
                    intSet.add(trappedChestSection.c() << 12 | i2);
                }
            }
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)typed.get(DSL.remainderFinder()))));
            int k2 = dynamic.get("xPos").asInt(0);
            int l2 = dynamic.get("zPos").asInt(0);
            TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.l);
            return typed.updateTyped(opticFinder, arg_0 -> DataConverterTrappedChest.a(taggedChoiceType, k2, l2, (IntSet)intSet, arg_0));
        })));
    }

    private static /* synthetic */ Typed a(TaggedChoice.TaggedChoiceType taggedChoiceType, int i2, int j2, IntSet intSet, Typed typed2) {
        return typed2.updateTyped(taggedChoiceType.finder(), typed -> {
            int m2;
            int l2;
            Dynamic dynamic = (Dynamic)((Object)((Object)typed.getOrCreate(DSL.remainderFinder())));
            int k2 = dynamic.get("x").asInt(0) - (i2 << 4);
            if (intSet.contains(DataConverterLeaves.a(k2, l2 = dynamic.get("y").asInt(0), m2 = dynamic.get("z").asInt(0) - (j2 << 4)))) {
                return typed.update(taggedChoiceType.finder(), pair -> pair.mapFirst(string -> {
                    if (!Objects.equals(string, "minecraft:chest")) {
                        a.warn("Block Entity was expected to be a chest");
                    }
                    return "minecraft:trapped_chest";
                }));
            }
            return typed;
        });
    }

    public static final class a
    extends DataConverterLeaves.b {
        @Nullable
        private IntSet h;

        public a(Typed<?> typed, Schema schema) {
            super(typed, schema);
        }

        @Override
        @Override
        protected boolean a() {
            this.h = new IntOpenHashSet();
            for (int i2 = 0; i2 < this.e.size(); ++i2) {
                Dynamic<?> dynamic = this.e.get(i2);
                String string = dynamic.get("Name").asString("");
                if (!Objects.equals(string, "minecraft:trapped_chest")) continue;
                this.h.add(i2);
            }
            return this.h.isEmpty();
        }

        public boolean a(int index) {
            return this.h.contains(index);
        }
    }
}

