/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterEntityProjectileOwner
extends DataFix {
    public DataConverterEntityProjectileOwner(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        return this.fixTypeEverywhereTyped("EntityProjectileOwner", schema.getType(DataConverterTypes.q), this::a);
    }

    private Typed<?> a(Typed<?> typed) {
        typed = this.a(typed, "minecraft:egg", this::d);
        typed = this.a(typed, "minecraft:ender_pearl", this::d);
        typed = this.a(typed, "minecraft:experience_bottle", this::d);
        typed = this.a(typed, "minecraft:snowball", this::d);
        typed = this.a(typed, "minecraft:potion", this::d);
        typed = this.a(typed, "minecraft:potion", this::c);
        typed = this.a(typed, "minecraft:llama_spit", this::b);
        typed = this.a(typed, "minecraft:arrow", this::a);
        typed = this.a(typed, "minecraft:spectral_arrow", this::a);
        typed = this.a(typed, "minecraft:trident", this::a);
        return typed;
    }

    private Dynamic<?> a(Dynamic<?> dynamic) {
        long l2 = dynamic.get("OwnerUUIDMost").asLong(0L);
        long m2 = dynamic.get("OwnerUUIDLeast").asLong(0L);
        return this.a(dynamic, l2, m2).remove("OwnerUUIDMost").remove("OwnerUUIDLeast");
    }

    private Dynamic<?> b(Dynamic<?> dynamic) {
        OptionalDynamic<?> optionalDynamic = dynamic.get("Owner");
        long l2 = optionalDynamic.get("OwnerUUIDMost").asLong(0L);
        long m2 = optionalDynamic.get("OwnerUUIDLeast").asLong(0L);
        return this.a(dynamic, l2, m2).remove("Owner");
    }

    private Dynamic<?> c(Dynamic<?> dynamic) {
        OptionalDynamic<?> optionalDynamic = dynamic.get("Potion");
        return dynamic.set("Item", optionalDynamic.orElseEmptyMap()).remove("Potion");
    }

    private Dynamic<?> d(Dynamic<?> dynamic) {
        String string = "owner";
        OptionalDynamic<?> optionalDynamic = dynamic.get("owner");
        long l2 = optionalDynamic.get("M").asLong(0L);
        long m2 = optionalDynamic.get("L").asLong(0L);
        return this.a(dynamic, l2, m2).remove("owner");
    }

    private Dynamic<?> a(Dynamic<?> dynamic, long most, long least) {
        String string = "OwnerUUID";
        if (most != 0L && least != 0L) {
            return dynamic.set("OwnerUUID", dynamic.createIntList(Arrays.stream(DataConverterEntityProjectileOwner.a(most, least))));
        }
        return dynamic;
    }

    private static int[] a(long most, long least) {
        return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
    }

    private Typed<?> a(Typed<?> typed2, String string, Function<Dynamic<?>, Dynamic<?>> function) {
        Type type = this.getInputSchema().getChoiceType(DataConverterTypes.q, string);
        Type type2 = this.getOutputSchema().getChoiceType(DataConverterTypes.q, string);
        return typed2.updateTyped(DSL.namedChoice((String)string, (Type)type), type2, typed -> typed.update(DSL.remainderFinder(), function));
    }
}

