/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBedBlock
extends DataFix {
    public DataConverterBedBlock(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.c);
        Type type2 = type.findFieldType("Level");
        Type type3 = type2.findFieldType("TileEntities");
        if (!(type3 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType listType = (List.ListType)type3;
        return this.a(type2, listType);
    }

    private <TE> TypeRewriteRule a(Type<?> level, List.ListType<TE> blockEntities) {
        Type type = blockEntities.getElement();
        OpticFinder opticFinder = DSL.fieldFinder((String)"Level", level);
        OpticFinder opticFinder2 = DSL.fieldFinder((String)"TileEntities", blockEntities);
        int i2 = 416;
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("InjectBedBlockEntityType", (Type)this.getInputSchema().findChoiceType(DataConverterTypes.l), (Type)this.getOutputSchema().findChoiceType(DataConverterTypes.l), dynamicOps -> pair -> pair), (TypeRewriteRule)this.fixTypeEverywhereTyped("BedBlockEntityInjecter", this.getOutputSchema().getType(DataConverterTypes.c), typed -> {
            Typed typed2 = typed.getTyped(opticFinder);
            Dynamic dynamic2 = (Dynamic)((Object)((Object)typed2.get(DSL.remainderFinder())));
            int i2 = dynamic2.get("xPos").asInt(0);
            int j2 = dynamic2.get("zPos").asInt(0);
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)typed2.getOrCreate(opticFinder2)));
            List list2 = dynamic2.get("Sections").asList(Function.identity());
            for (int k2 = 0; k2 < list2.size(); ++k2) {
                Dynamic dynamic22 = (Dynamic)((Object)((Object)list2.get(k2)));
                int l2 = dynamic22.get("Y").asInt(0);
                Stream<Integer> stream = dynamic22.get("Blocks").asStream().map(dynamic -> dynamic.asInt(0));
                int m2 = 0;
                Iterator iterator = ((Iterable)stream::iterator).iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    if (416 == (n2 & 0xFF) << 4) {
                        int o2 = m2 & 0xF;
                        int p2 = m2 >> 8 & 0xF;
                        int q2 = m2 >> 4 & 0xF;
                        HashMap map = Maps.newHashMap();
                        map.put(dynamic22.createString("id"), dynamic22.createString("minecraft:bed"));
                        map.put(dynamic22.createString("x"), dynamic22.createInt(o2 + (i2 << 4)));
                        map.put(dynamic22.createString("y"), dynamic22.createInt(p2 + (l2 << 4)));
                        map.put(dynamic22.createString("z"), dynamic22.createInt(q2 + (j2 << 4)));
                        map.put(dynamic22.createString("color"), dynamic22.createShort((short)14));
                        list.add(((Pair)type.read(dynamic22.createMap(map)).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created bed block entity."))).getFirst());
                    }
                    ++m2;
                }
            }
            if (!list.isEmpty()) {
                return typed.set(opticFinder, typed2.set(opticFinder2, (Object)list));
            }
            return typed;
        }));
    }
}

