/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryID;
import net.minecraft.util.datafix.DataBitsPacked;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkConverterPalette
extends DataFix {
    private static final int a = 128;
    private static final int b = 64;
    private static final int c = 32;
    private static final int d = 16;
    private static final int e = 8;
    private static final int f = 4;
    private static final int g = 2;
    private static final int h = 1;
    static final Logger i = LogManager.getLogger();
    static final BitSet j = new BitSet(256);
    static final BitSet k = new BitSet(256);
    static final Dynamic<?> l = DataConverterFlattenData.b("{Name:'minecraft:pumpkin'}");
    static final Dynamic<?> m = DataConverterFlattenData.b("{Name:'minecraft:podzol',Properties:{snowy:'true'}}");
    static final Dynamic<?> n = DataConverterFlattenData.b("{Name:'minecraft:grass_block',Properties:{snowy:'true'}}");
    static final Dynamic<?> o = DataConverterFlattenData.b("{Name:'minecraft:mycelium',Properties:{snowy:'true'}}");
    static final Dynamic<?> p = DataConverterFlattenData.b("{Name:'minecraft:sunflower',Properties:{half:'upper'}}");
    static final Dynamic<?> q = DataConverterFlattenData.b("{Name:'minecraft:lilac',Properties:{half:'upper'}}");
    static final Dynamic<?> r = DataConverterFlattenData.b("{Name:'minecraft:tall_grass',Properties:{half:'upper'}}");
    static final Dynamic<?> s = DataConverterFlattenData.b("{Name:'minecraft:large_fern',Properties:{half:'upper'}}");
    static final Dynamic<?> t = DataConverterFlattenData.b("{Name:'minecraft:rose_bush',Properties:{half:'upper'}}");
    static final Dynamic<?> u = DataConverterFlattenData.b("{Name:'minecraft:peony',Properties:{half:'upper'}}");
    static final Map<String, Dynamic<?>> v = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        map.put("minecraft:air0", DataConverterFlattenData.b("{Name:'minecraft:flower_pot'}"));
        map.put("minecraft:red_flower0", DataConverterFlattenData.b("{Name:'minecraft:potted_poppy'}"));
        map.put("minecraft:red_flower1", DataConverterFlattenData.b("{Name:'minecraft:potted_blue_orchid'}"));
        map.put("minecraft:red_flower2", DataConverterFlattenData.b("{Name:'minecraft:potted_allium'}"));
        map.put("minecraft:red_flower3", DataConverterFlattenData.b("{Name:'minecraft:potted_azure_bluet'}"));
        map.put("minecraft:red_flower4", DataConverterFlattenData.b("{Name:'minecraft:potted_red_tulip'}"));
        map.put("minecraft:red_flower5", DataConverterFlattenData.b("{Name:'minecraft:potted_orange_tulip'}"));
        map.put("minecraft:red_flower6", DataConverterFlattenData.b("{Name:'minecraft:potted_white_tulip'}"));
        map.put("minecraft:red_flower7", DataConverterFlattenData.b("{Name:'minecraft:potted_pink_tulip'}"));
        map.put("minecraft:red_flower8", DataConverterFlattenData.b("{Name:'minecraft:potted_oxeye_daisy'}"));
        map.put("minecraft:yellow_flower0", DataConverterFlattenData.b("{Name:'minecraft:potted_dandelion'}"));
        map.put("minecraft:sapling0", DataConverterFlattenData.b("{Name:'minecraft:potted_oak_sapling'}"));
        map.put("minecraft:sapling1", DataConverterFlattenData.b("{Name:'minecraft:potted_spruce_sapling'}"));
        map.put("minecraft:sapling2", DataConverterFlattenData.b("{Name:'minecraft:potted_birch_sapling'}"));
        map.put("minecraft:sapling3", DataConverterFlattenData.b("{Name:'minecraft:potted_jungle_sapling'}"));
        map.put("minecraft:sapling4", DataConverterFlattenData.b("{Name:'minecraft:potted_acacia_sapling'}"));
        map.put("minecraft:sapling5", DataConverterFlattenData.b("{Name:'minecraft:potted_dark_oak_sapling'}"));
        map.put("minecraft:red_mushroom0", DataConverterFlattenData.b("{Name:'minecraft:potted_red_mushroom'}"));
        map.put("minecraft:brown_mushroom0", DataConverterFlattenData.b("{Name:'minecraft:potted_brown_mushroom'}"));
        map.put("minecraft:deadbush0", DataConverterFlattenData.b("{Name:'minecraft:potted_dead_bush'}"));
        map.put("minecraft:tallgrass2", DataConverterFlattenData.b("{Name:'minecraft:potted_fern'}"));
        map.put("minecraft:cactus0", DataConverterFlattenData.b(2240));
    });
    static final Map<String, Dynamic<?>> w = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        ChunkConverterPalette.a(map, 0, "skeleton", "skull");
        ChunkConverterPalette.a(map, 1, "wither_skeleton", "skull");
        ChunkConverterPalette.a(map, 2, "zombie", "head");
        ChunkConverterPalette.a(map, 3, "player", "head");
        ChunkConverterPalette.a(map, 4, "creeper", "head");
        ChunkConverterPalette.a(map, 5, "dragon", "head");
    });
    static final Map<String, Dynamic<?>> x = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        ChunkConverterPalette.a(map, "oak_door", 1024);
        ChunkConverterPalette.a(map, "iron_door", 1136);
        ChunkConverterPalette.a(map, "spruce_door", 3088);
        ChunkConverterPalette.a(map, "birch_door", 3104);
        ChunkConverterPalette.a(map, "jungle_door", 3120);
        ChunkConverterPalette.a(map, "acacia_door", 3136);
        ChunkConverterPalette.a(map, "dark_oak_door", 3152);
    });
    static final Map<String, Dynamic<?>> y = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        for (int i2 = 0; i2 < 26; ++i2) {
            map.put("true" + i2, DataConverterFlattenData.b("{Name:'minecraft:note_block',Properties:{powered:'true',note:'" + i2 + "'}}"));
            map.put("false" + i2, DataConverterFlattenData.b("{Name:'minecraft:note_block',Properties:{powered:'false',note:'" + i2 + "'}}"));
        }
    });
    private static final Int2ObjectMap<String> z = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), map -> {
        map.put(0, (Object)"white");
        map.put(1, (Object)"orange");
        map.put(2, (Object)"magenta");
        map.put(3, (Object)"light_blue");
        map.put(4, (Object)"yellow");
        map.put(5, (Object)"lime");
        map.put(6, (Object)"pink");
        map.put(7, (Object)"gray");
        map.put(8, (Object)"light_gray");
        map.put(9, (Object)"cyan");
        map.put(10, (Object)"purple");
        map.put(11, (Object)"blue");
        map.put(12, (Object)"brown");
        map.put(13, (Object)"green");
        map.put(14, (Object)"red");
        map.put(15, (Object)"black");
    });
    static final Map<String, Dynamic<?>> A = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        for (Int2ObjectMap.Entry entry : z.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "red")) continue;
            ChunkConverterPalette.a(map, entry.getIntKey(), (String)entry.getValue());
        }
    });
    static final Map<String, Dynamic<?>> B = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        for (Int2ObjectMap.Entry entry : z.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "white")) continue;
            ChunkConverterPalette.b(map, 15 - entry.getIntKey(), (String)entry.getValue());
        }
    });
    static final Dynamic<?> C;
    private static final int D = 4096;

    public ChunkConverterPalette(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private static void a(Map<String, Dynamic<?>> out, int i2, String mob, String block) {
        out.put(i2 + "north", DataConverterFlattenData.b("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'north'}}"));
        out.put(i2 + "east", DataConverterFlattenData.b("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'east'}}"));
        out.put(i2 + "south", DataConverterFlattenData.b("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'south'}}"));
        out.put(i2 + "west", DataConverterFlattenData.b("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'west'}}"));
        for (int j2 = 0; j2 < 16; ++j2) {
            out.put("" + i2 + j2, DataConverterFlattenData.b("{Name:'minecraft:" + mob + "_" + block + "',Properties:{rotation:'" + j2 + "'}}"));
        }
    }

    private static void a(Map<String, Dynamic<?>> out, String name, int i2) {
        out.put("minecraft:" + name + "eastlowerleftfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "eastlowerleftfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "eastlowerlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "eastlowerlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "eastlowerrightfalsefalse", DataConverterFlattenData.b(i2));
        out.put("minecraft:" + name + "eastlowerrightfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "eastlowerrighttruefalse", DataConverterFlattenData.b(i2 + 4));
        out.put("minecraft:" + name + "eastlowerrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "eastupperleftfalsefalse", DataConverterFlattenData.b(i2 + 8));
        out.put("minecraft:" + name + "eastupperleftfalsetrue", DataConverterFlattenData.b(i2 + 10));
        out.put("minecraft:" + name + "eastupperlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "eastupperlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "eastupperrightfalsefalse", DataConverterFlattenData.b(i2 + 9));
        out.put("minecraft:" + name + "eastupperrightfalsetrue", DataConverterFlattenData.b(i2 + 11));
        out.put("minecraft:" + name + "eastupperrighttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "eastupperrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerleftfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "northlowerleftfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "northlowerlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerrightfalsefalse", DataConverterFlattenData.b(i2 + 3));
        out.put("minecraft:" + name + "northlowerrightfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerrighttruefalse", DataConverterFlattenData.b(i2 + 7));
        out.put("minecraft:" + name + "northlowerrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperleftfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperleftfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperrightfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperrightfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperrighttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerleftfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "southlowerleftfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "southlowerlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerrightfalsefalse", DataConverterFlattenData.b(i2 + 1));
        out.put("minecraft:" + name + "southlowerrightfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerrighttruefalse", DataConverterFlattenData.b(i2 + 5));
        out.put("minecraft:" + name + "southlowerrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperleftfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperleftfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperrightfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperrightfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperrighttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerleftfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "westlowerleftfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "westlowerlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerrightfalsefalse", DataConverterFlattenData.b(i2 + 2));
        out.put("minecraft:" + name + "westlowerrightfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerrighttruefalse", DataConverterFlattenData.b(i2 + 6));
        out.put("minecraft:" + name + "westlowerrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperleftfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperleftfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperlefttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperlefttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperrightfalsefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperrightfalsetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperrighttruefalse", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperrighttruetrue", DataConverterFlattenData.b("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
    }

    private static void a(Map<String, Dynamic<?>> out, int i2, String color) {
        out.put("southfalsefoot" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'south',occupied:'false',part:'foot'}}"));
        out.put("westfalsefoot" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'west',occupied:'false',part:'foot'}}"));
        out.put("northfalsefoot" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'north',occupied:'false',part:'foot'}}"));
        out.put("eastfalsefoot" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'east',occupied:'false',part:'foot'}}"));
        out.put("southfalsehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'south',occupied:'false',part:'head'}}"));
        out.put("westfalsehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'west',occupied:'false',part:'head'}}"));
        out.put("northfalsehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'north',occupied:'false',part:'head'}}"));
        out.put("eastfalsehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'east',occupied:'false',part:'head'}}"));
        out.put("southtruehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'south',occupied:'true',part:'head'}}"));
        out.put("westtruehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'west',occupied:'true',part:'head'}}"));
        out.put("northtruehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'north',occupied:'true',part:'head'}}"));
        out.put("easttruehead" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_bed',Properties:{facing:'east',occupied:'true',part:'head'}}"));
    }

    private static void b(Map<String, Dynamic<?>> out, int i2, String color) {
        for (int j2 = 0; j2 < 16; ++j2) {
            out.put(j2 + "_" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_banner',Properties:{rotation:'" + j2 + "'}}"));
        }
        out.put("north_" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'north'}}"));
        out.put("south_" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'south'}}"));
        out.put("west_" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'west'}}"));
        out.put("east_" + i2, DataConverterFlattenData.b("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'east'}}"));
    }

    public static String a(Dynamic<?> dynamic) {
        return dynamic.get("Name").asString("");
    }

    public static String a(Dynamic<?> dynamic, String string) {
        return dynamic.get("Properties").get(string).asString("");
    }

    public static int a(RegistryID<Dynamic<?>> crudeIncrementalIntIdentityHashBiMap, Dynamic<?> dynamic) {
        int i2 = crudeIncrementalIntIdentityHashBiMap.a(dynamic);
        if (i2 == -1) {
            i2 = crudeIncrementalIntIdentityHashBiMap.c(dynamic);
        }
        return i2;
    }

    private Dynamic<?> b(Dynamic<?> dynamic) {
        Optional optional = dynamic.get("Level").result();
        if (optional.isPresent() && ((Dynamic)((Object)optional.get())).get("Sections").asStreamOpt().result().isPresent()) {
            return dynamic.set("Level", new d((Dynamic)((Object)optional.get())).a());
        }
        return dynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        Type type2 = this.getOutputSchema().getType(DataConverterTypes.c);
        return this.writeFixAndRead("ChunkPalettedStorageFix", type, type2, this::b);
    }

    public static int a(boolean west, boolean east, boolean north, boolean south) {
        int i2 = 0;
        if (north) {
            i2 = east ? (i2 |= 2) : (west ? (i2 |= 0x80) : (i2 |= 1));
        } else if (south) {
            i2 = west ? (i2 |= 0x20) : (east ? (i2 |= 8) : (i2 |= 0x10));
        } else if (east) {
            i2 |= 4;
        } else if (west) {
            i2 |= 0x40;
        }
        return i2;
    }

    static {
        k.set(2);
        k.set(3);
        k.set(110);
        k.set(140);
        k.set(144);
        k.set(25);
        k.set(86);
        k.set(26);
        k.set(176);
        k.set(177);
        k.set(175);
        k.set(64);
        k.set(71);
        k.set(193);
        k.set(194);
        k.set(195);
        k.set(196);
        k.set(197);
        j.set(54);
        j.set(146);
        j.set(25);
        j.set(26);
        j.set(51);
        j.set(53);
        j.set(67);
        j.set(108);
        j.set(109);
        j.set(114);
        j.set(128);
        j.set(134);
        j.set(135);
        j.set(136);
        j.set(156);
        j.set(163);
        j.set(164);
        j.set(180);
        j.set(203);
        j.set(55);
        j.set(85);
        j.set(113);
        j.set(188);
        j.set(189);
        j.set(190);
        j.set(191);
        j.set(192);
        j.set(93);
        j.set(94);
        j.set(101);
        j.set(102);
        j.set(160);
        j.set(106);
        j.set(107);
        j.set(183);
        j.set(184);
        j.set(185);
        j.set(186);
        j.set(187);
        j.set(132);
        j.set(139);
        j.set(199);
        C = DataConverterFlattenData.b(0);
    }

    static final class d {
        private int a;
        private final c[] b = new c[16];
        private final Dynamic<?> c;
        private final int d;
        private final int e;
        private final Int2ObjectMap<Dynamic<?>> f = new Int2ObjectLinkedOpenHashMap(16);

        public d(Dynamic<?> dynamic) {
            this.c = dynamic;
            this.d = dynamic.get("xPos").asInt(0) << 4;
            this.e = dynamic.get("zPos").asInt(0) << 4;
            dynamic.get("TileEntities").asStreamOpt().result().ifPresent(stream -> stream.forEach(dynamic -> {
                int k2;
                int i2 = dynamic.get("x").asInt(0) - this.d & 0xF;
                int j2 = dynamic.get("y").asInt(0);
                int l2 = j2 << 8 | (k2 = dynamic.get("z").asInt(0) - this.e & 0xF) << 4 | i2;
                if (this.f.put(l2, (Object)dynamic) != null) {
                    i.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", (Object)this.d, (Object)this.e, (Object)i2, (Object)j2, (Object)k2);
                }
            }));
            boolean bl = dynamic.get("convertedFromAlphaFormat").asBoolean(false);
            dynamic.get("Sections").asStreamOpt().result().ifPresent(stream -> stream.forEach(dynamic -> {
                c section = new c((Dynamic<?>)((Object)((Object)dynamic)));
                this.a = section.b(this.a);
                this.b[section.a] = section;
            }));
            for (c section : this.b) {
                if (section == null) continue;
                block14: for (Map.Entry entry : section.f.entrySet()) {
                    int i2 = section.a << 12;
                    switch ((Integer)entry.getKey()) {
                        case 2: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string;
                                int j2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic2 = this.a(j2 |= i2);
                                if (!"minecraft:grass_block".equals(ChunkConverterPalette.a(dynamic2)) || !"minecraft:snow".equals(string = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$d.a(j2, Direction.b)))) && !"minecraft:snow_layer".equals(string)) continue;
                                this.a(j2, n);
                            }
                            continue block14;
                        }
                        case 3: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string2;
                                int k2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic3 = this.a(k2 |= i2);
                                if (!"minecraft:podzol".equals(ChunkConverterPalette.a(dynamic3)) || !"minecraft:snow".equals(string2 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$d.a(k2, Direction.b)))) && !"minecraft:snow_layer".equals(string2)) continue;
                                this.a(k2, m);
                            }
                            continue block14;
                        }
                        case 110: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string3;
                                int l2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic4 = this.a(l2 |= i2);
                                if (!"minecraft:mycelium".equals(ChunkConverterPalette.a(dynamic4)) || !"minecraft:snow".equals(string3 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$d.a(l2, Direction.b)))) && !"minecraft:snow_layer".equals(string3)) continue;
                                this.a(l2, o);
                            }
                            continue block14;
                        }
                        case 25: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int m2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic5 = this.c(m2 |= i2);
                                if (dynamic5 == null) continue;
                                String string4 = Boolean.toString(dynamic5.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(dynamic5.get("note").asInt(0), 0), 24);
                                this.a(m2, y.getOrDefault(string4, y.get("false0")));
                            }
                            continue block14;
                        }
                        case 26: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string5;
                                int o2;
                                int n2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic6 = this.b(n2 |= i2);
                                Dynamic<?> dynamic7 = this.a(n2);
                                if (dynamic6 == null || (o2 = dynamic6.get("color").asInt(0)) == 14 || o2 < 0 || o2 >= 16 || !A.containsKey(string5 = ChunkConverterPalette.a(dynamic7, "facing") + ChunkConverterPalette.a(dynamic7, "occupied") + ChunkConverterPalette.a(dynamic7, "part") + o2)) continue;
                                this.a(n2, A.get(string5));
                            }
                            continue block14;
                        }
                        case 176: 
                        case 177: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string6;
                                int q2;
                                int p2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic8 = this.b(p2 |= i2);
                                Dynamic<?> dynamic9 = this.a(p2);
                                if (dynamic8 == null || (q2 = dynamic8.get("Base").asInt(0)) == 15 || q2 < 0 || q2 >= 16 || !B.containsKey(string6 = ChunkConverterPalette.a(dynamic9, (Integer)entry.getKey() == 176 ? "rotation" : "facing") + "_" + q2)) continue;
                                this.a(p2, B.get(string6));
                            }
                            continue block14;
                        }
                        case 86: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string7;
                                int r2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic10 = this.a(r2 |= i2);
                                if (!"minecraft:carved_pumpkin".equals(ChunkConverterPalette.a(dynamic10)) || !"minecraft:grass_block".equals(string7 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$d.a(r2, Direction.a)))) && !"minecraft:dirt".equals(string7)) continue;
                                this.a(r2, l);
                            }
                            continue block14;
                        }
                        case 140: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int s2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic11 = this.c(s2 |= i2);
                                if (dynamic11 == null) continue;
                                String string8 = dynamic11.get("Item").asString("") + dynamic11.get("Data").asInt(0);
                                this.a(s2, v.getOrDefault(string8, v.get("minecraft:air0")));
                            }
                            continue block14;
                        }
                        case 144: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string12;
                                int t2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic12 = this.b(t2 |= i2);
                                if (dynamic12 == null) continue;
                                String string9 = String.valueOf(dynamic12.get("SkullType").asInt(0));
                                String string10 = ChunkConverterPalette.a(this.a(t2), "facing");
                                if ("up".equals(string10) || "down".equals(string10)) {
                                    String string11 = string9 + String.valueOf(dynamic12.get("Rot").asInt(0));
                                } else {
                                    string12 = string9 + string10;
                                }
                                dynamic12.remove("SkullType");
                                dynamic12.remove("facing");
                                dynamic12.remove("Rot");
                                this.a(t2, w.getOrDefault(string12, w.get("0north")));
                            }
                            continue block14;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                Dynamic<?> dynamic14;
                                int u2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic13 = this.a(u2 |= i2);
                                if (!ChunkConverterPalette.a(dynamic13).endsWith("_door") || !"lower".equals(ChunkConverterPalette.a(dynamic14 = this.a(u2), "half"))) continue;
                                int v2 = net.minecraft.util.datafix.fixes.ChunkConverterPalette$d.a(u2, Direction.b);
                                Dynamic<?> dynamic15 = this.a(v2);
                                String string13 = ChunkConverterPalette.a(dynamic14);
                                if (!string13.equals(ChunkConverterPalette.a(dynamic15))) continue;
                                String string14 = ChunkConverterPalette.a(dynamic14, "facing");
                                String string15 = ChunkConverterPalette.a(dynamic14, "open");
                                String string16 = bl ? "left" : ChunkConverterPalette.a(dynamic15, "hinge");
                                String string17 = bl ? "false" : ChunkConverterPalette.a(dynamic15, "powered");
                                this.a(u2, x.get(string13 + string14 + "lower" + string16 + string15 + string17));
                                this.a(v2, x.get(string13 + string14 + "upper" + string16 + string15 + string17));
                            }
                            continue block14;
                        }
                        case 175: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int w2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic16 = this.a(w2 |= i2);
                                if (!"upper".equals(ChunkConverterPalette.a(dynamic16, "half"))) continue;
                                Dynamic<?> dynamic17 = this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$d.a(w2, Direction.a));
                                String string18 = ChunkConverterPalette.a(dynamic17);
                                if ("minecraft:sunflower".equals(string18)) {
                                    this.a(w2, p);
                                    continue;
                                }
                                if ("minecraft:lilac".equals(string18)) {
                                    this.a(w2, q);
                                    continue;
                                }
                                if ("minecraft:tall_grass".equals(string18)) {
                                    this.a(w2, r);
                                    continue;
                                }
                                if ("minecraft:large_fern".equals(string18)) {
                                    this.a(w2, s);
                                    continue;
                                }
                                if ("minecraft:rose_bush".equals(string18)) {
                                    this.a(w2, t);
                                    continue;
                                }
                                if (!"minecraft:peony".equals(string18)) continue;
                                this.a(w2, u);
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> b(int i2) {
            return (Dynamic)((Object)this.f.get(i2));
        }

        @Nullable
        private Dynamic<?> c(int i2) {
            return (Dynamic)((Object)this.f.remove(i2));
        }

        public static int a(int i2, Direction direction) {
            switch (direction.b()) {
                case a: {
                    int j2 = (i2 & 0xF) + direction.a().a();
                    return j2 < 0 || j2 > 15 ? -1 : i2 & 0xFFFFFFF0 | j2;
                }
                case b: {
                    int k2 = (i2 >> 8) + direction.a().a();
                    return k2 < 0 || k2 > 255 ? -1 : i2 & 0xFF | k2 << 8;
                }
                case c: {
                    int l2 = (i2 >> 4 & 0xF) + direction.a().a();
                    return l2 < 0 || l2 > 15 ? -1 : i2 & 0xFFFFFF0F | l2 << 4;
                }
            }
            return -1;
        }

        private void a(int i2, Dynamic<?> dynamic) {
            if (i2 < 0 || i2 > 65535) {
                return;
            }
            c section = this.d(i2);
            if (section == null) {
                return;
            }
            section.a(i2 & 0xFFF, dynamic);
        }

        @Nullable
        private c d(int i2) {
            int j2 = i2 >> 12;
            return j2 < this.b.length ? this.b[j2] : null;
        }

        public Dynamic<?> a(int i2) {
            if (i2 < 0 || i2 > 65535) {
                return C;
            }
            c section = this.d(i2);
            if (section == null) {
                return C;
            }
            return section.a(i2 & 0xFFF);
        }

        public Dynamic<?> a() {
            Dynamic<?> dynamic = this.c;
            dynamic = this.f.isEmpty() ? dynamic.remove("TileEntities") : dynamic.set("TileEntities", dynamic.createList(this.f.values().stream()));
            Dynamic dynamic2 = dynamic.emptyMap();
            ArrayList list = Lists.newArrayList();
            for (c section : this.b) {
                if (section == null) continue;
                list.add(section.a());
                dynamic2 = dynamic2.set(String.valueOf(section.a), dynamic2.createIntList(Arrays.stream(section.g.toIntArray())));
            }
            Dynamic dynamic3 = dynamic.emptyMap();
            dynamic3 = dynamic3.set("Sides", dynamic3.createByte((byte)this.a));
            dynamic3 = dynamic3.set("Indices", dynamic2);
            return dynamic.set("UpgradeData", dynamic3).set("Sections", dynamic3.createList(list.stream()));
        }
    }

    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction a = new Direction(AxisDirection.b, Axis.b);
        public static final /* enum */ Direction b = new Direction(AxisDirection.a, Axis.b);
        public static final /* enum */ Direction c = new Direction(AxisDirection.b, Axis.c);
        public static final /* enum */ Direction d = new Direction(AxisDirection.a, Axis.c);
        public static final /* enum */ Direction e = new Direction(AxisDirection.b, Axis.a);
        public static final /* enum */ Direction f = new Direction(AxisDirection.a, Axis.a);
        private final Axis g;
        private final AxisDirection h;
        private static final /* synthetic */ Direction[] i;

        public static Direction[] values() {
            return (Direction[])i.clone();
        }

        public static Direction valueOf(String string) {
            return Enum.valueOf(Direction.class, string);
        }

        private Direction(AxisDirection direction, Axis axis) {
            this.g = axis;
            this.h = direction;
        }

        public AxisDirection a() {
            return this.h;
        }

        public Axis b() {
            return this.g;
        }

        private static /* synthetic */ Direction[] c() {
            return new Direction[]{a, b, c, d, e, f};
        }

        static {
            i = Direction.c();
        }

        public static final class Axis
        extends Enum<Axis> {
            public static final /* enum */ Axis a = new Axis();
            public static final /* enum */ Axis b = new Axis();
            public static final /* enum */ Axis c = new Axis();
            private static final /* synthetic */ Axis[] d;

            public static Axis[] values() {
                return (Axis[])d.clone();
            }

            public static Axis valueOf(String string) {
                return Enum.valueOf(Axis.class, string);
            }

            private static /* synthetic */ Axis[] a() {
                return new Axis[]{a, b, c};
            }

            static {
                d = Axis.a();
            }
        }

        public static final class AxisDirection
        extends Enum<AxisDirection> {
            public static final /* enum */ AxisDirection a = new AxisDirection(1);
            public static final /* enum */ AxisDirection b = new AxisDirection(-1);
            private final int c;
            private static final /* synthetic */ AxisDirection[] d;

            public static AxisDirection[] values() {
                return (AxisDirection[])d.clone();
            }

            public static AxisDirection valueOf(String string) {
                return Enum.valueOf(AxisDirection.class, string);
            }

            private AxisDirection(int j2) {
                this.c = j2;
            }

            public int a() {
                return this.c;
            }

            private static /* synthetic */ AxisDirection[] b() {
                return new AxisDirection[]{a, b};
            }

            static {
                d = AxisDirection.b();
            }
        }
    }

    static class a {
        private static final int a = 2048;
        private static final int b = 4;
        private final byte[] c;

        public a() {
            this.c = new byte[2048];
        }

        public a(byte[] bs) {
            this.c = bs;
            if (bs.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + bs.length);
            }
        }

        public int a(int x2, int y2, int i2) {
            int j2 = this.b(y2 << 8 | i2 << 4 | x2);
            if (this.a(y2 << 8 | i2 << 4 | x2)) {
                return this.c[j2] & 0xF;
            }
            return this.c[j2] >> 4 & 0xF;
        }

        private boolean a(int index) {
            return (index & 1) == 0;
        }

        private int b(int index) {
            return index >> 1;
        }
    }

    static class c {
        private final RegistryID<Dynamic<?>> b = RegistryID.c(32);
        private final List<Dynamic<?>> c;
        private final Dynamic<?> d;
        private final boolean e;
        final Int2ObjectMap<IntList> f = new Int2ObjectLinkedOpenHashMap();
        final IntList g = new IntArrayList();
        public final int a;
        private final Set<Dynamic<?>> h = Sets.newIdentityHashSet();
        private final int[] i = new int[4096];

        public c(Dynamic<?> dynamic) {
            this.c = Lists.newArrayList();
            this.d = dynamic;
            this.a = dynamic.get("Y").asInt(0);
            this.e = dynamic.get("Blocks").result().isPresent();
        }

        public Dynamic<?> a(int index) {
            if (index < 0 || index > 4095) {
                return C;
            }
            Dynamic<?> dynamic = this.b.a(this.i[index]);
            return dynamic == null ? C : dynamic;
        }

        public void a(int pos, Dynamic<?> dynamic) {
            if (this.h.add(dynamic)) {
                this.c.add("%%FILTER_ME%%".equals(ChunkConverterPalette.a(dynamic)) ? C : dynamic);
            }
            this.i[pos] = ChunkConverterPalette.a(this.b, dynamic);
        }

        public int b(int sidesToUpgrade) {
            if (!this.e) {
                return sidesToUpgrade;
            }
            ByteBuffer byteBuffer2 = (ByteBuffer)this.d.get("Blocks").asByteBufferOpt().result().get();
            a dataLayer = this.d.get("Data").asByteBufferOpt().map(byteBuffer -> new a(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(a::new);
            a dataLayer2 = this.d.get("Add").asByteBufferOpt().map(byteBuffer -> new a(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(a::new);
            this.h.add(C);
            ChunkConverterPalette.a(this.b, C);
            this.c.add(C);
            for (int i2 = 0; i2 < 4096; ++i2) {
                int j2 = i2 & 0xF;
                int k2 = i2 >> 8 & 0xF;
                int l2 = i2 >> 4 & 0xF;
                int m2 = dataLayer2.a(j2, k2, l2) << 12 | (byteBuffer2.get(i2) & 0xFF) << 4 | dataLayer.a(j2, k2, l2);
                if (k.get(m2 >> 4)) {
                    this.a(m2 >> 4, i2);
                }
                if (j.get(m2 >> 4)) {
                    int n2 = ChunkConverterPalette.a(j2 == 0, j2 == 15, l2 == 0, l2 == 15);
                    if (n2 == 0) {
                        this.g.add(i2);
                    } else {
                        sidesToUpgrade |= n2;
                    }
                }
                this.a(i2, DataConverterFlattenData.b(m2));
            }
            return sidesToUpgrade;
        }

        private void a(int section, int index) {
            IntList intList = (IntList)this.f.get(section);
            if (intList == null) {
                intList = new IntArrayList();
                this.f.put(section, (Object)intList);
            }
            intList.add(index);
        }

        public Dynamic<?> a() {
            Dynamic<?> dynamic = this.d;
            if (!this.e) {
                return dynamic;
            }
            dynamic = dynamic.set("Palette", dynamic.createList(this.c.stream()));
            int i2 = Math.max(4, DataFixUtils.ceillog2((int)this.h.size()));
            DataBitsPacked packedBitStorage = new DataBitsPacked(i2, 4096);
            for (int j2 = 0; j2 < this.i.length; ++j2) {
                packedBitStorage.a(j2, this.i[j2]);
            }
            dynamic = dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(packedBitStorage.a())));
            dynamic = dynamic.remove("Blocks");
            dynamic = dynamic.remove("Data");
            dynamic = dynamic.remove("Add");
            return dynamic;
        }
    }
}

