/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.BlockRenameFixWithJigsaw;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChunkConverterPalette;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterAdvancement;
import net.minecraft.util.datafix.fixes.DataConverterAdvancementBase;
import net.minecraft.util.datafix.fixes.DataConverterArmorStand;
import net.minecraft.util.datafix.fixes.DataConverterAttributes;
import net.minecraft.util.datafix.fixes.DataConverterBanner;
import net.minecraft.util.datafix.fixes.DataConverterBannerColour;
import net.minecraft.util.datafix.fixes.DataConverterBedBlock;
import net.minecraft.util.datafix.fixes.DataConverterBedItem;
import net.minecraft.util.datafix.fixes.DataConverterBeehive;
import net.minecraft.util.datafix.fixes.DataConverterBiome;
import net.minecraft.util.datafix.fixes.DataConverterBiomeBase;
import net.minecraft.util.datafix.fixes.DataConverterBitStorageAlign;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterBlockName;
import net.minecraft.util.datafix.fixes.DataConverterBlockRename;
import net.minecraft.util.datafix.fixes.DataConverterBook;
import net.minecraft.util.datafix.fixes.DataConverterCatType;
import net.minecraft.util.datafix.fixes.DataConverterChunkLightRemove;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus2;
import net.minecraft.util.datafix.fixes.DataConverterChunkStructuresTemplateRename;
import net.minecraft.util.datafix.fixes.DataConverterColorlessShulkerEntity;
import net.minecraft.util.datafix.fixes.DataConverterCoral;
import net.minecraft.util.datafix.fixes.DataConverterCoralFan;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameEntity;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameItem;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameTile;
import net.minecraft.util.datafix.fixes.DataConverterDropChances;
import net.minecraft.util.datafix.fixes.DataConverterDye;
import net.minecraft.util.datafix.fixes.DataConverterEntity;
import net.minecraft.util.datafix.fixes.DataConverterEntityBlockState;
import net.minecraft.util.datafix.fixes.DataConverterEntityCatSplit;
import net.minecraft.util.datafix.fixes.DataConverterEntityCodSalmon;
import net.minecraft.util.datafix.fixes.DataConverterEntityProjectileOwner;
import net.minecraft.util.datafix.fixes.DataConverterEntityPufferfish;
import net.minecraft.util.datafix.fixes.DataConverterEntityRavagerRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityShulkerRotation;
import net.minecraft.util.datafix.fixes.DataConverterEntityTippedArrow;
import net.minecraft.util.datafix.fixes.DataConverterEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterEntityZombifiedPiglinRename;
import net.minecraft.util.datafix.fixes.DataConverterEquipment;
import net.minecraft.util.datafix.fixes.DataConverterFlatten;
import net.minecraft.util.datafix.fixes.DataConverterFlattenSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterFlattenState;
import net.minecraft.util.datafix.fixes.DataConverterFurnaceRecipesUsed;
import net.minecraft.util.datafix.fixes.DataConverterGossip;
import net.minecraft.util.datafix.fixes.DataConverterGuardian;
import net.minecraft.util.datafix.fixes.DataConverterHanging;
import net.minecraft.util.datafix.fixes.DataConverterHealth;
import net.minecraft.util.datafix.fixes.DataConverterHeightmapRenaming;
import net.minecraft.util.datafix.fixes.DataConverterHorse;
import net.minecraft.util.datafix.fixes.DataConverterIglooMetadataRemoval;
import net.minecraft.util.datafix.fixes.DataConverterItemFrame;
import net.minecraft.util.datafix.fixes.DataConverterItemLoreComponentize;
import net.minecraft.util.datafix.fixes.DataConverterItemName;
import net.minecraft.util.datafix.fixes.DataConverterItemStackEnchantment;
import net.minecraft.util.datafix.fixes.DataConverterItemStackUUID;
import net.minecraft.util.datafix.fixes.DataConverterJigsawProperties;
import net.minecraft.util.datafix.fixes.DataConverterJigsawRotation;
import net.minecraft.util.datafix.fixes.DataConverterJukeBox;
import net.minecraft.util.datafix.fixes.DataConverterKeybind;
import net.minecraft.util.datafix.fixes.DataConverterKeybind2;
import net.minecraft.util.datafix.fixes.DataConverterLang;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterLeavesBiome;
import net.minecraft.util.datafix.fixes.DataConverterLevelDataGeneratorOptions;
import net.minecraft.util.datafix.fixes.DataConverterMap;
import net.minecraft.util.datafix.fixes.DataConverterMapId;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterMemoryExpiry;
import net.minecraft.util.datafix.fixes.DataConverterMinecart;
import net.minecraft.util.datafix.fixes.DataConverterMiscUUID;
import net.minecraft.util.datafix.fixes.DataConverterMissingDimension;
import net.minecraft.util.datafix.fixes.DataConverterMobSpawner;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterNewVillage;
import net.minecraft.util.datafix.fixes.DataConverterObjectiveDisplayName;
import net.minecraft.util.datafix.fixes.DataConverterObjectiveRenderType;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerBlockEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerRename;
import net.minecraft.util.datafix.fixes.DataConverterOptionsAddTextBackground;
import net.minecraft.util.datafix.fixes.DataConverterPOI;
import net.minecraft.util.datafix.fixes.DataConverterPOIRebuild;
import net.minecraft.util.datafix.fixes.DataConverterPainting;
import net.minecraft.util.datafix.fixes.DataConverterPiston;
import net.minecraft.util.datafix.fixes.DataConverterPlayerUUID;
import net.minecraft.util.datafix.fixes.DataConverterPotionId;
import net.minecraft.util.datafix.fixes.DataConverterPotionWater;
import net.minecraft.util.datafix.fixes.DataConverterProtoChunk;
import net.minecraft.util.datafix.fixes.DataConverterRecipeBase;
import net.minecraft.util.datafix.fixes.DataConverterRecipeRename;
import net.minecraft.util.datafix.fixes.DataConverterRecipes;
import net.minecraft.util.datafix.fixes.DataConverterRedstoneConnections;
import net.minecraft.util.datafix.fixes.DataConverterRemoveGolemGossip;
import net.minecraft.util.datafix.fixes.DataConverterRiding;
import net.minecraft.util.datafix.fixes.DataConverterSaddle;
import net.minecraft.util.datafix.fixes.DataConverterSavedDataUUID;
import net.minecraft.util.datafix.fixes.DataConverterSettingRename;
import net.minecraft.util.datafix.fixes.DataConverterShoulderEntity;
import net.minecraft.util.datafix.fixes.DataConverterShulker;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxBlock;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxItem;
import net.minecraft.util.datafix.fixes.DataConverterSignText;
import net.minecraft.util.datafix.fixes.DataConverterSkeleton;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterStatistic;
import net.minecraft.util.datafix.fixes.DataConverterStriderGravity;
import net.minecraft.util.datafix.fixes.DataConverterStructureReference;
import net.minecraft.util.datafix.fixes.DataConverterTeamDisplayName;
import net.minecraft.util.datafix.fixes.DataConverterTileEntity;
import net.minecraft.util.datafix.fixes.DataConverterTrappedChest;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterUUID;
import net.minecraft.util.datafix.fixes.DataConverterVBO;
import net.minecraft.util.datafix.fixes.DataConverterVillage;
import net.minecraft.util.datafix.fixes.DataConverterVillagerFollowRange;
import net.minecraft.util.datafix.fixes.DataConverterVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DataConverterVillagerProfession;
import net.minecraft.util.datafix.fixes.DataConverterVillagerTrade;
import net.minecraft.util.datafix.fixes.DataConverterWallProperty;
import net.minecraft.util.datafix.fixes.DataConverterWolf;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettings;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettingsBuilding;
import net.minecraft.util.datafix.fixes.DataConverterZombie;
import net.minecraft.util.datafix.fixes.DataConverterZombieType;
import net.minecraft.util.datafix.fixes.DataConverterZombieVillagerLevelXp;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV102;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1022;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV106;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV107;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1125;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV135;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV143;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_1;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_2;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_3;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_4;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_5;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_6;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_7;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1460;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1466;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1470;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1481;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1483;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1486;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1510;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1800;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1801;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1904;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1906;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1909;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1920;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1928;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1929;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1931;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2502;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2505;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2509;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2519;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2522;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2551;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2568;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV700;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV701;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV702;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV703;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV704;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV705;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV808;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV99;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;

public class DataConverterRegistry {
    private static final BiFunction<Integer, Schema, Schema> a = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> b = DataConverterSchemaNamed::new;
    private static final DataFixer c = DataConverterRegistry.b();

    private static DataFixer b() {
        DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.b().getWorldVersion());
        DataConverterRegistry.a(datafixerbuilder);
        return datafixerbuilder.build(SystemUtils.f());
    }

    public static DataFixer a() {
        return c;
    }

    private static void a(DataFixerBuilder builder) {
        Schema schema = builder.addSchema(99, DataConverterSchemaV99::new);
        Schema schema1 = builder.addSchema(100, DataConverterSchemaV100::new);
        builder.addFixer(new DataConverterEquipment(schema1, true));
        Schema schema2 = builder.addSchema(101, a);
        builder.addFixer(new DataConverterSignText(schema2, false));
        Schema schema3 = builder.addSchema(102, DataConverterSchemaV102::new);
        builder.addFixer(new DataConverterMaterialId(schema3, true));
        builder.addFixer(new DataConverterPotionId(schema3, false));
        Schema schema4 = builder.addSchema(105, a);
        builder.addFixer(new DataConverterSpawnEgg(schema4, true));
        Schema schema5 = builder.addSchema(106, DataConverterSchemaV106::new);
        builder.addFixer(new DataConverterMobSpawner(schema5, true));
        Schema schema6 = builder.addSchema(107, DataConverterSchemaV107::new);
        builder.addFixer(new DataConverterMinecart(schema6, true));
        Schema schema7 = builder.addSchema(108, a);
        builder.addFixer(new DataConverterUUID(schema7, true));
        Schema schema8 = builder.addSchema(109, a);
        builder.addFixer(new DataConverterHealth(schema8, true));
        Schema schema9 = builder.addSchema(110, a);
        builder.addFixer(new DataConverterSaddle(schema9, true));
        Schema schema10 = builder.addSchema(111, a);
        builder.addFixer(new DataConverterHanging(schema10, true));
        Schema schema11 = builder.addSchema(113, a);
        builder.addFixer(new DataConverterDropChances(schema11, true));
        Schema schema12 = builder.addSchema(135, DataConverterSchemaV135::new);
        builder.addFixer(new DataConverterRiding(schema12, true));
        Schema schema13 = builder.addSchema(143, DataConverterSchemaV143::new);
        builder.addFixer(new DataConverterEntityTippedArrow(schema13, true));
        Schema schema14 = builder.addSchema(147, a);
        builder.addFixer(new DataConverterArmorStand(schema14, true));
        Schema schema15 = builder.addSchema(165, a);
        builder.addFixer(new DataConverterBook(schema15, true));
        Schema schema16 = builder.addSchema(501, DataConverterSchemaV501::new);
        builder.addFixer(new DataConverterAddChoices(schema16, "Add 1.10 entities fix", DataConverterTypes.q));
        Schema schema17 = builder.addSchema(502, a);
        builder.addFixer(DataConverterItemName.a(schema17, "cooked_fished item renamer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : s2));
        builder.addFixer(new DataConverterZombie(schema17, false));
        Schema schema18 = builder.addSchema(505, a);
        builder.addFixer(new DataConverterVBO(schema18, false));
        Schema schema19 = builder.addSchema(700, DataConverterSchemaV700::new);
        builder.addFixer(new DataConverterGuardian(schema19, true));
        Schema schema20 = builder.addSchema(701, DataConverterSchemaV701::new);
        builder.addFixer(new DataConverterSkeleton(schema20, true));
        Schema schema21 = builder.addSchema(702, DataConverterSchemaV702::new);
        builder.addFixer(new DataConverterZombieType(schema21, true));
        Schema schema22 = builder.addSchema(703, DataConverterSchemaV703::new);
        builder.addFixer(new DataConverterHorse(schema22, true));
        Schema schema23 = builder.addSchema(704, DataConverterSchemaV704::new);
        builder.addFixer(new DataConverterTileEntity(schema23, true));
        Schema schema24 = builder.addSchema(705, DataConverterSchemaV705::new);
        builder.addFixer(new DataConverterEntity(schema24, true));
        Schema schema25 = builder.addSchema(804, b);
        builder.addFixer(new DataConverterBanner(schema25, true));
        Schema schema26 = builder.addSchema(806, b);
        builder.addFixer(new DataConverterPotionWater(schema26, false));
        Schema schema27 = builder.addSchema(808, DataConverterSchemaV808::new);
        builder.addFixer(new DataConverterAddChoices(schema27, "added shulker box", DataConverterTypes.l));
        Schema schema28 = builder.addSchema(808, 1, b);
        builder.addFixer(new DataConverterShulker(schema28, false));
        Schema schema29 = builder.addSchema(813, b);
        builder.addFixer(new DataConverterShulkerBoxItem(schema29, false));
        builder.addFixer(new DataConverterShulkerBoxBlock(schema29, false));
        Schema schema30 = builder.addSchema(816, b);
        builder.addFixer(new DataConverterLang(schema30, false));
        Schema schema31 = builder.addSchema(820, b);
        builder.addFixer(DataConverterItemName.a(schema31, "totem item renamer", DataConverterRegistry.a("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema32 = builder.addSchema(1022, DataConverterSchemaV1022::new);
        builder.addFixer(new DataConverterShoulderEntity(schema32, "added shoulder entities to players", DataConverterTypes.b));
        Schema schema33 = builder.addSchema(1125, DataConverterSchemaV1125::new);
        builder.addFixer(new DataConverterBedBlock(schema33, true));
        builder.addFixer(new DataConverterBedItem(schema33, false));
        Schema schema34 = builder.addSchema(1344, b);
        builder.addFixer(new DataConverterKeybind(schema34, false));
        Schema schema35 = builder.addSchema(1446, b);
        builder.addFixer(new DataConverterKeybind2(schema35, false));
        Schema schema36 = builder.addSchema(1450, b);
        builder.addFixer(new DataConverterFlattenState(schema36, false));
        Schema schema37 = builder.addSchema(1451, DataConverterSchemaV1451::new);
        builder.addFixer(new DataConverterAddChoices(schema37, "AddTrappedChestFix", DataConverterTypes.l));
        Schema schema38 = builder.addSchema(1451, 1, DataConverterSchemaV1451_1::new);
        builder.addFixer(new ChunkConverterPalette(schema38, true));
        Schema schema39 = builder.addSchema(1451, 2, DataConverterSchemaV1451_2::new);
        builder.addFixer(new DataConverterPiston(schema39, true));
        Schema schema40 = builder.addSchema(1451, 3, DataConverterSchemaV1451_3::new);
        builder.addFixer(new DataConverterEntityBlockState(schema40, true));
        builder.addFixer(new DataConverterMap(schema40, false));
        Schema schema41 = builder.addSchema(1451, 4, DataConverterSchemaV1451_4::new);
        builder.addFixer(new DataConverterBlockName(schema41, true));
        builder.addFixer(new DataConverterFlatten(schema41, false));
        Schema schema42 = builder.addSchema(1451, 5, DataConverterSchemaV1451_5::new);
        builder.addFixer(new DataConverterAddChoices(schema42, "RemoveNoteBlockFlowerPotFix", DataConverterTypes.l));
        builder.addFixer(new DataConverterFlattenSpawnEgg(schema42, false));
        builder.addFixer(new DataConverterWolf(schema42, false));
        builder.addFixer(new DataConverterBannerColour(schema42, false));
        builder.addFixer(new DataConverterWorldGenSettings(schema42, false));
        Schema schema43 = builder.addSchema(1451, 6, DataConverterSchemaV1451_6::new);
        builder.addFixer(new DataConverterStatistic(schema43, true));
        builder.addFixer(new DataConverterShoulderEntity(schema43, "Rewrite objectives", DataConverterTypes.v));
        builder.addFixer(new DataConverterJukeBox(schema43, false));
        Schema schema44 = builder.addSchema(1451, 7, DataConverterSchemaV1451_7::new);
        builder.addFixer(new DataConverterVillage(schema44, true));
        Schema schema45 = builder.addSchema(1451, 7, b);
        builder.addFixer(new DataConverterVillagerTrade(schema45, false));
        Schema schema46 = builder.addSchema(1456, b);
        builder.addFixer(new DataConverterItemFrame(schema46, false));
        Schema schema47 = builder.addSchema(1458, b);
        builder.addFixer(new DataFix(schema47, false){

            protected TypeRewriteRule makeRule() {
                return this.fixTypeEverywhereTyped("Player CustomName", this.getInputSchema().getType(DataConverterTypes.b), typed -> typed.update(DSL.remainderFinder(), dynamic -> DataConverterCustomNameEntity.a(dynamic)));
            }
        });
        builder.addFixer(new DataConverterCustomNameEntity(schema47, false));
        builder.addFixer(new DataConverterCustomNameItem(schema47, false));
        builder.addFixer(new DataConverterCustomNameTile(schema47, false));
        Schema schema48 = builder.addSchema(1460, DataConverterSchemaV1460::new);
        builder.addFixer(new DataConverterPainting(schema48, false));
        Schema schema49 = builder.addSchema(1466, DataConverterSchemaV1466::new);
        builder.addFixer(new DataConverterProtoChunk(schema49, true));
        Schema schema50 = builder.addSchema(1470, DataConverterSchemaV1470::new);
        builder.addFixer(new DataConverterAddChoices(schema50, "Add 1.13 entities fix", DataConverterTypes.q));
        Schema schema51 = builder.addSchema(1474, b);
        builder.addFixer(new DataConverterColorlessShulkerEntity(schema51, false));
        builder.addFixer(DataConverterBlockRename.a(schema51, "Colorless shulker block fixer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s2));
        builder.addFixer(DataConverterItemName.a(schema51, "Colorless shulker item fixer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s2));
        Schema schema52 = builder.addSchema(1475, b);
        builder.addFixer(DataConverterBlockRename.a(schema52, "Flowing fixer", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema53 = builder.addSchema(1480, b);
        builder.addFixer(DataConverterBlockRename.a(schema53, "Rename coral blocks", DataConverterRegistry.a(DataConverterCoral.a)));
        builder.addFixer(DataConverterItemName.a(schema53, "Rename coral items", DataConverterRegistry.a(DataConverterCoral.a)));
        Schema schema54 = builder.addSchema(1481, DataConverterSchemaV1481::new);
        builder.addFixer(new DataConverterAddChoices(schema54, "Add conduit", DataConverterTypes.l));
        Schema schema55 = builder.addSchema(1483, DataConverterSchemaV1483::new);
        builder.addFixer(new DataConverterEntityPufferfish(schema55, true));
        builder.addFixer(DataConverterItemName.a(schema55, "Rename pufferfish egg item", DataConverterRegistry.a(DataConverterEntityPufferfish.a)));
        Schema schema56 = builder.addSchema(1484, b);
        builder.addFixer(DataConverterItemName.a(schema56, "Rename seagrass items", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        builder.addFixer(DataConverterBlockRename.a(schema56, "Rename seagrass blocks", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        builder.addFixer(new DataConverterHeightmapRenaming(schema56, false));
        Schema schema57 = builder.addSchema(1486, DataConverterSchemaV1486::new);
        builder.addFixer(new DataConverterEntityCodSalmon(schema57, true));
        builder.addFixer(DataConverterItemName.a(schema57, "Rename cod/salmon egg items", DataConverterRegistry.a(DataConverterEntityCodSalmon.b)));
        Schema schema58 = builder.addSchema(1487, b);
        builder.addFixer(DataConverterItemName.a(schema58, "Rename prismarine_brick(s)_* blocks", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        builder.addFixer(DataConverterBlockRename.a(schema58, "Rename prismarine_brick(s)_* items", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema59 = builder.addSchema(1488, b);
        builder.addFixer(DataConverterBlockRename.a(schema59, "Rename kelp/kelptop", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        builder.addFixer(DataConverterItemName.a(schema59, "Rename kelptop", DataConverterRegistry.a("minecraft:kelp_top", "minecraft:kelp")));
        builder.addFixer(new DataConverterNamedEntity(schema59, false, "Command block block entity custom name fix", DataConverterTypes.l, "minecraft:command_block"){

            @Override
            protected Typed<?> a(Typed<?> inputType) {
                return inputType.update(DSL.remainderFinder(), DataConverterCustomNameEntity::a);
            }
        });
        builder.addFixer(new DataConverterNamedEntity(schema59, false, "Command block minecart custom name fix", DataConverterTypes.q, "minecraft:commandblock_minecart"){

            @Override
            protected Typed<?> a(Typed<?> inputType) {
                return inputType.update(DSL.remainderFinder(), DataConverterCustomNameEntity::a);
            }
        });
        builder.addFixer(new DataConverterIglooMetadataRemoval(schema59, false));
        Schema schema60 = builder.addSchema(1490, b);
        builder.addFixer(DataConverterBlockRename.a(schema60, "Rename melon_block", DataConverterRegistry.a("minecraft:melon_block", "minecraft:melon")));
        builder.addFixer(DataConverterItemName.a(schema60, "Rename melon_block/melon/speckled_melon", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema61 = builder.addSchema(1492, b);
        builder.addFixer(new DataConverterChunkStructuresTemplateRename(schema61, false));
        Schema schema62 = builder.addSchema(1494, b);
        builder.addFixer(new DataConverterItemStackEnchantment(schema62, false));
        Schema schema63 = builder.addSchema(1496, b);
        builder.addFixer(new DataConverterLeaves(schema63, false));
        Schema schema64 = builder.addSchema(1500, b);
        builder.addFixer(new DataConverterBlockEntityKeepPacked(schema64, false));
        Schema schema65 = builder.addSchema(1501, b);
        builder.addFixer(new DataConverterAdvancement(schema65, false));
        Schema schema66 = builder.addSchema(1502, b);
        builder.addFixer(new DataConverterRecipes(schema66, false));
        Schema schema67 = builder.addSchema(1506, b);
        builder.addFixer(new DataConverterLevelDataGeneratorOptions(schema67, false));
        Schema schema68 = builder.addSchema(1510, DataConverterSchemaV1510::new);
        builder.addFixer(DataConverterBlockRename.a(schema68, "Block renamening fix", DataConverterRegistry.a(DataConverterEntityRename.b)));
        builder.addFixer(DataConverterItemName.a(schema68, "Item renamening fix", DataConverterRegistry.a(DataConverterEntityRename.c)));
        builder.addFixer(new DataConverterRecipeRename(schema68, false));
        builder.addFixer(new DataConverterEntityRename(schema68, true));
        builder.addFixer(new StatsRenameFix(schema68, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema schema69 = builder.addSchema(1514, b);
        builder.addFixer(new DataConverterObjectiveDisplayName(schema69, false));
        builder.addFixer(new DataConverterTeamDisplayName(schema69, false));
        builder.addFixer(new DataConverterObjectiveRenderType(schema69, false));
        Schema schema70 = builder.addSchema(1515, b);
        builder.addFixer(DataConverterBlockRename.a(schema70, "Rename coral fan blocks", DataConverterRegistry.a(DataConverterCoralFan.a)));
        Schema schema71 = builder.addSchema(1624, b);
        builder.addFixer(new DataConverterTrappedChest(schema71, false));
        Schema schema72 = builder.addSchema(1800, DataConverterSchemaV1800::new);
        builder.addFixer(new DataConverterAddChoices(schema72, "Added 1.14 mobs fix", DataConverterTypes.q));
        builder.addFixer(DataConverterItemName.a(schema72, "Rename dye items", DataConverterRegistry.a(DataConverterDye.a)));
        Schema schema73 = builder.addSchema(1801, DataConverterSchemaV1801::new);
        builder.addFixer(new DataConverterAddChoices(schema73, "Added Illager Beast", DataConverterTypes.q));
        Schema schema74 = builder.addSchema(1802, b);
        builder.addFixer(DataConverterBlockRename.a(schema74, "Rename sign blocks & stone slabs", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        builder.addFixer(DataConverterItemName.a(schema74, "Rename sign item & stone slabs", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema75 = builder.addSchema(1803, b);
        builder.addFixer(new DataConverterItemLoreComponentize(schema75, false));
        Schema schema76 = builder.addSchema(1904, DataConverterSchemaV1904::new);
        builder.addFixer(new DataConverterAddChoices(schema76, "Added Cats", DataConverterTypes.q));
        builder.addFixer(new DataConverterEntityCatSplit(schema76, false));
        Schema schema77 = builder.addSchema(1905, b);
        builder.addFixer(new DataConverterChunkStatus(schema77, false));
        Schema schema78 = builder.addSchema(1906, DataConverterSchemaV1906::new);
        builder.addFixer(new DataConverterAddChoices(schema78, "Add POI Blocks", DataConverterTypes.l));
        Schema schema79 = builder.addSchema(1909, DataConverterSchemaV1909::new);
        builder.addFixer(new DataConverterAddChoices(schema79, "Add jigsaw", DataConverterTypes.l));
        Schema schema80 = builder.addSchema(1911, b);
        builder.addFixer(new DataConverterChunkStatus2(schema80, false));
        Schema schema81 = builder.addSchema(1917, b);
        builder.addFixer(new DataConverterCatType(schema81, false));
        Schema schema82 = builder.addSchema(1918, b);
        builder.addFixer(new DataConverterVillagerProfession(schema82, "minecraft:villager"));
        builder.addFixer(new DataConverterVillagerProfession(schema82, "minecraft:zombie_villager"));
        Schema schema83 = builder.addSchema(1920, DataConverterSchemaV1920::new);
        builder.addFixer(new DataConverterNewVillage(schema83, false));
        builder.addFixer(new DataConverterAddChoices(schema83, "Add campfire", DataConverterTypes.l));
        Schema schema84 = builder.addSchema(1925, b);
        builder.addFixer(new DataConverterMapId(schema84, false));
        Schema schema85 = builder.addSchema(1928, DataConverterSchemaV1928::new);
        builder.addFixer(new DataConverterEntityRavagerRename(schema85, true));
        builder.addFixer(DataConverterItemName.a(schema85, "Rename ravager egg item", DataConverterRegistry.a(DataConverterEntityRavagerRename.a)));
        Schema schema86 = builder.addSchema(1929, DataConverterSchemaV1929::new);
        builder.addFixer(new DataConverterAddChoices(schema86, "Add Wandering Trader and Trader Llama", DataConverterTypes.q));
        Schema schema87 = builder.addSchema(1931, DataConverterSchemaV1931::new);
        builder.addFixer(new DataConverterAddChoices(schema87, "Added Fox", DataConverterTypes.q));
        Schema schema88 = builder.addSchema(1936, b);
        builder.addFixer(new DataConverterOptionsAddTextBackground(schema88, false));
        Schema schema89 = builder.addSchema(1946, b);
        builder.addFixer(new DataConverterPOI(schema89, false));
        Schema schema90 = builder.addSchema(1948, b);
        builder.addFixer(new DataConverterOminousBannerRename(schema90, false));
        Schema schema91 = builder.addSchema(1953, b);
        builder.addFixer(new DataConverterOminousBannerBlockEntityRename(schema91, false));
        Schema schema92 = builder.addSchema(1955, b);
        builder.addFixer(new DataConverterVillagerLevelXp(schema92, false));
        builder.addFixer(new DataConverterZombieVillagerLevelXp(schema92, false));
        Schema schema93 = builder.addSchema(1961, b);
        builder.addFixer(new DataConverterChunkLightRemove(schema93, false));
        Schema schema94 = builder.addSchema(1963, b);
        builder.addFixer(new DataConverterRemoveGolemGossip(schema94, false));
        Schema schema95 = builder.addSchema(2100, DataConverterSchemaV2100::new);
        builder.addFixer(new DataConverterAddChoices(schema95, "Added Bee and Bee Stinger", DataConverterTypes.q));
        builder.addFixer(new DataConverterAddChoices(schema95, "Add beehive", DataConverterTypes.l));
        builder.addFixer(new DataConverterRecipeBase(schema95, false, "Rename sugar recipe", DataConverterRegistry.a("minecraft:sugar", "sugar_from_sugar_cane")));
        builder.addFixer(new DataConverterAdvancementBase(schema95, false, "Rename sugar recipe advancement", DataConverterRegistry.a("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema96 = builder.addSchema(2202, b);
        builder.addFixer(new DataConverterLeavesBiome(schema96, false));
        Schema schema97 = builder.addSchema(2209, b);
        builder.addFixer(DataConverterItemName.a(schema97, "Rename bee_hive item to beehive", DataConverterRegistry.a("minecraft:bee_hive", "minecraft:beehive")));
        builder.addFixer(new DataConverterBeehive(schema97));
        builder.addFixer(DataConverterBlockRename.a(schema97, "Rename bee_hive block to beehive", DataConverterRegistry.a("minecraft:bee_hive", "minecraft:beehive")));
        Schema schema98 = builder.addSchema(2211, b);
        builder.addFixer(new DataConverterStructureReference(schema98, false));
        Schema schema99 = builder.addSchema(2218, b);
        builder.addFixer(new DataConverterPOIRebuild(schema99, false));
        Schema schema100 = builder.addSchema(2501, DataConverterSchemaV2501::new);
        builder.addFixer(new DataConverterFurnaceRecipesUsed(schema100, true));
        Schema schema101 = builder.addSchema(2502, DataConverterSchemaV2502::new);
        builder.addFixer(new DataConverterAddChoices(schema101, "Added Hoglin", DataConverterTypes.q));
        Schema schema102 = builder.addSchema(2503, b);
        builder.addFixer(new DataConverterWallProperty(schema102, false));
        builder.addFixer(new DataConverterAdvancementBase(schema102, false, "Composter category change", DataConverterRegistry.a("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema103 = builder.addSchema(2505, DataConverterSchemaV2505::new);
        builder.addFixer(new DataConverterAddChoices(schema103, "Added Piglin", DataConverterTypes.q));
        builder.addFixer(new DataConverterMemoryExpiry(schema103, "minecraft:villager"));
        Schema schema104 = builder.addSchema(2508, b);
        builder.addFixer(DataConverterItemName.a(schema104, "Renamed fungi items to fungus", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        builder.addFixer(DataConverterBlockRename.a(schema104, "Renamed fungi blocks to fungus", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema105 = builder.addSchema(2509, DataConverterSchemaV2509::new);
        builder.addFixer(new DataConverterEntityZombifiedPiglinRename(schema105));
        builder.addFixer(DataConverterItemName.a(schema105, "Rename zombie pigman egg item", DataConverterRegistry.a(DataConverterEntityZombifiedPiglinRename.a)));
        Schema schema106 = builder.addSchema(2511, b);
        builder.addFixer(new DataConverterEntityProjectileOwner(schema106));
        Schema schema107 = builder.addSchema(2514, b);
        builder.addFixer(new DataConverterEntityUUID(schema107));
        builder.addFixer(new DataConverterBlockEntityUUID(schema107));
        builder.addFixer(new DataConverterPlayerUUID(schema107));
        builder.addFixer(new DataConverterMiscUUID(schema107));
        builder.addFixer(new DataConverterSavedDataUUID(schema107));
        builder.addFixer(new DataConverterItemStackUUID(schema107));
        Schema schema108 = builder.addSchema(2516, b);
        builder.addFixer(new DataConverterGossip(schema108, "minecraft:villager"));
        builder.addFixer(new DataConverterGossip(schema108, "minecraft:zombie_villager"));
        Schema schema109 = builder.addSchema(2518, b);
        builder.addFixer(new DataConverterJigsawProperties(schema109, false));
        builder.addFixer(new DataConverterJigsawRotation(schema109, false));
        Schema schema110 = builder.addSchema(2519, DataConverterSchemaV2519::new);
        builder.addFixer(new DataConverterAddChoices(schema110, "Added Strider", DataConverterTypes.q));
        Schema schema111 = builder.addSchema(2522, DataConverterSchemaV2522::new);
        builder.addFixer(new DataConverterAddChoices(schema111, "Added Zoglin", DataConverterTypes.q));
        Schema schema112 = builder.addSchema(2523, b);
        builder.addFixer(new DataConverterAttributes(schema112));
        Schema schema113 = builder.addSchema(2527, b);
        builder.addFixer(new DataConverterBitStorageAlign(schema113));
        Schema schema114 = builder.addSchema(2528, b);
        builder.addFixer(DataConverterItemName.a(schema114, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        builder.addFixer(DataConverterBlockRename.a(schema114, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema115 = builder.addSchema(2529, b);
        builder.addFixer(new DataConverterStriderGravity(schema115, false));
        Schema schema116 = builder.addSchema(2531, b);
        builder.addFixer(new DataConverterRedstoneConnections(schema116));
        Schema schema117 = builder.addSchema(2533, b);
        builder.addFixer(new DataConverterVillagerFollowRange(schema117));
        Schema schema118 = builder.addSchema(2535, b);
        builder.addFixer(new DataConverterEntityShulkerRotation(schema118));
        Schema schema119 = builder.addSchema(2550, b);
        builder.addFixer(new DataConverterWorldGenSettingsBuilding(schema119));
        Schema schema120 = builder.addSchema(2551, DataConverterSchemaV2551::new);
        builder.addFixer(new DataConverterShoulderEntity(schema120, "add types to WorldGenData", DataConverterTypes.z));
        Schema schema121 = builder.addSchema(2552, b);
        builder.addFixer(new DataConverterBiomeBase(schema121, false, "Nether biome rename", (Map<String, String>)ImmutableMap.of((Object)"minecraft:nether", (Object)"minecraft:nether_wastes")));
        Schema schema122 = builder.addSchema(2553, b);
        builder.addFixer(new DataConverterBiome(schema122, false));
        Schema schema123 = builder.addSchema(2558, b);
        builder.addFixer(new DataConverterMissingDimension(schema123, false));
        builder.addFixer(new DataConverterSettingRename(schema123, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema124 = builder.addSchema(2568, DataConverterSchemaV2568::new);
        builder.addFixer(new DataConverterAddChoices(schema124, "Added Piglin Brute", DataConverterTypes.q));
        Schema schema125 = builder.addSchema(2571, V2571::new);
        builder.addFixer(new DataConverterAddChoices(schema125, "Added Goat", DataConverterTypes.q));
        Schema schema126 = builder.addSchema(2679, b);
        builder.addFixer(new CauldronRenameFix(schema126, false));
        Schema schema127 = builder.addSchema(2680, b);
        builder.addFixer(DataConverterItemName.a(schema127, "Renamed grass path item to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema127, "Renamed grass path block to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        Schema schema128 = builder.addSchema(2684, V2684::new);
        builder.addFixer(new DataConverterAddChoices(schema128, "Added Sculk Sensor", DataConverterTypes.l));
        Schema schema129 = builder.addSchema(2686, V2686::new);
        builder.addFixer(new DataConverterAddChoices(schema129, "Added Axolotl", DataConverterTypes.q));
        Schema schema130 = builder.addSchema(2688, V2688::new);
        builder.addFixer(new DataConverterAddChoices(schema130, "Added Glow Squid", DataConverterTypes.q));
        builder.addFixer(new DataConverterAddChoices(schema130, "Added Glow Item Frame", DataConverterTypes.q));
        Schema schema131 = builder.addSchema(2690, b);
        ImmutableMap immutablemap = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        builder.addFixer(DataConverterItemName.a(schema131, "Renamed copper block items to new oxidized terms", DataConverterRegistry.a((Map<String, String>)immutablemap)));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema131, "Renamed copper blocks to new oxidized terms", DataConverterRegistry.a((Map<String, String>)immutablemap)));
        Schema schema132 = builder.addSchema(2691, b);
        ImmutableMap immutablemap1 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        builder.addFixer(DataConverterItemName.a(schema132, "Rename copper item suffixes", DataConverterRegistry.a((Map<String, String>)immutablemap1)));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema132, "Rename copper blocks suffixes", DataConverterRegistry.a((Map<String, String>)immutablemap1)));
        Schema schema133 = builder.addSchema(2693, b);
        builder.addFixer(new AddFlagIfNotPresentFix(schema133, DataConverterTypes.z, "has_increased_height_already", false));
        Schema schema134 = builder.addSchema(2696, b);
        ImmutableMap immutablemap2 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        builder.addFixer(DataConverterItemName.a(schema134, "Renamed grimstone block items to deepslate", DataConverterRegistry.a((Map<String, String>)immutablemap2)));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema134, "Renamed grimstone blocks to deepslate", DataConverterRegistry.a((Map<String, String>)immutablemap2)));
        Schema schema135 = builder.addSchema(2700, b);
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema135, "Renamed cave vines blocks", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema schema136 = builder.addSchema(2701, b);
        builder.addFixer(new SavedDataFeaturePoolElementFix(schema136));
        Schema schema137 = builder.addSchema(2702, b);
        builder.addFixer(new AbstractArrowPickupFix(schema137));
        Schema schema138 = builder.addSchema(2704, V2704::new);
        builder.addFixer(new DataConverterAddChoices(schema138, "Added Goat", DataConverterTypes.q));
        Schema schema139 = builder.addSchema(2707, V2707::new);
        builder.addFixer(new DataConverterAddChoices(schema139, "Added Marker", DataConverterTypes.q));
        builder.addFixer(new AddFlagIfNotPresentFix(schema139, DataConverterTypes.z, "has_increased_height_already", true));
        Schema schema140 = builder.addSchema(2710, b);
        builder.addFixer(new StatsRenameFix(schema140, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema schema141 = builder.addSchema(2717, b);
        builder.addFixer(DataConverterItemName.a(schema141, "Rename azalea_leaves_flowers", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        builder.addFixer(DataConverterBlockRename.a(schema141, "Rename azalea_leaves_flowers items", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema schema142 = builder.addSchema(2825, b);
        builder.addFixer(new AddFlagIfNotPresentFix(schema142, DataConverterTypes.z, "has_increased_height_already", false));
        Schema schema143 = builder.addSchema(2831, V2831::new);
        builder.addFixer(new SpawnerDataFix(schema143));
        Schema schema144 = builder.addSchema(2832, V2832::new);
        builder.addFixer(new WorldGenSettingsHeightAndBiomeFix(schema144));
        builder.addFixer(new ChunkHeightAndBiomeFix(schema144));
        Schema schema145 = builder.addSchema(2833, b);
        builder.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema145));
        Schema schema146 = builder.addSchema(2838, b);
        builder.addFixer(new DataConverterBiomeBase(schema146, false, "Caves and Cliffs biome renames", (Map<String, String>)CavesAndCliffsRenames.a));
        Schema schema147 = builder.addSchema(2841, b);
        builder.addFixer(new ChunkProtoTickListFix(schema147));
        Schema schema148 = builder.addSchema(2842, V2842::new);
        builder.addFixer(new ChunkRenamesFix(schema148));
        Schema schema149 = builder.addSchema(2843, b);
        builder.addFixer(new DataConverterBiomeBase(schema149, false, "Remove Deep Warm Ocean", Map.of("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema schema150 = builder.addSchema(2846, b);
        builder.addFixer(new DataConverterAdvancementBase(schema150, false, "Rename some C&C part 2 advancements", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema schema151 = builder.addSchema(2852, b);
        builder.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema151));
    }

    private static UnaryOperator<String> a(Map<String, String> replacements) {
        return s2 -> replacements.getOrDefault(s2, (String)s2);
    }

    private static UnaryOperator<String> a(String old, String current) {
        return s2 -> Objects.equals(s2, old) ? current : s2;
    }
}

