/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C>
extends ToFloatFunction<C> {
    @VisibleForDebug
    public String a();

    public static <C> Codec<CubicSpline<C>> a(Codec<ToFloatFunction<C>> codec) {
        record A<C>(float a, CubicSpline<C> b, float c) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this, object);
            }
        }
        MutableObject mutableObject = new MutableObject();
        Codec codec2 = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("location").forGetter(A::a), (App)ExtraCodecs.a(() -> ((MutableObject)mutableObject).getValue()).fieldOf("value").forGetter(A::b), (App)Codec.FLOAT.fieldOf("derivative").forGetter(A::c)).apply((Applicative)instance, (f2, cubicSpline, g2) -> new A((float)f2, cubicSpline, (float)g2)));
        Codec codec3 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("coordinate").forGetter(d::b), (App)ExtraCodecs.a(codec2.listOf()).fieldOf("points").forGetter(multipoint -> IntStream.range(0, multipoint.b.length).mapToObj(i2 -> new A(multipoint.c()[i2], multipoint.d().get(i2), multipoint.e()[i2])).toList())).apply((Applicative)instance, (toFloatFunction, list) -> {
            float[] fs = new float[list.size()];
            ImmutableList.Builder builder = ImmutableList.builder();
            float[] gs = new float[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                A lv = (A)list.get(i2);
                fs[i2] = lv.a();
                builder.add(lv.b());
                gs[i2] = lv.c();
            }
            return new d(toFloatFunction, fs, builder.build(), gs);
        }));
        mutableObject.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)codec3).xmap(either -> (CubicSpline)((Object)either.map(c::new, multipoint -> multipoint)), cubicSpline -> {
            Either<Object, d<Object>> either;
            if (cubicSpline instanceof c) {
                c constant = (c)cubicSpline;
                either = Either.left(Float.valueOf(constant.b()));
            } else {
                either = Either.right((d)cubicSpline);
            }
            return either;
        }));
        return (Codec)mutableObject.getValue();
    }

    public static <C> CubicSpline<C> a(float value) {
        return new c(value);
    }

    public static <C> b<C> a(ToFloatFunction<C> locationFunction) {
        return new b<C>(locationFunction);
    }

    public static <C> b<C> a(ToFloatFunction<C> locationFunction, ToFloatFunction<Float> toFloatFunction) {
        return new b<C>(locationFunction, toFloatFunction);
    }

    @VisibleForDebug
    public record c<C>(float a) implements CubicSpline<C>
    {
        private final float a;

        @Override
        @Override
        public float apply(C x2) {
            return this.a;
        }

        @Override
        @Override
        public String a() {
            return String.format("k=%.3f", Float.valueOf(this.a));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "value", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "value", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "value", "a"}, this, object);
        }

        public float b() {
            return this.a;
        }
    }

    public static final class b<C> {
        private final ToFloatFunction<C> a;
        private final ToFloatFunction<Float> b;
        private final FloatList c = new FloatArrayList();
        private final List<CubicSpline<C>> d = Lists.newArrayList();
        private final FloatList e = new FloatArrayList();

        protected b(ToFloatFunction<C> locationFunction) {
            this(locationFunction, float_ -> float_.floatValue());
        }

        protected b(ToFloatFunction<C> locationFunction, ToFloatFunction<Float> toFloatFunction) {
            this.a = locationFunction;
            this.b = toFloatFunction;
        }

        public b<C> a(float location, float value, float derivative) {
            return this.a(location, new c(this.b.apply(Float.valueOf(value))), derivative);
        }

        public b<C> a(float location, CubicSpline<C> value, float derivative) {
            if (!this.c.isEmpty() && location <= this.c.getFloat(this.c.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.c.add(location);
            this.d.add(value);
            this.e.add(derivative);
            return this;
        }

        public CubicSpline<C> a() {
            if (this.c.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return new d<C>(this.a, this.c.toFloatArray(), ImmutableList.copyOf(this.d), this.e.toFloatArray());
        }
    }

    @VisibleForDebug
    public record d<C>(ToFloatFunction<C> a, float[] b, List<CubicSpline<C>> c, float[] d) implements CubicSpline<C>
    {
        private final ToFloatFunction<C> a;
        private final float[] b;
        private final List<CubicSpline<C>> c;
        private final float[] d;

        public d {
            if (fs.length != list.size() || fs.length != gs.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + fs.length + " " + list.size() + " " + gs.length);
            }
        }

        @Override
        @Override
        public float apply(C x2) {
            float f2 = this.a.apply(x2);
            int i3 = MathHelper.a(0, this.b.length, (int i2) -> f2 < this.b[i2]) - 1;
            int j2 = this.b.length - 1;
            if (i3 < 0) {
                return this.c.get(0).apply(x2) + this.d[0] * (f2 - this.b[0]);
            }
            if (i3 == j2) {
                return this.c.get(j2).apply(x2) + this.d[j2] * (f2 - this.b[j2]);
            }
            float g2 = this.b[i3];
            float h2 = this.b[i3 + 1];
            float k2 = (f2 - g2) / (h2 - g2);
            ToFloatFunction toFloatFunction = this.c.get(i3);
            ToFloatFunction toFloatFunction2 = this.c.get(i3 + 1);
            float l2 = this.d[i3];
            float m2 = this.d[i3 + 1];
            float n2 = toFloatFunction.apply(x2);
            float o2 = toFloatFunction2.apply(x2);
            float p2 = l2 * (h2 - g2) - (o2 - n2);
            float q2 = -m2 * (h2 - g2) + (o2 - n2);
            float r2 = MathHelper.i(k2, n2, o2) + k2 * (1.0f - k2) * MathHelper.i(k2, p2, q2);
            return r2;
        }

        @Override
        @VisibleForTesting
        @Override
        public String a() {
            return "Spline{coordinate=" + this.a + ", locations=" + this.a(this.b) + ", derivatives=" + this.a(this.d) + ", values=" + this.c.stream().map(CubicSpline::a).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String a(float[] fs) {
            return "[" + IntStream.range(0, fs.length).mapToDouble(i2 -> fs[i2]).mapToObj(d2 -> String.format(Locale.ROOT, "%.3f", d2)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "coordinate;locations;values;derivatives", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "coordinate;locations;values;derivatives", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "coordinate;locations;values;derivatives", "a", "b", "c", "d"}, this, object);
        }

        public ToFloatFunction<C> b() {
            return this.a;
        }

        public float[] c() {
            return this.b;
        }

        public List<CubicSpline<C>> d() {
            return this.c;
        }

        public float[] e() {
            return this.d;
        }
    }
}

