/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class ArraySetSorted<T>
extends AbstractSet<T> {
    private static final int a = 10;
    private final Comparator<T> b;
    T[] c;
    int d;

    private ArraySetSorted(int initialCapacity, Comparator<T> comparator) {
        this.b = comparator;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + initialCapacity + ") is negative");
        }
        this.c = ArraySetSorted.a(new Object[initialCapacity]);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        int i2 = 0;
        int len = this.d;
        Object[] backingArray = this.c;
        while (true) {
            if (i2 >= len) {
                return false;
            }
            if (filter.test(backingArray[i2])) break;
            ++i2;
        }
        int lastIndex = i2;
        while (i2 < len) {
            T curr = backingArray[i2];
            if (!filter.test(curr)) {
                backingArray[lastIndex++] = curr;
            }
            ++i2;
        }
        Arrays.fill(backingArray, lastIndex, len, null);
        this.d = lastIndex;
        return true;
    }

    public static <T extends Comparable<T>> ArraySetSorted<T> a() {
        return ArraySetSorted.a(10);
    }

    public static <T extends Comparable<T>> ArraySetSorted<T> a(int initialCapacity) {
        return new ArraySetSorted(initialCapacity, Comparator.naturalOrder());
    }

    public static <T> ArraySetSorted<T> a(Comparator<T> comparator) {
        return ArraySetSorted.a(comparator, 10);
    }

    public static <T> ArraySetSorted<T> a(Comparator<T> comparator, int initialCapacity) {
        return new ArraySetSorted<T>(initialCapacity, comparator);
    }

    private static <T> T[] a(Object[] array) {
        return array;
    }

    private int c(T object) {
        return Arrays.binarySearch(this.c, 0, this.d, object, this.b);
    }

    private static int b(int binarySearchResult) {
        return -binarySearchResult - 1;
    }

    @Override
    public boolean add(T object) {
        int i2 = this.c(object);
        if (i2 >= 0) {
            return false;
        }
        int j2 = ArraySetSorted.b(i2);
        this.a(object, j2);
        return true;
    }

    private void c(int minCapacity) {
        if (minCapacity > this.c.length) {
            if (this.c != ObjectArrays.DEFAULT_EMPTY_ARRAY) {
                minCapacity = (int)Math.max(Math.min((long)this.c.length + (long)(this.c.length >> 1), 0x7FFFFFF7L), (long)minCapacity);
            } else if (minCapacity < 10) {
                minCapacity = 10;
            }
            Object[] objects = new Object[minCapacity];
            System.arraycopy(this.c, 0, objects, 0, this.d);
            this.c = ArraySetSorted.a(objects);
        }
    }

    private void a(T object, int index) {
        this.c(this.d + 1);
        if (index != this.d) {
            System.arraycopy(this.c, index, this.c, index + 1, this.d - index);
        }
        this.c[index] = object;
        ++this.d;
    }

    void d(int index) {
        --this.d;
        if (index != this.d) {
            System.arraycopy(this.c, index + 1, this.c, index, this.d - index);
        }
        this.c[this.d] = null;
    }

    private T e(int index) {
        return this.c[index];
    }

    public T a(T object) {
        int i2 = this.c(object);
        if (i2 >= 0) {
            return this.e(i2);
        }
        this.a(object, ArraySetSorted.b(i2));
        return object;
    }

    @Override
    public boolean remove(Object object) {
        int i2 = this.c(object);
        if (i2 >= 0) {
            this.d(i2);
            return true;
        }
        return false;
    }

    @Nullable
    public T b(T object) {
        int i2 = this.c(object);
        return i2 >= 0 ? (T)this.e(i2) : null;
    }

    public T b() {
        return this.e(0);
    }

    public T c() {
        return this.e(this.d - 1);
    }

    @Override
    public boolean contains(Object object) {
        int i2 = this.c(object);
        return i2 >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new a();
    }

    @Override
    public int size() {
        return this.d;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.c.clone();
    }

    @Override
    public <U> U[] toArray(U[] objects) {
        if (objects.length < this.d) {
            return Arrays.copyOf(this.c, this.d, objects.getClass());
        }
        System.arraycopy(this.c, 0, objects, 0, this.d);
        if (objects.length > this.d) {
            objects[this.d] = null;
        }
        return objects;
    }

    @Override
    public void clear() {
        Arrays.fill(this.c, 0, this.d, null);
        this.d = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ArraySetSorted) {
            ArraySetSorted sortedArraySet = (ArraySetSorted)object;
            if (this.b.equals(sortedArraySet.b)) {
                return this.d == sortedArraySet.d && Arrays.equals(this.c, sortedArraySet.c);
            }
        }
        return super.equals(object);
    }

    class a
    implements Iterator<T> {
        private int b;
        private int c = -1;

        a() {
        }

        @Override
        public boolean hasNext() {
            return this.b < ArraySetSorted.this.d;
        }

        @Override
        public T next() {
            if (this.b >= ArraySetSorted.this.d) {
                throw new NoSuchElementException();
            }
            this.c = this.b++;
            return ArraySetSorted.this.c[this.c];
        }

        @Override
        public void remove() {
            if (this.c == -1) {
                throw new IllegalStateException();
            }
            ArraySetSorted.this.d(this.c);
            --this.b;
            this.c = -1;
        }
    }
}

