/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.ExpirableListEntry;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.SavedFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NameReferencingFileConverter {
    static final Logger e = LogManager.getLogger();
    public static final File a = new File("banned-ips.txt");
    public static final File b = new File("banned-players.txt");
    public static final File c = new File("ops.txt");
    public static final File d = new File("white-list.txt");

    static List<String> a(File file, Map<String, String[]> valueMap) throws IOException {
        List list = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        for (String s2 : list) {
            if ((s2 = s2.trim()).startsWith("#") || s2.length() < 1) continue;
            String[] astring = s2.split("\\|");
            valueMap.put(astring[0].toLowerCase(Locale.ROOT), astring);
        }
        return list;
    }

    private static void a(MinecraftServer server, Collection<String> bannedPlayers, ProfileLookupCallback callback) {
        String[] astring = (String[])bannedPlayers.stream().filter(s2 -> !UtilColor.b(s2)).toArray(String[]::new);
        if (server.U() || PaperConfig.isProxyOnlineMode()) {
            server.an().findProfilesByNames(astring, Agent.MINECRAFT, callback);
        } else {
            String[] astring1 = astring;
            int i2 = astring.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                String s3 = astring1[j2];
                UUID uuid = EntityHuman.a(new GameProfile((UUID)null, s3));
                GameProfile gameprofile = new GameProfile(uuid, s3);
                callback.onProfileLookupSucceeded(gameprofile);
            }
        }
    }

    public static boolean a(final MinecraftServer server) {
        final GameProfileBanList gameprofilebanlist = new GameProfileBanList(PlayerList.b);
        if (b.exists() && b.isFile()) {
            if (gameprofilebanlist.b().exists()) {
                try {
                    gameprofilebanlist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)gameprofilebanlist.b().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.a(b, map);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.ao().a(gameprofile);
                        String[] astring = (String[])map.get(gameprofile.getName().toLowerCase(Locale.ROOT));
                        if (astring == null) {
                            e.warn("Could not convert user banlist entry for {}", (Object)gameprofile.getName());
                            throw new FileConversionException("Profile not in the conversionlist");
                        }
                        Date date = astring.length > 1 ? NameReferencingFileConverter.a(astring[1], (Date)null) : null;
                        String s2 = astring.length > 2 ? astring[2] : null;
                        Date date1 = astring.length > 3 ? NameReferencingFileConverter.a(astring[3], (Date)null) : null;
                        String s1 = astring.length > 4 ? astring[4] : null;
                        gameprofilebanlist.a(new GameProfileBanEntry(gameprofile, date, s2, date1, s1));
                    }

                    public void onProfileLookupFailed(GameProfile gameprofile, Exception exception) {
                        e.warn("Could not lookup user banlist entry for {}", (Object)gameprofile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + gameprofile.getName() + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(server, map.keySet(), profilelookupcallback);
                gameprofilebanlist.e();
                NameReferencingFileConverter.b(b);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not read old user banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean b(MinecraftServer server) {
        IpBanList ipbanlist = new IpBanList(PlayerList.c);
        if (a.exists() && a.isFile()) {
            if (ipbanlist.b().exists()) {
                try {
                    ipbanlist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)ipbanlist.b().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.a(a, map);
                for (String s2 : map.keySet()) {
                    String[] astring = (String[])map.get(s2);
                    Date date = astring.length > 1 ? NameReferencingFileConverter.a(astring[1], (Date)null) : null;
                    String s1 = astring.length > 2 ? astring[2] : null;
                    Date date1 = astring.length > 3 ? NameReferencingFileConverter.a(astring[3], (Date)null) : null;
                    String s22 = astring.length > 4 ? astring[4] : null;
                    ipbanlist.a(new IpBanEntry(s2, date, s1, date1, s22));
                }
                ipbanlist.e();
                NameReferencingFileConverter.b(a);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not parse old ip banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
        }
        return true;
    }

    public static boolean c(final MinecraftServer server) {
        final OpList oplist = new OpList(PlayerList.d);
        if (c.exists() && c.isFile()) {
            if (oplist.b().exists()) {
                try {
                    oplist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)oplist.b().getName());
                }
            }
            try {
                List list = Files.readLines((File)c, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.ao().a(gameprofile);
                        oplist.a(new OpListEntry(gameprofile, server.h(), false));
                    }

                    public void onProfileLookupFailed(GameProfile gameprofile, Exception exception) {
                        e.warn("Could not lookup oplist entry for {}", (Object)gameprofile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + gameprofile.getName() + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(server, list, profilelookupcallback);
                oplist.e();
                NameReferencingFileConverter.b(c);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not read old oplist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean d(final MinecraftServer server) {
        final WhiteList whitelist = new WhiteList(PlayerList.e);
        if (d.exists() && d.isFile()) {
            if (whitelist.b().exists()) {
                try {
                    whitelist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)whitelist.b().getName());
                }
            }
            try {
                List list = Files.readLines((File)d, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.ao().a(gameprofile);
                        whitelist.a(new WhiteListEntry(gameprofile));
                    }

                    public void onProfileLookupFailed(GameProfile gameprofile, Exception exception) {
                        e.warn("Could not lookup user whitelist entry for {}", (Object)gameprofile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + gameprofile.getName() + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(server, list, profilelookupcallback);
                whitelist.e();
                NameReferencingFileConverter.b(d);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not read old whitelist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID a(final MinecraftServer server, String name) {
        if (!UtilColor.b(name) && name.length() <= 16) {
            Optional<UUID> optional = server.ao().a(name).map(GameProfile::getId);
            if (optional.isPresent()) {
                return optional.get();
            }
            if (!server.O() && server.U()) {
                final ArrayList list = Lists.newArrayList();
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.ao().a(gameprofile);
                        list.add(gameprofile);
                    }

                    public void onProfileLookupFailed(GameProfile gameprofile, Exception exception) {
                        e.warn("Could not lookup user whitelist entry for {}", (Object)gameprofile.getName(), (Object)exception);
                    }
                };
                NameReferencingFileConverter.a(server, Lists.newArrayList((Object[])new String[]{name}), profilelookupcallback);
                return !list.isEmpty() && ((GameProfile)list.get(0)).getId() != null ? ((GameProfile)list.get(0)).getId() : null;
            }
            return EntityHuman.a(new GameProfile((UUID)null, name));
        }
        try {
            return UUID.fromString(name);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public static boolean a(final DedicatedServer minecraftServer) {
        final File file = NameReferencingFileConverter.g(minecraftServer);
        final File file1 = new File(file.getParentFile(), "playerdata");
        final File file2 = new File(file.getParentFile(), "unknownplayers");
        if (file.exists() && file.isDirectory()) {
            File[] afile = file.listFiles();
            ArrayList list = Lists.newArrayList();
            File[] afile1 = afile;
            int i2 = afile.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                String s1;
                File file3 = afile1[j2];
                String s2 = file3.getName();
                if (!s2.toLowerCase(Locale.ROOT).endsWith(".dat") || (s1 = s2.substring(0, s2.length() - ".dat".length())).isEmpty()) continue;
                list.add(s1);
            }
            try {
                Object[] astring = list.toArray(new String[list.size()]);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){
                    final /* synthetic */ String[] val$astring;
                    {
                        this.val$astring = strings;
                    }

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftServer.ao().a(gameprofile);
                        UUID uuid = gameprofile.getId();
                        if (uuid == null) {
                            throw new FileConversionException("Missing UUID for user profile " + gameprofile.getName());
                        }
                        this.a(file1, this.a(gameprofile), uuid.toString());
                    }

                    public void onProfileLookupFailed(GameProfile gameprofile, Exception exception) {
                        e.warn("Could not lookup user uuid for {}", (Object)gameprofile.getName(), (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + gameprofile.getName() + " from backend systems", exception);
                        }
                        String s2 = this.a(gameprofile);
                        this.a(file2, s2, s2);
                    }

                    private void a(File playerDataFolder, String fileName, String uuid) {
                        File file5 = new File(file, fileName + ".dat");
                        File file6 = new File(playerDataFolder, uuid + ".dat");
                        NBTTagCompound root = null;
                        try {
                            root = NBTCompressedStreamTools.a(new FileInputStream(file5));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            ServerInternalException.reportInternalException((Throwable)exception);
                        }
                        if (root != null) {
                            if (!root.e("bukkit")) {
                                root.a("bukkit", new NBTTagCompound());
                            }
                            NBTTagCompound data = root.p("bukkit");
                            data.a("lastKnownName", fileName);
                            try {
                                NBTCompressedStreamTools.a(root, new FileOutputStream(file2));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                ServerInternalException.reportInternalException((Throwable)exception);
                            }
                        }
                        NameReferencingFileConverter.a(playerDataFolder);
                        if (!file5.renameTo(file6)) {
                            throw new FileConversionException("Could not convert file for " + fileName);
                        }
                    }

                    private String a(GameProfile profile) {
                        String s2 = null;
                        for (String s3 : this.val$astring) {
                            if (s3 == null || !s3.equalsIgnoreCase(profile.getName())) continue;
                            s2 = s3;
                            break;
                        }
                        if (s2 == null) {
                            throw new FileConversionException("Could not find the filename for " + profile.getName() + " anymore");
                        }
                        return s2;
                    }
                };
                NameReferencingFileConverter.a(minecraftServer, Lists.newArrayList((Object[])astring), profilelookupcallback);
                return true;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    static void a(File directory) {
        if (directory.exists() ? !directory.isDirectory() : !directory.mkdirs()) {
            throw new FileConversionException("Can't create directory " + directory.getName() + " in world save directory.");
        }
    }

    public static boolean e(MinecraftServer server) {
        boolean flag = NameReferencingFileConverter.a();
        flag = flag && NameReferencingFileConverter.f(server);
        return flag;
    }

    private static boolean a() {
        boolean flag = false;
        if (b.exists() && b.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (a.exists() && a.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (c.exists() && c.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (d.exists() && d.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        e.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
        e.warn("** please remove the following files and restart the server:");
        if (flag) {
            e.warn("* {}", (Object)b.getName());
        }
        if (flag1) {
            e.warn("* {}", (Object)a.getName());
        }
        if (flag2) {
            e.warn("* {}", (Object)c.getName());
        }
        if (flag3) {
            e.warn("* {}", (Object)d.getName());
        }
        return false;
    }

    private static boolean f(MinecraftServer server) {
        File file = NameReferencingFileConverter.g(server);
        if (file.exists() && file.isDirectory() && (file.list().length > 0 || !file.delete())) {
            e.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            e.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            e.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
            return false;
        }
        return true;
    }

    private static File g(MinecraftServer server) {
        return server.a(SavedFile.d).toFile();
    }

    private static void b(File file) {
        File file1 = new File(file.getName() + ".converted");
        file.renameTo(file1);
    }

    static Date a(String dateString, Date fallback) {
        Date date1;
        try {
            date1 = ExpirableListEntry.a.parse(dateString);
        }
        catch (ParseException parseexception) {
            date1 = fallback;
        }
        return date1;
    }

    private static class FileConversionException
    extends RuntimeException {
        FileConversionException(String title, Throwable other) {
            super(title, other);
        }

        FileConversionException(String title) {
            super(title);
        }
    }
}

