/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.util.ChatDeserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class JsonList<K, V extends JsonListEntry<K>> {
    protected static final Logger a = LogManager.getLogger();
    private static final Gson b = new GsonBuilder().setPrettyPrinting().create();
    private final File c;
    private final Map<String, V> d = Maps.newConcurrentMap();
    private boolean e = true;
    private static final ParameterizedType f = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{JsonListEntry.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };

    public JsonList(File file) {
        this.c = file;
    }

    public File b() {
        return this.c;
    }

    public void a(V entry) {
        this.d.put(this.a((K)((JsonListEntry)entry).g()), entry);
        try {
            this.e();
        }
        catch (IOException ioexception) {
            a.warn("Could not save the list after adding a user.", (Throwable)ioexception);
        }
    }

    @Nullable
    public V b(K key) {
        return (V)this.d.computeIfPresent(this.a(key), (k2, v2) -> v2.f() ? null : v2);
    }

    public void c(K key) {
        this.d.remove(this.a(key));
        try {
            this.e();
        }
        catch (IOException ioexception) {
            a.warn("Could not save the list after removing a user.", (Throwable)ioexception);
        }
    }

    public void b(JsonListEntry<K> entry) {
        this.c(entry.g());
    }

    public String[] a() {
        return this.d.keySet().toArray(new String[0]);
    }

    public Collection<V> getValues() {
        return this.d.values();
    }

    public boolean c() {
        return this.d.isEmpty();
    }

    protected String a(K profile) {
        return profile.toString();
    }

    protected boolean d(K k0) {
        return this.d.containsKey(this.a(k0));
    }

    private void g() {
        this.d.values().removeIf(JsonListEntry::f);
    }

    protected abstract JsonListEntry<K> a(JsonObject var1);

    public Collection<V> d() {
        return this.d.values();
    }

    public void e() throws IOException {
        this.g();
        JsonArray jsonarray = new JsonArray();
        Stream<JsonObject> stream = this.d.values().stream().map(jsonlistentry -> {
            JsonObject jsonobject = new JsonObject();
            Objects.requireNonNull(jsonlistentry);
            return SystemUtils.a(jsonobject, jsonlistentry::a);
        });
        Objects.requireNonNull(jsonarray);
        stream.forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
        try (BufferedWriter bufferedwriter = Files.newWriter((File)this.c, (Charset)StandardCharsets.UTF_8);){
            b.toJson((JsonElement)jsonarray, (Appendable)bufferedwriter);
        }
    }

    public void f() throws IOException {
        if (this.c.exists()) {
            BufferedReader bufferedreader = Files.newReader((File)this.c, (Charset)StandardCharsets.UTF_8);
            try {
                JsonArray jsonarray = (JsonArray)b.fromJson((Reader)bufferedreader, JsonArray.class);
                Preconditions.checkState((jsonarray != null ? 1 : 0) != 0, (Object)("The file \"" + this.c.getName() + "\" is either empty or corrupt"));
                this.d.clear();
                for (JsonElement jsonelement : jsonarray) {
                    JsonObject jsonobject = ChatDeserializer.m(jsonelement, "entry");
                    JsonListEntry<K> jsonlistentry = this.a(jsonobject);
                    if (jsonlistentry.g() == null) continue;
                    this.d.put(this.a(jsonlistentry.g()), jsonlistentry);
                }
            }
            catch (JsonParseException | NullPointerException ex) {
                Bukkit.getLogger().log(Level.WARNING, "Unable to read file " + this.c + ", backing it up to {0}.backup and creating new copy.", ex);
                File backup = new File(this.c + ".backup");
                this.c.renameTo(backup);
                this.c.delete();
            }
            catch (Throwable throwable) {
                if (bufferedreader != null) {
                    try {
                        bufferedreader.close();
                    }
                    catch (Throwable throwable1) {
                        throwable.addSuppressed(throwable1);
                    }
                }
                throw throwable;
            }
            if (bufferedreader != null) {
                bufferedreader.close();
            }
        }
    }
}

