/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IReloadable;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ReloadableProfiled;
import net.minecraft.server.packs.resources.ResourceManagerFallback;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ResourceManager
implements IReloadableResourceManager {
    private static final Logger a = LogManager.getLogger();
    private final Map<String, ResourceManagerFallback> b = Maps.newHashMap();
    private final List<IReloadListener> c = Lists.newArrayList();
    private final Set<String> d = Sets.newLinkedHashSet();
    private final List<IResourcePack> e = Lists.newArrayList();
    private final EnumResourcePackType f;

    public ResourceManager(EnumResourcePackType type) {
        this.f = type;
    }

    public void a(IResourcePack pack) {
        this.e.add(pack);
        for (String string : pack.a(this.f)) {
            this.d.add(string);
            ResourceManagerFallback fallbackResourceManager = this.b.get(string);
            if (fallbackResourceManager == null) {
                fallbackResourceManager = new ResourceManagerFallback(this.f, string);
                this.b.put(string, fallbackResourceManager);
            }
            fallbackResourceManager.a(pack);
        }
    }

    @Override
    @Override
    public Set<String> a() {
        return this.d;
    }

    @Override
    @Override
    public IResource a(MinecraftKey id) throws IOException {
        IResourceManager resourceManager = this.b.get(id.b());
        if (resourceManager != null) {
            return resourceManager.a(id);
        }
        throw new FileNotFoundException(id.toString());
    }

    @Override
    @Override
    public boolean b(MinecraftKey id) {
        IResourceManager resourceManager = this.b.get(id.b());
        if (resourceManager != null) {
            return resourceManager.b(id);
        }
        return false;
    }

    @Override
    @Override
    public List<IResource> c(MinecraftKey id) throws IOException {
        IResourceManager resourceManager = this.b.get(id.b());
        if (resourceManager != null) {
            return resourceManager.c(id);
        }
        throw new FileNotFoundException(id.toString());
    }

    @Override
    @Override
    public Collection<MinecraftKey> a(String startingPath, Predicate<String> pathPredicate) {
        HashSet set = Sets.newHashSet();
        for (ResourceManagerFallback fallbackResourceManager : this.b.values()) {
            set.addAll(fallbackResourceManager.a(startingPath, pathPredicate));
        }
        ArrayList list = Lists.newArrayList((Iterable)set);
        Collections.sort(list);
        return list;
    }

    private void c() {
        this.b.clear();
        this.d.clear();
        this.e.forEach(IResourcePack::close);
        this.e.clear();
    }

    @Override
    @Override
    public void close() {
        this.c();
    }

    @Override
    @Override
    public void a(IReloadListener reloader) {
        this.c.add(reloader);
    }

    @Override
    @Override
    public IReloadable a(Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage, List<IResourcePack> packs) {
        a.info("Reloading ResourceManager: {}", new Supplier[]{() -> packs.stream().map(IResourcePack::a).collect(Collectors.joining(", "))});
        this.c();
        for (IResourcePack packResources : packs) {
            try {
                this.a(packResources);
            }
            catch (Exception exception) {
                a.error("Failed to add resource pack {}", (Object)packResources.a(), (Object)exception);
                return new a(new b(packResources, (Throwable)exception));
            }
        }
        if (a.isDebugEnabled()) {
            return new ReloadableProfiled(this, Lists.newArrayList(this.c), prepareExecutor, applyExecutor, initialStage);
        }
        return Reloadable.a(this, Lists.newArrayList(this.c), prepareExecutor, applyExecutor, initialStage);
    }

    @Override
    @Override
    public Stream<IResourcePack> b() {
        return this.e.stream();
    }

    static class a
    implements IReloadable {
        private final b a;
        private final CompletableFuture<Unit> b;

        public a(b exception) {
            this.a = exception;
            this.b = new CompletableFuture();
            this.b.completeExceptionally(exception);
        }

        @Override
        @Override
        public CompletableFuture<Unit> a() {
            return this.b;
        }

        @Override
        @Override
        public float b() {
            return 0.0f;
        }

        @Override
        @Override
        public boolean c() {
            return true;
        }

        @Override
        @Override
        public void d() {
            throw this.a;
        }
    }

    public static class b
    extends RuntimeException {
        private final IResourcePack a;

        public b(IResourcePack pack, Throwable cause) {
            super(pack.a(), cause);
            this.a = pack;
        }

        public IResourcePack a() {
            return this.a;
        }
    }
}

