/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.MethodProfiler;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReloadableProfiled
extends Reloadable<a> {
    private static final Logger d = LogManager.getLogger();
    private final Stopwatch e = Stopwatch.createUnstarted();

    public ReloadableProfiled(IResourceManager manager, List<IReloadListener> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage) {
        super(prepareExecutor, applyExecutor, manager, reloaders, (synchronizer, resourceManager, reloader, prepare, apply) -> {
            AtomicLong atomicLong = new AtomicLong();
            AtomicLong atomicLong2 = new AtomicLong();
            MethodProfiler activeProfiler = new MethodProfiler(SystemUtils.a, () -> 0, false);
            MethodProfiler activeProfiler2 = new MethodProfiler(SystemUtils.a, () -> 0, false);
            CompletableFuture<Void> completableFuture = reloader.a(synchronizer, resourceManager, activeProfiler, activeProfiler2, preparation -> prepare.execute(() -> {
                long l2 = SystemUtils.d();
                preparation.run();
                atomicLong.addAndGet(SystemUtils.d() - l2);
            }), application -> apply.execute(() -> {
                long l2 = SystemUtils.d();
                application.run();
                atomicLong2.addAndGet(SystemUtils.d() - l2);
            }));
            return completableFuture.thenApplyAsync(void_ -> {
                d.debug("Finished reloading " + reloader.c());
                return new a(reloader.c(), activeProfiler.d(), activeProfiler2.d(), atomicLong, atomicLong2);
            }, applyExecutor);
        }, initialStage);
        this.e.start();
        this.c.thenAcceptAsync(this::a, applyExecutor);
    }

    private void a(List<a> summaries) {
        this.e.stop();
        int i2 = 0;
        d.info("Resource reload finished after {} ms", (Object)this.e.elapsed(TimeUnit.MILLISECONDS));
        for (a state : summaries) {
            MethodProfilerResults profileResults = state.b;
            MethodProfilerResults profileResults2 = state.c;
            int j2 = (int)((double)state.d.get() / 1000000.0);
            int k2 = (int)((double)state.e.get() / 1000000.0);
            int l2 = j2 + k2;
            String string = state.a;
            d.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", (Object)string, (Object)l2, (Object)j2, (Object)k2);
            i2 += k2;
        }
        d.info("Total blocking time: {} ms", (Object)i2);
    }

    public static class a {
        final String a;
        final MethodProfilerResults b;
        final MethodProfilerResults c;
        final AtomicLong d;
        final AtomicLong e;

        a(String name, MethodProfilerResults prepareProfile, MethodProfilerResults applyProfile, AtomicLong prepareTimeMs, AtomicLong applyTimeMs) {
            this.a = name;
            this.b = prepareProfile;
            this.c = applyProfile;
            this.d = prepareTimeMs;
            this.e = applyTimeMs;
        }
    }
}

