/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.ResourceNotFoundException;
import net.minecraft.server.packs.ResourcePackAbstract;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackFolder
extends ResourcePackAbstract {
    private static final Logger b = LogManager.getLogger();
    private static final boolean e = SystemUtils.j() == SystemUtils.OS.c;
    private static final CharMatcher f = CharMatcher.is((char)'\\');

    public ResourcePackFolder(File base) {
        super(base);
    }

    public static boolean a(File file, String filename) throws IOException {
        String string = file.getCanonicalPath();
        if (e) {
            string = f.replaceFrom((CharSequence)string, '/');
        }
        return string.endsWith(filename);
    }

    @Override
    @Override
    protected InputStream a(String name) throws IOException {
        File file = this.e(name);
        if (file == null) {
            throw new ResourceNotFoundException(this.a, name);
        }
        return new FileInputStream(file);
    }

    @Override
    @Override
    protected boolean c(String name) {
        return this.e(name) != null;
    }

    @Nullable
    private File e(String name) {
        try {
            File file = new File(this.a, name);
            if (file.isFile() && ResourcePackFolder.a(file, name)) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @Override
    public Set<String> a(EnumResourcePackType type) {
        HashSet set = Sets.newHashSet();
        File file = new File(this.a, type.a());
        File[] files = file.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (files != null) {
            for (File file2 : files) {
                String string = ResourcePackFolder.a(file, file2);
                if (string.equals(string.toLowerCase(Locale.ROOT))) {
                    set.add(string.substring(0, string.length() - 1));
                    continue;
                }
                this.d(string);
            }
        }
        return set;
    }

    @Override
    @Override
    public void close() {
    }

    @Override
    @Override
    public Collection<MinecraftKey> a(EnumResourcePackType type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        File file = new File(this.a, type.a());
        ArrayList list = Lists.newArrayList();
        this.a(new File(new File(file, namespace), prefix), maxDepth, namespace, list, prefix + "/", pathFilter);
        return list;
    }

    private void a(File file, int maxDepth, String namespace, List<MinecraftKey> found, String prefix, Predicate<String> pathFilter) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    if (maxDepth <= 0) continue;
                    this.a(file2, maxDepth - 1, namespace, found, prefix + file2.getName() + "/", pathFilter);
                    continue;
                }
                if (file2.getName().endsWith(".mcmeta") || !pathFilter.test(file2.getName())) continue;
                try {
                    found.add(new MinecraftKey(namespace, prefix + file2.getName()));
                }
                catch (ResourceKeyInvalidException resourceLocationException) {
                    b.error(resourceLocationException.getMessage());
                }
            }
        }
    }
}

