/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.PaperConfig;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.network.ChannelInitializeListenerHolder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.NetworkManagerServer;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.LegacyPingHandler;
import net.minecraft.server.network.MemoryServerHandshakePacketListenerImpl;
import net.minecraft.util.LazyInitVar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerConnection {
    private static final Logger d = LogManager.getLogger();
    public static final LazyInitVar<NioEventLoopGroup> a = new LazyInitVar<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Server IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(d)).build()));
    public static final LazyInitVar<EpollEventLoopGroup> b = new LazyInitVar<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Server IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(d)).build()));
    final MinecraftServer e;
    public volatile boolean c;
    private final List<ChannelFuture> f = Collections.synchronizedList(Lists.newArrayList());
    final List<NetworkManager> g = Collections.synchronizedList(Lists.newArrayList());
    private final Queue<NetworkManager> pending = new ConcurrentLinkedQueue<NetworkManager>();
    private static final boolean disableFlushConsolidation = Boolean.getBoolean("Paper.disableFlushConsolidate");

    private final void addPending() {
        NetworkManager manager = null;
        while ((manager = this.pending.poll()) != null) {
            this.g.add(manager);
            manager.isPending = false;
        }
    }

    public ServerConnection(MinecraftServer server) {
        this.e = server;
        this.c = true;
    }

    public void a(@Nullable InetAddress address, int port) throws IOException {
        this.bind(new InetSocketAddress(address, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address) throws IOException {
        List<ChannelFuture> list = this.f;
        List<ChannelFuture> list2 = this.f;
        synchronized (list2) {
            LazyInitVar<NioEventLoopGroup> lazyinitvar;
            Class oclass;
            if (Epoll.isAvailable() && this.e.m()) {
                oclass = address instanceof DomainSocketAddress ? EpollServerDomainSocketChannel.class : EpollServerSocketChannel.class;
                lazyinitvar = b;
                d.info("Using epoll channel type");
            } else {
                oclass = NioServerSocketChannel.class;
                lazyinitvar = a;
                d.info("Using default channel type");
            }
            d.info("Paper: Using " + Natives.compress.getLoadedVariant() + " compression from Velocity.");
            d.info("Paper: Using " + Natives.cipher.getLoadedVariant() + " cipher from Velocity.");
            this.f.add(((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(oclass)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    try {
                        channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    if (!disableFlushConsolidation) {
                        channel.pipeline().addFirst(new ChannelHandler[]{new FlushConsolidationHandler()});
                    }
                    channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(ServerConnection.this)).addLast("splitter", (ChannelHandler)new PacketSplitter()).addLast("decoder", (ChannelHandler)new PacketDecoder(EnumProtocolDirection.a)).addLast("prepender", (ChannelHandler)new PacketPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(EnumProtocolDirection.b));
                    int j2 = ServerConnection.this.e.l();
                    NetworkManager object = j2 > 0 ? new NetworkManagerServer(j2) : new NetworkManager(EnumProtocolDirection.a);
                    ServerConnection.this.pending.add(object);
                    channel.pipeline().addLast("packet_handler", (ChannelHandler)object);
                    ((NetworkManager)object).a(new HandshakeListener(ServerConnection.this.e, object));
                    ChannelInitializeListenerHolder.callListeners(channel);
                }
            }).group((EventLoopGroup)lazyinitvar.a()).localAddress(address)).option(ChannelOption.AUTO_READ, (Object)false)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptConnections() {
        List<ChannelFuture> list = this.f;
        synchronized (list) {
            for (ChannelFuture future : this.f) {
                future.channel().config().setAutoRead(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress a() {
        ChannelFuture channelfuture;
        List<ChannelFuture> list = this.f;
        List<ChannelFuture> list2 = this.f;
        synchronized (list2) {
            channelfuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.a);
                    networkmanager.a(new MemoryServerHandshakePacketListenerImpl(ServerConnection.this.e, networkmanager));
                    ServerConnection.this.g.add(networkmanager);
                    channel.pipeline().addLast("packet_handler", (ChannelHandler)networkmanager);
                }
            }).group((EventLoopGroup)a.a()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.f.add(channelfuture);
        }
        return channelfuture.channel().localAddress();
    }

    public void b() {
        this.c = false;
        for (ChannelFuture channelfuture : this.f) {
            try {
                channelfuture.channel().close().sync();
            }
            catch (InterruptedException interruptedexception) {
                d.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void c() {
        List<NetworkManager> list = this.g;
        List<NetworkManager> list2 = this.g;
        synchronized (list2) {
            this.addPending();
            if (SpigotConfig.playerShuffle > 0 && MinecraftServer.currentTick % SpigotConfig.playerShuffle == 0) {
                Collections.shuffle(this.g);
            }
            Iterator<NetworkManager> iterator = this.g.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (networkmanager.i()) continue;
                if (networkmanager.h()) {
                    try {
                        networkmanager.a();
                    }
                    catch (Exception exception) {
                        if (networkmanager.d()) {
                            throw new ReportedException(CrashReport.a(exception, "Ticking memory connection"));
                        }
                        d.warn("Failed to handle packet for {}", (Object)(PaperConfig.logPlayerIpAddresses ? String.valueOf(networkmanager.c()) : "<ip address withheld>"), (Object)exception);
                        ChatComponentText chatcomponenttext = new ChatComponentText("Internal server error");
                        networkmanager.a(new PacketPlayOutKickDisconnect(chatcomponenttext), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> networkmanager.a(chatcomponenttext)));
                        networkmanager.l();
                    }
                    continue;
                }
                if (networkmanager.preparing) continue;
                iterator.remove();
                networkmanager.m();
            }
        }
    }

    public MinecraftServer d() {
        return this.e;
    }

    public List<NetworkManager> e() {
        return this.g;
    }

    private static class LatencySimulator
    extends ChannelInboundHandlerAdapter {
        private static final Timer a = new HashedWheelTimer();
        private final int b;
        private final int c;
        private final List<DelayedMessage> d = Lists.newArrayList();

        public LatencySimulator(int baseDelay, int extraDelay) {
            this.b = baseDelay;
            this.c = extraDelay;
        }

        public void channelRead(ChannelHandlerContext channelhandlercontext, Object object) {
            this.a(channelhandlercontext, object);
        }

        private void a(ChannelHandlerContext ctx, Object msg) {
            int i2 = this.b + (int)(Math.random() * (double)this.c);
            this.d.add(new DelayedMessage(ctx, msg));
            a.newTimeout(this::a, (long)i2, TimeUnit.MILLISECONDS);
        }

        private void a(Timeout timeout) {
            DelayedMessage serverconnection_latencysimulator_delayedmessage = this.d.remove(0);
            serverconnection_latencysimulator_delayedmessage.a.fireChannelRead(serverconnection_latencysimulator_delayedmessage.b);
        }

        private static class DelayedMessage {
            public final ChannelHandlerContext a;
            public final Object b;

            public DelayedMessage(ChannelHandlerContext context, Object message) {
                this.a = context;
                this.b = message;
            }
        }
    }
}

