/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import co.aikar.timings.MinecraftTimings;
import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_18_R1.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_18_R1.util.UnsafeList;
import org.bukkit.craftbukkit.v1_18_R1.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
implements ServerPlayerConnection,
PacketListenerPlayIn {
    static final org.apache.logging.log4j.Logger c = LogManager.getLogger();
    private static final int d = 15000;
    public final NetworkManager a;
    private final MinecraftServer e;
    public Runnable playerJoinReady;
    public EntityPlayer b;
    private int f;
    private long g = SystemUtils.c();
    private boolean h;
    private long i;
    private final AtomicInteger chatSpamTickCount = new AtomicInteger();
    private final AtomicInteger tabSpamLimiter = new AtomicInteger();
    private final AtomicInteger recipeSpamPackets = new AtomicInteger();
    private int k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    @Nullable
    private net.minecraft.world.entity.Entity r;
    private double s;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    @Nullable
    private Vec3D y;
    private int z;
    private int A;
    private boolean B;
    private int C;
    private boolean D;
    private int E;
    private int F;
    private int G;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    private String clientBrandName = null;
    private final CraftServer cserver;
    public boolean processedDisconnect;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private static final int SURVIVAL_PLACE_DISTANCE_SQUARED = 36;
    private static final int CREATIVE_PLACE_DISTANCE_SQUARED = 49;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private boolean hasMoved;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;
    private static final int THRESHOLD = PaperConfig.packetInSpamThreshold;
    private static final MinecraftKey CUSTOM_REGISTER = new MinecraftKey("register");
    private static final MinecraftKey CUSTOM_UNREGISTER = new MinecraftKey("unregister");
    private static final MinecraftKey MINECRAFT_BRAND = new MinecraftKey("brand");

    public PlayerConnection(MinecraftServer server, NetworkManager connection, EntityPlayer player) {
        this.e = server;
        this.a = connection;
        connection.a(this);
        this.b = player;
        player.b = this;
        this.g = SystemUtils.c();
        player.T().a();
        this.cserver = server.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.b == null ? null : this.b.getBukkitEntity();
    }

    public void b() {
        int spam;
        Runnable playerJoinReady = this.playerJoinReady;
        if (playerJoinReady != null) {
            this.playerJoinReady = null;
            playerJoinReady.run();
        }
        if (this.b.valid) {
            this.c();
            this.b.u = this.b.dc();
            this.b.v = this.b.de();
            this.b.w = this.b.di();
            this.b.l();
            this.b.a(this.l, this.m, this.n, this.b.dm(), this.b.dn());
            ++this.f;
            this.G = this.F;
            if (this.B && !this.b.fb()) {
                if (++this.C > 80) {
                    c.warn("{} was kicked for floating too long!", (Object)this.b.X().getString());
                    this.disconnect(PaperConfig.flyingKickPlayerMessage, PlayerKickEvent.Cause.FLYING_PLAYER);
                    return;
                }
            } else {
                this.B = false;
                this.C = 0;
            }
            this.r = this.b.cL();
            if (this.r != this.b && this.r.cE() == this.b) {
                this.s = this.r.dc();
                this.t = this.r.de();
                this.u = this.r.di();
                this.v = this.r.dc();
                this.w = this.r.de();
                this.x = this.r.di();
                if (this.D && this.b.cL().cE() == this.b) {
                    if (++this.E > 80) {
                        c.warn("{} was kicked for floating a vehicle too long!", (Object)this.b.X().getString());
                        this.disconnect(PaperConfig.flyingKickVehicleMessage, PlayerKickEvent.Cause.FLYING_VEHICLE);
                        return;
                    }
                } else {
                    this.D = false;
                    this.E = 0;
                }
            } else {
                this.r = null;
                this.D = false;
                this.E = 0;
            }
        }
        this.e.aO().a("keepAlive");
        long currentTime = SystemUtils.c();
        long elapsedTime = currentTime - this.g;
        if (this.h) {
            if (!this.processedDisconnect && elapsedTime >= KEEPALIVE_LIMIT) {
                c.warn("{} was kicked due to keepalive timeout!", (Object)this.b.co());
                this.disconnect(new ChatMessage("disconnect.timeout", new Object[0]), PlayerKickEvent.Cause.TIMEOUT);
            }
        } else if (elapsedTime >= 15000L) {
            this.h = true;
            this.g = currentTime;
            this.i = currentTime;
            this.a(new PacketPlayOutKeepAlive(this.i));
        }
        this.e.aO().c();
        while ((spam = this.chatSpamTickCount.get()) > 0 && !this.chatSpamTickCount.compareAndSet(spam, spam - 1)) {
        }
        if (this.tabSpamLimiter.get() > 0) {
            this.tabSpamLimiter.getAndDecrement();
        }
        if (this.recipeSpamPackets.get() > 0) {
            this.recipeSpamPackets.getAndDecrement();
        }
        if (this.k > 0) {
            --this.k;
        }
        if (this.b.I() > 0L && this.e.al() > 0 && SystemUtils.c() - this.b.I() > (long)(this.e.al() * 1000 * 60) && !this.b.f) {
            this.b.C();
            this.disconnect(new ChatMessage("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
        }
    }

    public void c() {
        this.l = this.b.dc();
        this.m = this.b.de();
        this.n = this.b.di();
        this.o = this.b.dc();
        this.p = this.b.de();
        this.q = this.b.di();
    }

    @Override
    public NetworkManager a() {
        return this.a;
    }

    private boolean e() {
        return this.e.a(this.b.fp());
    }

    public void disconnect(String s2) {
        this.disconnect((Component)PaperAdventure.LEGACY_SECTION_UXRC.deserialize(s2), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(String s2, PlayerKickEvent.Cause cause) {
        this.disconnect((Component)PaperAdventure.LEGACY_SECTION_UXRC.deserialize(s2), cause);
    }

    public void b(IChatBaseComponent reason) {
        this.disconnect(PaperAdventure.asAdventure(reason), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asAdventure(reason), cause);
    }

    public void disconnect(Component reason, PlayerKickEvent.Cause cause) {
        if (this.processedDisconnect) {
            return;
        }
        TranslatableComponent leaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{this.b.getBukkitEntity().displayName()});
        PlayerKickEvent event = new PlayerKickEvent((Player)this.b.getBukkitEntity(), reason, (Component)leaveMessage, cause);
        if (this.cserver.getServer().v()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla(event.reason());
        this.b.quitReason = PlayerQuitEvent.QuitReason.KICKED;
        this.a.a(new PacketPlayOutKickDisconnect(ichatbasecomponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.a.a(ichatbasecomponent)));
        this.onDisconnect(ichatbasecomponent, event.leaveMessage());
        this.a.l();
        MinecraftServer minecraftserver = this.e;
        NetworkManager networkmanager = this.a;
        Objects.requireNonNull(this.a);
        minecraftserver.scheduleOnMain(networkmanager::m);
    }

    private <T, R> void a(T text, Consumer<R> consumer, BiFunction<ITextFilter, T, CompletableFuture<R>> backingFilterer) {
        MinecraftServer iasynctaskhandler = this.b.x().n();
        Consumer<Object> consumer1 = object -> {
            if (this.a().h()) {
                consumer.accept(object);
            } else {
                c.debug("Ignoring packet due to disconnection");
            }
        };
        backingFilterer.apply(this.b.T(), (ITextFilter)text).thenAcceptAsync(consumer1, (Executor)iasynctaskhandler);
    }

    private void a(String text, Consumer<ITextFilter.a> consumer) {
        this.a(text, consumer, ITextFilter::a);
    }

    private void a(List<String> texts, Consumer<List<ITextFilter.a>> consumer) {
        this.a(texts, consumer, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.a(packet.b(), packet.c(), packet.d(), packet.e());
    }

    private static boolean c(double x2, double y2, double z2, float yaw, float pitch) {
        return Double.isNaN(x2) || Double.isNaN(y2) || Double.isNaN(z2) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double a(double d2) {
        return MathHelper.a(d2, -3.0E7, 3.0E7);
    }

    private static double b(double d2) {
        return MathHelper.a(d2, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (PlayerConnection.c(packet.b(), packet.c(), packet.d(), packet.e(), packet.f())) {
            this.disconnect(new ChatMessage("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else {
            net.minecraft.world.entity.Entity entity = this.b.cL();
            if (entity != this.b && entity.cE() == this.b && entity == this.r) {
                double d5;
                double d4;
                double d3;
                double d2;
                double d1;
                double d0;
                WorldServer worldserver = this.b.x();
                double fromX = d0 = entity.dc();
                double fromY = d1 = entity.de();
                double fromZ = d2 = entity.di();
                double toX = d3 = PlayerConnection.a(packet.b());
                double toY = d4 = PlayerConnection.b(packet.c());
                double toZ = d5 = PlayerConnection.a(packet.d());
                float f2 = MathHelper.g(packet.e());
                float f1 = MathHelper.g(packet.f());
                double d6 = d3 - this.s;
                double d7 = d4 - this.t;
                double d8 = d5 - this.u;
                double d9 = entity.da().g();
                double currDeltaX = toX - fromX;
                double currDeltaY = toY - fromY;
                double currDeltaZ = toZ - fromZ;
                double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = d3 - this.v;
                double otherFieldY = d4 - this.w - 1.0E-6;
                double otherFieldZ = d5 - this.x;
                d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.F;
                int i2 = this.F - this.G;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    c.debug(this.b.co() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.b.fr().b ? (double)(this.b.fr().f * 20.0f) : (double)(this.b.fr().g * 10.0f);
                speed *= 2.0;
                if (this.b.t.paperConfig.preventMovingIntoUnloadedChunks && worldserver.getChunkIfLoadedImmediately((int)Math.floor(packet.b()) >> 4, (int)Math.floor(packet.d()) >> 4) == null) {
                    this.a.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.e()) {
                    c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.X().getString(), (Object)this.b.X().getString(), (Object)d6, (Object)d7, (Object)d8);
                    this.a.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                AxisAlignedBB oldBox = entity.cw();
                d6 = d3 - this.v;
                d7 = d4 - this.w - 1.0E-6;
                d8 = d5 - this.x;
                entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                boolean didCollide = toX != entity.dc() || toY != entity.de() || toZ != entity.di();
                double d11 = d7;
                d6 = d3 - entity.dc();
                d7 = d4 - entity.de();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.di();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag1 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag1 = true;
                    c.warn("{} (vehicle of {}) moved wrongly! {}", (Object)entity.X().getString(), (Object)this.b.X().getString(), (Object)Math.sqrt(d10));
                }
                Location curPos = this.getCraftPlayer().getLocation();
                entity.a(d3, d4, d5, f2, f1);
                this.b.a(d3, d4, d5, this.b.dm(), this.b.dn());
                boolean teleportBack = flag1;
                if (!teleportBack) {
                    AxisAlignedBB newBox = entity.cw();
                    if (didCollide || !oldBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(worldserver, entity, oldBox, newBox);
                    }
                }
                if (teleportBack) {
                    entity.a(d0, d1, d2, f2, f1);
                    this.b.a(d0, d1, d2, this.b.dm(), this.b.dn());
                    this.a.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = curPos.getX();
                    this.lastPosY = curPos.getY();
                    this.lastPosZ = curPos.getZ();
                    this.lastYaw = curPos.getYaw();
                    this.lastPitch = curPos.getPitch();
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(packet.b());
                to.setY(packet.c());
                to.setZ(packet.d());
                to.setYaw(packet.e());
                to.setPitch(packet.f());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.b.ew()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.b.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.b.x().k().a(this.b);
                this.b.q(this.b.dc() - d0, this.b.de() - d1, this.b.di() - d2);
                this.D = d11 >= -0.03125 && !this.e.Z() && this.a(entity);
                this.v = entity.dc();
                this.w = entity.de();
                this.x = entity.di();
            }
        }
    }

    private boolean a(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB box = entity.cw().g(0.0625).b(0.0, -0.55, 0.0);
        int minX = MathHelper.b(box.a);
        int minY = MathHelper.b(box.b);
        int minZ = MathHelper.b(box.c);
        int maxX = MathHelper.b(box.d);
        int maxY = MathHelper.b(box.e);
        int maxZ = MathHelper.b(box.f);
        World world = entity.t;
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int x2 = minX; x2 <= maxX; ++x2) {
                    pos.d(x2, y2, z2);
                    IBlockData type = world.getBlockStateIfLoaded(pos);
                    if (type == null || type.g()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void a(PacketPlayInTeleportAccept packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.b() == this.z && this.y != null) {
            this.b.b(this.y.b, this.y.c, this.y.d, this.b.dm(), this.b.dn());
            this.o = this.y.b;
            this.p = this.y.c;
            this.q = this.y.d;
            if (this.b.K()) {
                this.b.L();
            }
            this.y = null;
            this.b.x().k().a(this.b);
        }
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        Optional<IRecipe<?>> optional = this.e.aC().a(packet.b());
        RecipeBookServer recipebookserver = this.b.E();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::e);
    }

    @Override
    public void a(PacketPlayInRecipeSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.E().a(packet.b(), packet.c(), packet.d());
    }

    @Override
    public void a(PacketPlayInAdvancements packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.c() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = packet.d();
            Advancement advancement = this.e.ax().a(minecraftkey);
            if (advancement != null) {
                this.b.M().a(advancement);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packet) {
        Object completions;
        if (this.chatSpamTickCount.addAndGet(PaperConfig.tabSpamIncrement) > PaperConfig.tabSpamLimit && !this.e.ac().f(this.b.fp())) {
            this.e.scheduleOnMain(() -> this.disconnect(new ChatMessage("disconnect.spam", new Object[0]), PlayerKickEvent.Cause.SPAM));
            return;
        }
        String str = packet.c();
        int index = -1;
        if (str.length() > 64 && ((index = str.indexOf(32)) == -1 || index >= 64)) {
            this.e.scheduleOnMain(() -> this.disconnect(new ChatMessage("disconnect.spam", new Object[0]), PlayerKickEvent.Cause.SPAM));
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        StringReader stringreader = new StringReader(packet.c());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        String buffer = packet.c();
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), buffer, true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (!event.isHandled()) {
            if (!event.isCancelled()) {
                this.e.scheduleOnMain(() -> {
                    ParseResults<CommandListenerWrapper> parseresults = this.e.aA().a().parse(stringreader, this.b.cQ());
                    this.e.aA().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
                        AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, buffer);
                        suggestEvent.setCancelled(suggestions.isEmpty());
                        if (!suggestEvent.callEvent()) {
                            return;
                        }
                        this.a.a(new PacketPlayOutTabComplete(packet.b(), suggestEvent.getSuggestions()));
                    });
                });
            }
        } else if (!completions.isEmpty()) {
            SuggestionsBuilder builder0 = new SuggestionsBuilder(packet.c(), stringreader.getTotalLength());
            SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
            completions.forEach(completion -> {
                if (completion.tooltip() == null) {
                    builder.suggest(completion.suggestion());
                } else {
                    builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                }
            });
            Suggestions suggestions = (Suggestions)builder.buildFuture().join();
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, buffer);
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (!suggestEvent.callEvent()) {
                return;
            }
            this.a.a(new PacketPlayOutTabComplete(packet.b(), suggestEvent.getSuggestions()));
        }
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (!this.e.n()) {
            this.b.a((IChatBaseComponent)new ChatMessage("advMode.notEnabled"), SystemUtils.b);
        } else if (!(this.b.fM() || this.b.f() && this.b.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.b.a((IChatBaseComponent)new ChatMessage("advMode.notAllowed"), SystemUtils.b);
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packet.b();
            TileEntity tileentity = this.b.t.c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.c();
            }
            String s2 = packet.c();
            boolean flag = packet.d();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.v();
                IBlockData iblockdata = this.b.t.a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.a);
                IBlockData iblockdata2 = (IBlockData)((IBlockData)(switch (packet.g()) {
                    case TileEntityCommand.Type.a -> Blocks.iV.n();
                    case TileEntityCommand.Type.b -> Blocks.iU.n();
                    default -> Blocks.eE.n();
                }).a(BlockCommand.a, enumdirection)).a(BlockCommand.b, packet.e());
                if (iblockdata2 != iblockdata) {
                    this.b.t.a(blockposition, iblockdata2, 2);
                    tileentity.b(iblockdata2);
                    this.b.t.l(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.b((IChatBaseComponent)null);
                }
                tileentitycommand.b(packet.f());
                if (tileentitycommand_type != packet.g()) {
                    tileentitycommand.g();
                }
                commandblocklistenerabstract.f();
                if (!UtilColor.b(s2)) {
                    this.b.a((IChatBaseComponent)new ChatMessage("advMode.setCommand.success", s2), SystemUtils.b);
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (!this.e.n()) {
            this.b.a((IChatBaseComponent)new ChatMessage("advMode.notEnabled"), SystemUtils.b);
        } else if (!(this.b.fM() || this.b.f() && this.b.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.b.a((IChatBaseComponent)new ChatMessage("advMode.notAllowed"), SystemUtils.b);
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packet.a(this.b.t);
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.a(packet.b());
                commandblocklistenerabstract.a(packet.c());
                if (!packet.c()) {
                    commandblocklistenerabstract.b((IChatBaseComponent)null);
                }
                commandblocklistenerabstract.f();
                this.b.a((IChatBaseComponent)new ChatMessage("advMode.setCommand.success", packet.b()), SystemUtils.b);
            }
        }
    }

    @Override
    public void a(PacketPlayInPickItem packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.b() < 0 || packet.b() >= this.b.fq().h.size()) {
            c.warn("{} tried to set an invalid carried item", (Object)this.b.X().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.b.fq().c(packet.b());
        this.b.b.a(new PacketPlayOutSetSlot(-2, 0, this.b.fq().k, this.b.fq().a(this.b.fq().k)));
        this.b.b.a(new PacketPlayOutSetSlot(-2, 0, packet.b(), this.b.fq().a(packet.b())));
        this.b.b.a(new PacketPlayOutHeldItemSlot(this.b.fq().k));
    }

    @Override
    public void a(PacketPlayInItemName packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.bW instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)this.b.bW;
            String s2 = SharedConstants.a(packet.b());
            if (s2.length() <= 50) {
                containeranvil.a(s2);
            }
        }
    }

    @Override
    public void a(PacketPlayInBeacon packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.bW instanceof ContainerBeacon) {
            ((ContainerBeacon)this.b.bW).c(packet.b(), packet.c());
        }
    }

    @Override
    public void a(PacketPlayInStruct packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.fM()) {
            BlockPosition blockposition = packet.b();
            IBlockData iblockdata = this.b.t.a_(blockposition);
            TileEntity tileentity = this.b.t.c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packet.d());
                tileentitystructure.a(packet.e());
                tileentitystructure.a(packet.f());
                tileentitystructure.a(packet.g());
                tileentitystructure.a(packet.h());
                tileentitystructure.a(packet.i());
                tileentitystructure.b(packet.j());
                tileentitystructure.a(packet.k());
                tileentitystructure.d(packet.l());
                tileentitystructure.e(packet.m());
                tileentitystructure.a(packet.n());
                tileentitystructure.a(packet.o());
                if (tileentitystructure.g()) {
                    String s2 = tileentitystructure.d();
                    if (packet.c() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.D()) {
                            this.b.a((IChatBaseComponent)new ChatMessage("structure_block.save_success", s2), false);
                        } else {
                            this.b.a((IChatBaseComponent)new ChatMessage("structure_block.save_failure", s2), false);
                        }
                    } else if (packet.c() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.F()) {
                            this.b.a((IChatBaseComponent)new ChatMessage("structure_block.load_not_found", s2), false);
                        } else if (tileentitystructure.a(this.b.x())) {
                            this.b.a((IChatBaseComponent)new ChatMessage("structure_block.load_success", s2), false);
                        } else {
                            this.b.a((IChatBaseComponent)new ChatMessage("structure_block.load_prepare", s2), false);
                        }
                    } else if (packet.c() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.C()) {
                            this.b.a((IChatBaseComponent)new ChatMessage("structure_block.size_success", s2), false);
                        } else {
                            this.b.a((IChatBaseComponent)new ChatMessage("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.b.a((IChatBaseComponent)new ChatMessage("structure_block.invalid_structure_name", packet.e()), false);
                }
                tileentitystructure.e();
                this.b.t.a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.fM()) {
            BlockPosition blockposition = packet.b();
            IBlockData iblockdata = this.b.t.a_(blockposition);
            TileEntity tileentity = this.b.t.c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packet.c());
                tileentityjigsaw.b(packet.d());
                tileentityjigsaw.c(packet.e());
                tileentityjigsaw.a(packet.f());
                tileentityjigsaw.a(packet.g());
                tileentityjigsaw.e();
                this.b.t.a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packet) {
        BlockPosition blockposition;
        TileEntity tileentity;
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.fM() && (tileentity = this.b.t.c_(blockposition = packet.b())) instanceof TileEntityJigsaw) {
            TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
            tileentityjigsaw.a(this.b.x(), packet.c(), packet.d());
        }
    }

    @Override
    public void a(PacketPlayInTrSel packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        int i2 = packet.b();
        Container container = this.b.bW;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            CraftEventFactory.callTradeSelectEvent(this.b, i2, containermerchant);
            containermerchant.d(i2);
            containermerchant.g(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packet) {
        if (!this.cserver.isPrimaryThread()) {
            List<String> pageList = packet.b();
            long byteTotal = 0L;
            int maxBookPageSize = PaperConfig.maxBookPageSize;
            double multiplier = Math.max(0.3, Math.min(1.0, PaperConfig.maxBookTotalSizeMultiplier));
            long byteAllowed = maxBookPageSize;
            for (String testString : pageList) {
                int byteLength = testString.getBytes(StandardCharsets.UTF_8).length;
                if (byteLength > 1024) {
                    c.warn(this.b.co() + " tried to send a book with with a page too large!");
                    this.e.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                    return;
                }
                byteTotal += (long)byteLength;
                int length = testString.length();
                int multibytes = 0;
                if (byteLength != length) {
                    for (char c2 : testString.toCharArray()) {
                        if (c2 <= '\u007f') continue;
                        ++multibytes;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.min(1.0, Math.max(0.1, (double)length / 255.0)) * multiplier);
                if (multibytes <= 1) continue;
                byteAllowed -= (long)multibytes;
            }
            if (byteTotal > byteAllowed) {
                c.warn(this.b.co() + " tried to send too large of a book. Book Size: " + byteTotal + " - Allowed:  " + byteAllowed + " - Pages: " + pageList.size());
                this.e.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.e.scheduleOnMain(() -> this.disconnect("Book edited too quickly!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packet.d();
        if (PlayerInventory.d(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.c();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packet.b().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            this.a(list, optional.isPresent() ? list1 -> this.a((ITextFilter.a)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<ITextFilter.a>)list1, i2));
        }
    }

    private void a(List<ITextFilter.a> pages, int slotId) {
        ItemStack itemstack = this.b.fq().a(slotId);
        if (itemstack.a(Items.rg)) {
            this.updateBookPages(pages, UnaryOperator.identity(), itemstack.m(), slotId, itemstack);
        }
    }

    private void a(ITextFilter.a title, List<ITextFilter.a> pages, int slotId) {
        ItemStack itemstack = this.b.fq().a(slotId);
        if (itemstack.a(Items.rg)) {
            ItemStack itemstack1 = new ItemStack(Items.rh);
            NBTTagCompound nbttagcompound = itemstack.s();
            if (nbttagcompound != null) {
                itemstack1.c(nbttagcompound.g());
            }
            itemstack1.a("author", NBTTagString.a(this.b.X().getString()));
            if (this.b.U()) {
                itemstack1.a("title", NBTTagString.a(title.b()));
            } else {
                itemstack1.a("filtered_title", NBTTagString.a(title.b()));
                itemstack1.a("title", NBTTagString.a(title.a()));
            }
            this.updateBookPages(pages, s2 -> IChatBaseComponent.ChatSerializer.a(new ChatComponentText((String)s2)), itemstack1, slotId, itemstack);
            this.b.fq().a(slotId, itemstack);
        }
    }

    private void updateBookPages(List<ITextFilter.a> list, UnaryOperator<String> unaryoperator, ItemStack itemstack, int slot, ItemStack handItem) {
        NBTTagList nbttaglist = new NBTTagList();
        if (this.b.U()) {
            Stream<NBTTagString> stream = list.stream().map(itextfilter_a -> NBTTagString.a((String)unaryoperator.apply(itextfilter_a.b())));
            Objects.requireNonNull(nbttaglist);
            stream.forEach(nbttaglist::add);
        } else {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            int j2 = list.size();
            for (int i2 = 0; i2 < j2; ++i2) {
                ITextFilter.a itextfilter_a2 = list.get(i2);
                String s2 = itextfilter_a2.a();
                nbttaglist.add(NBTTagString.a((String)unaryoperator.apply(s2)));
                String s1 = itextfilter_a2.b();
                if (s2.equals(s1)) continue;
                nbttagcompound.a(String.valueOf(i2), (String)unaryoperator.apply(s1));
            }
            if (!nbttagcompound.f()) {
                itemstack.a("filtered_pages", nbttagcompound);
            }
        }
        itemstack.a("pages", nbttaglist);
        this.b.fq().a(slot, CraftEventFactory.handleEditBookEvent(this.b, slot, handItem, itemstack));
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packet) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2) && (entity = this.b.x().a(packet.c())) != null) {
            NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
            this.b.b.a(new PacketPlayOutNBTQuery(packet.b(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2)) {
            TileEntity tileentity = this.b.x().c_(packet.c());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.o() : null;
            this.b.b.a(new PacketPlayOutNBTQuery(packet.b(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (PlayerConnection.c(packet.a(0.0), packet.b(0.0), packet.c(0.0), packet.a(0.0f), packet.b(0.0f))) {
            this.disconnect(new ChatMessage("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            WorldServer worldserver = this.b.x();
            if (!this.b.f && !this.b.ew()) {
                if (this.f == 0) {
                    this.c();
                }
                if (this.y != null) {
                    this.allowedPlayerTicks = 20;
                } else {
                    this.A = this.f;
                    double d0 = PlayerConnection.a(packet.a(this.b.dc()));
                    double d1 = PlayerConnection.b(packet.b(this.b.de()));
                    double d2 = PlayerConnection.a(packet.c(this.b.di()));
                    float f2 = MathHelper.g(packet.a(this.b.dm()));
                    float f1 = MathHelper.g(packet.b(this.b.dn()));
                    if (this.b.bF()) {
                        this.b.a(this.b.dc(), this.b.de(), this.b.di(), f2, f1);
                        this.b.x().k().a(this.b);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double d5;
                        double d4;
                        double d3;
                        double prevX = this.b.dc();
                        double prevY = this.b.de();
                        double prevZ = this.b.di();
                        float prevYaw = this.b.dm();
                        float prevPitch = this.b.dn();
                        double toX = d3 = this.b.dc();
                        double toY = d4 = this.b.de();
                        double toZ = d5 = this.b.di();
                        double d6 = this.b.de();
                        double d7 = d0 - this.l;
                        double d8 = d1 - this.m;
                        double d9 = d2 - this.n;
                        double d10 = this.b.da().g();
                        double currDeltaX = toX - prevX;
                        double currDeltaY = toY - prevY;
                        double currDeltaZ = toZ - prevZ;
                        double d11 = Math.max(d7 * d7 + d8 * d8 + d9 * d9, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                        double otherFieldX = d0 - this.o;
                        double otherFieldY = d1 - this.p;
                        double otherFieldZ = d2 - this.q;
                        d11 = Math.max(d11, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                        if (this.b.fb()) {
                            if (d11 > 1.0) {
                                this.b(this.b.dc(), this.b.de(), this.b.di(), f2, f1);
                            }
                        } else {
                            boolean flag;
                            ++this.F;
                            int i2 = this.F - this.G;
                            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.b.X().getString(), (Object)i2);
                                i2 = 1;
                            }
                            this.allowedPlayerTicks = packet.h || d11 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.b.fr().b ? (double)(this.b.fr().f * 20.0f) : (double)(this.b.fr().g * 10.0f);
                            if (this.b.t.paperConfig.preventMovingIntoUnloadedChunks && (this.b.dc() != toX || this.b.di() != toZ) && worldserver.getChunkIfLoadedImmediately((int)Math.floor(toX) >> 4, (int)Math.floor(toZ) >> 4) == null) {
                                this.internalTeleport(this.b.dc(), this.b.de(), this.b.di(), this.b.dm(), this.b.dn(), Collections.emptySet(), true);
                                return;
                            }
                            if (!(this.b.K() || this.b.x().X().b(GameRules.s) && this.b.eU())) {
                                float f22;
                                float f3 = f22 = this.b.eU() ? 300.0f : 100.0f;
                                if (d11 - d10 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.e()) {
                                    c.warn("{} moved too quickly! {},{},{}", (Object)this.b.X().getString(), (Object)d7, (Object)d8, (Object)d9);
                                    this.b(this.b.dc(), this.b.de(), this.b.di(), this.b.dm(), this.b.dn());
                                    return;
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.b.cw();
                            d7 = d0 - this.o;
                            d8 = d1 - this.p;
                            d9 = d2 - this.q;
                            boolean bl = flag = d8 > 0.0;
                            if (this.b.aw() && !packet.b() && flag) {
                                PlayerJumpEvent event;
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                if ((event = new PlayerJumpEvent((Player)player, from, to)).callEvent()) {
                                    this.b.ez();
                                } else {
                                    from = event.getFrom();
                                    this.internalTeleport(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch(), Collections.emptySet(), false);
                                    return;
                                }
                            }
                            this.b.a(EnumMoveType.b, new Vec3D(d7, d8, d9));
                            boolean didCollide = toX != this.b.dc() || toY != this.b.de() || toZ != this.b.di();
                            this.b.z = packet.b();
                            if (this.y != null) {
                                return;
                            }
                            double d12 = d8;
                            d7 = d0 - this.b.dc();
                            d8 = d1 - this.b.de();
                            if (d8 > -0.5 || d8 < 0.5) {
                                d8 = 0.0;
                            }
                            d9 = d2 - this.b.di();
                            d11 = d7 * d7 + d8 * d8 + d9 * d9;
                            boolean flag1 = false;
                            if (!this.b.K() && d11 > SpigotConfig.movedWronglyThreshold && !this.b.fb() && !this.b.d.e() && this.b.d.b() != EnumGamemode.d) {
                                flag1 = true;
                                c.warn("{} moved wrongly!", (Object)this.b.X().getString());
                            }
                            this.b.a(d0, d1, d2, f2, f1);
                            boolean teleportBack = flag1;
                            if (!(this.b.Q || this.b.fb() || teleportBack)) {
                                AxisAlignedBB newBox = this.b.cw();
                                if (didCollide || !axisalignedbb.equals(newBox)) {
                                    teleportBack = this.hasNewCollision(worldserver, this.b, axisalignedbb, newBox);
                                }
                            }
                            if (!this.b.Q && !this.b.fb() && teleportBack) {
                                this.b(d3, d4, d5, f2, f1);
                            } else {
                                this.b.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.b.ew()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (from.getX() != Double.MAX_VALUE) {
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event);
                                        if (event.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                            this.b.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                }
                                this.b.a(d0, d1, d2, f2, f1);
                                this.B = d12 >= -0.03125 && this.b.d.b() != EnumGamemode.d && !this.e.Z() && !this.b.fr().c && !this.b.a(MobEffects.y) && !this.b.eU() && this.a(this.b) && !this.b.eG();
                                this.b.x().k().a(this.b);
                                this.b.a(this.b.de() - d6, packet.b());
                                this.b.c(packet.b());
                                if (flag) {
                                    this.b.m();
                                }
                                this.b.q(this.b.dc() - d3, this.b.de() - d4, this.b.di() - d5);
                                this.o = this.b.dc();
                                this.p = this.b.de();
                                this.q = this.b.di();
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNewCollision(WorldServer world, net.minecraft.world.entity.Entity entity, AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        UnsafeList<AxisAlignedBB> collisions = CachedLists.getTempCollisionList();
        try {
            CollisionUtil.getCollisions(world, entity, newBox, collisions, false, true, true, false, null, null);
            int len = collisions.size();
            for (int i2 = 0; i2 < len; ++i2) {
                AxisAlignedBB box = (AxisAlignedBB)collisions.get(i2);
                if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            CachedLists.returnTempCollisionList(collisions);
        }
    }

    private boolean a(IWorldReader world, AxisAlignedBB box) {
        VoxelShape voxelshape1;
        Iterable<VoxelShape> iterable = world.c(this.b, this.b.cw().h(1.0E-5f));
        VoxelShape voxelshape = VoxelShapes.a(box.h(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (VoxelShapes.c(voxelshape1 = iterator.next(), voxelshape, OperatorBoolean.i));
        return true;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.dismount(x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void dismount(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), true, cause);
    }

    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        this.teleport(x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), false, cause);
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, Set<PacketPlayOutPosition.EnumPlayerTeleportFlags> flags) {
        this.teleport(x2, y2, z2, yaw, pitch, flags, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f2, float f1, Set<PacketPlayOutPosition.EnumPlayerTeleportFlags> set, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f2, f1, set, false, cause);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, Set<PacketPlayOutPosition.EnumPlayerTeleportFlags> set, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x2 = d0;
        double y2 = d1;
        double z2 = d2;
        float yaw = f2;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x2, y2, z2, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f2, f1, set, flag);
            return false;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set.clear();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f2, f1, set, flag);
        return event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet(), true);
    }

    private void internalTeleport(double d0, double d1, double d2, float f2, float f1, Set<PacketPlayOutPosition.EnumPlayerTeleportFlags> set, boolean flag) {
        if (this.b.do()) {
            c.info("Attempt to teleport removed player {} restricted", (Object)this.b.co());
            if (this.e.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.a) ? this.b.dc() : 0.0;
        double d4 = set.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.b) ? this.b.de() : 0.0;
        double d5 = set.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.c) ? this.b.di() : 0.0;
        float f22 = set.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.d) ? this.b.dm() : 0.0f;
        float f3 = set.contains((Object)PacketPlayOutPosition.EnumPlayerTeleportFlags.e) ? this.b.dn() : 0.0f;
        this.y = new Vec3D(d0, d1, d2);
        if (++this.z == Integer.MAX_VALUE) {
            this.z = 0;
        }
        this.lastPosX = this.y.b;
        this.lastPosY = this.y.c;
        this.lastPosZ = this.y.d;
        this.lastYaw = f2;
        this.lastPitch = f1;
        this.A = this.f;
        this.b.b(d0, d1, d2, f2, f1);
        this.b.b.a(new PacketPlayOutPosition(d0 - d3, d1 - d4, d2 - d5, f2 - f22, f1 - f3, set, this.z, flag));
    }

    @Override
    public void a(PacketPlayInBlockDig packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        BlockPosition blockposition = packet.b();
        this.b.C();
        PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packet.d();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case g: {
                if (!this.b.B_()) {
                    ItemStack itemstack = this.b.b(EnumHand.b);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.b.b(EnumHand.a));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.b.a(EnumHand.b, this.b.b(EnumHand.a));
                    } else {
                        this.b.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.b.a(EnumHand.a, itemstack);
                    } else {
                        this.b.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.b.eR();
                }
                return;
            }
            case e: {
                if (!this.b.B_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            c.warn(this.b.co() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
                            return;
                        }
                    }
                    this.b.a(false);
                }
                return;
            }
            case d: {
                if (!this.b.B_()) {
                    this.b.a(true);
                }
                return;
            }
            case f: {
                this.b.eQ();
                return;
            }
            case a: 
            case b: 
            case c: {
                if (this.b.t.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4) == null) {
                    return;
                }
                this.b.d.a(blockposition, packetplayinblockdig_enumplayerdigtype, packet.c(), this.b.t.ag());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean a(EntityPlayer player, ItemStack stack) {
        if (stack.b()) {
            return false;
        }
        Item item = stack.c();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !player.fK().a(item);
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)THRESHOLD && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)THRESHOLD) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    private boolean isOutsideOfReach(double x2, double y2, double z2) {
        Location eyeLoc = this.getCraftPlayer().getEyeLocation();
        double reachDistance = NumberConversions.square((double)(eyeLoc.getX() - x2)) + NumberConversions.square((double)(eyeLoc.getY() - y2)) + NumberConversions.square((double)(eyeLoc.getZ() - z2));
        return reachDistance > (double)(this.getCraftPlayer().getGameMode() == GameMode.CREATIVE ? 49 : 36);
    }

    @Override
    public void a(PacketPlayInUseItem packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        WorldServer worldserver = this.b.x();
        EnumHand enumhand = packet.b();
        ItemStack itemstack = this.b.b(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = packet.c();
        BlockPosition blockposition = movingobjectpositionblock.a();
        EnumDirection enumdirection = movingobjectpositionblock.b();
        Vec3D clickedLocation = movingobjectpositionblock.e();
        if (this.isOutsideOfReach((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) || !Double.isFinite(clickedLocation.b) || !Double.isFinite(clickedLocation.c) || !Double.isFinite(clickedLocation.d) || this.isOutsideOfReach(clickedLocation.b, clickedLocation.c, clickedLocation.d)) {
            return;
        }
        this.b.C();
        int i2 = this.b.t.ag();
        if (blockposition.v() < i2) {
            if (this.y == null && this.b.h((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) < 64.0 && (worldserver.a((EntityHuman)this.b, blockposition) || worldserver.paperConfig.allowUsingSignsInsideSpawnProtection && worldserver.a_(blockposition).b() instanceof BlockSign)) {
                this.b.eR();
                EnumInteractionResult enuminteractionresult = this.b.d.a(this.b, worldserver, itemstack, enumhand, movingobjectpositionblock);
                if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 - 1 && PlayerConnection.a(this.b, itemstack)) {
                    IChatMutableComponent ichatmutablecomponent = new ChatMessage("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                    this.b.a(ichatmutablecomponent, ChatMessageType.c, SystemUtils.b);
                } else if (enuminteractionresult.b() && !this.b.d.interactResult) {
                    this.b.a(enumhand, true);
                }
            }
        } else {
            IChatMutableComponent ichatmutablecomponent1 = new ChatMessage("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
            this.b.a(ichatmutablecomponent1, ChatMessageType.c, SystemUtils.b);
        }
        this.b.b.a(new PacketPlayOutBlockChange(worldserver, blockposition));
        this.b.b.a(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
    }

    @Override
    public void a(PacketPlayInBlockPlace packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        WorldServer worldserver = this.b.x();
        EnumHand enumhand = packet.b();
        ItemStack itemstack = this.b.b(enumhand);
        this.b.C();
        if (!itemstack.b()) {
            boolean cancelled;
            float f1 = this.b.dn();
            float f2 = this.b.dm();
            double d0 = this.b.dc();
            double d1 = this.b.de() + (double)this.b.cy();
            double d2 = this.b.di();
            Vec3D vec3d = new Vec3D(d0, d1, d2);
            float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
            float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.b.d.b() == EnumGamemode.b ? 5.0 : 4.5;
            Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            MovingObjectPositionBlock movingobjectposition = this.b.t.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.b));
            if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).c() != MovingObjectPosition.EnumMovingObjectType.b) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.b, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                cancelled = this.b.d.firedInteract && this.b.d.interactPosition.equals(movingobjectpositionblock.a()) && this.b.d.interactHand == enumhand && ItemStack.a(this.b.d.interactItemStack, itemstack) ? this.b.d.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.b, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.a(), movingobjectpositionblock.b(), itemstack, true, enumhand)).useItemInHand() == Event.Result.DENY;
                this.b.d.firedInteract = false;
            }
            if (cancelled) {
                this.b.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.b.b(enumhand);
            if (itemstack.b()) {
                return;
            }
            EnumInteractionResult enuminteractionresult = this.b.d.a(this.b, worldserver, itemstack, enumhand);
            if (enuminteractionresult.b()) {
                this.b.a(enumhand, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.B_()) {
            for (WorldServer worldserver : this.e.F()) {
                net.minecraft.world.entity.Entity entity = packet.a(worldserver);
                if (entity == null) continue;
                this.b.teleportTo(worldserver, entity.dc(), entity.de(), entity.di(), entity.dm(), entity.dn(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInResourcePackStatus packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.b() == PacketPlayInResourcePackStatus.EnumResourcePackStatus.b && this.e.aW()) {
            c.info("Disconnecting {} due to resource pack rejection", (Object)this.b.X());
            this.disconnect(new ChatMessage("multiplayer.requiredTexturePrompt.disconnect"), PlayerKickEvent.Cause.RESOURCE_PACK_REJECTION);
        }
        PlayerResourcePackStatusEvent.Status packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.a.ordinal()];
        this.b.getBukkitEntity().setResourcePackStatus(packStatus);
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packStatus));
    }

    @Override
    public void a(PacketPlayInBoatMove packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        net.minecraft.world.entity.Entity entity = this.b.cN();
        if (entity instanceof EntityBoat) {
            ((EntityBoat)entity).a(packet.b(), packet.c());
        }
    }

    @Override
    public void a(ServerboundPongPacket packet) {
    }

    @Override
    public void a(IChatBaseComponent reason) {
        this.onDisconnect(reason, null);
    }

    public void onDisconnect(IChatBaseComponent reason, @Nullable Component quitMessage) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        c.info("{} lost connection: {}", (Object)this.b.X().getString(), (Object)reason.getString());
        this.b.s();
        Component component = quitMessage = quitMessage == null ? this.e.ac().remove(this.b) : this.e.ac().remove(this.b, quitMessage);
        if (quitMessage != null && !quitMessage.equals(Component.empty())) {
            this.e.ac().a(PaperAdventure.asVanilla(quitMessage), ChatMessageType.b, SystemUtils.b);
        }
        this.b.T().b();
        if (this.e()) {
            c.info("Stopping singleplayer server as player logged out");
            this.e.a(false);
        }
    }

    @Override
    public void a(Packet<?> packet) {
        this.a(packet, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void a(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> listener) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof PacketPlayOutSpawnPosition) {
            PacketPlayOutSpawnPosition packet6 = (PacketPlayOutSpawnPosition)packet;
            this.b.compassTarget = new Location(this.getCraftPlayer().getWorld(), (double)packet6.a.u(), (double)packet6.a.v(), (double)packet6.a.w());
        }
        try {
            this.a.a(packet, listener);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Sending packet");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Packet being sent");
            crashreportsystemdetails.a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        if (packet.b() >= 0 && packet.b() < PlayerInventory.g()) {
            if (packet.b() == this.b.fq().k) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.b.fq().k, packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.a(new PacketPlayOutHeldItemSlot(this.b.fq().k));
                this.b.C();
                return;
            }
            if (this.b.fq().k != packet.b() && this.b.eM() == EnumHand.a) {
                this.b.eR();
            }
            this.b.fq().k = packet.b();
            this.b.C();
        } else {
            c.warn("{} tried to set an invalid carried item", (Object)this.b.X().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void a(PacketPlayInChat packet) {
        if (this.e.ab()) {
            return;
        }
        String s2 = StringUtils.normalizeSpace((String)packet.b());
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (SharedConstants.a(s2.charAt(i2))) continue;
            this.disconnect(new ChatMessage("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
            return;
        }
        if (s2.startsWith("/")) {
            PlayerConnectionUtils.a(packet, this, this.b.x());
            this.a(ITextFilter.a.a(s2));
        } else {
            this.a(ITextFilter.a.a(s2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ITextFilter.a message) {
        if (this.b.do() || this.b.A() == EnumChatVisibility.c) {
            this.a(new PacketPlayOutChat(new ChatMessage("chat.disabled.options").a(EnumChatFormat.m), ChatMessageType.b, SystemUtils.b));
        } else {
            this.b.C();
            String s2 = message.a();
            boolean isSync = s2.startsWith("/");
            if (isSync) {
                try {
                    this.e.server.playerCommandState = true;
                    this.a(s2);
                }
                finally {
                    this.e.server.playerCommandState = false;
                }
            } else if (s2.isEmpty()) {
                c.warn(this.b.co() + " tried to send an empty message");
            } else if (this.getCraftPlayer().isConversing()) {
                final String conversationInput = s2;
                this.e.processQueue.add(new Runnable(){

                    @Override
                    public void run() {
                        PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                    }
                });
            } else if (this.b.A() == EnumChatVisibility.b) {
                this.a(new PacketPlayOutChat(new ChatMessage("chat.cannotSend").a(EnumChatFormat.m), ChatMessageType.b, SystemUtils.b));
            } else {
                this.chat(s2, true);
            }
            boolean counted = true;
            for (String exclude : SpigotConfig.spamExclusions) {
                if (exclude == null || !s2.startsWith(exclude)) continue;
                counted = false;
                break;
            }
            if (counted && this.chatSpamTickCount.addAndGet(20) > 200 && !this.e.ac().f(this.b.fp())) {
                if (!isSync) {
                    Waitable waitable = new Waitable(){

                        protected Object evaluate() {
                            PlayerConnection.this.disconnect(new ChatMessage("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
                            return null;
                        }
                    };
                    this.e.processQueue.add(waitable);
                    try {
                        waitable.get();
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e3) {
                        throw new RuntimeException(e3);
                    }
                } else {
                    this.disconnect(new ChatMessage("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
                }
            }
        }
    }

    public void chat(String s2, boolean async) {
        if (s2.isEmpty() || this.b.A() == EnumChatVisibility.c) {
            return;
        }
        if (!async && s2.startsWith("/")) {
            if (!AsyncCatcher.shuttingDown && !Bukkit.isPrimaryThread()) {
                final String fCommandLine = s2;
                MinecraftServer.r.log(org.apache.logging.log4j.Level.ERROR, "Command Dispatched Async: " + fCommandLine);
                MinecraftServer.r.log(org.apache.logging.log4j.Level.ERROR, "Please notify author of plugin causing this execution to fix this bug! see: http://bit.ly/1oSiM6C", new Throwable());
                Waitable wait = new Waitable(){

                    protected Object evaluate() {
                        PlayerConnection.this.chat(fCommandLine, false);
                        return null;
                    }
                };
                this.e.processQueue.add(wait);
                try {
                    wait.get();
                    return;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e3) {
                    throw new RuntimeException("Exception processing chat command", e3.getCause());
                }
            }
            this.a(s2);
        } else if (this.b.A() != EnumChatVisibility.b) {
            ChatProcessor cp = new ChatProcessor(this.e, this.b, s2, async);
            cp.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String input) {
        MinecraftTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            c.info(this.b.co() + " issued server command: " + input);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, input, (Set)new LazyPlayerSet(this.e));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            MinecraftTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            MinecraftTimings.playerCommandTimer.stopTiming();
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        this.b.C();
        float f1 = this.b.dn();
        float f2 = this.b.dm();
        double d0 = this.b.dc();
        double d1 = this.b.de() + (double)this.b.cy();
        double d2 = this.b.di();
        Vec3D vec3d = new Vec3D(d0, d1, d2);
        float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
        float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
        float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = this.b.d.b() == EnumGamemode.b ? 5.0 : 4.5;
        Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        MovingObjectPositionBlock movingobjectposition = this.b.t.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.b));
        if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).c() != MovingObjectPosition.EnumMovingObjectType.b || this.b.d.b() == EnumGamemode.c) {
            CraftEventFactory.callPlayerInteractEvent(this.b, Action.LEFT_CLICK_AIR, this.b.fq().f(), EnumHand.a);
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((Player)this.getCraftPlayer(), packet.b() == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.b.a(packet.b());
    }

    @Override
    public void a(PacketPlayInEntityAction packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.do()) {
            return;
        }
        switch (packet.c()) {
            case a: 
            case b: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packet.c() == PacketPlayInEntityAction.EnumPlayerAction.a);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case d: 
            case e: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packet.c() == PacketPlayInEntityAction.EnumPlayerAction.d);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.b.C();
        switch (packet.c()) {
            case a: {
                this.b.f(true);
                if (!this.b.t.paperConfig.parrotsHangOnBetter) break;
                this.b.fD();
                break;
            }
            case b: {
                this.b.f(false);
                break;
            }
            case d: {
                this.b.g(true);
                break;
            }
            case e: {
                this.b.g(false);
                break;
            }
            case c: {
                if (!this.b.fb()) break;
                this.b.a(false, true);
                this.y = this.b.cV();
                break;
            }
            case f: {
                if (!(this.b.cN() instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)this.b.cN());
                int i2 = packet.d();
                if (!ijumpable.a() || i2 <= 0) break;
                ijumpable.b(i2);
                break;
            }
            case g: {
                if (!(this.b.cN() instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)this.b.cN());
                ijumpable.b();
                break;
            }
            case h: {
                if (!(this.b.cN() instanceof EntityHorseAbstract)) break;
                ((EntityHorseAbstract)this.b.cN()).f(this.b);
                break;
            }
            case i: {
                if (this.b.fu()) break;
                this.b.fw();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    @Override
    public void a(final PacketPlayInUseEntity packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        WorldServer worldserver = this.b.x();
        final net.minecraft.world.entity.Entity entity = packet.a(worldserver);
        if (entity == this.b && !this.b.B_()) {
            this.disconnect("Cannot interact with self!", PlayerKickEvent.Cause.SELF_INTERACTION);
            return;
        }
        this.b.C();
        this.b.f(packet.b());
        if (entity != null) {
            if (!worldserver.p_().a(entity.cW())) {
                return;
            }
            double d0 = 36.0;
            if (this.b.f(entity) < 36.0) {
                packet.a(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = PlayerConnection.this.b.b(enumhand).m();
                        ItemStack itemInHand = PlayerConnection.this.b.b(enumhand);
                        boolean triggerLeashUpdate = itemInHand != null && itemInHand.c() == Items.rP && entity instanceof EntityInsentient;
                        Item origItem = PlayerConnection.this.b.fq().f() == null ? null : PlayerConnection.this.b.fq().f().c();
                        PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                        if (entity instanceof EntityFish && origItem != null && origItem.k() == Items.nX && (event.isCancelled() || PlayerConnection.this.b.fq().f() == null || PlayerConnection.this.b.fq().f().c() != origItem)) {
                            PlayerConnection.this.a(new PacketPlayOutSpawnEntityLiving((EntityFish)entity));
                            PlayerConnection.this.b.bW.b();
                        }
                        if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.b.fq().f() == null || PlayerConnection.this.b.fq().f().c() != origItem)) {
                            PlayerConnection.this.a(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).fq()));
                        }
                        if (event.isCancelled() || PlayerConnection.this.b.fq().f() == null || PlayerConnection.this.b.fq().f().c() != origItem) {
                            PacketPlayOutEntityMetadata packet1 = new PacketPlayOutEntityMetadata(entity.ae(), entity.ai(), true);
                            if (entity.tracker != null) {
                                entity.tracker.a(packet1);
                            } else {
                                PlayerConnection.this.a(packet1);
                            }
                        }
                        if (event.isCancelled()) {
                            PlayerConnection.this.b.bW.b();
                            return;
                        }
                        EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.b, entity, enumhand);
                        if (!itemInHand.b() && itemInHand.I() <= -1) {
                            PlayerConnection.this.b.bW.b();
                        }
                        if (enuminteractionresult.a()) {
                            CriterionTriggers.P.a(PlayerConnection.this.b, itemstack, entity);
                            if (enuminteractionresult.b()) {
                                PlayerConnection.this.b.a(enumhand, true);
                            }
                        }
                    }

                    @Override
                    public void a(EnumHand hand) {
                        this.performInteraction(hand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a(EnumHand hand, Vec3D pos) {
                        this.performInteraction(hand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, pos, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(pos.b, pos.c, pos.d), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a() {
                        if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity instanceof EntityArrow || entity == PlayerConnection.this.b && !PlayerConnection.this.b.B_())) {
                            ItemStack itemInHand = PlayerConnection.this.b.er();
                            PlayerConnection.this.b.d(entity);
                            if (!itemInHand.b() && itemInHand.I() <= -1) {
                                PlayerConnection.this.b.bW.b();
                            }
                        } else {
                            PlayerConnection.this.disconnect(new ChatMessage("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                            c.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.b.X().getString());
                        }
                    }
                });
            }
        } else {
            packet.a(new PacketPlayInUseEntity.c(){

                @Override
                public void a(EnumHand hand) {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, hand);
                }

                @Override
                public void a(EnumHand hand, Vec3D pos) {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, hand);
                }

                @Override
                public void a() {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, EnumHand.a);
                }
            });
        }
    }

    private void callPlayerUseUnknownEntityEvent(PacketPlayInUseEntity packet, EnumHand hand) {
        this.cserver.getPluginManager().callEvent((Event)new PlayerUseUnknownEntityEvent((Player)this.getCraftPlayer(), packet.getEntityId(), packet.getActionType() == PacketPlayInUseEntity.b.b, hand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND));
    }

    @Override
    public void a(PacketPlayInClientCommand packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.C();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packet.b();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.b.f) {
                    this.b.f = false;
                    this.b = this.e.ac().respawn(this.b, this.e.a(this.b.P()), true, null, true, PlayerRespawnEvent.RespawnFlag.END_PORTAL);
                    CriterionTriggers.v.a(this.b, World.h, World.f);
                    break;
                }
                if (this.b.dZ() > 0.0f) {
                    return;
                }
                this.b = this.e.ac().a(this.b, false);
                if (!this.e.g()) break;
                this.b.setGameMode(EnumGamemode.d, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.b.x().X().a(GameRules.q).a(false, this.e);
                break;
            }
            case b: {
                this.b.D().a(this.b);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(PacketPlayInCloseWindow packetplayinclosewindow, InventoryCloseEvent.Reason reason) {
        PlayerConnectionUtils.a(packetplayinclosewindow, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.b, reason);
        this.b.r();
    }

    @Override
    public void a(PacketPlayInWindowClick packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        this.b.C();
        if (this.b.bW.j == packet.b() && this.b.bW.a(this.b)) {
            boolean cancelled = this.b.B_();
            boolean flag = packet.h() != this.b.bW.j();
            this.b.bW.h();
            if (packet.c() < -1 && packet.c() != -999) {
                return;
            }
            InventoryView inventory = this.b.bW.getBukkitView();
            InventoryType.SlotType type = inventory.getSlotType(packet.c());
            ClickType click = ClickType.UNKNOWN;
            InventoryAction action = InventoryAction.UNKNOWN;
            ItemStack itemstack = ItemStack.b;
            switch (packet.g()) {
                case a: {
                    if (packet.d() == 0) {
                        click = ClickType.LEFT;
                    } else if (packet.d() == 1) {
                        click = ClickType.RIGHT;
                    }
                    if (packet.d() != 0 && packet.d() != 1) break;
                    action = InventoryAction.NOTHING;
                    if (packet.c() == -999) {
                        if (this.b.bW.g().b()) break;
                        action = packet.d() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                        break;
                    }
                    if (packet.c() < 0) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    Slot slot = this.b.bW.a(packet.c());
                    if (slot == null) break;
                    ItemStack clickedItem = slot.e();
                    ItemStack cursor = this.b.bW.g();
                    if (clickedItem.b()) {
                        if (cursor.b()) break;
                        action = packet.d() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                        break;
                    }
                    if (!slot.a(this.b)) break;
                    if (cursor.b()) {
                        action = packet.d() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                        break;
                    }
                    if (slot.a(cursor)) {
                        if (clickedItem.a(cursor) && ItemStack.a(clickedItem, cursor)) {
                            int toPlace = packet.d() == 0 ? cursor.I() : 1;
                            toPlace = Math.min(toPlace, clickedItem.d() - clickedItem.I());
                            if ((toPlace = Math.min(toPlace, slot.c.M_() - clickedItem.I())) == 1) {
                                action = InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (toPlace == cursor.I()) {
                                action = InventoryAction.PLACE_ALL;
                                break;
                            }
                            if (toPlace < 0) {
                                action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                break;
                            }
                            if (toPlace == 0) break;
                            action = InventoryAction.PLACE_SOME;
                            break;
                        }
                        if (cursor.I() > slot.a()) break;
                        action = InventoryAction.SWAP_WITH_CURSOR;
                        break;
                    }
                    if (cursor.c() != clickedItem.c() || !ItemStack.a(cursor, clickedItem) || clickedItem.I() < 0 || clickedItem.I() + cursor.I() > cursor.d()) break;
                    action = InventoryAction.PICKUP_ALL;
                    break;
                }
                case b: {
                    if (packet.d() == 0) {
                        click = ClickType.SHIFT_LEFT;
                    } else if (packet.d() == 1) {
                        click = ClickType.SHIFT_RIGHT;
                    }
                    if (packet.d() != 0 && packet.d() != 1) break;
                    if (packet.c() < 0) {
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    Slot slot = this.b.bW.a(packet.c());
                    if (slot != null && slot.a(this.b) && slot.f()) {
                        action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case c: {
                    if ((packet.d() < 0 || packet.d() >= 9) && packet.d() != 40) break;
                    click = packet.d() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                    Slot clickedSlot = this.b.bW.a(packet.c());
                    if (clickedSlot.a(this.b)) {
                        boolean canCleanSwap;
                        ItemStack hotbar = this.b.fq().a(packet.d());
                        boolean bl = canCleanSwap = hotbar.b() || clickedSlot.c == this.b.fq() && clickedSlot.a(hotbar);
                        if (clickedSlot.f()) {
                            if (canCleanSwap) {
                                action = InventoryAction.HOTBAR_SWAP;
                                break;
                            }
                            action = InventoryAction.HOTBAR_MOVE_AND_READD;
                            break;
                        }
                        if (!clickedSlot.f() && !hotbar.b() && clickedSlot.a(hotbar)) {
                            action = InventoryAction.HOTBAR_SWAP;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case d: {
                    Slot slot;
                    if (packet.d() == 2) {
                        click = ClickType.MIDDLE;
                        if (packet.c() < 0) {
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        slot = this.b.bW.a(packet.c());
                        if (slot != null && slot.f() && this.b.fr().d && this.b.bW.g().b()) {
                            action = InventoryAction.CLONE_STACK;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    click = ClickType.UNKNOWN;
                    action = InventoryAction.UNKNOWN;
                    break;
                }
                case e: {
                    Slot slot;
                    if (packet.c() >= 0) {
                        if (packet.d() == 0) {
                            click = ClickType.DROP;
                            slot = this.b.bW.a(packet.c());
                            if (slot != null && slot.f() && slot.a(this.b) && !slot.e().b() && slot.e().c() != Item.a(Blocks.a)) {
                                action = InventoryAction.DROP_ONE_SLOT;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        if (packet.d() != 1) break;
                        click = ClickType.CONTROL_DROP;
                        slot = this.b.bW.a(packet.c());
                        if (slot != null && slot.f() && slot.a(this.b) && !slot.e().b() && slot.e().c() != Item.a(Blocks.a)) {
                            action = InventoryAction.DROP_ALL_SLOT;
                            break;
                        }
                        action = InventoryAction.NOTHING;
                        break;
                    }
                    click = ClickType.LEFT;
                    if (packet.d() == 1) {
                        click = ClickType.RIGHT;
                    }
                    action = InventoryAction.NOTHING;
                    break;
                }
                case f: {
                    this.b.bW.a(packet.c(), packet.d(), packet.g(), this.b);
                    break;
                }
                case g: {
                    click = ClickType.DOUBLE_CLICK;
                    action = InventoryAction.NOTHING;
                    if (packet.c() < 0 || this.b.bW.g().b()) break;
                    ItemStack cursor = this.b.bW.g();
                    action = InventoryAction.NOTHING;
                    if (!inventory.getTopInventory().contains(CraftMagicNumbers.getMaterial(cursor.c())) && !inventory.getBottomInventory().contains(CraftMagicNumbers.getMaterial(cursor.c()))) break;
                    action = InventoryAction.COLLECT_TO_CURSOR;
                    break;
                }
            }
            if (packet.g() != InventoryClickType.f) {
                org.bukkit.inventory.ItemStack result;
                Recipe recipe;
                InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packet.c(), click, action, packet.d()) : new InventoryClickEvent(inventory, type, packet.c(), click, action);
                Inventory top = inventory.getTopInventory();
                if (packet.c() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                    event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packet.c(), click, action, packet.d()) : new CraftItemEvent(recipe, inventory, type, packet.c(), click, action);
                }
                if (packet.c() == 2 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                    event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packet.c(), click, action, packet.d()) : new SmithItemEvent(inventory, type, packet.c(), click, action);
                }
                event.setCancelled(cancelled);
                Container oldContainer = this.b.bW;
                this.cserver.getPluginManager().callEvent((Event)event);
                if (this.b.bW != oldContainer) {
                    return;
                }
                block9 : switch (event.getResult()) {
                    case ALLOW: 
                    case DEFAULT: {
                        this.b.bW.a(packet.c(), packet.d(), packet.g(), this.b);
                        break;
                    }
                    case DENY: {
                        switch (action) {
                            case PICKUP_ALL: 
                            case MOVE_TO_OTHER_INVENTORY: 
                            case HOTBAR_MOVE_AND_READD: 
                            case HOTBAR_SWAP: 
                            case COLLECT_TO_CURSOR: 
                            case UNKNOWN: {
                                this.b.bW.b();
                                break block9;
                            }
                            case PICKUP_SOME: 
                            case PICKUP_HALF: 
                            case PICKUP_ONE: 
                            case PLACE_ALL: 
                            case PLACE_SOME: 
                            case PLACE_ONE: 
                            case SWAP_WITH_CURSOR: {
                                this.b.b.a(new PacketPlayOutSetSlot(-1, -1, this.b.bV.k(), this.b.bW.g()));
                                this.b.b.a(new PacketPlayOutSetSlot(this.b.bW.j, this.b.bV.k(), packet.c(), this.b.bW.a(packet.c()).e()));
                                break block9;
                            }
                            case DROP_ALL_SLOT: 
                            case DROP_ONE_SLOT: {
                                this.b.b.a(new PacketPlayOutSetSlot(this.b.bW.j, this.b.bV.k(), packet.c(), this.b.bW.a(packet.c()).e()));
                                break block9;
                            }
                            case DROP_ALL_CURSOR: 
                            case DROP_ONE_CURSOR: 
                            case CLONE_STACK: {
                                this.b.b.a(new PacketPlayOutSetSlot(-1, -1, this.b.bV.k(), this.b.bW.g()));
                                break block9;
                            }
                        }
                    }
                }
                if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                    this.b.bW.b();
                }
            }
            for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.f())) {
                this.b.bW.b(entry.getIntKey(), (ItemStack)entry.getValue());
            }
            this.b.bW.a(packet.e());
            this.b.bW.i();
            if (flag) {
                this.b.bW.e();
            } else {
                this.b.bW.d();
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packet) {
        PlayerRecipeBookClickEvent event;
        if (!Bukkit.isPrimaryThread() && this.recipeSpamPackets.addAndGet(PaperConfig.autoRecipeIncrement) > PaperConfig.autoRecipeLimit) {
            this.e.scheduleOnMain(() -> this.disconnect(new ChatMessage("disconnect.spam", new Object[0]), PlayerKickEvent.Cause.SPAM));
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.C();
        if (!this.b.B_() && this.b.bW.j == packet.b() && this.b.bW instanceof ContainerRecipeBook && (event = new PlayerRecipeBookClickEvent((Player)this.b.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(packet.c()), packet.d())).callEvent()) {
            this.e.aC().a(CraftNamespacedKey.toMinecraft(event.getRecipe())).ifPresent(irecipe -> ((ContainerRecipeBook)this.b.bW).a(event.isMakeAll(), (IRecipe<?>)irecipe, this.b));
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.ew()) {
            return;
        }
        this.b.C();
        if (this.b.bW.j == packet.b() && !this.b.B_()) {
            this.b.bW.a((EntityHuman)this.b, packet.c());
            this.b.bW.d();
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.d.e()) {
            boolean flag2;
            BlockPosition blockposition;
            TileEntity tileentity;
            boolean flag = packet.b() < 0;
            ItemStack itemstack = packet.c();
            NBTTagCompound nbttagcompound = ItemBlock.a(itemstack);
            if (!itemstack.b() && nbttagcompound != null && nbttagcompound.e("x") && nbttagcompound.e("y") && nbttagcompound.e("z") && this.b.getBukkitEntity().hasPermission("minecraft.nbt.copy") && (tileentity = this.b.t.c_(blockposition = TileEntity.c(nbttagcompound))) != null) {
                tileentity.e(itemstack);
            }
            boolean flag1 = packet.b() >= 1 && packet.b() <= 45;
            boolean bl = flag2 = itemstack.b() || itemstack.h() >= 0 && itemstack.I() <= 64 && !itemstack.b();
            if (flag || flag1 && !ItemStack.b(this.b.bV.a(packet.b()).e(), packet.c())) {
                CraftInventoryView inventory = this.b.bV.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packet.c());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.b() < 36) {
                    type = packet.b() >= 5 && packet.b() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : packet.b(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.b() >= 0) {
                            this.b.b.a(new PacketPlayOutSetSlot(this.b.bV.j, this.b.bV.k(), packet.b(), this.b.bV.a(packet.b()).e()));
                            this.b.b.a(new PacketPlayOutSetSlot(-1, this.b.bV.k(), -1, ItemStack.b));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.b.bV.a(packet.b()).d(itemstack);
                this.b.bV.d();
            } else if (flag && flag2 && this.k < 200) {
                this.k += 20;
                this.b.a(itemstack, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packet) {
        List<String> list = Stream.of(packet.c()).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list, (List<ITextFilter.a> list1) -> this.a(packet, (List<ITextFilter.a>)list1));
    }

    private void a(PacketPlayInUpdateSign packet, List<ITextFilter.a> signText) {
        if (this.b.ew()) {
            return;
        }
        this.b.C();
        WorldServer worldserver = this.b.x();
        BlockPosition blockposition = packet.b();
        if (worldserver.C(blockposition)) {
            IBlockData iblockdata = worldserver.a_(blockposition);
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            if (!tileentitysign.d() || !this.b.cm().equals(tileentitysign.f())) {
                c.warn("Player {} just tried to change non-editable sign", (Object)this.b.X().getString());
                if (this.b.h(blockposition.u(), blockposition.v(), blockposition.w()) < 1024.0) {
                    this.a(tileentity.h());
                }
                return;
            }
            CraftPlayer player = this.b.getBukkitEntity();
            int x2 = packet.b().u();
            int y2 = packet.b().v();
            int z2 = packet.b().w();
            ArrayList<TextComponent> lines = new ArrayList<TextComponent>();
            for (int i2 = 0; i2 < signText.size(); ++i2) {
                int offset;
                ITextFilter.a currentLine = signText.get(i2);
                if (MAX_SIGN_LINE_LENGTH > 0 && currentLine.a().length() > MAX_SIGN_LINE_LENGTH && (offset = currentLine.a().codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) < currentLine.a().length()) {
                    currentLine = ITextFilter.a.a(currentLine.a().substring(0, offset));
                    signText.set(i2, currentLine);
                }
                if (this.b.U()) {
                    lines.add(Component.text((String)SharedConstants.a(currentLine.b())));
                    continue;
                }
                lines.add(Component.text((String)SharedConstants.a(currentLine.a())));
            }
            SignChangeEvent event = new SignChangeEvent((Block)((CraftBlock)player.getWorld().getBlockAt(x2, y2, z2)), (Player)this.b.getBukkitEntity(), lines);
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    tileentitysign.a(i3, PaperAdventure.asVanilla(event.line(i3)));
                }
                tileentitysign.f = false;
            }
            tileentitysign.e();
            worldserver.a(blockposition, iblockdata, iblockdata, 3);
        }
    }

    @Override
    public void a(PacketPlayInKeepAlive packet) {
        if (this.h && packet.b() == this.i) {
            int i2 = (int)(SystemUtils.c() - this.g);
            this.b.e = (this.b.e * 3 + i2) / 4;
            this.h = false;
        } else if (!this.e()) {
            this.e.f(() -> this.disconnect(new ChatMessage("disconnect.timeout"), PlayerKickEvent.Cause.TIMEOUT));
        }
    }

    @Override
    public void a(PacketPlayInAbilities packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.fr().c && this.b.fr().b != packet.b()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.b.getBukkitEntity(), packet.b());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.b.fr().b = packet.b();
            } else {
                this.b.w();
            }
        }
    }

    @Override
    public void a(PacketPlayInSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        this.b.a(packet);
    }

    @Override
    public void a(PacketPlayInCustomPayload packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (packet.c.equals(CUSTOM_REGISTER)) {
            try {
                String channels = packet.d.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                c.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect("Invalid payload REGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else if (packet.c.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = packet.d.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                c.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect("Invalid payload UNREGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else {
            try {
                byte[] data = new byte[packet.d.readableBytes()];
                packet.d.readBytes(data);
                if (packet.c.equals(MINECRAFT_BRAND)) {
                    try {
                        this.clientBrandName = new PacketDataSerializer(Unpooled.copiedBuffer((byte[])data)).e(256);
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        this.clientBrandName = "illegal";
                    }
                }
                this.cserver.getMessenger().dispatchIncomingMessage((Player)this.b.getBukkitEntity(), packet.c.toString(), data);
            }
            catch (Exception ex) {
                c.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect("Invalid custom payload!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        }
    }

    public String getClientBrandName() {
        return this.clientBrandName;
    }

    public final boolean isDisconnected() {
        return !this.b.joining && !this.a.h() || this.processedDisconnect;
    }

    @Override
    public void a(PacketPlayInDifficultyChange packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2) || this.e()) {
            // empty if block
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packet) {
        PlayerConnectionUtils.a(packet, this, this.b.x());
        if (this.b.l(2) || this.e()) {
            this.e.b(packet.b());
        }
    }

    @Override
    public EntityPlayer d() {
        return this.b;
    }

    private /* synthetic */ IChatBaseComponent lambda$handleChat$15(ChatMessage chatmessage, ChatMessage chatmessage1, EntityPlayer entityplayer) {
        return this.b.b(entityplayer) ? chatmessage : chatmessage1;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

