/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.PaperConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreak;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBisected;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerInteractManager {
    private static final Logger a = LogManager.getLogger();
    public WorldServer c;
    protected final EntityPlayer d;
    private EnumGamemode b = EnumGamemode.e;
    @Nullable
    private EnumGamemode e;
    private boolean f;
    private int g;
    private long lastDigTime;
    private BlockPosition h = BlockPosition.b;
    private int i;
    private boolean j;
    private BlockPosition k = BlockPosition.b;
    private int l;
    private long hasDestroyedTooFastStartTime;
    private int m = -1;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    private int getTimeDiggingLagCompensate() {
        int lagCompensated = (int)((System.nanoTime() - this.lastDigTime) / 50000000L);
        int tickDiff = this.i - this.g;
        return PaperConfig.lagCompensateBlockBreaking && lagCompensated > tickDiff + 1 ? lagCompensated : tickDiff;
    }

    private int getTimeDiggingTooFastLagCompensate() {
        int lagCompensated = (int)((System.nanoTime() - this.hasDestroyedTooFastStartTime) / 50000000L);
        int tickDiff = this.i - this.l;
        return PaperConfig.lagCompensateBlockBreaking && lagCompensated > tickDiff + 1 ? lagCompensated : tickDiff;
    }

    public PlayerInteractManager(EntityPlayer player) {
        this.d = player;
        this.c = player.x();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.changeGameModeForPlayer(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    public PlayerGameModeChangeEvent changeGameModeForPlayer(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, Component cancelMessage) {
        if (gameMode == this.b) {
            return null;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.d.getBukkitEntity(), GameMode.getByValue((int)gameMode.a()), cause, cancelMessage);
        this.c.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.a(gameMode, this.b);
        return event;
    }

    protected void a(EnumGamemode gameMode, @Nullable EnumGamemode previousGameMode) {
        this.e = previousGameMode;
        this.b = gameMode;
        gameMode.a(this.d.fr());
        this.d.w();
        this.d.c.ac().broadcastAll((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.b, this.d), this.d);
        this.c.e();
    }

    public EnumGamemode b() {
        return this.b;
    }

    @Nullable
    public EnumGamemode c() {
        return this.e;
    }

    public boolean d() {
        return this.b.g();
    }

    public boolean e() {
        return this.b.f();
    }

    public void a() {
        this.i = MinecraftServer.currentTick;
        if (this.j) {
            IBlockData iblockdata = this.c.getBlockStateIfLoaded(this.k);
            if (iblockdata == null || iblockdata.g()) {
                this.j = false;
            } else {
                float f2 = this.updateBlockBreakAnimation(iblockdata, this.k, this.getTimeDiggingTooFastLagCompensate());
                if (f2 >= 1.0f) {
                    this.j = false;
                    this.a(this.k);
                }
            }
        } else if (this.f) {
            IBlockData iblockdata = this.c.getBlockStateIfLoaded(this.h);
            if (iblockdata == null) {
                this.f = false;
                return;
            }
            if (iblockdata.g()) {
                this.c.a(this.d.ae(), this.h, -1);
                this.m = -1;
                this.f = false;
            } else {
                this.updateBlockBreakAnimation(iblockdata, this.h, this.getTimeDiggingLagCompensate());
            }
        }
    }

    private float a(IBlockData state, BlockPosition pos, int i2) {
        int j2 = this.i - i2;
        return this.updateBlockBreakAnimation(state, pos, j2);
    }

    private float updateBlockBreakAnimation(IBlockData state, BlockPosition pos, int totalTime) {
        int j2 = totalTime;
        float f2 = state.a(this.d, this.d.t, pos) * (float)(j2 + 1);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.m) {
            this.c.a(this.d.ae(), pos, k2);
            this.m = k2;
        }
        return f2;
    }

    public void a(BlockPosition pos, PacketPlayInBlockDig.EnumPlayerDigType action, EnumDirection direction, int worldHeight) {
        double d2;
        double d1;
        double d0 = this.d.dc() - ((double)pos.u() + 0.5);
        double d3 = d0 * d0 + (d1 = this.d.de() - ((double)pos.v() + 0.5) + 1.5) * d1 + (d2 = this.d.di() - ((double)pos.w() + 0.5)) * d2;
        if (d3 > 36.0) {
            return;
        }
        if (pos.v() >= worldHeight) {
            this.d.b.a(new PacketPlayOutBlockBreak(pos, this.c.a_(pos), action, false, "too high"));
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.a) {
            if (!this.c.a((EntityHuman)this.d, pos)) {
                CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, direction, this.d.fq().f(), EnumHand.a);
                this.d.b.a(new PacketPlayOutBlockBreak(pos, this.c.a_(pos), action, false, "may not interact"));
                TileEntity tileentity = this.c.c_(pos);
                if (tileentity != null) {
                    this.d.b.a(tileentity.h());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, direction, this.d.fq().f(), EnumHand.a);
            if (event.isCancelled()) {
                for (EnumDirection dir : EnumDirection.values()) {
                    this.d.b.a(new PacketPlayOutBlockChange(this.c, pos.a(dir)));
                }
                this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
                TileEntity tileentity = this.c.c_(pos);
                if (tileentity != null) {
                    this.d.b.a(tileentity.h());
                }
                return;
            }
            if (this.e()) {
                this.a(pos, action, "creative destroy");
                return;
            }
            if (this.d.a(this.c, pos, this.b)) {
                this.d.b.a(new PacketPlayOutBlockBreak(pos, this.c.a_(pos), action, false, "block action restricted"));
                return;
            }
            this.g = this.i;
            this.lastDigTime = System.nanoTime();
            float f2 = 1.0f;
            IBlockData iblockdata = this.c.a_(pos);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                IBlockData data = this.c.a_(pos);
                if (data.b() instanceof BlockDoor) {
                    boolean bottom = data.c(BlockDoor.e) == BlockPropertyDoubleBlockHalf.b;
                    this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
                    this.d.b.a(new PacketPlayOutBlockChange(this.c, bottom ? pos.b() : pos.c()));
                } else if (data.b() instanceof BlockTrapdoor) {
                    this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
                }
            } else if (!iblockdata.g()) {
                iblockdata.a((World)this.c, pos, this.d);
                f2 = iblockdata.a(this.d, this.d.t, pos);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f2 > 1.0f) {
                    this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.d, pos.u(), pos.v(), pos.w(), this.d.fq().f(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!iblockdata.g() && f2 >= 1.0f) {
                this.a(pos, action, "insta mine");
            } else {
                if (this.f) {
                    this.d.b.a(new PacketPlayOutBlockBreak(this.h, this.c.a_(this.h), PacketPlayInBlockDig.EnumPlayerDigType.a, false, "abort destroying since another started (client insta mine, server disagreed)"));
                }
                this.f = true;
                this.h = pos.h();
                int j2 = (int)(f2 * 10.0f);
                this.c.a(this.d.ae(), pos, j2);
                if (!PaperConfig.lagCompensateBlockBreaking) {
                    this.d.b.a(new PacketPlayOutBlockBreak(pos, this.c.a_(pos), action, true, "actual start of destroying"));
                }
                this.m = j2;
            }
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.c) {
            if (pos.equals(this.h)) {
                int k2 = this.getTimeDiggingLagCompensate();
                IBlockData iblockdata = this.c.a_(pos);
                if (!iblockdata.g()) {
                    float f1 = iblockdata.a(this.d, this.d.t, pos) * (float)(k2 + 1);
                    if (f1 >= 0.7f) {
                        this.f = false;
                        this.c.a(this.d.ae(), pos, -1);
                        this.a(pos, action, "destroyed");
                        return;
                    }
                    if (!this.j) {
                        this.f = false;
                        this.j = true;
                        this.k = pos;
                        this.l = this.g;
                        this.hasDestroyedTooFastStartTime = this.lastDigTime;
                    }
                }
            }
            if (PaperConfig.lagCompensateBlockBreaking) {
                this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
            } else {
                this.d.b.a(new PacketPlayOutBlockBreak(pos, this.c.a_(pos), action, true, "stopped destroying"));
            }
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.b) {
            this.f = false;
            if (!Objects.equals(this.h, pos) && !BlockPosition.b.equals(this.h)) {
                a.debug("Mismatch in destroy block pos: {} {}", (Object)this.h, (Object)pos);
                IBlockData type = this.c.getBlockStateIfLoaded(this.h);
                if (type != null) {
                    this.c.a(this.d.ae(), this.h, -1);
                }
                if (type != null) {
                    this.d.b.a(new PacketPlayOutBlockBreak(this.h, type, action, true, "aborted mismatched destroying"));
                }
                this.h = BlockPosition.b;
            }
            this.c.a(this.d.ae(), pos, -1);
            if (!PaperConfig.lagCompensateBlockBreaking) {
                this.d.b.a(new PacketPlayOutBlockBreak(pos, this.c.a_(pos), action, true, "aborted destroying"));
            }
        }
        this.c.chunkPacketBlockController.onPlayerLeftClickBlock(this, pos, action, direction, worldHeight);
    }

    public void a(BlockPosition pos, PacketPlayInBlockDig.EnumPlayerDigType action, String reason) {
        if (this.a(pos)) {
            if (PaperConfig.lagCompensateBlockBreaking) {
                this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
            } else {
                this.d.b.a(new PacketPlayOutBlockBreak(pos, this.c.a_(pos), action, true, reason));
            }
        } else {
            this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
        }
    }

    public boolean a(BlockPosition pos) {
        IBlockData iblockdata = this.c.a_(pos);
        CraftBlock bblock = CraftBlock.at(this.c, pos);
        BlockBreakEvent event = null;
        if (this.d instanceof EntityPlayer) {
            boolean isSwordNoBreak;
            boolean bl = isSwordNoBreak = !this.d.er().c().a(iblockdata, (World)this.c, pos, (EntityHuman)this.d);
            if (this.c.c_(pos) == null && !isSwordNoBreak) {
                PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(pos, Blocks.a.n());
                this.d.b.a(packet);
            }
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.d.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            IBlockData nmsData = this.c.a_(pos);
            Block nmsBlock = nmsData.b();
            ItemStack itemstack = this.d.b(EnumItemSlot.a);
            if (nmsBlock != null && !event.isCancelled() && !this.e() && this.d.d(nmsBlock.n())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.c, pos, itemstack));
            }
            this.c.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                this.d.b.a(new PacketPlayOutBlockChange(this.c, pos));
                for (EnumDirection dir : EnumDirection.values()) {
                    this.d.b.a(new PacketPlayOutBlockChange(this.c, pos.a(dir)));
                }
                TileEntity tileentity = this.c.c_(pos);
                if (tileentity != null) {
                    this.d.b.a(tileentity.h());
                }
                return false;
            }
        }
        if ((iblockdata = this.c.a_(pos)).g()) {
            return false;
        }
        TileEntity tileentity = this.c.c_(pos);
        Block block = iblockdata.b();
        if (!(!(block instanceof GameMasterBlock) || this.d.fM() || block instanceof BlockCommand && this.d.f() && this.d.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.c.a(pos, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.d.a(this.c, pos, this.b)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.c.captureDrops = new ArrayList<EntityItem>();
        block.a((World)this.c, pos, iblockdata, (EntityHuman)this.d);
        boolean flag = this.c.a(pos, false);
        if (flag) {
            block.a((GeneratorAccess)this.c, pos, iblockdata);
        }
        if (!this.e()) {
            ItemStack itemstack = this.d.er();
            ItemStack itemstack1 = itemstack.m();
            boolean flag1 = this.d.d(iblockdata);
            itemstack.a((World)this.c, iblockdata, pos, this.d);
            if (flag && flag1 && event.isDropItems()) {
                block.a(this.c, this.d, pos, iblockdata, tileentity, itemstack1);
            }
        }
        List<EntityItem> itemsToDrop = this.c.captureDrops;
        this.c.captureDrops = null;
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.d, itemsToDrop);
        }
        if (flag && event != null) {
            iblockdata.b().popExperience(this.c, pos, event.getExpToDrop(), this.d);
        }
        return true;
    }

    public EnumInteractionResult a(EntityPlayer player, World world, ItemStack stack, EnumHand hand) {
        if (this.b == EnumGamemode.d) {
            return EnumInteractionResult.d;
        }
        if (player.fK().a(stack.c())) {
            return EnumInteractionResult.d;
        }
        int i2 = stack.I();
        int j2 = stack.h();
        InteractionResultWrapper<ItemStack> interactionresultwrapper = stack.a(world, (EntityHuman)player, hand);
        ItemStack itemstack1 = interactionresultwrapper.b();
        if (itemstack1 == stack && itemstack1.I() == i2 && itemstack1.o() <= 0 && itemstack1.h() == j2) {
            return interactionresultwrapper.a();
        }
        if (interactionresultwrapper.a() == EnumInteractionResult.e && itemstack1.o() > 0 && !player.eL()) {
            return interactionresultwrapper.a();
        }
        player.a(hand, itemstack1);
        if (this.e()) {
            itemstack1.e(i2);
            if (itemstack1.f() && itemstack1.h() != j2) {
                itemstack1.b(j2);
            }
        }
        if (itemstack1.b()) {
            player.a(hand, ItemStack.b);
        }
        if (!player.eL()) {
            player.bV.b();
        }
        return interactionresultwrapper.a();
    }

    public EnumInteractionResult a(EntityPlayer player, World world, ItemStack stack, EnumHand hand, MovingObjectPositionBlock hitResult) {
        BlockPosition blockposition = hitResult.a();
        IBlockData iblockdata = world.a_(blockposition);
        EnumInteractionResult enuminteractionresult = EnumInteractionResult.d;
        boolean cancelledBlock = false;
        if (this.b == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.b(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof ITileInventory);
        }
        if (player.fK().a(stack.c())) {
            cancelledBlock = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, blockposition, hitResult.b(), stack, cancelledBlock, hand, hitResult.e());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.h();
        this.interactHand = hand;
        this.interactItemStack = stack.m();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (iblockdata.b() instanceof BlockDoor) {
                boolean bottom = iblockdata.c(BlockDoor.e) == BlockPropertyDoubleBlockHalf.b;
                player.b.a(new PacketPlayOutBlockChange(world, bottom ? blockposition.b() : blockposition.c()));
            } else if (iblockdata.b() instanceof BlockCake) {
                player.getBukkitEntity().sendHealthUpdate();
            } else if (this.interactItemStack.c() instanceof ItemBisected) {
                player.b.a(new PacketPlayOutBlockChange(world, blockposition.a(hitResult.b()).b()));
                player.b.a(new PacketPlayOutBlockChange(world, blockposition.b()));
            } else if (iblockdata.b() instanceof BlockStructure) {
                player.b.a(new PacketPlayOutCloseWindow(this.d.bW.j));
            } else if (iblockdata.b() instanceof BlockCommand) {
                player.b.a(new PacketPlayOutCloseWindow(this.d.bW.j));
            }
            player.getBukkitEntity().updateInventory();
            enuminteractionresult = event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.a : EnumInteractionResult.d;
        } else {
            if (this.b == EnumGamemode.d) {
                ITileInventory itileinventory = iblockdata.b(world, blockposition);
                if (itileinventory != null) {
                    player.a(itileinventory);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.d;
            }
            boolean flag = !player.er().b() || !player.es().b();
            boolean flag1 = player.ff() && flag;
            ItemStack itemstack1 = stack.m();
            if (!flag1 && (enuminteractionresult = iblockdata.a(world, player, hand, hitResult)).a()) {
                CriterionTriggers.M.a(player, blockposition, itemstack1);
                return enuminteractionresult;
            }
            if (!stack.b() && enuminteractionresult != EnumInteractionResult.a && !this.interactResult) {
                EnumInteractionResult enuminteractionresult1;
                ItemActionContext itemactioncontext = new ItemActionContext(player, hand, hitResult);
                if (this.e()) {
                    int i2 = stack.I();
                    enuminteractionresult1 = stack.useOn(itemactioncontext, hand);
                    stack.e(i2);
                } else {
                    enuminteractionresult1 = stack.useOn(itemactioncontext, hand);
                }
                if (enuminteractionresult1.a()) {
                    CriterionTriggers.M.a(player, blockposition, itemstack1);
                }
                return enuminteractionresult1;
            }
        }
        return enuminteractionresult;
    }

    public void a(WorldServer world) {
        this.c = world;
    }
}

