/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkTaskQueueSorter
implements PlayerChunk.d,
AutoCloseable {
    private static final Logger a = LogManager.getLogger();
    private final Map<Mailbox<?>, ChunkTaskQueue<? extends Function<Mailbox<Unit>, ?>>> b;
    private final Set<Mailbox<?>> c;
    private final ThreadedMailbox<PairedQueue.b> d;

    public ChunkTaskQueueSorter(List<Mailbox<?>> actors, Executor executor, int maxQueues) {
        this.b = actors.stream().collect(Collectors.toMap(Function.identity(), actor -> new ChunkTaskQueue(actor.bn() + "_queue", maxQueues)));
        this.c = Sets.newHashSet(actors);
        this.d = new ThreadedMailbox<PairedQueue.b>(new PairedQueue.a(4), executor, "sorter");
    }

    public static <T> a<T> a(Function<Mailbox<Unit>, T> taskFunction, long pos, IntSupplier lastLevelUpdatedToProvider) {
        return new a<T>(taskFunction, pos, lastLevelUpdatedToProvider);
    }

    public static a<Runnable> a(Runnable task, long pos, IntSupplier lastLevelUpdatedToProvider) {
        return new a<Runnable>(yield -> () -> {
            task.run();
            yield.a(Unit.a);
        }, pos, lastLevelUpdatedToProvider);
    }

    public static a<Runnable> a(PlayerChunk holder, Runnable task) {
        return ChunkTaskQueueSorter.a(task, holder.i().a(), holder::k);
    }

    public static <T> a<T> a(PlayerChunk holder, Function<Mailbox<Unit>, T> taskFunction) {
        return ChunkTaskQueueSorter.a(taskFunction, holder.i().a(), holder::k);
    }

    public static b a(Runnable task, long pos, boolean removeTask) {
        return new b(task, pos, removeTask);
    }

    public <T> Mailbox<a<T>> a(Mailbox<T> executor, boolean addBlocker) {
        return (Mailbox)this.d.b((? super Mailbox<Source> yield) -> new PairedQueue.b(0, () -> {
            this.b(executor);
            yield.a(Mailbox.a("chunk priority sorter around " + executor.bn(), (Msg message) -> this.a(executor, message.a, message.b, message.c, addBlocker)));
        })).join();
    }

    public Mailbox<b> a(Mailbox<Runnable> executor) {
        return (Mailbox)this.d.b((? super Mailbox<Source> yield) -> new PairedQueue.b(0, () -> yield.a(Mailbox.a("chunk priority sorter around " + executor.bn(), (Msg release) -> this.a(executor, release.b, release.a, release.c))))).join();
    }

    @Override
    @Override
    public void onLevelChange(ChunkCoordIntPair pos, IntSupplier levelGetter, int targetLevel, IntConsumer levelSetter) {
        this.d.a(new PairedQueue.b(0, () -> {
            int j2 = levelGetter.getAsInt();
            this.b.values().forEach(queue -> queue.a(j2, pos, targetLevel));
            levelSetter.accept(targetLevel);
        }));
    }

    private <T> void a(Mailbox<T> actor, long chunkPos, Runnable callback, boolean clearTask) {
        this.d.a(new PairedQueue.b(1, () -> {
            ChunkTaskQueue chunkTaskPriorityQueue = this.b(actor);
            chunkTaskPriorityQueue.a(chunkPos, clearTask);
            if (this.c.remove(actor)) {
                this.a(chunkTaskPriorityQueue, actor);
            }
            callback.run();
        }));
    }

    private <T> void a(Mailbox<T> actor, Function<Mailbox<Unit>, T> task, long chunkPos, IntSupplier lastLevelUpdatedToProvider, boolean addBlocker) {
        this.d.a(new PairedQueue.b(2, () -> {
            ChunkTaskQueue chunkTaskPriorityQueue = this.b(actor);
            int i2 = lastLevelUpdatedToProvider.getAsInt();
            chunkTaskPriorityQueue.a(Optional.of(task), chunkPos, i2);
            if (addBlocker) {
                chunkTaskPriorityQueue.a(Optional.empty(), chunkPos, i2);
            }
            if (this.c.remove(actor)) {
                this.a(chunkTaskPriorityQueue, actor);
            }
        }));
    }

    private <T> void a(ChunkTaskQueue<Function<Mailbox<Unit>, T>> queue, Mailbox<T> actor) {
        this.d.a(new PairedQueue.b(3, () -> {
            Stream<Either<Either, Runnable>> stream = queue.a();
            if (stream == null) {
                this.c.add(actor);
            } else {
                SystemUtils.b(stream.map(executeOrAddBlocking -> executeOrAddBlocking.map(actor::b, addBlocking -> {
                    addBlocking.run();
                    return CompletableFuture.completedFuture(Unit.a);
                })).collect(Collectors.toList())).thenAccept(list -> this.a(queue, actor));
            }
        }));
    }

    private <T> ChunkTaskQueue<Function<Mailbox<Unit>, T>> b(Mailbox<T> actor) {
        ChunkTaskQueue<Function<Mailbox<Unit>, T>> chunkTaskPriorityQueue = this.b.get(actor);
        if (chunkTaskPriorityQueue == null) {
            throw SystemUtils.c(new IllegalArgumentException("No queue for: " + actor));
        }
        return chunkTaskPriorityQueue;
    }

    @VisibleForTesting
    public String a() {
        return this.b.entrySet().stream().map(entry -> ((Mailbox)entry.getKey()).bn() + "=[" + ((ChunkTaskQueue)entry.getValue()).b().stream().map(long_ -> long_ + ":" + new ChunkCoordIntPair((long)long_)).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",")) + ", s=" + this.c.size();
    }

    @Override
    @Override
    public void close() {
        this.b.keySet().forEach(Mailbox::close);
    }

    public static final class a<T> {
        final Function<Mailbox<Unit>, T> a;
        final long b;
        final IntSupplier c;

        a(Function<Mailbox<Unit>, T> taskFunction, long pos, IntSupplier lastLevelUpdatedToProvider) {
            this.a = taskFunction;
            this.b = pos;
            this.c = lastLevelUpdatedToProvider;
        }
    }

    public static final class b {
        final Runnable a;
        final long b;
        final boolean c;

        b(Runnable callback, long pos, boolean removeTask) {
            this.a = callback;
            this.b = pos;
            this.c = removeTask;
        }
    }
}

