/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsReportListener;
import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.console.PaperConsole;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.unix.DomainSocketAddress;
import io.papermc.paper.brigadier.PaperBrigadierProviderImpl;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.BufferedCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_18_R1.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_18_R1.util.ForwardLogHandler;
import org.bukkit.craftbukkit.v1_18_R1.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.spigotmc.SpigotConfig;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final org.apache.logging.log4j.Logger r = LogManager.getLogger();
    private static final int s = 5000;
    private static final int t = 2;
    private static final Pattern u = Pattern.compile("^[a-fA-F0-9]{40}$");
    private final Queue<ServerCommand> serverCommandQueue = new ConcurrentLinkedQueue<ServerCommand>();
    @Nullable
    private RemoteStatusListener w;
    public final RemoteControlCommandListener x;
    @Nullable
    private RemoteControlListener y;
    public DedicatedServerSettings z;
    @Nullable
    private ServerGUI A;
    @Nullable
    private final TextFilter B;
    @Nullable
    private final IChatBaseComponent C;

    public DedicatedServer(OptionSet options, DataPackConfiguration datapackconfiguration, Thread thread, IRegistryCustom.Dimension iregistrycustom_dimension, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, DataPackResources datapackresources, SaveData savedata, DedicatedServerSettings dedicatedserversettings, DataFixer datafixer, MinecraftSessionService minecraftsessionservice, GameProfileRepository gameprofilerepository, UserCache usercache, WorldLoadListenerFactory worldloadlistenerfactory) {
        super(options, datapackconfiguration, thread, iregistrycustom_dimension, convertable_conversionsession, savedata, resourcepackrepository, Proxy.NO_PROXY, datafixer, datapackresources, minecraftsessionservice, gameprofilerepository, usercache, worldloadlistenerfactory);
        this.z = dedicatedserversettings;
        this.x = new RemoteControlCommandListener(this);
        this.B = TextFilter.a(dedicatedserversettings.a().V);
        this.C = DedicatedServer.a(dedicatedserversettings);
    }

    @Override
    public boolean e() throws IOException {
        Object bindAddress;
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                new PaperConsole(DedicatedServer.this).start();
            }
        };
        Logger global = Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (Handler handler : global.getHandlers()) {
            global.removeHandler(handler);
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(r));
        r.info("Starting minecraft server version {}", (Object)SharedConstants.b().getName());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            r.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        if (ServerEnvironment.userIsRootOrAdmin()) {
            r.warn("****************************");
            r.warn("YOU ARE RUNNING THIS SERVER AS AN ADMINISTRATIVE OR ROOT USER. THIS IS NOT ADVISED.");
            r.warn("YOU ARE OPENING YOURSELF UP TO POTENTIAL RISKS WHEN DOING THIS.");
            r.warn("FOR MORE INFORMATION, SEE https://madelinemiller.dev/blog/root-minecraft-server/");
            r.warn("****************************");
        }
        r.info("Loading properties");
        DedicatedServerProperties dedicatedserverproperties = this.z.a();
        if (this.O()) {
            this.a_("127.0.0.1");
        } else {
            this.d(dedicatedserverproperties.a);
            this.e(dedicatedserverproperties.b);
            this.a_(dedicatedserverproperties.c);
        }
        this.a(new DedicatedPlayerList(this, this.n, this.m));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        if (this.bi()) {
            this.ao().save(false);
        }
        this.bg().loadAndSaveFiles();
        try {
            PaperConfig.init((File)this.options.valueOf("paper-settings"));
        }
        catch (Exception e2) {
            r.error("Unable to load server configuration", (Throwable)e2);
            return false;
        }
        thread.start();
        PaperConfig.registerCommands();
        ((Object)((Object)VersionHistoryManager.INSTANCE)).getClass();
        ((Object)((Object)ObfHelper.INSTANCE)).getClass();
        ((Object)((Object)PaperBrigadierProviderImpl.INSTANCE)).getClass();
        this.f(dedicatedserverproperties.f);
        this.g(dedicatedserverproperties.g);
        this.a(dedicatedserverproperties.h, this.be());
        this.e(dedicatedserverproperties.k);
        super.c(dedicatedserverproperties.W.get());
        this.h(dedicatedserverproperties.m);
        r.info("Default game type: {}", (Object)dedicatedserverproperties.o);
        if (this.u().startsWith("unix:")) {
            if (!Epoll.isAvailable()) {
                r.fatal("**** INVALID CONFIGURATION!");
                r.fatal("You are trying to use a Unix domain socket but you're not on a supported OS.");
                return false;
            }
            if (!PaperConfig.velocitySupport && !SpigotConfig.bungee) {
                r.fatal("**** INVALID CONFIGURATION!");
                r.fatal("Unix domain sockets require IPs to be forwarded from a proxy.");
                return false;
            }
            bindAddress = new DomainSocketAddress(this.u().substring("unix:".length()));
        } else {
            InetAddress inetaddress = null;
            if (!this.u().isEmpty()) {
                inetaddress = InetAddress.getByName(this.u());
            }
            if (this.M() < 0) {
                this.a(dedicatedserverproperties.q);
            }
            bindAddress = new InetSocketAddress(inetaddress, this.M());
        }
        this.P();
        r.info("Starting Minecraft server on {}:{}", (Object)(this.u().isEmpty() ? "*" : this.u()), (Object)this.M());
        try {
            this.ad().bind((SocketAddress)bindAddress);
        }
        catch (IOException ioexception) {
            r.warn("**** FAILED TO BIND TO PORT!");
            r.warn("The exception was: {}", (Object)ioexception.toString());
            r.warn("Perhaps a server is already running on that port?");
            return false;
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        if (!this.U()) {
            r.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            r.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (SpigotConfig.bungee) {
                r.warn("Whilst this makes it possible to use BungeeCord, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.");
                r.warn("Please see http://www.spigotmc.org/wiki/firewall-guide/ for further information.");
            } else {
                r.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            r.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        long i2 = SystemUtils.d();
        TileEntitySkull.a(this.ao(), this.am(), this);
        UserCache.a(this.U());
        r.info("Preparing level \"{}\"", (Object)this.r());
        this.loadLevel(this.l.a());
        long j2 = SystemUtils.d() - i2;
        String s2 = String.format(Locale.ROOT, "%.3fs", (double)j2 / 1.0E9);
        if (dedicatedserverproperties.r != null) {
            this.aJ().a(GameRules.x).a(dedicatedserverproperties.r, (MinecraftServer)this);
        }
        if (dedicatedserverproperties.s) {
            r.info("Starting GS4 status listener");
            this.w = RemoteStatusListener.a(this);
        }
        if (dedicatedserverproperties.u) {
            r.info("Starting remote control listener");
            this.y = RemoteControlListener.a(this);
            this.remoteConsole = new CraftRemoteConsoleCommandSender(this.x);
        }
        Items.a.a(CreativeModeTab.g, NonNullList.a());
        if (dedicatedserverproperties.R) {
            MinecraftServerBeans.a(this);
            r.info("JMX monitoring enabled");
        }
        return true;
    }

    @Override
    public boolean W() {
        return this.a().d && super.W();
    }

    @Override
    public boolean Q() {
        return this.z.a().B && super.Q();
    }

    @Override
    public boolean X() {
        return this.z.a().e && super.X();
    }

    public String be() {
        String s2;
        DedicatedServerProperties dedicatedserverproperties = this.z.a();
        if (!dedicatedserverproperties.y.isEmpty()) {
            s2 = dedicatedserverproperties.y;
            if (!Strings.isNullOrEmpty((String)dedicatedserverproperties.x)) {
                r.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)dedicatedserverproperties.x)) {
            r.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            s2 = dedicatedserverproperties.x;
        } else {
            s2 = "";
        }
        if (!s2.isEmpty() && !u.matcher(s2).matches()) {
            r.warn("Invalid sha1 for ressource-pack-sha1");
        }
        if (!dedicatedserverproperties.h.isEmpty() && s2.isEmpty()) {
            r.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        }
        return s2;
    }

    @Override
    public DedicatedServerProperties a() {
        return this.z.a();
    }

    @Override
    public void q() {
    }

    @Override
    public boolean g() {
        return this.a().z;
    }

    @Override
    public SystemReport a(SystemReport details) {
        details.a("Is Modded", () -> this.K().b());
        details.a("Type", () -> "Dedicated Server (map_server.txt)");
        return details;
    }

    @Override
    public void a(Path file) throws IOException {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(file, new OpenOption[0]);){
            bufferedwriter.write(String.format("sync-chunk-writes=%s%n", dedicatedserverproperties.Q));
            bufferedwriter.write(String.format("gamemode=%s%n", new Object[]{dedicatedserverproperties.o}));
            bufferedwriter.write(String.format("spawn-monsters=%s%n", dedicatedserverproperties.B));
            bufferedwriter.write(String.format("entity-broadcast-range-percentage=%d%n", dedicatedserverproperties.U));
            bufferedwriter.write(String.format("max-world-size=%d%n", dedicatedserverproperties.P));
            bufferedwriter.write(String.format("spawn-npcs=%s%n", dedicatedserverproperties.e));
            bufferedwriter.write(String.format("view-distance=%d%n", dedicatedserverproperties.J));
            bufferedwriter.write(String.format("simulation-distance=%d%n", dedicatedserverproperties.K));
            bufferedwriter.write(String.format("spawn-animals=%s%n", dedicatedserverproperties.d));
            bufferedwriter.write(String.format("generate-structures=%s%n", dedicatedserverproperties.a(this.n).b()));
            bufferedwriter.write(String.format("use-native=%s%n", dedicatedserverproperties.C));
            bufferedwriter.write(String.format("rate-limit=%d%n", dedicatedserverproperties.I));
        }
    }

    @Override
    public void f() {
        if (this.B != null) {
            this.B.close();
        }
        if (this.A != null) {
            this.A.b();
        }
        if (this.y != null) {
            // empty if block
        }
        if (this.w != null) {
            // empty if block
        }
        this.hasFullyShutdown = true;
        System.exit(this.abnormalExit ? 70 : 0);
    }

    @Override
    public void b(BooleanSupplier shouldKeepTicking) {
        super.b(shouldKeepTicking);
        this.bf();
    }

    @Override
    public boolean B() {
        return this.a().A;
    }

    public void a(String command, CommandListenerWrapper commandSource) {
        this.serverCommandQueue.add(new ServerCommand(command, commandSource));
    }

    public void bf() {
        ServerCommand servercommand;
        MinecraftTimings.serverCommandTimer.startTiming();
        while ((servercommand = this.serverCommandQueue.poll()) != null) {
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, servercommand.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            servercommand = new ServerCommand(event.getCommand(), servercommand.b);
            this.server.dispatchServerCommand((CommandSender)this.console, servercommand);
        }
        MinecraftTimings.serverCommandTimer.stopTiming();
    }

    @Override
    public boolean k() {
        return true;
    }

    @Override
    public int l() {
        return this.a().I;
    }

    @Override
    public boolean m() {
        return this.a().C;
    }

    public DedicatedPlayerList bg() {
        return (DedicatedPlayerList)super.ac();
    }

    @Override
    public boolean o() {
        return true;
    }

    @Override
    public String b() {
        return this.u();
    }

    @Override
    public int d() {
        return this.M();
    }

    @Override
    public String p() {
        return this.aa();
    }

    public void bh() {
        if (this.A == null) {
            this.A = ServerGUI.a(this);
        }
    }

    @Override
    public boolean af() {
        return this.A != null;
    }

    @Override
    public boolean n() {
        return this.a().D;
    }

    @Override
    public int ah() {
        return this.a().E;
    }

    @Override
    public boolean a(WorldServer world, BlockPosition pos, EntityHuman player) {
        int j2;
        if (world.aa() != World.f) {
            return false;
        }
        if (this.bg().k().c()) {
            return false;
        }
        if (this.bg().f(player.fp())) {
            return false;
        }
        if (this.ah() <= 0) {
            return false;
        }
        BlockPosition blockposition1 = world.w();
        int i2 = MathHelper.a(pos.u() - blockposition1.u());
        int k2 = Math.max(i2, j2 = MathHelper.a(pos.w() - blockposition1.w()));
        return k2 <= this.ah();
    }

    @Override
    public boolean ai() {
        return this.a().S;
    }

    @Override
    public boolean aj() {
        return this.a().T;
    }

    @Override
    public int h() {
        return this.a().F;
    }

    @Override
    public int i() {
        return this.a().G;
    }

    @Override
    public void c(int playerIdleTimeout) {
        super.c(playerIdleTimeout);
        this.z.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.W.a(this.aV(), playerIdleTimeout));
    }

    @Override
    public boolean j() {
        return this.a().N;
    }

    @Override
    public boolean F_() {
        return this.a().O;
    }

    @Override
    public int ar() {
        return this.a().P;
    }

    @Override
    public int au() {
        return this.a().M;
    }

    protected boolean bi() {
        int i2;
        boolean flag = false;
        for (i2 = 0; !flag && i2 <= 2; ++i2) {
            if (i2 > 0) {
                r.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bs();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (i2 = 0; !flag1 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                r.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bs();
            }
            flag1 = NameReferencingFileConverter.b(this);
        }
        boolean flag2 = false;
        for (i2 = 0; !flag2 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                r.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bs();
            }
            flag2 = NameReferencingFileConverter.c(this);
        }
        boolean flag3 = false;
        for (i2 = 0; !flag3 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                r.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bs();
            }
            flag3 = NameReferencingFileConverter.d(this);
        }
        boolean flag4 = false;
        for (i2 = 0; !flag4 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                r.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bs();
            }
            flag4 = NameReferencingFileConverter.a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bs() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bj() {
        return this.a().H;
    }

    @Override
    public String s() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String a(String command) {
        Waitable[] waitableArray = new Waitable[1];
        this.x.e();
        this.g(() -> {
            RemoteServerCommandEvent event = new RemoteServerCommandEvent((CommandSender)this.remoteConsole, command);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (command.toLowerCase().startsWith("timings") && command.toLowerCase().matches("timings (report|paste|get|merged|seperate)")) {
                final BufferedCommandSender sender = new BufferedCommandSender();
                Waitable<String> waitable = new Waitable<String>(){

                    @Override
                    protected String evaluate() {
                        return sender.getBuffer();
                    }
                };
                waitableArray[0] = waitable;
                Timings.generateReport((TimingsReportListener)new TimingsReportListener((CommandSender)sender, (Runnable)waitable));
            } else {
                ServerCommand serverCommand = new ServerCommand(event.getCommand(), this.x.g());
                this.server.dispatchServerCommand((CommandSender)this.remoteConsole, serverCommand);
            }
        });
        if (waitableArray[0] != null) {
            Waitable waitable = waitableArray[0];
            try {
                return (String)waitable.get();
            }
            catch (ExecutionException e2) {
                throw new RuntimeException("Exception processing rcon command " + command, e2.getCause());
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted processing rcon command " + command, e3);
            }
        }
        return this.x.f();
    }

    public void i(boolean useWhitelist) {
        this.z.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.X.a(this.aV(), useWhitelist));
    }

    @Override
    public void t() {
        super.t();
        TileEntitySkull.c();
    }

    @Override
    public boolean a(GameProfile profile) {
        return false;
    }

    @Override
    public int b(int initialDistance) {
        return this.a().U * initialDistance / 100;
    }

    @Override
    public String r() {
        return this.l.a();
    }

    @Override
    public boolean aS() {
        return this.z.a().Q;
    }

    @Override
    public ITextFilter a(EntityPlayer player) {
        return this.B != null ? this.B.a(player.fp()) : ITextFilter.a;
    }

    @Override
    public boolean aW() {
        return this.z.a().i;
    }

    @Override
    @Nullable
    public EnumGamemode aX() {
        return this.z.a().l ? this.q.m() : null;
    }

    @Nullable
    private static IChatBaseComponent a(DedicatedServerSettings propertiesLoader) {
        String s2 = propertiesLoader.a().j;
        if (!Strings.isNullOrEmpty((String)s2)) {
            try {
                return IChatBaseComponent.ChatSerializer.a(s2);
            }
            catch (Exception exception) {
                r.warn("Failed to parse resource pack prompt '{}'", (Object)s2, (Object)exception);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IChatBaseComponent aZ() {
        return this.C;
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

