/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class CommandLoot {
    public static final SuggestionProvider<CommandListenerWrapper> a = (context, builder) -> {
        LootTableRegistry lootTables = ((CommandListenerWrapper)context.getSource()).j().aG();
        return ICompletionProvider.a(lootTables.a(), builder);
    };
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(entityName -> new ChatMessage("commands.drop.no_held_items", entityName));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(entityName -> new ChatMessage("commands.drop.no_loot_table", entityName));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)CommandLoot.a((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("loot").requires(source -> source.c(2)), (ArgumentBuilder<CommandListenerWrapper, ?> builder, b constructor) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)builder.then(net.minecraft.commands.CommandDispatcher.a("fish").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ArgumentMinecraftKeyRegistered.a()).suggests(a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.f((CommandContext<CommandListenerWrapper>)context, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ItemStack.b, constructor))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a()).executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.f((CommandContext<CommandListenerWrapper>)context, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentItemStack.a(context, "tool").a(1, false), constructor)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.f((CommandContext<CommandListenerWrapper>)context, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), CommandLoot.a((CommandListenerWrapper)context.getSource(), EnumItemSlot.a), constructor)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.f((CommandContext<CommandListenerWrapper>)context, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), CommandLoot.a((CommandListenerWrapper)context.getSource(), EnumItemSlot.b), constructor))))))).then(net.minecraft.commands.CommandDispatcher.a("loot").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.f((CommandContext<CommandListenerWrapper>)context, "loot_table"), constructor))))).then(net.minecraft.commands.CommandDispatcher.a("kill").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), constructor))))).then(net.minecraft.commands.CommandDispatcher.a("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ItemStack.b, constructor))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a()).executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentItemStack.a(context, "tool").a(1, false), constructor)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), CommandLoot.a((CommandListenerWrapper)context.getSource(), EnumItemSlot.a), constructor)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(context -> CommandLoot.a((CommandContext<CommandListenerWrapper>)context, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), CommandLoot.a((CommandListenerWrapper)context.getSource(), EnumItemSlot.b), constructor)))))));
    }

    private static <T extends ArgumentBuilder<CommandListenerWrapper, T>> T a(T rootArgument, c sourceConstructor) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)rootArgument.then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (context, stacks, messageSender) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), stacks.size(), stacks, messageSender)).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (context, stacks, messageSender) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), stacks, messageSender))))))).then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (context, stacks, messageSender) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), stacks.size(), stacks, messageSender)).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (context, stacks, messageSender) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), stacks, messageSender)))))))).then(net.minecraft.commands.CommandDispatcher.a("insert").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()), (context, stacks, messageSender) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), (List<ItemStack>)stacks, messageSender))))).then(net.minecraft.commands.CommandDispatcher.a("give").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("players", ArgumentEntity.d()), (context, stacks, messageSender) -> CommandLoot.a(ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "players"), (List<ItemStack>)stacks, messageSender))))).then(net.minecraft.commands.CommandDispatcher.a("spawn").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentVec3.a()), (context, stacks, messageSender) -> CommandLoot.a((CommandListenerWrapper)context.getSource(), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)context, "targetPos"), (List<ItemStack>)stacks, messageSender))));
    }

    private static IInventory a(CommandListenerWrapper source, BlockPosition pos) throws CommandSyntaxException {
        TileEntity blockEntity = source.e().c_(pos);
        if (!(blockEntity instanceof IInventory)) {
            throw ItemCommands.a.create((Object)pos.u(), (Object)pos.v(), (Object)pos.w());
        }
        return (IInventory)((Object)blockEntity);
    }

    private static int a(CommandListenerWrapper source, BlockPosition targetPos, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        IInventory container = CommandLoot.a(source, targetPos);
        ArrayList list = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemStack : stacks) {
            if (!CommandLoot.a(container, itemStack.m())) continue;
            container.e();
            list.add(itemStack);
        }
        messageSender.accept(list);
        return list.size();
    }

    private static boolean a(IInventory inventory, ItemStack stack) {
        boolean bl = false;
        for (int i2 = 0; i2 < inventory.b() && !stack.b(); ++i2) {
            ItemStack itemStack = inventory.a(i2);
            if (!inventory.b(i2, stack)) continue;
            if (itemStack.b()) {
                inventory.a(i2, stack);
                bl = true;
                break;
            }
            if (!CommandLoot.a(itemStack, stack)) continue;
            int j2 = stack.d() - itemStack.I();
            int k2 = Math.min(stack.I(), j2);
            stack.g(k2);
            itemStack.f(k2);
            bl = true;
        }
        return bl;
    }

    private static int a(CommandListenerWrapper source, BlockPosition targetPos, int slot, int stackCount, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        IInventory container = CommandLoot.a(source, targetPos);
        int i2 = container.b();
        if (slot < 0 || slot >= i2) {
            throw ItemCommands.b.create((Object)slot);
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)stacks.size());
        for (int j2 = 0; j2 < stackCount; ++j2) {
            ItemStack itemStack;
            int k2 = slot + j2;
            ItemStack itemStack2 = itemStack = j2 < stacks.size() ? stacks.get(j2) : ItemStack.b;
            if (!container.b(k2, itemStack)) continue;
            container.a(k2, itemStack);
            list.add(itemStack);
        }
        messageSender.accept(list);
        return list.size();
    }

    private static boolean a(ItemStack first, ItemStack second) {
        return first.a(second.c()) && first.h() == second.h() && first.I() <= first.d() && Objects.equals(first.s(), second.s());
    }

    private static int a(Collection<EntityPlayer> players, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemStack : stacks) {
            for (EntityPlayer serverPlayer : players) {
                if (!serverPlayer.fq().e(itemStack.m())) continue;
                list.add(itemStack);
            }
        }
        messageSender.accept(list);
        return list.size();
    }

    private static void a(Entity entity, List<ItemStack> stacks, int slot, int stackCount, List<ItemStack> addedStacks) {
        for (int i2 = 0; i2 < stackCount; ++i2) {
            ItemStack itemStack = i2 < stacks.size() ? stacks.get(i2) : ItemStack.b;
            SlotAccess slotAccess = entity.k(slot + i2);
            if (slotAccess == SlotAccess.a || !slotAccess.a(itemStack.m())) continue;
            addedStacks.add(itemStack);
        }
    }

    private static int a(Collection<? extends Entity> targets, int slot, int stackCount, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)stacks.size());
        for (Entity entity : targets) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                CommandLoot.a(entity, stacks, slot, stackCount, list);
                serverPlayer.bW.d();
                continue;
            }
            CommandLoot.a(entity, stacks, slot, stackCount, list);
        }
        messageSender.accept(list);
        return list.size();
    }

    private static int a(CommandListenerWrapper source, Vec3D pos, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        WorldServer serverLevel = source.e();
        stacks.forEach(stack -> {
            EntityItem itemEntity = new EntityItem(serverLevel, vec3.b, vec3.c, vec3.d, stack.m());
            itemEntity.n();
            serverLevel.b(itemEntity);
        });
        messageSender.accept(stacks);
        return stacks.size();
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> stacks) {
        if (stacks.size() == 1) {
            ItemStack itemStack = stacks.get(0);
            source.a(new ChatMessage("commands.drop.success.single", itemStack.I(), itemStack.G()), false);
        } else {
            source.a(new ChatMessage("commands.drop.success.multiple", stacks.size()), false);
        }
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> stacks, MinecraftKey lootTable) {
        if (stacks.size() == 1) {
            ItemStack itemStack = stacks.get(0);
            source.a(new ChatMessage("commands.drop.success.single_with_table", itemStack.I(), itemStack.G(), lootTable), false);
        } else {
            source.a(new ChatMessage("commands.drop.success.multiple_with_table", stacks.size(), lootTable), false);
        }
    }

    private static ItemStack a(CommandListenerWrapper source, EnumItemSlot slot) throws CommandSyntaxException {
        Entity entity = source.g();
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).b(slot);
        }
        throw b.create((Object)entity.C_());
    }

    private static int a(CommandContext<CommandListenerWrapper> context, BlockPosition pos, ItemStack stack, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        WorldServer serverLevel = commandSourceStack.e();
        IBlockData blockState = serverLevel.a_(pos);
        TileEntity blockEntity = serverLevel.c_(pos);
        LootTableInfo.Builder builder = new LootTableInfo.Builder(serverLevel).a(LootContextParameters.f, Vec3D.a(pos)).a(LootContextParameters.g, blockState).b(LootContextParameters.h, blockEntity).b(LootContextParameters.a, commandSourceStack.f()).a(LootContextParameters.i, stack);
        List<ItemStack> list = blockState.a(builder);
        return constructor.accept(context, list, stacks -> CommandLoot.a(commandSourceStack, (List<ItemStack>)stacks, blockState.b().r()));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Entity entity, b constructor) throws CommandSyntaxException {
        if (!(entity instanceof EntityLiving)) {
            throw c.create((Object)entity.C_());
        }
        MinecraftKey resourceLocation = ((EntityLiving)entity).ee();
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        LootTableInfo.Builder builder = new LootTableInfo.Builder(commandSourceStack.e());
        Entity entity2 = commandSourceStack.f();
        if (entity2 instanceof EntityHuman) {
            builder.a(LootContextParameters.b, (EntityHuman)entity2);
        }
        builder.a(LootContextParameters.c, DamageSource.o);
        builder.b(LootContextParameters.e, entity2);
        builder.b(LootContextParameters.d, entity2);
        builder.a(LootContextParameters.a, entity);
        builder.a(LootContextParameters.f, commandSourceStack.d());
        LootTable lootTable = commandSourceStack.j().aG().a(resourceLocation);
        List<ItemStack> list = lootTable.a(builder.a(LootContextParameterSets.f));
        return constructor.accept(context, list, stacks -> CommandLoot.a(commandSourceStack, (List<ItemStack>)stacks, resourceLocation));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, MinecraftKey lootTable, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        LootTableInfo.Builder builder = new LootTableInfo.Builder(commandSourceStack.e()).b(LootContextParameters.a, commandSourceStack.f()).a(LootContextParameters.f, commandSourceStack.d());
        return CommandLoot.a(context, lootTable, builder.a(LootContextParameterSets.b), constructor);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, MinecraftKey lootTable, BlockPosition pos, ItemStack stack, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        LootTableInfo lootContext = new LootTableInfo.Builder(commandSourceStack.e()).a(LootContextParameters.f, Vec3D.a(pos)).a(LootContextParameters.i, stack).b(LootContextParameters.a, commandSourceStack.f()).a(LootContextParameterSets.e);
        return CommandLoot.a(context, lootTable, lootContext, constructor);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, MinecraftKey lootTable, LootTableInfo lootContext, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)context.getSource();
        LootTable lootTable2 = commandSourceStack.j().aG().a(lootTable);
        List<ItemStack> list = lootTable2.a(lootContext);
        return constructor.accept(context, list, stacks -> CommandLoot.a(commandSourceStack, stacks));
    }

    @FunctionalInterface
    static interface c {
        public ArgumentBuilder<CommandListenerWrapper, ?> construct(ArgumentBuilder<CommandListenerWrapper, ?> var1, b var2);
    }

    @FunctionalInterface
    static interface b {
        public int accept(CommandContext<CommandListenerWrapper> var1, List<ItemStack> var2, a var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface a {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

