/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Joiner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;

public class CommandForceload {
    private static final int a = 256;
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((maxCount, count) -> new ChatMessage("commands.forceload.toobig", maxCount, count));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((chunkPos, registryKey) -> new ChatMessage("commands.forceload.query.failure", chunkPos, registryKey));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)new ChatMessage("commands.forceload.added.failure"));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)new ChatMessage("commands.forceload.removed.failure"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("forceload").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("add").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), true))).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "to"), true)))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("remove").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), false))).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "to"), false))))).then(net.minecraft.commands.CommandDispatcher.a("all").executes(context -> CommandForceload.b((CommandListenerWrapper)context.getSource()))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("query").executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource()))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentVec2I.a()).executes(context -> CommandForceload.a((CommandListenerWrapper)context.getSource(), ArgumentVec2I.a((CommandContext<CommandListenerWrapper>)context, "pos")))))));
    }

    private static int a(CommandListenerWrapper source, BlockPosition2D pos) throws CommandSyntaxException {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(SectionPosition.a(pos.a), SectionPosition.a(pos.b));
        WorldServer serverLevel = source.e();
        ResourceKey<World> resourceKey = serverLevel.aa();
        boolean bl = serverLevel.y().contains(chunkPos.a());
        if (bl) {
            source.a(new ChatMessage("commands.forceload.query.success", chunkPos, resourceKey.a()), false);
            return 1;
        }
        throw c.create((Object)chunkPos, (Object)resourceKey.a());
    }

    private static int a(CommandListenerWrapper source) {
        WorldServer serverLevel = source.e();
        ResourceKey<World> resourceKey = serverLevel.aa();
        LongSet longSet = serverLevel.y();
        int i2 = longSet.size();
        if (i2 > 0) {
            String string = Joiner.on((String)", ").join(longSet.stream().sorted().map(ChunkCoordIntPair::new).map(ChunkCoordIntPair::toString).iterator());
            if (i2 == 1) {
                source.a(new ChatMessage("commands.forceload.list.single", resourceKey.a(), string), false);
            } else {
                source.a(new ChatMessage("commands.forceload.list.multiple", i2, resourceKey.a(), string), false);
            }
        } else {
            source.a(new ChatMessage("commands.forceload.added.none", resourceKey.a()));
        }
        return i2;
    }

    private static int b(CommandListenerWrapper source) {
        WorldServer serverLevel = source.e();
        ResourceKey<World> resourceKey = serverLevel.aa();
        LongSet longSet = serverLevel.y();
        longSet.forEach(l2 -> serverLevel.a(ChunkCoordIntPair.a(l2), ChunkCoordIntPair.b(l2), false));
        source.a(new ChatMessage("commands.forceload.removed.all", resourceKey.a()), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, BlockPosition2D from, BlockPosition2D to, boolean forceLoaded) throws CommandSyntaxException {
        int p2;
        int i2 = Math.min(from.a, to.a);
        int j2 = Math.min(from.b, to.b);
        int k2 = Math.max(from.a, to.a);
        int l2 = Math.max(from.b, to.b);
        if (i2 < -30000000 || j2 < -30000000 || k2 >= 30000000 || l2 >= 30000000) {
            throw ArgumentPosition.b.create();
        }
        int m2 = SectionPosition.a(i2);
        int n2 = SectionPosition.a(j2);
        int o2 = SectionPosition.a(k2);
        long q2 = ((long)(o2 - m2) + 1L) * ((long)((p2 = SectionPosition.a(l2)) - n2) + 1L);
        if (q2 > 256L) {
            throw b.create((Object)256, (Object)q2);
        }
        WorldServer serverLevel = source.e();
        ResourceKey<World> resourceKey = serverLevel.aa();
        ChunkCoordIntPair chunkPos = null;
        int r2 = 0;
        for (int s2 = m2; s2 <= o2; ++s2) {
            for (int t2 = n2; t2 <= p2; ++t2) {
                boolean bl = serverLevel.a(s2, t2, forceLoaded);
                if (!bl) continue;
                ++r2;
                if (chunkPos != null) continue;
                chunkPos = new ChunkCoordIntPair(s2, t2);
            }
        }
        if (r2 == 0) {
            throw (forceLoaded ? d : e).create();
        }
        if (r2 == 1) {
            source.a(new ChatMessage("commands.forceload." + (forceLoaded ? "added" : "removed") + ".single", chunkPos, resourceKey.a()), true);
        } else {
            ChunkCoordIntPair chunkPos2 = new ChunkCoordIntPair(m2, n2);
            ChunkCoordIntPair chunkPos3 = new ChunkCoordIntPair(o2, p2);
            source.a(new ChatMessage("commands.forceload." + (forceLoaded ? "added" : "removed") + ".multiple", r2, resourceKey.a(), chunkPos2, chunkPos3), true);
        }
        return r2;
    }
}

