/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandDebug {
    private static final Logger a = LogManager.getLogger();
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)new ChatMessage("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)new ChatMessage("commands.debug.alreadyRunning"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("debug").requires(source -> source.c(3))).then(net.minecraft.commands.CommandDispatcher.a("start").executes(context -> CommandDebug.a((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("stop").executes(context -> CommandDebug.b((CommandListenerWrapper)context.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("function").requires(commandSourceStack -> commandSourceStack.c(3))).then(net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(CommandFunction.a).executes(context -> CommandDebug.a((CommandListenerWrapper)context.getSource(), ArgumentTag.a((CommandContext<CommandListenerWrapper>)context, "name")))))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer minecraftServer = source.j();
        if (minecraftServer.bb()) {
            throw c.create();
        }
        minecraftServer.bc();
        source.a(new ChatMessage("commands.debug.started"), true);
        return 0;
    }

    private static int b(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer minecraftServer = source.j();
        if (!minecraftServer.bb()) {
            throw b.create();
        }
        MethodProfilerResults profileResults = minecraftServer.bd();
        double d2 = (double)profileResults.g() / (double)TimeRange.a;
        double e2 = (double)profileResults.f() / d2;
        source.a(new ChatMessage("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", d2), profileResults.f(), String.format("%.2f", e2)), true);
        return (int)e2;
    }

    private static int a(CommandListenerWrapper source, Collection<CustomFunction> functions) {
        int i2 = 0;
        MinecraftServer minecraftServer = source.j();
        String string = "debug-trace-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt";
        try {
            Path path = minecraftServer.c("debug").toPath();
            Files.createDirectories(path, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path.resolve(string), StandardCharsets.UTF_8, new OpenOption[0]);){
                PrintWriter printWriter = new PrintWriter(writer);
                for (CustomFunction commandFunction : functions) {
                    printWriter.println(commandFunction.a());
                    a tracer = new a(printWriter);
                    i2 += source.j().ay().a(commandFunction, source.a(tracer).b(2), tracer);
                }
            }
        }
        catch (IOException | UncheckedIOException exception) {
            a.warn("Tracing failed", (Throwable)exception);
            source.a(new ChatMessage("commands.debug.function.traceFailed"));
        }
        if (functions.size() == 1) {
            source.a(new ChatMessage("commands.debug.function.success.single", i2, functions.iterator().next().a(), string), true);
        } else {
            source.a(new ChatMessage("commands.debug.function.success.multiple", i2, functions.size(), string), true);
        }
        return i2;
    }

    static class a
    implements ICommandListener,
    CustomFunctionData.c {
        public static final int b = 1;
        private final PrintWriter c;
        private int d;
        private boolean e;

        a(PrintWriter writer) {
            this.c = writer;
        }

        private void a(int width) {
            this.b(width);
            this.d = width;
        }

        private void b(int width) {
            for (int i2 = 0; i2 < width + 1; ++i2) {
                this.c.write("    ");
            }
        }

        private void e() {
            if (this.e) {
                this.c.println();
                this.e = false;
            }
        }

        @Override
        @Override
        public void a(int depth, String command) {
            this.e();
            this.a(depth);
            this.c.print("[C] ");
            this.c.print(command);
            this.e = true;
        }

        @Override
        @Override
        public void a(int depth, String command, int result) {
            if (this.e) {
                this.c.print(" -> ");
                this.c.println(result);
                this.e = false;
            } else {
                this.a(depth);
                this.c.print("[R = ");
                this.c.print(result);
                this.c.print("] ");
                this.c.println(command);
            }
        }

        @Override
        @Override
        public void a(int depth, MinecraftKey function, int size) {
            this.e();
            this.a(depth);
            this.c.print("[F] ");
            this.c.print(function);
            this.c.print(" size=");
            this.c.println(size);
        }

        @Override
        @Override
        public void b(int depth, String message) {
            this.e();
            this.a(depth + 1);
            this.c.print("[E] ");
            this.c.print(message);
        }

        @Override
        @Override
        public void a(IChatBaseComponent message, UUID sender) {
            this.e();
            this.b(this.d + 1);
            this.c.print("[M] ");
            if (sender != SystemUtils.b) {
                this.c.print(sender);
                this.c.print(": ");
            }
            this.c.println(message.getString());
        }

        @Override
        @Override
        public boolean i_() {
            return true;
        }

        @Override
        @Override
        public boolean j_() {
            return true;
        }

        @Override
        @Override
        public boolean F_() {
            return false;
        }

        @Override
        @Override
        public boolean d_() {
            return true;
        }
    }
}

