/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandClone {
    private static final int b = 32768;
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)new ChatMessage("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((maxCount, count) -> new ChatMessage("commands.clone.toobig", maxCount, count));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)new ChatMessage("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> a = pos -> !pos.a().g();

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("clone").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("begin", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), pos -> true, Mode.c))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), pos -> true, Mode.c))).then(net.minecraft.commands.CommandDispatcher.a("force").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), pos -> true, Mode.a)))).then(net.minecraft.commands.CommandDispatcher.a("move").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), pos -> true, Mode.b)))).then(net.minecraft.commands.CommandDispatcher.a("normal").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), pos -> true, Mode.c))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("masked").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), a, Mode.c))).then(net.minecraft.commands.CommandDispatcher.a("force").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), a, Mode.a)))).then(net.minecraft.commands.CommandDispatcher.a("move").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), a, Mode.b)))).then(net.minecraft.commands.CommandDispatcher.a("normal").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), a, Mode.c))))).then(net.minecraft.commands.CommandDispatcher.a("filtered").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a()).executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), Mode.c))).then(net.minecraft.commands.CommandDispatcher.a("force").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), Mode.a)))).then(net.minecraft.commands.CommandDispatcher.a("move").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), Mode.b)))).then(net.minecraft.commands.CommandDispatcher.a("normal").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "begin"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "end"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "destination"), ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), Mode.c))))))))));
    }

    private static int a(CommandListenerWrapper source, BlockPosition begin, BlockPosition end, BlockPosition destination, Predicate<ShapeDetectorBlock> filter, Mode mode) throws CommandSyntaxException {
        StructureBoundingBox boundingBox = StructureBoundingBox.a(begin, end);
        BlockPosition blockPos = destination.a(boundingBox.b());
        StructureBoundingBox boundingBox2 = StructureBoundingBox.a(destination, blockPos);
        if (!mode.a() && boundingBox2.a(boundingBox)) {
            throw c.create();
        }
        int i2 = boundingBox.c() * boundingBox.d() * boundingBox.e();
        if (i2 > 32768) {
            throw d.create((Object)32768, (Object)i2);
        }
        WorldServer serverLevel = source.e();
        if (!serverLevel.a(begin, end) || !serverLevel.a(destination, blockPos)) {
            throw ArgumentPosition.a.create();
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        LinkedList deque = Lists.newLinkedList();
        BlockPosition blockPos2 = new BlockPosition(boundingBox2.g() - boundingBox.g(), boundingBox2.h() - boundingBox.h(), boundingBox2.i() - boundingBox.i());
        for (int j2 = boundingBox.i(); j2 <= boundingBox.l(); ++j2) {
            for (int k2 = boundingBox.h(); k2 <= boundingBox.k(); ++k2) {
                for (int l2 = boundingBox.g(); l2 <= boundingBox.j(); ++l2) {
                    BlockPosition blockPos3 = new BlockPosition(l2, k2, j2);
                    BlockPosition blockPos4 = blockPos3.a(blockPos2);
                    ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(serverLevel, blockPos3, false);
                    IBlockData blockState = blockInWorld.a();
                    if (!filter.test(blockInWorld)) continue;
                    TileEntity blockEntity = serverLevel.c_(blockPos3);
                    if (blockEntity != null) {
                        NBTTagCompound compoundTag = blockEntity.o();
                        list2.add(new CommandCloneStoredTileEntity(blockPos4, blockState, compoundTag));
                        deque.addLast(blockPos3);
                        continue;
                    }
                    if (blockState.i(serverLevel, blockPos3) || blockState.r(serverLevel, blockPos3)) {
                        list.add(new CommandCloneStoredTileEntity(blockPos4, blockState, null));
                        deque.addLast(blockPos3);
                        continue;
                    }
                    list3.add(new CommandCloneStoredTileEntity(blockPos4, blockState, null));
                    deque.addFirst(blockPos3);
                }
            }
        }
        if (mode == Mode.b) {
            for (BlockPosition blockPos5 : deque) {
                TileEntity blockEntity2 = serverLevel.c_(blockPos5);
                Clearable.a(blockEntity2);
                serverLevel.a(blockPos5, Blocks.gB.n(), 2);
            }
            for (BlockPosition blockPos6 : deque) {
                serverLevel.a(blockPos6, Blocks.a.n(), 3);
            }
        }
        ArrayList list4 = Lists.newArrayList();
        list4.addAll(list);
        list4.addAll(list2);
        list4.addAll(list3);
        List list5 = Lists.reverse((List)list4);
        for (CommandCloneStoredTileEntity cloneBlockInfo : list5) {
            TileEntity blockEntity3 = serverLevel.c_(cloneBlockInfo.a);
            Clearable.a(blockEntity3);
            serverLevel.a(cloneBlockInfo.a, Blocks.gB.n(), 2);
        }
        int m2 = 0;
        for (CommandCloneStoredTileEntity cloneBlockInfo2 : list4) {
            if (!serverLevel.a(cloneBlockInfo2.a, cloneBlockInfo2.b, 2)) continue;
            ++m2;
        }
        for (CommandCloneStoredTileEntity cloneBlockInfo3 : list2) {
            TileEntity blockEntity4 = serverLevel.c_(cloneBlockInfo3.a);
            if (cloneBlockInfo3.c != null && blockEntity4 != null) {
                blockEntity4.a(cloneBlockInfo3.c);
                blockEntity4.e();
            }
            serverLevel.a(cloneBlockInfo3.a, cloneBlockInfo3.b, 2);
        }
        for (CommandCloneStoredTileEntity cloneBlockInfo4 : list5) {
            serverLevel.a(cloneBlockInfo4.a, cloneBlockInfo4.b.b());
        }
        serverLevel.l().a(boundingBox, blockPos2);
        if (m2 == 0) {
            throw e.create();
        }
        source.a(new ChatMessage("commands.clone.success", m2), true);
        return m2;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode(true);
        public static final /* enum */ Mode b = new Mode(true);
        public static final /* enum */ Mode c = new Mode(false);
        private final boolean d;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }

        private Mode(boolean allowsOverlap) {
            this.d = allowsOverlap;
        }

        public boolean a() {
            return this.d;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{a, b, c};
        }

        static {
            e = Mode.b();
        }
    }

    static class CommandCloneStoredTileEntity {
        public final BlockPosition a;
        public final IBlockData b;
        @Nullable
        public final NBTTagCompound c;

        public CommandCloneStoredTileEntity(BlockPosition pos, IBlockData state, @Nullable NBTTagCompound blockEntityTag) {
            this.a = pos;
            this.b = state;
            this.c = blockEntityTag;
        }
    }
}

