/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import org.bukkit.event.player.PlayerKickEvent;

public class CommandBanIp {
    public static final Pattern a = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)new ChatMessage("commands.banip.invalid"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)new ChatMessage("commands.banip.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("ban-ip").requires(source -> source.c(3))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("target", StringArgumentType.word()).executes(context -> CommandBanIp.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), null))).then(net.minecraft.commands.CommandDispatcher.a("reason", ArgumentChat.a()).executes(context -> CommandBanIp.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), ArgumentChat.a((CommandContext<CommandListenerWrapper>)context, "reason")))))));
    }

    private static int a(CommandListenerWrapper source, String target, @Nullable IChatBaseComponent reason) throws CommandSyntaxException {
        Matcher matcher = a.matcher(target);
        if (matcher.matches()) {
            return CommandBanIp.b(source, target, reason);
        }
        EntityPlayer serverPlayer = source.j().ac().a(target);
        if (serverPlayer != null) {
            return CommandBanIp.b(source, serverPlayer.y(), reason);
        }
        throw b.create();
    }

    private static int b(CommandListenerWrapper source, String targetIp, @Nullable IChatBaseComponent reason) throws CommandSyntaxException {
        IpBanList ipBanList = source.j().ac().g();
        if (ipBanList.a(targetIp)) {
            throw c.create();
        }
        List<EntityPlayer> list = source.j().ac().b(targetIp);
        IpBanEntry ipBanListEntry = new IpBanEntry(targetIp, (Date)null, source.c(), (Date)null, reason == null ? null : reason.getString());
        ipBanList.a(ipBanListEntry);
        source.a(new ChatMessage("commands.banip.success", targetIp, ipBanListEntry.d()), true);
        if (!list.isEmpty()) {
            source.a(new ChatMessage("commands.banip.info", list.size(), EntitySelector.a(list)), true);
        }
        for (EntityPlayer serverPlayer : list) {
            serverPlayer.b.disconnect(new ChatMessage("multiplayer.disconnect.ip_banned"), PlayerKickEvent.Cause.IP_BANNED);
        }
        return list.size();
    }
}

