/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class CommandAttribute {
    private static final SuggestionProvider<CommandListenerWrapper> a = (context, builder) -> ICompletionProvider.a(IRegistry.am.d(), builder);
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(name -> new ChatMessage("commands.attribute.failed.entity", name));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((entityName, attributeName) -> new ChatMessage("commands.attribute.failed.no_attribute", entityName, attributeName));
    private static final Dynamic3CommandExceptionType d = new Dynamic3CommandExceptionType((entityName, attributeName, uuid) -> new ChatMessage("commands.attribute.failed.no_modifier", attributeName, entityName, uuid));
    private static final Dynamic3CommandExceptionType e = new Dynamic3CommandExceptionType((entityName, attributeName, uuid) -> new ChatMessage("commands.attribute.failed.modifier_already_present", uuid, attributeName, entityName));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute", ArgumentMinecraftKeyRegistered.a()).suggests(a).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("base").then(net.minecraft.commands.CommandDispatcher.a("set").then(net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.c((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context -> CommandAttribute.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("modifier").then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("uuid", ArgumentUUID.a()).then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).then(net.minecraft.commands.CommandDispatcher.a("add").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), StringArgumentType.getString((CommandContext)context, (String)"name"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.a)))).then(net.minecraft.commands.CommandDispatcher.a("multiply").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), StringArgumentType.getString((CommandContext)context, (String)"name"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.c)))).then(net.minecraft.commands.CommandDispatcher.a("multiply_base").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), StringArgumentType.getString((CommandContext)context, (String)"name"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.b)))))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("uuid", ArgumentUUID.a()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid")))))).then(net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("get").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("uuid", ArgumentUUID.a()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))))))))))));
    }

    private static AttributeModifiable a(Entity entity, AttributeBase attribute) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(entity).ep().a(attribute);
        if (attributeInstance == null) {
            throw c.create((Object)entity.X(), (Object)new ChatMessage(attribute.c()));
        }
        return attributeInstance;
    }

    private static EntityLiving a(Entity entity) throws CommandSyntaxException {
        if (!(entity instanceof EntityLiving)) {
            throw b.create((Object)entity.X());
        }
        return (EntityLiving)entity;
    }

    private static EntityLiving b(Entity entity, AttributeBase attribute) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.a(entity);
        if (!livingEntity.ep().b(attribute)) {
            throw c.create((Object)entity.X(), (Object)new ChatMessage(attribute.c()));
        }
        return livingEntity;
    }

    private static int a(CommandListenerWrapper source, Entity target, AttributeBase attribute, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        double d2 = livingEntity.b(attribute);
        source.a(new ChatMessage("commands.attribute.value.get.success", new ChatMessage(attribute.c()), target.X(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int b(CommandListenerWrapper source, Entity target, AttributeBase attribute, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        double d2 = livingEntity.c(attribute);
        source.a(new ChatMessage("commands.attribute.base_value.get.success", new ChatMessage(attribute.c()), target.X(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int a(CommandListenerWrapper source, Entity target, AttributeBase attribute, UUID uuid, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        AttributeMapBase attributeMap = livingEntity.ep();
        if (!attributeMap.a(attribute, uuid)) {
            throw d.create((Object)target.X(), (Object)new ChatMessage(attribute.c()), (Object)uuid);
        }
        double d2 = attributeMap.b(attribute, uuid);
        source.a(new ChatMessage("commands.attribute.modifier.value.get.success", uuid, new ChatMessage(attribute.c()), target.X(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int c(CommandListenerWrapper source, Entity target, AttributeBase attribute, double value) throws CommandSyntaxException {
        CommandAttribute.a(target, attribute).a(value);
        source.a(new ChatMessage("commands.attribute.base_value.set.success", new ChatMessage(attribute.c()), target.X(), value), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity target, AttributeBase attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation) throws CommandSyntaxException {
        AttributeModifier attributeModifier;
        AttributeModifiable attributeInstance = CommandAttribute.a(target, attribute);
        if (attributeInstance.a(attributeModifier = new AttributeModifier(uuid, name, value, operation))) {
            throw e.create((Object)target.X(), (Object)new ChatMessage(attribute.c()), (Object)uuid);
        }
        attributeInstance.c(attributeModifier);
        source.a(new ChatMessage("commands.attribute.modifier.add.success", uuid, new ChatMessage(attribute.c()), target.X()), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity target, AttributeBase attribute, UUID uuid) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(target, attribute);
        if (attributeInstance.c(uuid)) {
            source.a(new ChatMessage("commands.attribute.modifier.remove.success", uuid, new ChatMessage(attribute.c()), target.X()), false);
            return 1;
        }
        throw d.create((Object)target.X(), (Object)new ChatMessage(attribute.c()), (Object)uuid);
    }
}

