/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.spigotmc.SpigotConfig;

public class AdvancementDataPlayer {
    private static final Logger a = LogManager.getLogger();
    private static final int b = 2;
    private static final Gson c = new GsonBuilder().registerTypeAdapter(AdvancementProgress.class, (Object)new AdvancementProgress.a()).registerTypeAdapter(MinecraftKey.class, (Object)new MinecraftKey.a()).setPrettyPrinting().create();
    private static final TypeToken<Map<MinecraftKey, AdvancementProgress>> d = new TypeToken<Map<MinecraftKey, AdvancementProgress>>(){};
    private final DataFixer e;
    private final PlayerList f;
    private final File g;
    public final Map<Advancement, AdvancementProgress> h = Maps.newLinkedHashMap();
    private final Set<Advancement> i = Sets.newLinkedHashSet();
    private final Set<Advancement> j = Sets.newLinkedHashSet();
    private final Set<Advancement> k = Sets.newLinkedHashSet();
    private EntityPlayer l;
    @Nullable
    private Advancement m;
    private boolean n = true;
    public final Map<CriterionTriggerAbstract, Set<CriterionTrigger.a>> criterionData = Maps.newIdentityHashMap();

    public AdvancementDataPlayer(DataFixer dataFixer, PlayerList playerManager, AdvancementDataWorld advancementLoader, File advancementFile, EntityPlayer owner) {
        this.e = dataFixer;
        this.f = playerManager;
        this.g = advancementFile;
        this.l = owner;
        this.d(advancementLoader);
    }

    public void a(EntityPlayer owner) {
        this.l = owner;
    }

    public void a() {
        for (CriterionTrigger<?> criteriontrigger : CriterionTriggers.a()) {
            criteriontrigger.a(this);
        }
    }

    public void a(AdvancementDataWorld advancementLoader) {
        this.a();
        this.h.clear();
        this.i.clear();
        this.j.clear();
        this.k.clear();
        this.n = true;
        this.m = null;
        this.d(advancementLoader);
    }

    private void b(AdvancementDataWorld advancementLoader) {
        for (Advancement advancement : advancementLoader.a()) {
            this.c(advancement);
        }
    }

    private void c() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<Advancement, AdvancementProgress> entry : this.h.entrySet()) {
            if (!entry.getValue().a()) continue;
            list.add(entry.getKey());
            this.k.add(entry.getKey());
        }
        for (Advancement advancement : list) {
            this.e(advancement);
        }
    }

    private void c(AdvancementDataWorld advancementLoader) {
        for (Advancement advancement : advancementLoader.a()) {
            if (!advancement.f().isEmpty()) continue;
            this.a(advancement, "");
            advancement.d().a(this.l);
        }
    }

    private void d(AdvancementDataWorld advancementLoader) {
        if (this.g.isFile()) {
            try (JsonReader jsonreader = new JsonReader((Reader)new StringReader(Files.toString((File)this.g, (Charset)StandardCharsets.UTF_8)));){
                jsonreader.setLenient(false);
                Dynamic dynamic = new Dynamic(JsonOps.INSTANCE, Streams.parse((JsonReader)jsonreader));
                if (!dynamic.get("DataVersion").asNumber().result().isPresent()) {
                    dynamic = dynamic.set("DataVersion", dynamic.createInt(1343));
                }
                dynamic = this.e.update(DataFixTypes.i.a(), dynamic, dynamic.get("DataVersion").asInt(0), SharedConstants.b().getWorldVersion());
                dynamic = dynamic.remove("DataVersion");
                Map map = (Map)c.getAdapter(d).fromJsonTree((JsonElement)dynamic.getValue());
                if (map == null) {
                    throw new JsonParseException("Found null for advancements");
                }
                Stream<Map.Entry> stream = map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue));
                for (Map.Entry entry : stream.collect(Collectors.toList())) {
                    Advancement advancement = advancementLoader.a((MinecraftKey)entry.getKey());
                    if (advancement == null) {
                        if (!((MinecraftKey)entry.getKey()).b().equals("minecraft")) continue;
                        a.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", entry.getKey(), (Object)this.g);
                        continue;
                    }
                    this.a(advancement, (AdvancementProgress)entry.getValue());
                }
            }
            catch (JsonParseException jsonparseexception) {
                a.error("Couldn't parse player advancements in {}", (Object)this.g, (Object)jsonparseexception);
            }
            catch (IOException ioexception) {
                a.error("Couldn't access player advancements in {}", (Object)this.g, (Object)ioexception);
            }
        }
        this.c(advancementLoader);
        this.c();
        this.b(advancementLoader);
    }

    public void b() {
        if (SpigotConfig.disableAdvancementSaving) {
            return;
        }
        HashMap map = Maps.newHashMap();
        for (Map.Entry<Advancement, AdvancementProgress> entry : this.h.entrySet()) {
            AdvancementProgress advancementprogress = entry.getValue();
            if (!advancementprogress.b()) continue;
            map.put(entry.getKey().h(), advancementprogress);
        }
        if (this.g.getParentFile() != null) {
            this.g.getParentFile().mkdirs();
        }
        JsonElement jsonelement = c.toJsonTree((Object)map);
        jsonelement.getAsJsonObject().addProperty("DataVersion", (Number)SharedConstants.b().getWorldVersion());
        try (FileOutputStream fileoutputstream = new FileOutputStream(this.g);
             OutputStreamWriter outputstreamwriter = new OutputStreamWriter((OutputStream)fileoutputstream, Charsets.UTF_8.newEncoder());){
            c.toJson(jsonelement, (Appendable)outputstreamwriter);
        }
        catch (IOException ioexception) {
            a.error("Couldn't save player advancements to {}", (Object)this.g, (Object)ioexception);
        }
    }

    public boolean a(Advancement advancement, String criterionName) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.b(advancement);
        boolean flag1 = advancementprogress.a();
        if (advancementprogress.a(criterionName)) {
            if (!new PlayerAdvancementCriterionGrantEvent((Player)this.l.getBukkitEntity(), advancement.bukkit, criterionName).callEvent()) {
                advancementprogress.b(criterionName);
                return false;
            }
            this.d(advancement);
            this.k.add(advancement);
            flag = true;
            if (!flag1 && advancementprogress.a()) {
                boolean announceToChat = advancement.c() != null && advancement.c().i();
                Component message = announceToChat ? PaperAdventure.asAdventure(new ChatMessage("chat.type.advancement." + advancement.c().e().a(), this.l.C_(), advancement.j())) : null;
                PlayerAdvancementDoneEvent event = new PlayerAdvancementDoneEvent((Player)this.l.getBukkitEntity(), advancement.bukkit, message);
                this.l.t.getCraftServer().getPluginManager().callEvent((Event)event);
                message = event.message();
                advancement.d().a(this.l);
                if (message != null && this.l.t.X().b(GameRules.x)) {
                    this.f.a(PaperAdventure.asVanilla(message), ChatMessageType.b, SystemUtils.b);
                }
            }
        }
        if (advancementprogress.a()) {
            this.e(advancement);
        }
        return flag;
    }

    public boolean b(Advancement advancement, String criterionName) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.b(advancement);
        if (advancementprogress.b(criterionName)) {
            this.c(advancement);
            this.k.add(advancement);
            flag = true;
        }
        if (!advancementprogress.b()) {
            this.e(advancement);
        }
        return flag;
    }

    private void c(Advancement advancement) {
        AdvancementProgress advancementprogress = this.b(advancement);
        if (!advancementprogress.a()) {
            for (Map.Entry<String, Criterion> entry : advancement.f().entrySet()) {
                CriterionTrigger<CriterionInstance> criteriontrigger;
                CriterionInstance criterioninstance;
                CriterionProgress criterionprogress = advancementprogress.c(entry.getKey());
                if (criterionprogress == null || criterionprogress.a() || (criterioninstance = entry.getValue().a()) == null || (criteriontrigger = CriterionTriggers.a(criterioninstance.a())) == null) continue;
                criteriontrigger.a(this, new CriterionTrigger.a<CriterionInstance>(criterioninstance, advancement, entry.getKey()));
            }
        }
    }

    private void d(Advancement advancement) {
        AdvancementProgress advancementprogress = this.b(advancement);
        for (Map.Entry<String, Criterion> entry : advancement.f().entrySet()) {
            CriterionTrigger<CriterionInstance> criteriontrigger;
            CriterionInstance criterioninstance;
            CriterionProgress criterionprogress = advancementprogress.c(entry.getKey());
            if (criterionprogress == null || !criterionprogress.a() && !advancementprogress.a() || (criterioninstance = entry.getValue().a()) == null || (criteriontrigger = CriterionTriggers.a(criterioninstance.a())) == null) continue;
            criteriontrigger.b(this, new CriterionTrigger.a<CriterionInstance>(criterioninstance, advancement, entry.getKey()));
        }
    }

    public void b(EntityPlayer player) {
        if (this.n || !this.j.isEmpty() || !this.k.isEmpty()) {
            HashMap map = Maps.newHashMap();
            LinkedHashSet set = Sets.newLinkedHashSet();
            LinkedHashSet set1 = Sets.newLinkedHashSet();
            for (Advancement advancement : this.k) {
                if (!this.i.contains(advancement)) continue;
                map.put(advancement.h(), this.h.get(advancement));
            }
            for (Advancement advancement : this.j) {
                if (this.i.contains(advancement)) {
                    set.add(advancement);
                    continue;
                }
                set1.add(advancement.h());
            }
            if (this.n || !map.isEmpty() || !set.isEmpty() || !set1.isEmpty()) {
                player.b.a(new PacketPlayOutAdvancements(this.n, set, set1, map));
                this.j.clear();
                this.k.clear();
            }
        }
        this.n = false;
    }

    public void a(@Nullable Advancement advancement) {
        Advancement advancement1 = this.m;
        this.m = advancement != null && advancement.b() == null && advancement.c() != null ? advancement : null;
        if (advancement1 != this.m) {
            this.l.b.a(new PacketPlayOutSelectAdvancementTab(this.m == null ? null : this.m.h()));
        }
    }

    public AdvancementProgress b(Advancement advancement) {
        AdvancementProgress advancementprogress = this.h.get(advancement);
        if (advancementprogress == null) {
            advancementprogress = new AdvancementProgress();
            this.a(advancement, advancementprogress);
        }
        return advancementprogress;
    }

    private void a(Advancement advancement, AdvancementProgress progress) {
        progress.a(advancement.f(), advancement.i());
        this.h.put(advancement, progress);
    }

    private void e(Advancement advancement) {
        this.ensureVisibility(advancement, IterationEntryPoint.ROOT);
    }

    private void ensureVisibility(Advancement advancement, IterationEntryPoint entryPoint) {
        boolean flag = this.f(advancement);
        boolean flag1 = this.i.contains(advancement);
        if (flag && !flag1) {
            this.i.add(advancement);
            this.j.add(advancement);
            if (this.h.containsKey(advancement)) {
                this.k.add(advancement);
            }
        } else if (!flag && flag1) {
            this.i.remove(advancement);
            this.j.add(advancement);
        }
        if (flag != flag1 && advancement.b() != null) {
            this.ensureVisibility(advancement.b(), entryPoint == IterationEntryPoint.ITERATOR ? IterationEntryPoint.PARENT_OF_ITERATOR : IterationEntryPoint.ROOT);
        }
        if (entryPoint == IterationEntryPoint.PARENT_OF_ITERATOR) {
            return;
        }
        for (Advancement advancement1 : advancement.e()) {
            this.ensureVisibility(advancement1, IterationEntryPoint.ITERATOR);
        }
    }

    private boolean f(Advancement advancement) {
        for (int i2 = 0; advancement != null && i2 <= 2; advancement = advancement.b(), ++i2) {
            if (i2 == 0 && this.g(advancement)) {
                return true;
            }
            if (advancement.c() == null) {
                return false;
            }
            AdvancementProgress advancementprogress = this.b(advancement);
            if (advancementprogress.a()) {
                return true;
            }
            if (!advancement.c().j()) continue;
            return false;
        }
        return false;
    }

    private boolean g(Advancement advancement) {
        Advancement advancement1;
        AdvancementProgress advancementprogress = this.b(advancement);
        if (advancementprogress.a()) {
            return true;
        }
        Iterator<Advancement> iterator = advancement.e().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!this.g(advancement1 = iterator.next()));
        return true;
    }

    private static enum IterationEntryPoint {
        ROOT,
        ITERATOR,
        PARENT_OF_ITERATOR;

    }
}

