/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryWriteOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface RegistryResourceAccess {
    public <E> Collection<ResourceKey<E>> a(ResourceKey<? extends IRegistry<E>> var1);

    public <E> Optional<DataResult<ParsedEntry<E>>> a(DynamicOps<JsonElement> var1, ResourceKey<? extends IRegistry<E>> var2, ResourceKey<E> var3, Decoder<E> var4);

    public static RegistryResourceAccess a(final IResourceManager resourceManager) {
        return new RegistryResourceAccess(){
            private static final String b = ".json";

            @Override
            @Override
            public <E> Collection<ResourceKey<E>> a(ResourceKey<? extends IRegistry<E>> key) {
                String string = 1.b(key);
                HashSet set = new HashSet();
                resourceManager.a(string, name -> name.endsWith(b)).forEach(id -> {
                    String string2 = id.a();
                    String string3 = string2.substring(string.length() + 1, string2.length() - b.length());
                    set.add(ResourceKey.a(key, new MinecraftKey(id.b(), string3)));
                });
                return set;
            }

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            @Override
            public <E> Optional<DataResult<ParsedEntry<E>>> a(DynamicOps<JsonElement> json, ResourceKey<? extends IRegistry<E>> registryId, ResourceKey<E> entryId, Decoder<E> decoder) {
                MinecraftKey resourceLocation = 1.a(registryId, entryId);
                if (!resourceManager.b(resourceLocation)) {
                    return Optional.empty();
                }
                try (IResource resource = resourceManager.a(resourceLocation);){
                    Optional<DataResult<ParsedEntry<E>>> optional;
                    try (InputStreamReader reader = new InputStreamReader(resource.b(), StandardCharsets.UTF_8);){
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        optional = Optional.of(decoder.parse(json, (Object)jsonElement).map(ParsedEntry::a));
                    }
                    return optional;
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    return Optional.of(DataResult.error((String)("Failed to parse " + resourceLocation + " file: " + exception.getMessage())));
                }
            }

            private static String b(ResourceKey<? extends IRegistry<?>> registryKey) {
                return registryKey.a().a();
            }

            private static <E> MinecraftKey a(ResourceKey<? extends IRegistry<E>> rootKey, ResourceKey<E> key) {
                return new MinecraftKey(key.a().b(), 1.b(rootKey) + "/" + key.a().a() + b);
            }

            @Override
            public String toString() {
                return "ResourceAccess[" + resourceManager + "]";
            }
        };
    }

    public static final class InMemoryStorage
    implements RegistryResourceAccess {
        private static final Logger a = LogManager.getLogger();
        private final Map<ResourceKey<?>, Entry> b = Maps.newIdentityHashMap();

        public <E> void a(IRegistryCustom.Dimension registryManager, ResourceKey<E> key, Encoder<E> encoder, int rawId, E entry, Lifecycle lifecycle) {
            DataResult dataResult = encoder.encodeStart(RegistryWriteOps.a(JsonOps.INSTANCE, registryManager), entry);
            Optional optional = dataResult.error();
            if (optional.isPresent()) {
                a.error("Error adding element: {}", (Object)((DataResult.PartialResult)optional.get()).message());
            } else {
                this.b.put(key, new Entry((JsonElement)dataResult.result().get(), rawId, lifecycle));
            }
        }

        @Override
        @Override
        public <E> Collection<ResourceKey<E>> a(ResourceKey<? extends IRegistry<E>> key) {
            return this.b.keySet().stream().flatMap(registryKey -> registryKey.c(key).stream()).collect(Collectors.toList());
        }

        @Override
        @Override
        public <E> Optional<DataResult<ParsedEntry<E>>> a(DynamicOps<JsonElement> json, ResourceKey<? extends IRegistry<E>> registryId, ResourceKey<E> entryId, Decoder<E> decoder) {
            Entry entry = this.b.get(entryId);
            if (entry == null) {
                return Optional.of(DataResult.error((String)("Unknown element: " + entryId)));
            }
            return Optional.of(decoder.parse(json, (Object)entry.a).setLifecycle(entry.c).map(value -> ParsedEntry.a(value, entry.b)));
        }

        record Entry(JsonElement a, int b, Lifecycle c) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "data;id;lifecycle", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "data;id;lifecycle", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "data;id;lifecycle", "a", "b", "c"}, this, object);
            }
        }
    }

    public record ParsedEntry<E>(E a, OptionalInt b) {
        public static <E> ParsedEntry<E> a(E value) {
            return new ParsedEntry<E>(value, OptionalInt.empty());
        }

        public static <E> ParsedEntry<E> a(E value, int id) {
            return new ParsedEntry<E>(value, OptionalInt.of(id));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ParsedEntry.class, "value;fixedId", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ParsedEntry.class, "value;fixedId", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ParsedEntry.class, "value;fixedId", "a", "b"}, this, object);
        }
    }
}

