/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResourceManager;

public class RegistryReadOps<T>
extends DynamicOpsWrapper<T> {
    private final RegistryResourceAccess b;
    private final IRegistryCustom c;
    private final Map<ResourceKey<? extends IRegistry<?>>, a<?>> d;
    private final RegistryReadOps<JsonElement> e;

    public static <T> RegistryReadOps<T> a(DynamicOps<T> ops, IResourceManager resourceManager, IRegistryCustom registryManager) {
        return RegistryReadOps.a(ops, RegistryResourceAccess.a(resourceManager), registryManager);
    }

    public static <T> RegistryReadOps<T> a(DynamicOps<T> ops, RegistryResourceAccess entryLoader, IRegistryCustom registryManager) {
        RegistryReadOps<T> registryReadOps = new RegistryReadOps<T>(ops, entryLoader, registryManager, Maps.newIdentityHashMap());
        IRegistryCustom.a(registryManager, registryReadOps);
        return registryReadOps;
    }

    public static <T> RegistryReadOps<T> b(DynamicOps<T> delegate, IResourceManager resourceManager, IRegistryCustom registryManager) {
        return RegistryReadOps.b(delegate, RegistryResourceAccess.a(resourceManager), registryManager);
    }

    public static <T> RegistryReadOps<T> b(DynamicOps<T> delegate, RegistryResourceAccess entryLoader, IRegistryCustom registryManager) {
        return new RegistryReadOps<T>(delegate, entryLoader, registryManager, Maps.newIdentityHashMap());
    }

    private RegistryReadOps(DynamicOps<T> delegate, RegistryResourceAccess entryLoader, IRegistryCustom registryManager, IdentityHashMap<ResourceKey<? extends IRegistry<?>>, a<?>> valueHolders) {
        super(delegate);
        this.b = entryLoader;
        this.c = registryManager;
        this.d = valueHolders;
        this.e = delegate == JsonOps.INSTANCE ? this : new RegistryReadOps<T>(JsonOps.INSTANCE, entryLoader, registryManager, (IdentityHashMap<ResourceKey<IRegistry<?>>, a<?>>)valueHolders);
    }

    protected <E> DataResult<Pair<Supplier<E>, T>> a(T object, ResourceKey<? extends IRegistry<E>> key, Codec<E> codec, boolean allowInlineDefinitions) {
        Optional optional = this.c.a(key);
        if (!optional.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + key));
        }
        IRegistryWritable writableRegistry = optional.get();
        DataResult dataResult = MinecraftKey.a.decode(this.a, object);
        if (!dataResult.result().isPresent()) {
            if (!allowInlineDefinitions) {
                return DataResult.error((String)"Inline definitions not allowed here");
            }
            return codec.decode((DynamicOps)this, object).map(pair -> pair.mapFirst(object -> () -> object));
        }
        Pair pair2 = (Pair)dataResult.result().get();
        ResourceKey resourceKey = ResourceKey.a(key, (MinecraftKey)pair2.getFirst());
        return this.a(key, writableRegistry, codec, resourceKey).map(supplier -> Pair.of((Object)supplier, (Object)pair2.getSecond()));
    }

    public <E> DataResult<RegistryMaterials<E>> a(RegistryMaterials<E> registry, ResourceKey<? extends IRegistry<E>> key, Codec<E> codec) {
        Collection collection = this.b.a(key);
        DataResult dataResult = DataResult.success(registry, (Lifecycle)Lifecycle.stable());
        for (ResourceKey resourceKey : collection) {
            dataResult = dataResult.flatMap(mappedRegistry -> this.a(key, (IRegistryWritable)mappedRegistry, codec, resourceKey).map(supplier -> mappedRegistry));
        }
        return dataResult.setPartial(registry);
    }

    private <E> DataResult<Supplier<E>> a(ResourceKey<? extends IRegistry<E>> resourceKey, IRegistryWritable<E> writableRegistry, Codec<E> codec, ResourceKey<E> resourceKey2) {
        DataResult dataResult5;
        a<E> readCache = this.b(resourceKey);
        DataResult dataResult = readCache.a.get(resourceKey2);
        if (dataResult != null) {
            return dataResult;
        }
        readCache.a.put(resourceKey2, DataResult.success(RegistryReadOps.a(writableRegistry, resourceKey2)));
        Optional<DataResult<RegistryResourceAccess.ParsedEntry<E>>> optional = this.b.a((DynamicOps<JsonElement>)this.e, resourceKey, resourceKey2, codec);
        if (optional.isEmpty()) {
            if (writableRegistry.b(resourceKey2)) {
                DataResult dataResult2 = DataResult.success(RegistryReadOps.a(writableRegistry, resourceKey2), (Lifecycle)Lifecycle.stable());
            } else {
                DataResult dataResult3 = DataResult.error((String)("Missing referenced custom/removed registry entry for registry " + resourceKey + " named " + resourceKey2.a()));
            }
        } else {
            DataResult<RegistryResourceAccess.ParsedEntry<E>> dataResult4 = optional.get();
            Optional optional2 = dataResult4.result();
            if (optional2.isPresent()) {
                RegistryResourceAccess.ParsedEntry parsedEntry2 = (RegistryResourceAccess.ParsedEntry)optional2.get();
                writableRegistry.a(parsedEntry2.b(), resourceKey2, parsedEntry2.a(), dataResult4.lifecycle());
            }
            dataResult5 = dataResult4.map(parsedEntry -> RegistryReadOps.a(writableRegistry, resourceKey2));
        }
        readCache.a.put(resourceKey2, dataResult5);
        return dataResult5;
    }

    private static <E> Supplier<E> a(IRegistryWritable<E> registry, ResourceKey<E> key) {
        return Suppliers.memoize(() -> {
            Object object = registry.a(key);
            if (object == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + key);
            }
            return object;
        });
    }

    private static <E> Supplier<E> a(final IRegistry<E> registry, final ResourceKey<E> key) {
        return new Supplier<E>(){

            @Override
            @Override
            public E get() {
                return registry.a(key);
            }

            @Override
            public String toString() {
                return key.toString();
            }
        };
    }

    private <E> a<E> b(ResourceKey<? extends IRegistry<E>> registryRef) {
        return this.d.computeIfAbsent(registryRef, resourceKey -> new a());
    }

    protected <E> DataResult<IRegistry<E>> a(ResourceKey<? extends IRegistry<E>> key) {
        return this.c.a(key).map(writableRegistry -> DataResult.success((Object)writableRegistry, (Lifecycle)writableRegistry.c())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + key)));
    }

    static final class a<E> {
        final Map<ResourceKey<E>, DataResult<Supplier<E>>> a = Maps.newIdentityHashMap();

        a() {
        }
    }
}

