/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.util.ChatDeserializer;
import org.apache.commons.lang3.StringUtils;

public class MinecraftKey
implements Comparable<MinecraftKey> {
    public static final Codec<MinecraftKey> a = Codec.STRING.comapFlatMap(MinecraftKey::c, MinecraftKey::toString).stable();
    private static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)new ChatMessage("argument.id.invalid"));
    public static final char b = ':';
    public static final String c = "minecraft";
    public static final String d = "realms";
    protected final String e;
    protected final String f;

    protected MinecraftKey(String[] id) {
        this.e = StringUtils.isEmpty((CharSequence)id[0]) ? c : id[0];
        this.f = id[1];
        if (!MinecraftKey.e(this.e)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9_.-] character in namespace of location: " + StringUtils.normalizeSpace((String)this.e) + ":" + StringUtils.normalizeSpace((String)this.f));
        }
        if (!MinecraftKey.d(this.f)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9/._-] character in path of location: " + this.e + ":" + StringUtils.normalizeSpace((String)this.f));
        }
    }

    public MinecraftKey(String id) {
        this(MinecraftKey.b(id, ':'));
    }

    public MinecraftKey(String namespace, String path) {
        this(new String[]{namespace, path});
    }

    public static MinecraftKey a(String id, char delimiter) {
        return new MinecraftKey(MinecraftKey.b(id, delimiter));
    }

    @Nullable
    public static MinecraftKey a(String id) {
        try {
            return new MinecraftKey(id);
        }
        catch (ResourceKeyInvalidException var2) {
            return null;
        }
    }

    protected static String[] b(String id, char delimiter) {
        String[] strings = new String[]{c, id};
        int i2 = id.indexOf(delimiter);
        if (i2 >= 0) {
            strings[1] = id.substring(i2 + 1, id.length());
            if (i2 >= 1) {
                strings[0] = id.substring(0, i2);
            }
        }
        return strings;
    }

    private static DataResult<MinecraftKey> c(String id) {
        try {
            return DataResult.success((Object)new MinecraftKey(id));
        }
        catch (ResourceKeyInvalidException var2) {
            return DataResult.error((String)("Not a valid resource location: " + id + " " + var2.getMessage()));
        }
    }

    public String a() {
        return this.f;
    }

    public String b() {
        return this.e;
    }

    public String toString() {
        return this.e + ":" + this.f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MinecraftKey)) {
            return false;
        }
        MinecraftKey resourceLocation = (MinecraftKey)object;
        return this.e.equals(resourceLocation.e) && this.f.equals(resourceLocation.f);
    }

    public int hashCode() {
        return 31 * this.e.hashCode() + this.f.hashCode();
    }

    public int a(MinecraftKey resourceLocation) {
        int i2 = this.f.compareTo(resourceLocation.f);
        if (i2 == 0) {
            i2 = this.e.compareTo(resourceLocation.e);
        }
        return i2;
    }

    public String c() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public static MinecraftKey a(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && MinecraftKey.a(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(i2, reader.getCursor());
        try {
            return new MinecraftKey(string);
        }
        catch (ResourceKeyInvalidException var4) {
            reader.setCursor(i2);
            throw g.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean a(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 == '_' || c2 == ':' || c2 == '/' || c2 == '.' || c2 == '-';
    }

    private static boolean d(String path) {
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (MinecraftKey.b(path.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean e(String namespace) {
        for (int i2 = 0; i2 < namespace.length(); ++i2) {
            if (MinecraftKey.c(namespace.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '/' || character == '.';
    }

    private static boolean c(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    public static boolean b(String id) {
        String[] strings = MinecraftKey.b(id, ':');
        return MinecraftKey.e(StringUtils.isEmpty((CharSequence)strings[0]) ? c : strings[0]) && MinecraftKey.d(strings[1]);
    }

    public static class a
    implements JsonDeserializer<MinecraftKey>,
    JsonSerializer<MinecraftKey> {
        public MinecraftKey a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new MinecraftKey(ChatDeserializer.a(jsonElement, "location"));
        }

        public JsonElement a(MinecraftKey resourceLocation, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(resourceLocation.toString());
        }
    }
}

