/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.google.common.collect.Lists;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataWatcher {
    private static final Logger a = LogManager.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> b = new Object2IntOpenHashMap();
    private static final int c = 255;
    private static final int d = 254;
    private final Entity e;
    private final Int2ObjectMap<Item<?>> f = new Int2ObjectOpenHashMap();
    private boolean h = true;
    private boolean i;
    public boolean registrationLocked;

    public DataWatcher(Entity trackedEntity) {
        this.e = trackedEntity;
    }

    public static <T> DataWatcherObject<T> a(Class<? extends Entity> entityClass, DataWatcherSerializer<T> dataHandler) {
        int i2;
        if (a.isDebugEnabled()) {
            try {
                Class<?> oclass1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass1.equals(entityClass)) {
                    a.debug("defineId called for: {} from {}", entityClass, oclass1, (Object)new RuntimeException());
                }
            }
            catch (ClassNotFoundException oclass1) {
                // empty catch block
            }
        }
        if (b.containsKey(entityClass)) {
            i2 = b.getInt(entityClass) + 1;
        } else {
            int j2 = 0;
            Class<? extends Entity> oclass2 = entityClass;
            while (oclass2 != Entity.class) {
                if (!b.containsKey(oclass2 = oclass2.getSuperclass())) continue;
                j2 = b.getInt(oclass2) + 1;
                break;
            }
            i2 = j2;
        }
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        b.put(entityClass, i2);
        return dataHandler.a(i2);
    }

    public <T> void a(DataWatcherObject<T> key, T initialValue) {
        if (this.registrationLocked) {
            throw new IllegalStateException("Registering datawatcher object after entity initialization");
        }
        int i2 = key.a();
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        if (this.f.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
        }
        if (DataWatcherRegistry.b(key.b()) < 0) {
            DataWatcherSerializer<T> datawatcherserializer = key.b();
            throw new IllegalArgumentException("Unregistered serializer " + datawatcherserializer + " for " + i2 + "!");
        }
        this.c(key, initialValue);
    }

    private <T> void c(DataWatcherObject<T> datawatcherobject, T t0) {
        Item<T> datawatcher_item = new Item<T>(datawatcherobject, t0);
        this.f.put(datawatcherobject.a(), datawatcher_item);
        this.h = false;
    }

    private <T> Item<T> b(DataWatcherObject<T> datawatcherobject) {
        return (Item)this.f.get(datawatcherobject.a());
    }

    public <T> T a(DataWatcherObject<T> data) {
        return this.b(data).b();
    }

    public <T> void b(DataWatcherObject<T> key, T value) {
        Item<T> datawatcher_item = this.b(key);
        if (ObjectUtils.notEqual(value, datawatcher_item.b())) {
            datawatcher_item.a(value);
            this.e.a(key);
            datawatcher_item.a(true);
            this.i = true;
        }
    }

    public <T> void markDirty(DataWatcherObject<T> datawatcherobject) {
        this.b(datawatcherobject).a(true);
        this.i = true;
    }

    public boolean a() {
        return this.i;
    }

    public static void a(@Nullable List<Item<?>> entries, PacketDataSerializer buf) {
        if (entries != null) {
            for (Item<?> datawatcher_item : entries) {
                DataWatcher.a(buf, datawatcher_item);
            }
        }
        buf.writeByte(255);
    }

    @Nullable
    public List<Item<?>> b() {
        ArrayList list = null;
        if (this.i) {
            for (Item datawatcher_item : this.f.values()) {
                if (!datawatcher_item.c()) continue;
                datawatcher_item.a(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(datawatcher_item.d());
            }
        }
        this.i = false;
        return list;
    }

    @Nullable
    public List<Item<?>> c() {
        ArrayList list = null;
        for (Item datawatcher_item : this.f.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(datawatcher_item.d());
        }
        return list;
    }

    private static <T> void a(PacketDataSerializer buf, Item<T> entry) {
        DataWatcherObject<T> datawatcherobject = entry.a();
        int i2 = DataWatcherRegistry.b(datawatcherobject.b());
        if (i2 < 0) {
            throw new EncoderException("Unknown serializer type " + datawatcherobject.b());
        }
        buf.writeByte(datawatcherobject.a());
        buf.d(i2);
        datawatcherobject.b().a(buf, entry.b());
    }

    @Nullable
    public static List<Item<?>> a(PacketDataSerializer buf) {
        short short0;
        ArrayList arraylist = null;
        while ((short0 = buf.readUnsignedByte()) != 255) {
            int i2;
            DataWatcherSerializer<?> datawatcherserializer;
            if (arraylist == null) {
                arraylist = Lists.newArrayList();
            }
            if ((datawatcherserializer = DataWatcherRegistry.a(i2 = buf.j())) == null) {
                throw new DecoderException("Unknown serializer type " + i2);
            }
            arraylist.add(DataWatcher.a(buf, short0, datawatcherserializer));
        }
        return arraylist;
    }

    private static <T> Item<T> a(PacketDataSerializer buf, int i2, DataWatcherSerializer<T> datawatcherserializer) {
        return new Item<PacketDataSerializer>((DataWatcherObject<PacketDataSerializer>)datawatcherserializer.a(i2), datawatcherserializer.a((int)buf));
    }

    public void a(List<Item<?>> entries) {
        for (Item<?> datawatcher_item : entries) {
            Item datawatcher_item1 = (Item)this.f.get(datawatcher_item.a().a());
            if (datawatcher_item1 == null) continue;
            this.a(datawatcher_item1, datawatcher_item);
            this.e.a(datawatcher_item.a());
        }
        this.i = true;
    }

    private <T> void a(Item<T> to, Item<?> from) {
        if (!Objects.equals(from.a.b(), to.a.b())) {
            throw new IllegalStateException(String.format("Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", to.a.a(), this.e, to.b, to.b.getClass(), from.b, from.b.getClass()));
        }
        to.a(from.b());
    }

    public boolean d() {
        return this.h;
    }

    public void e() {
        this.i = false;
        for (Item datawatcher_item : this.f.values()) {
            datawatcher_item.a(false);
        }
    }

    public static class Item<T> {
        final DataWatcherObject<T> a;
        T b;
        private boolean c;

        public Item(DataWatcherObject<T> data, T value) {
            this.a = data;
            this.b = value;
            this.c = true;
        }

        public DataWatcherObject<T> a() {
            return this.a;
        }

        public void a(T value) {
            this.b = value;
        }

        public T b() {
            return this.b;
        }

        public boolean c() {
            return this.c;
        }

        public void a(boolean dirty) {
            this.c = dirty;
        }

        public Item<T> d() {
            return new Item<T>(this.a, this.a.b().a(this.b));
        }
    }
}

