/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class PacketPlayOutUpdateAttributes
implements Packet<PacketListenerPlayOut> {
    private final int a;
    private final List<AttributeSnapshot> b;

    public PacketPlayOutUpdateAttributes(int entityId, Collection<AttributeModifiable> attributes) {
        this.a = entityId;
        this.b = Lists.newArrayList();
        for (AttributeModifiable attributeInstance : attributes) {
            this.b.add(new AttributeSnapshot(attributeInstance.a(), attributeInstance.b(), attributeInstance.c()));
        }
    }

    public PacketPlayOutUpdateAttributes(PacketDataSerializer buf2) {
        this.a = buf2.j();
        this.b = buf2.a((PacketDataSerializer buf) -> {
            MinecraftKey resourceLocation = buf.q();
            AttributeBase attribute = IRegistry.am.a(resourceLocation);
            double d2 = buf.readDouble();
            List<AttributeModifier> list = buf.a((PacketDataSerializer modifiers) -> new AttributeModifier(modifiers.l(), "Unknown synced attribute modifier", modifiers.readDouble(), AttributeModifier.Operation.a(modifiers.readByte())));
            return new AttributeSnapshot(attribute, d2, list);
        });
    }

    @Override
    @Override
    public void a(PacketDataSerializer buf) {
        buf.d(this.a);
        buf.a(this.b, (buf2, attribute) -> {
            buf2.a(IRegistry.am.b(attribute.a()));
            buf2.writeDouble(attribute.b());
            buf2.a(attribute.c(), (buf, modifier) -> {
                buf.a(modifier.a());
                buf.writeDouble(modifier.d());
                buf.writeByte(modifier.c().a());
            });
        });
    }

    @Override
    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public int b() {
        return this.a;
    }

    public List<AttributeSnapshot> c() {
        return this.b;
    }

    public static class AttributeSnapshot {
        private final AttributeBase a;
        private final double b;
        private final Collection<AttributeModifier> c;

        public AttributeSnapshot(AttributeBase attribute, double baseValue, Collection<AttributeModifier> modifiers) {
            this.a = attribute;
            this.b = baseValue;
            this.c = modifiers;
        }

        public AttributeBase a() {
            return this.a;
        }

        public double b() {
            return this.b;
        }

        public Collection<AttributeModifier> c() {
            return this.c;
        }
    }
}

