/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import io.papermc.paper.adventure.AdventureComponent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentKeybind;
import net.minecraft.network.chat.ChatComponentNBT;
import net.minecraft.network.chat.ChatComponentScore;
import net.minecraft.network.chat.ChatComponentSelector;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ChatTypeAdapterFactory;
import net.minecraft.util.FormattedString;

public interface IChatBaseComponent
extends Message,
IChatFormatted,
Iterable<IChatBaseComponent> {
    default public Stream<IChatBaseComponent> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.b().stream().flatMap(IChatBaseComponent::stream)});
    }

    @Override
    default public Iterator<IChatBaseComponent> iterator() {
        return this.stream().iterator();
    }

    public ChatModifier c();

    public String a();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String a(int length) {
        StringBuilder stringbuilder = new StringBuilder();
        this.a(s2 -> {
            int j2 = length - stringbuilder.length();
            if (j2 <= 0) {
                return b;
            }
            stringbuilder.append(s2.length() <= j2 ? s2 : s2.substring(0, j2));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<IChatBaseComponent> b();

    public IChatMutableComponent g();

    public IChatMutableComponent e();

    public FormattedString f();

    @Override
    default public <T> Optional<T> a(IChatFormatted.b<T> styledVisitor, ChatModifier style) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        ChatModifier chatmodifier1 = this.c().a(style);
        Optional<T> optional = this.b(styledVisitor, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.b().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).a(styledVisitor, chatmodifier1)).isPresent());
        return optional1;
    }

    @Override
    default public <T> Optional<T> a(IChatFormatted.a<T> visitor) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        Optional<T> optional = this.b(visitor);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.b().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).a(visitor)).isPresent());
        return optional1;
    }

    default public <T> Optional<T> b(IChatFormatted.b<T> visitor, ChatModifier style) {
        return visitor.accept(style, this.a());
    }

    default public <T> Optional<T> b(IChatFormatted.a<T> visitor) {
        return visitor.accept(this.a());
    }

    default public List<IChatBaseComponent> b(ChatModifier style) {
        ArrayList list = Lists.newArrayList();
        this.a((chatmodifier1, s2) -> {
            if (!s2.isEmpty()) {
                list.add(new ChatComponentText(s2).c(chatmodifier1));
            }
            return Optional.empty();
        }, style);
        return list;
    }

    public static IChatBaseComponent a(@Nullable String string) {
        return string != null ? new ChatComponentText(string) : ChatComponentText.d;
    }

    public static class ChatSerializer
    implements JsonDeserializer<IChatMutableComponent>,
    JsonSerializer<IChatBaseComponent> {
        private static final Gson a = SystemUtils.a(() -> {
            GsonBuilder gsonbuilder = new GsonBuilder();
            gsonbuilder.disableHtmlEscaping();
            gsonbuilder.registerTypeAdapter(AdventureComponent.class, (Object)new AdventureComponent.Serializer());
            gsonbuilder.registerTypeHierarchyAdapter(IChatBaseComponent.class, (Object)new ChatSerializer());
            gsonbuilder.registerTypeHierarchyAdapter(ChatModifier.class, (Object)new ChatModifier.ChatModifierSerializer());
            gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ChatTypeAdapterFactory());
            return gsonbuilder.create();
        });
        private static final Field b = SystemUtils.a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", nosuchfieldexception);
            }
        });
        private static final Field c = SystemUtils.a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", nosuchfieldexception);
            }
        });

        public IChatMutableComponent a(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            ChatBaseComponent object;
            if (jsonelement.isJsonPrimitive()) {
                return new ChatComponentText(jsonelement.getAsString());
            }
            if (!jsonelement.isJsonObject()) {
                if (jsonelement.isJsonArray()) {
                    JsonArray jsonarray = jsonelement.getAsJsonArray();
                    IChatMutableComponent ichatmutablecomponent = null;
                    for (JsonElement jsonelement1 : jsonarray) {
                        IChatMutableComponent ichatmutablecomponent1 = this.a(jsonelement1, jsonelement1.getClass(), jsondeserializationcontext);
                        if (ichatmutablecomponent == null) {
                            ichatmutablecomponent = ichatmutablecomponent1;
                            continue;
                        }
                        ichatmutablecomponent.a(ichatmutablecomponent1);
                    }
                    return ichatmutablecomponent;
                }
                throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
            }
            JsonObject jsonobject = jsonelement.getAsJsonObject();
            if (jsonobject.has("text")) {
                object = new ChatComponentText(ChatDeserializer.h(jsonobject, "text"));
            } else if (jsonobject.has("translate")) {
                s = ChatDeserializer.h(jsonobject, "translate");
                if (jsonobject.has("with")) {
                    JsonArray jsonarray1 = ChatDeserializer.u(jsonobject, "with");
                    Object[] aobject = new Object[jsonarray1.size()];
                    for (int i2 = 0; i2 < aobject.length; ++i2) {
                        ChatComponentText chatcomponenttext;
                        aobject[i2] = this.a(jsonarray1.get(i2), type, jsondeserializationcontext);
                        if (!(aobject[i2] instanceof ChatComponentText) || !(chatcomponenttext = (ChatComponentText)aobject[i2]).c().g() || !chatcomponenttext.b().isEmpty()) continue;
                        aobject[i2] = chatcomponenttext.h();
                    }
                    object = new ChatMessage(s, aobject);
                } else {
                    object = new ChatMessage(s);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = ChatDeserializer.t(jsonobject, "score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                object = new ChatComponentScore(ChatDeserializer.h(jsonobject1, "name"), ChatDeserializer.h(jsonobject1, "objective"));
            } else if (jsonobject.has("selector")) {
                Optional<IChatBaseComponent> optional = this.a(type, jsondeserializationcontext, jsonobject);
                object = new ChatComponentSelector(ChatDeserializer.h(jsonobject, "selector"), optional);
            } else if (jsonobject.has("keybind")) {
                object = new ChatComponentKeybind(ChatDeserializer.h(jsonobject, "keybind"));
            } else {
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
                }
                s = ChatDeserializer.h(jsonobject, "nbt");
                Optional<IChatBaseComponent> optional1 = this.a(type, jsondeserializationcontext, jsonobject);
                boolean flag = ChatDeserializer.a(jsonobject, "interpret", false);
                if (jsonobject.has("block")) {
                    object = new ChatComponentNBT.a(s, flag, ChatDeserializer.h(jsonobject, "block"), optional1);
                } else if (jsonobject.has("entity")) {
                    object = new ChatComponentNBT.b(s, flag, ChatDeserializer.h(jsonobject, "entity"), optional1);
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
                    }
                    object = new ChatComponentNBT.c(s, flag, new MinecraftKey(ChatDeserializer.h(jsonobject, "storage")), optional1);
                }
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = ChatDeserializer.u(jsonobject, "extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                for (int j2 = 0; j2 < jsonarray2.size(); ++j2) {
                    ((IChatMutableComponent)object).a(this.a(jsonarray2.get(j2), type, jsondeserializationcontext));
                }
            }
            ((IChatMutableComponent)object).a((ChatModifier)jsondeserializationcontext.deserialize(jsonelement, ChatModifier.class));
            return object;
        }

        private Optional<IChatBaseComponent> a(Type type, JsonDeserializationContext context, JsonObject json) {
            return json.has("separator") ? Optional.of(this.a(json.get("separator"), type, context)) : Optional.empty();
        }

        private void a(ChatModifier style, JsonObject json, JsonSerializationContext context) {
            JsonElement jsonelement = context.serialize((Object)style);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject1 = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject1.entrySet()) {
                    json.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public JsonElement a(IChatBaseComponent ichatbasecomponent, Type type, JsonSerializationContext jsonserializationcontext) {
            if (ichatbasecomponent instanceof AdventureComponent) {
                return jsonserializationcontext.serialize((Object)ichatbasecomponent);
            }
            JsonObject jsonobject = new JsonObject();
            if (!ichatbasecomponent.c().g()) {
                this.a(ichatbasecomponent.c(), jsonobject, jsonserializationcontext);
            }
            if (!ichatbasecomponent.b().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (IChatBaseComponent ichatbasecomponent1 : ichatbasecomponent.b()) {
                    jsonarray.add(this.a(ichatbasecomponent1, ichatbasecomponent1.getClass(), jsonserializationcontext));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if (ichatbasecomponent instanceof ChatComponentText) {
                jsonobject.addProperty("text", ((ChatComponentText)ichatbasecomponent).h());
            } else if (ichatbasecomponent instanceof ChatMessage) {
                ChatMessage chatmessage = (ChatMessage)ichatbasecomponent;
                jsonobject.addProperty("translate", chatmessage.i());
                if (chatmessage.j() != null && chatmessage.j().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    for (Object object : chatmessage.j()) {
                        if (object instanceof IChatBaseComponent) {
                            jsonarray1.add(this.a((IChatBaseComponent)object, object.getClass(), jsonserializationcontext));
                            continue;
                        }
                        jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (ichatbasecomponent instanceof ChatComponentScore) {
                ChatComponentScore chatcomponentscore = (ChatComponentScore)ichatbasecomponent;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", chatcomponentscore.h());
                jsonobject1.addProperty("objective", chatcomponentscore.j());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (ichatbasecomponent instanceof ChatComponentSelector) {
                ChatComponentSelector chatcomponentselector = (ChatComponentSelector)ichatbasecomponent;
                jsonobject.addProperty("selector", chatcomponentselector.h());
                this.a(jsonserializationcontext, jsonobject, chatcomponentselector.j());
            } else if (ichatbasecomponent instanceof ChatComponentKeybind) {
                ChatComponentKeybind chatcomponentkeybind = (ChatComponentKeybind)ichatbasecomponent;
                jsonobject.addProperty("keybind", chatcomponentkeybind.i());
            } else {
                if (!(ichatbasecomponent instanceof ChatComponentNBT)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + ichatbasecomponent + " as a Component");
                }
                ChatComponentNBT chatcomponentnbt = (ChatComponentNBT)ichatbasecomponent;
                jsonobject.addProperty("nbt", chatcomponentnbt.h());
                jsonobject.addProperty("interpret", Boolean.valueOf(chatcomponentnbt.i()));
                this.a(jsonserializationcontext, jsonobject, chatcomponentnbt.e);
                if (ichatbasecomponent instanceof ChatComponentNBT.a) {
                    ChatComponentNBT.a chatcomponentnbt_a = (ChatComponentNBT.a)ichatbasecomponent;
                    jsonobject.addProperty("block", chatcomponentnbt_a.j());
                } else if (ichatbasecomponent instanceof ChatComponentNBT.b) {
                    ChatComponentNBT.b chatcomponentnbt_b = (ChatComponentNBT.b)ichatbasecomponent;
                    jsonobject.addProperty("entity", chatcomponentnbt_b.j());
                } else {
                    if (!(ichatbasecomponent instanceof ChatComponentNBT.c)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + ichatbasecomponent + " as a Component");
                    }
                    ChatComponentNBT.c chatcomponentnbt_c = (ChatComponentNBT.c)ichatbasecomponent;
                    jsonobject.addProperty("storage", chatcomponentnbt_c.j().toString());
                }
            }
            return jsonobject;
        }

        private void a(JsonSerializationContext context, JsonObject json, Optional<IChatBaseComponent> separator) {
            separator.ifPresent(ichatbasecomponent -> json.add("separator", this.a((IChatBaseComponent)ichatbasecomponent, (Type)ichatbasecomponent.getClass(), context)));
        }

        public static String a(IChatBaseComponent text) {
            return a.toJson((Object)text);
        }

        public static JsonElement b(IChatBaseComponent text) {
            return a.toJsonTree((Object)text);
        }

        @Nullable
        public static IChatMutableComponent a(String json) {
            return ChatDeserializer.a(a, json, IChatMutableComponent.class, false);
        }

        @Nullable
        public static IChatMutableComponent a(JsonElement json) {
            return (IChatMutableComponent)a.fromJson(json, IChatMutableComponent.class);
        }

        @Nullable
        public static IChatMutableComponent b(String json) {
            return ChatDeserializer.a(a, json, IChatMutableComponent.class, true);
        }

        public static IChatMutableComponent a(com.mojang.brigadier.StringReader reader) {
            try {
                JsonReader jsonreader = new JsonReader((Reader)new StringReader(reader.getRemaining()));
                jsonreader.setLenient(false);
                IChatMutableComponent ichatmutablecomponent = (IChatMutableComponent)a.getAdapter(IChatMutableComponent.class).read(jsonreader);
                reader.setCursor(reader.getCursor() + ChatSerializer.a(jsonreader));
                return ichatmutablecomponent;
            }
            catch (IOException | StackOverflowError ioexception) {
                throw new JsonParseException(ioexception);
            }
        }

        private static int a(JsonReader reader) {
            try {
                return b.getInt(reader) - c.getInt(reader) + 1;
            }
            catch (IllegalAccessException illegalaccessexception) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalaccessexception);
            }
        }
    }
}

