/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;

public class ChatModifier {
    public static final ChatModifier a = new ChatModifier(null, null, null, null, null, null, null, null, null, null);
    public static final MinecraftKey b = new MinecraftKey("minecraft", "default");
    @Nullable
    final ChatHexColor c;
    @Nullable
    final Boolean d;
    @Nullable
    final Boolean e;
    @Nullable
    final Boolean f;
    @Nullable
    final Boolean g;
    @Nullable
    final Boolean h;
    @Nullable
    final ChatClickable i;
    @Nullable
    final ChatHoverable j;
    @Nullable
    final String k;
    @Nullable
    final MinecraftKey l;

    ChatModifier(@Nullable ChatHexColor color, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable ChatClickable clickEvent, @Nullable ChatHoverable hoverEvent, @Nullable String insertion, @Nullable MinecraftKey font) {
        this.c = color;
        this.d = bold;
        this.e = italic;
        this.f = underlined;
        this.g = strikethrough;
        this.h = obfuscated;
        this.i = clickEvent;
        this.j = hoverEvent;
        this.k = insertion;
        this.l = font;
    }

    @Nullable
    public ChatHexColor a() {
        return this.c;
    }

    public boolean b() {
        return this.d == Boolean.TRUE;
    }

    public boolean c() {
        return this.e == Boolean.TRUE;
    }

    public boolean d() {
        return this.g == Boolean.TRUE;
    }

    public boolean e() {
        return this.f == Boolean.TRUE;
    }

    public boolean f() {
        return this.h == Boolean.TRUE;
    }

    public boolean g() {
        return this == a;
    }

    @Nullable
    public ChatClickable h() {
        return this.i;
    }

    @Nullable
    public ChatHoverable i() {
        return this.j;
    }

    @Nullable
    public String j() {
        return this.k;
    }

    public MinecraftKey k() {
        return this.l != null ? this.l : b;
    }

    public ChatModifier a(@Nullable ChatHexColor color) {
        return new ChatModifier(color, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(@Nullable EnumChatFormat color) {
        return this.a(color != null ? ChatHexColor.a(color) : null);
    }

    public ChatModifier a(int rgbColor) {
        return this.a(ChatHexColor.a(rgbColor));
    }

    public ChatModifier a(@Nullable Boolean bold) {
        return new ChatModifier(this.c, bold, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l);
    }

    public ChatModifier b(@Nullable Boolean italic) {
        return new ChatModifier(this.c, this.d, italic, this.f, this.g, this.h, this.i, this.j, this.k, this.l);
    }

    public ChatModifier c(@Nullable Boolean underline) {
        return new ChatModifier(this.c, this.d, this.e, underline, this.g, this.h, this.i, this.j, this.k, this.l);
    }

    public ChatModifier d(@Nullable Boolean strikethrough) {
        return new ChatModifier(this.c, this.d, this.e, this.f, strikethrough, this.h, this.i, this.j, this.k, this.l);
    }

    public ChatModifier e(@Nullable Boolean obfuscated) {
        return new ChatModifier(this.c, this.d, this.e, this.f, this.g, obfuscated, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(@Nullable ChatClickable clickEvent) {
        return new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, clickEvent, this.j, this.k, this.l);
    }

    public ChatModifier a(@Nullable ChatHoverable hoverEvent) {
        return new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, hoverEvent, this.k, this.l);
    }

    public ChatModifier a(@Nullable String insertion) {
        return new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, insertion, this.l);
    }

    public ChatModifier a(@Nullable MinecraftKey font) {
        return new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, font);
    }

    public ChatModifier b(EnumChatFormat formatting) {
        ChatHexColor textColor = this.c;
        Boolean boolean_ = this.d;
        Boolean boolean2 = this.e;
        Boolean boolean3 = this.g;
        Boolean boolean4 = this.f;
        Boolean boolean5 = this.h;
        switch (formatting) {
            case q: {
                boolean5 = true;
                break;
            }
            case r: {
                boolean_ = true;
                break;
            }
            case s: {
                boolean3 = true;
                break;
            }
            case t: {
                boolean4 = true;
                break;
            }
            case u: {
                boolean2 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.i, this.j, this.k, this.l);
    }

    public ChatModifier c(EnumChatFormat formatting) {
        ChatHexColor textColor = this.c;
        Boolean boolean_ = this.d;
        Boolean boolean2 = this.e;
        Boolean boolean3 = this.g;
        Boolean boolean4 = this.f;
        Boolean boolean5 = this.h;
        switch (formatting) {
            case q: {
                boolean5 = true;
                break;
            }
            case r: {
                boolean_ = true;
                break;
            }
            case s: {
                boolean3 = true;
                break;
            }
            case t: {
                boolean4 = true;
                break;
            }
            case u: {
                boolean2 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                boolean5 = false;
                boolean_ = false;
                boolean3 = false;
                boolean4 = false;
                boolean2 = false;
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(EnumChatFormat ... formattings) {
        ChatHexColor textColor = this.c;
        Boolean boolean_ = this.d;
        Boolean boolean2 = this.e;
        Boolean boolean3 = this.g;
        Boolean boolean4 = this.f;
        Boolean boolean5 = this.h;
        block8: for (EnumChatFormat chatFormatting : formattings) {
            switch (chatFormatting) {
                case q: {
                    boolean5 = true;
                    continue block8;
                }
                case r: {
                    boolean_ = true;
                    continue block8;
                }
                case s: {
                    boolean3 = true;
                    continue block8;
                }
                case t: {
                    boolean4 = true;
                    continue block8;
                }
                case u: {
                    boolean2 = true;
                    continue block8;
                }
                case v: {
                    return a;
                }
                default: {
                    textColor = ChatHexColor.a(chatFormatting);
                }
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(ChatModifier parent) {
        if (this == a) {
            return parent;
        }
        if (parent == a) {
            return this;
        }
        return new ChatModifier(this.c != null ? this.c : parent.c, this.d != null ? this.d : parent.d, this.e != null ? this.e : parent.e, this.f != null ? this.f : parent.f, this.g != null ? this.g : parent.g, this.h != null ? this.h : parent.h, this.i != null ? this.i : parent.i, this.j != null ? this.j : parent.j, this.k != null ? this.k : parent.k, this.l != null ? this.l : parent.l);
    }

    @Override
    public String toString() {
        return "Style{ color=" + this.c + ", bold=" + this.d + ", italic=" + this.e + ", underlined=" + this.f + ", strikethrough=" + this.g + ", obfuscated=" + this.h + ", clickEvent=" + this.h() + ", hoverEvent=" + this.i() + ", insertion=" + this.j() + ", font=" + this.k() + "}";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChatModifier) {
            ChatModifier style = (ChatModifier)object;
            return this.b() == style.b() && Objects.equals(this.a(), style.a()) && this.c() == style.c() && this.f() == style.f() && this.d() == style.d() && this.e() == style.e() && Objects.equals(this.h(), style.h()) && Objects.equals(this.i(), style.i()) && Objects.equals(this.j(), style.j()) && Objects.equals(this.k(), style.k());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k);
    }

    public static class ChatModifierSerializer
    implements JsonDeserializer<ChatModifier>,
    JsonSerializer<ChatModifier> {
        @Nullable
        @Override
        public ChatModifier a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject == null) {
                    return null;
                }
                Boolean boolean_ = ChatModifierSerializer.a(jsonObject, "bold");
                Boolean boolean2 = ChatModifierSerializer.a(jsonObject, "italic");
                Boolean boolean3 = ChatModifierSerializer.a(jsonObject, "underlined");
                Boolean boolean4 = ChatModifierSerializer.a(jsonObject, "strikethrough");
                Boolean boolean5 = ChatModifierSerializer.a(jsonObject, "obfuscated");
                ChatHexColor textColor = ChatModifierSerializer.e(jsonObject);
                String string = ChatModifierSerializer.d(jsonObject);
                ChatClickable clickEvent = ChatModifierSerializer.c(jsonObject);
                ChatHoverable hoverEvent = ChatModifierSerializer.b(jsonObject);
                MinecraftKey resourceLocation = ChatModifierSerializer.a(jsonObject);
                return new ChatModifier(textColor, boolean_, boolean2, boolean3, boolean4, boolean5, clickEvent, hoverEvent, string, resourceLocation);
            }
            return null;
        }

        @Nullable
        private static MinecraftKey a(JsonObject root) {
            if (root.has("font")) {
                String string = ChatDeserializer.h(root, "font");
                try {
                    return new MinecraftKey(string);
                }
                catch (ResourceKeyInvalidException resourceLocationException) {
                    throw new JsonSyntaxException("Invalid font name: " + string);
                }
            }
            return null;
        }

        @Nullable
        private static ChatHoverable b(JsonObject root) {
            JsonObject jsonObject;
            ChatHoverable hoverEvent;
            if (root.has("hoverEvent") && (hoverEvent = ChatHoverable.a(jsonObject = ChatDeserializer.t(root, "hoverEvent"))) != null && hoverEvent.a().a()) {
                return hoverEvent;
            }
            return null;
        }

        @Nullable
        private static ChatClickable c(JsonObject root) {
            if (root.has("clickEvent")) {
                JsonObject jsonObject = ChatDeserializer.t(root, "clickEvent");
                String string = ChatDeserializer.a(jsonObject, "action", null);
                ChatClickable.EnumClickAction action = string == null ? null : ChatClickable.EnumClickAction.a(string);
                String string2 = ChatDeserializer.a(jsonObject, "value", null);
                if (action != null && string2 != null && action.a()) {
                    return new ChatClickable(action, string2);
                }
            }
            return null;
        }

        @Nullable
        private static String d(JsonObject root) {
            return ChatDeserializer.a(root, "insertion", null);
        }

        @Nullable
        private static ChatHexColor e(JsonObject root) {
            if (root.has("color")) {
                String string = ChatDeserializer.h(root, "color");
                return ChatHexColor.a(string);
            }
            return null;
        }

        @Nullable
        private static Boolean a(JsonObject root, String key) {
            if (root.has(key)) {
                return root.get(key).getAsBoolean();
            }
            return null;
        }

        @Nullable
        @Override
        public JsonElement a(ChatModifier style, Type type, JsonSerializationContext jsonSerializationContext) {
            if (style.g()) {
                return null;
            }
            JsonObject jsonObject = new JsonObject();
            if (style.d != null) {
                jsonObject.addProperty("bold", style.d);
            }
            if (style.e != null) {
                jsonObject.addProperty("italic", style.e);
            }
            if (style.f != null) {
                jsonObject.addProperty("underlined", style.f);
            }
            if (style.g != null) {
                jsonObject.addProperty("strikethrough", style.g);
            }
            if (style.h != null) {
                jsonObject.addProperty("obfuscated", style.h);
            }
            if (style.c != null) {
                jsonObject.addProperty("color", style.c.b());
            }
            if (style.k != null) {
                jsonObject.add("insertion", jsonSerializationContext.serialize((Object)style.k));
            }
            if (style.i != null) {
                JsonObject jsonObject2 = new JsonObject();
                jsonObject2.addProperty("action", style.i.a().b());
                jsonObject2.addProperty("value", style.i.b());
                jsonObject.add("clickEvent", (JsonElement)jsonObject2);
            }
            if (style.j != null) {
                jsonObject.add("hoverEvent", (JsonElement)style.j.b());
            }
            if (style.l != null) {
                jsonObject.addProperty("font", style.l.toString());
            }
            return jsonObject;
        }

        @Nullable
        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.a((ChatModifier)object, type, jsonSerializationContext);
        }

        @Nullable
        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.a(jsonElement, type, jsonDeserializationContext);
        }
    }
}

