/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChatHoverable {
    static final Logger a = LogManager.getLogger();
    private final EnumHoverAction<?> b;
    private final Object c;

    public <T> ChatHoverable(EnumHoverAction<T> action, T contents) {
        this.b = action;
        this.c = contents;
    }

    public EnumHoverAction<?> a() {
        return this.b;
    }

    @Nullable
    public <T> T a(EnumHoverAction<T> action) {
        if (this.b == action) {
            return action.b(this.c);
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChatHoverable hoverEvent = (ChatHoverable)object;
        return this.b == hoverEvent.b && Objects.equals(this.c, hoverEvent.c);
    }

    @Override
    public String toString() {
        return "HoverEvent{action=" + this.b + ", value='" + this.c + "'}";
    }

    @Override
    public int hashCode() {
        int i2 = this.b.hashCode();
        i2 = 31 * i2 + (this.c != null ? this.c.hashCode() : 0);
        return i2;
    }

    @Nullable
    public static ChatHoverable a(JsonObject json) {
        String string = ChatDeserializer.a(json, "action", null);
        if (string == null) {
            return null;
        }
        EnumHoverAction<?> action = EnumHoverAction.a(string);
        if (action == null) {
            return null;
        }
        JsonElement jsonElement = json.get("contents");
        if (jsonElement != null) {
            return action.a(jsonElement);
        }
        IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(json.get("value"));
        if (component != null) {
            return action.a(component);
        }
        return null;
    }

    public JsonObject b() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("action", this.b.b());
        jsonObject.add("contents", this.b.a(this.c));
        return jsonObject;
    }

    public static class EnumHoverAction<T> {
        public static final EnumHoverAction<IChatBaseComponent> a = new EnumHoverAction<IChatBaseComponent>("show_text", true, IChatBaseComponent.ChatSerializer::a, IChatBaseComponent.ChatSerializer::b, Function.identity());
        public static final EnumHoverAction<c> b = new EnumHoverAction<c>("show_item", true, c::a, c::b, c::a);
        public static final EnumHoverAction<b> c = new EnumHoverAction<b>("show_entity", true, b::a, b::a, b::a);
        private static final Map<String, EnumHoverAction<?>> d = (Map)Stream.of(a, b, c).collect(ImmutableMap.toImmutableMap(EnumHoverAction::b, action -> action));
        private final String e;
        private final boolean f;
        private final Function<JsonElement, T> g;
        private final Function<T, JsonElement> h;
        private final Function<IChatBaseComponent, T> i;

        public EnumHoverAction(String name, boolean parsable, Function<JsonElement, T> deserializer, Function<T, JsonElement> serializer, Function<IChatBaseComponent, T> legacyDeserializer) {
            this.e = name;
            this.f = parsable;
            this.g = deserializer;
            this.h = serializer;
            this.i = legacyDeserializer;
        }

        public boolean a() {
            return this.f;
        }

        public String b() {
            return this.e;
        }

        @Nullable
        public static EnumHoverAction<?> a(String name) {
            return d.get(name);
        }

        T b(Object o2) {
            return (T)o2;
        }

        @Nullable
        public ChatHoverable a(JsonElement contents) {
            T object = this.g.apply(contents);
            if (object == null) {
                return null;
            }
            return new ChatHoverable(this, object);
        }

        @Nullable
        public ChatHoverable a(IChatBaseComponent value) {
            T object = this.i.apply(value);
            if (object == null) {
                return null;
            }
            return new ChatHoverable(this, object);
        }

        public JsonElement a(Object contents) {
            return this.h.apply(this.b(contents));
        }

        @Override
        public String toString() {
            return "<action " + this.e + ">";
        }
    }

    public static class c {
        private final Item a;
        private final int b;
        @Nullable
        private final NBTTagCompound c;
        @Nullable
        private ItemStack d;

        c(Item item, int count, @Nullable NBTTagCompound nbt) {
            this.a = item;
            this.b = count;
            this.c = nbt;
        }

        public c(ItemStack stack) {
            this(stack.c(), stack.I(), stack.s() != null ? stack.s().g() : null);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            c itemStackInfo = (c)object;
            return this.b == itemStackInfo.b && this.a.equals(itemStackInfo.a) && Objects.equals(this.c, itemStackInfo.c);
        }

        @Override
        public int hashCode() {
            int i2 = this.a.hashCode();
            i2 = 31 * i2 + this.b;
            i2 = 31 * i2 + (this.c != null ? this.c.hashCode() : 0);
            return i2;
        }

        public ItemStack a() {
            if (this.d == null) {
                this.d = new ItemStack(this.a, this.b);
                if (this.c != null) {
                    this.d.c(this.c);
                }
            }
            return this.d;
        }

        private static c a(JsonElement json) {
            if (json.isJsonPrimitive()) {
                return new c(IRegistry.aa.a(new MinecraftKey(json.getAsString())), 1, null);
            }
            JsonObject jsonObject = ChatDeserializer.m(json, "item");
            Item item = IRegistry.aa.a(new MinecraftKey(ChatDeserializer.h(jsonObject, "id")));
            int i2 = ChatDeserializer.a(jsonObject, "count", 1);
            if (jsonObject.has("tag")) {
                String string = ChatDeserializer.h(jsonObject, "tag");
                try {
                    NBTTagCompound compoundTag = MojangsonParser.a(string);
                    return new c(item, i2, compoundTag);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    a.warn("Failed to parse tag: {}", (Object)string, (Object)commandSyntaxException);
                }
            }
            return new c(item, i2, null);
        }

        @Nullable
        private static c a(IChatBaseComponent text) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(text.getString());
                return new c(ItemStack.a(compoundTag));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                a.warn("Failed to parse item tag: {}", (Object)text, (Object)commandSyntaxException);
                return null;
            }
        }

        private JsonElement b() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", IRegistry.aa.b(this.a).toString());
            if (this.b != 1) {
                jsonObject.addProperty("count", (Number)this.b);
            }
            if (this.c != null) {
                jsonObject.addProperty("tag", this.c.toString());
            }
            return jsonObject;
        }
    }

    public static class b {
        public final EntityTypes<?> a;
        public final UUID b;
        @Nullable
        public final IChatBaseComponent c;
        @Nullable
        private List<IChatBaseComponent> d;

        public b(EntityTypes<?> entityType, UUID uuid, @Nullable IChatBaseComponent name) {
            this.a = entityType;
            this.b = uuid;
            this.c = name;
        }

        @Nullable
        public static b a(JsonElement json) {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            EntityTypes<?> entityType = IRegistry.Z.a(new MinecraftKey(ChatDeserializer.h(jsonObject, "type")));
            UUID uUID = UUID.fromString(ChatDeserializer.h(jsonObject, "id"));
            IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(jsonObject.get("name"));
            return new b(entityType, uUID, component);
        }

        @Nullable
        public static b a(IChatBaseComponent text) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(text.getString());
                IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(compoundTag.l("name"));
                EntityTypes<?> entityType = IRegistry.Z.a(new MinecraftKey(compoundTag.l("type")));
                UUID uUID = UUID.fromString(compoundTag.l("id"));
                return new b(entityType, uUID, component);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public JsonElement a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", IRegistry.Z.b(this.a).toString());
            jsonObject.addProperty("id", this.b.toString());
            if (this.c != null) {
                jsonObject.add("name", IChatBaseComponent.ChatSerializer.b(this.c));
            }
            return jsonObject;
        }

        public List<IChatBaseComponent> b() {
            if (this.d == null) {
                this.d = Lists.newArrayList();
                if (this.c != null) {
                    this.d.add(this.c);
                }
                this.d.add(new ChatMessage("gui.entity_tooltip.type", this.a.h()));
                this.d.add(new ChatComponentText(this.b.toString()));
            }
            return this.d;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            b entityTooltipInfo = (b)object;
            return this.a.equals(entityTooltipInfo.a) && this.b.equals(entityTooltipInfo.b) && Objects.equals(this.c, entityTooltipInfo.c);
        }

        @Override
        public int hashCode() {
            int i2 = this.a.hashCode();
            i2 = 31 * i2 + this.b.hashCode();
            i2 = 31 * i2 + (this.c != null ? this.c.hashCode() : 0);
            return i2;
        }
    }
}

