/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TileEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ChatComponentNBT
extends ChatBaseComponent
implements ChatComponentContextual {
    private static final Logger h = LogManager.getLogger();
    protected final boolean d;
    protected final Optional<IChatBaseComponent> e;
    protected final String f;
    @Nullable
    protected final ArgumentNBTKey.g g;

    @Nullable
    private static ArgumentNBTKey.g d(String rawPath) {
        try {
            return new ArgumentNBTKey().a(new StringReader(rawPath));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public ChatComponentNBT(String rawPath, boolean interpret, Optional<IChatBaseComponent> separator) {
        this(rawPath, ChatComponentNBT.d(rawPath), interpret, separator);
    }

    protected ChatComponentNBT(String rawPath, @Nullable ArgumentNBTKey.g path, boolean interpret, Optional<IChatBaseComponent> separator) {
        this.f = rawPath;
        this.g = path;
        this.d = interpret;
        this.e = separator;
    }

    protected abstract Stream<NBTTagCompound> a(CommandListenerWrapper var1) throws CommandSyntaxException;

    public String h() {
        return this.f;
    }

    public boolean i() {
        return this.d;
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (source == null || this.g == null) {
            return new ChatComponentText("");
        }
        Stream<String> stream = this.a(source).flatMap(nbt -> {
            try {
                return this.g.a((NBTBase)nbt).stream();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return Stream.empty();
            }
        }).map(NBTBase::e_);
        if (this.d) {
            IChatBaseComponent component = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.a(source, this.e, sender, depth), (Object)ChatComponentUtils.c);
            return stream.flatMap(text -> {
                try {
                    IChatMutableComponent mutableComponent = IChatBaseComponent.ChatSerializer.a(text);
                    return Stream.of(ChatComponentUtils.a(source, mutableComponent, sender, depth));
                }
                catch (Exception exception) {
                    h.warn("Failed to parse component: {}", text, (Object)exception);
                    return Stream.of(new IChatMutableComponent[0]);
                }
            }).reduce((accumulator, current) -> accumulator.a(component).a((IChatBaseComponent)current)).orElseGet(() -> new ChatComponentText(""));
        }
        return ChatComponentUtils.a(source, this.e, sender, depth).map(text -> stream.map(string -> new ChatComponentText((String)string)).reduce((accumulator, current) -> accumulator.a((IChatBaseComponent)text).a((IChatBaseComponent)current)).orElseGet(() -> new ChatComponentText(""))).orElseGet(() -> new ChatComponentText(stream.collect(Collectors.joining(", "))));
    }

    public static class c
    extends ChatComponentNBT {
        private final MinecraftKey h;

        public c(String rawPath, boolean interpret, MinecraftKey id, Optional<IChatBaseComponent> separator) {
            super(rawPath, interpret, separator);
            this.h = id;
        }

        public c(String rawPath, @Nullable ArgumentNBTKey.g path, boolean interpret, MinecraftKey id, Optional<IChatBaseComponent> separator) {
            super(rawPath, path, interpret, separator);
            this.h = id;
        }

        public MinecraftKey j() {
            return this.h;
        }

        @Override
        @Override
        public c k() {
            return new c(this.f, this.g, this.d, this.h, this.e);
        }

        @Override
        @Override
        protected Stream<NBTTagCompound> a(CommandListenerWrapper source) {
            NBTTagCompound compoundTag = source.j().aF().a(this.h);
            return Stream.of(compoundTag);
        }

        @Override
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof c) {
                c storageNbtComponent = (c)object;
                return Objects.equals(this.h, storageNbtComponent.h) && Objects.equals(this.f, storageNbtComponent.f) && super.equals(object);
            }
            return false;
        }

        @Override
        @Override
        public String toString() {
            return "StorageNbtComponent{id='" + this.h + "'path='" + this.f + "', siblings=" + this.a + ", style=" + this.c() + "}";
        }

        @Override
        public /* synthetic */ ChatBaseComponent d() {
            return this.k();
        }

        @Override
        public /* synthetic */ IChatMutableComponent g() {
            return this.k();
        }
    }

    public static class a
    extends ChatComponentNBT {
        private final String h;
        @Nullable
        private final IVectorPosition i;

        public a(String rawPath, boolean rawJson, String rawPos, Optional<IChatBaseComponent> separator) {
            super(rawPath, rawJson, separator);
            this.h = rawPos;
            this.i = this.d(this.h);
        }

        @Nullable
        private IVectorPosition d(String rawPos) {
            try {
                return ArgumentPosition.a().a(new StringReader(rawPos));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return null;
            }
        }

        private a(String rawPath, @Nullable ArgumentNBTKey.g path, boolean interpret, String rawPos, @Nullable IVectorPosition pos, Optional<IChatBaseComponent> separator) {
            super(rawPath, path, interpret, separator);
            this.h = rawPos;
            this.i = pos;
        }

        @Nullable
        public String j() {
            return this.h;
        }

        @Override
        @Override
        public a k() {
            return new a(this.f, this.g, this.d, this.h, this.i, this.e);
        }

        @Override
        @Override
        protected Stream<NBTTagCompound> a(CommandListenerWrapper source) {
            TileEntity blockEntity;
            BlockPosition blockPos;
            WorldServer serverLevel;
            if (this.i != null && (serverLevel = source.e()).n(blockPos = this.i.c(source)) && (blockEntity = serverLevel.c_(blockPos)) != null) {
                return Stream.of(blockEntity.m());
            }
            return Stream.empty();
        }

        @Override
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof a) {
                a blockNbtComponent = (a)object;
                return Objects.equals(this.h, blockNbtComponent.h) && Objects.equals(this.f, blockNbtComponent.f) && super.equals(object);
            }
            return false;
        }

        @Override
        @Override
        public String toString() {
            return "BlockPosArgument{pos='" + this.h + "'path='" + this.f + "', siblings=" + this.a + ", style=" + this.c() + "}";
        }

        @Override
        public /* synthetic */ ChatBaseComponent d() {
            return this.k();
        }

        @Override
        public /* synthetic */ IChatMutableComponent g() {
            return this.k();
        }
    }

    public static class b
    extends ChatComponentNBT {
        private final String h;
        @Nullable
        private final EntitySelector i;

        public b(String rawPath, boolean interpret, String rawSelector, Optional<IChatBaseComponent> separator) {
            super(rawPath, interpret, separator);
            this.h = rawSelector;
            this.i = b.d(rawSelector);
        }

        @Nullable
        private static EntitySelector d(String rawSelector) {
            try {
                ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(new StringReader(rawSelector));
                return entitySelectorParser.t();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return null;
            }
        }

        private b(String rawPath, @Nullable ArgumentNBTKey.g path, boolean interpret, String rawSelector, @Nullable EntitySelector selector, Optional<IChatBaseComponent> separator) {
            super(rawPath, path, interpret, separator);
            this.h = rawSelector;
            this.i = selector;
        }

        public String j() {
            return this.h;
        }

        @Override
        @Override
        public b k() {
            return new b(this.f, this.g, this.d, this.h, this.i, this.e);
        }

        @Override
        @Override
        protected Stream<NBTTagCompound> a(CommandListenerWrapper source) throws CommandSyntaxException {
            if (this.i != null) {
                List<? extends Entity> list = this.i.b(source);
                return list.stream().map(CriterionConditionNBT::b);
            }
            return Stream.empty();
        }

        @Override
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof b) {
                b entityNbtComponent = (b)object;
                return Objects.equals(this.h, entityNbtComponent.h) && Objects.equals(this.f, entityNbtComponent.f) && super.equals(object);
            }
            return false;
        }

        @Override
        @Override
        public String toString() {
            return "EntityNbtComponent{selector='" + this.h + "'path='" + this.f + "', siblings=" + this.a + ", style=" + this.c() + "}";
        }

        @Override
        public /* synthetic */ ChatBaseComponent d() {
            return this.k();
        }

        @Override
        public /* synthetic */ IChatMutableComponent g() {
            return this.k();
        }
    }
}

