/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketDecoder
extends ByteToMessageDecoder {
    private static final Logger a = LogManager.getLogger();
    private static final Marker b = MarkerManager.getMarker((String)"PACKET_RECEIVED", (Marker)NetworkManager.b);
    private final EnumProtocolDirection c;

    public PacketDecoder(EnumProtocolDirection side) {
        this.c = side;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        int i2 = byteBuf.readableBytes();
        if (i2 == 0) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(byteBuf);
        int j2 = friendlyByteBuf.j();
        Packet<?> packet = ((EnumProtocol)((Object)channelHandlerContext.channel().attr(NetworkManager.c).get())).a(this.c, j2, friendlyByteBuf);
        if (packet == null) {
            throw new IOException("Bad packet id " + j2);
        }
        int k2 = ((EnumProtocol)((Object)channelHandlerContext.channel().attr(NetworkManager.c).get())).a();
        JvmProfiler.e.a(k2, j2, channelHandlerContext.channel().remoteAddress(), i2);
        if (friendlyByteBuf.readableBytes() > 0) {
            throw new IOException("Packet " + ((EnumProtocol)((Object)channelHandlerContext.channel().attr(NetworkManager.c).get())).a() + "/" + j2 + " (" + packet.getClass().getSimpleName() + ") was larger than I expected, found " + friendlyByteBuf.readableBytes() + " bytes extra whilst reading packet " + j2);
        }
        list.add(packet);
        if (a.isDebugEnabled()) {
            a.debug(b, " IN: [{}:{}] {}", channelHandlerContext.channel().attr(NetworkManager.c).get(), (Object)j2, (Object)packet.getClass().getName());
        }
    }
}

