/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class PacketDataSerializer
extends ByteBuf {
    private static final int c = 5;
    private static final int d = 10;
    private static final int e = 0x200000;
    private final ByteBuf f;
    public Locale adventure$locale;
    public static final short a = Short.MAX_VALUE;
    public static final int b = 262144;

    public PacketDataSerializer(ByteBuf parent) {
        this.f = parent;
    }

    public static int a(int value) {
        for (int j2 = 1; j2 < 5; ++j2) {
            if ((value & -1 << j2 * 7) != 0) continue;
            return j2;
        }
        return 5;
    }

    public static int a(long value) {
        for (int j2 = 1; j2 < 10; ++j2) {
            if ((value & -1L << j2 * 7) != 0L) continue;
            return j2;
        }
        return 10;
    }

    public <T> T a(Codec<T> codec) {
        NBTTagCompound nbttagcompound = this.n();
        DataResult dataresult = codec.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound);
        dataresult.error().ifPresent(partialresult -> {
            String s2 = partialresult.message();
            throw new EncoderException("Failed to decode: " + s2 + " " + nbttagcompound);
        });
        return dataresult.result().get();
    }

    public <T> void a(Codec<T> codec, T object) {
        DataResult dataresult = codec.encodeStart((DynamicOps)DynamicOpsNBT.a, object);
        dataresult.error().ifPresent(partialresult -> {
            String s2 = partialresult.message();
            throw new EncoderException("Failed to encode: " + s2 + " " + object);
        });
        this.a((NBTTagCompound)dataresult.result().get());
    }

    public static <T> IntFunction<T> a(IntFunction<T> applier, int max) {
        return j2 -> {
            if (j2 > max) {
                throw new DecoderException("Value " + j2 + " is larger than limit " + max);
            }
            return applier.apply(j2);
        };
    }

    public <T, C extends Collection<T>> C a(IntFunction<C> collectionFactory, Function<PacketDataSerializer, T> entryParser) {
        int i2 = this.j();
        Collection c0 = (Collection)collectionFactory.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            c0.add(entryParser.apply(this));
        }
        return (C)c0;
    }

    public <T> void a(Collection<T> collection, BiConsumer<PacketDataSerializer, T> entrySerializer) {
        this.d(collection.size());
        for (T t0 : collection) {
            entrySerializer.accept(this, (PacketDataSerializer)((Object)t0));
        }
    }

    public <T> List<T> a(Function<PacketDataSerializer, T> entryParser) {
        return (List)this.a(Lists::newArrayListWithCapacity, entryParser);
    }

    public IntList a() {
        int i2 = this.j();
        IntArrayList intarraylist = new IntArrayList();
        for (int j2 = 0; j2 < i2; ++j2) {
            intarraylist.add(this.j());
        }
        return intarraylist;
    }

    public void a(IntList list) {
        this.d(list.size());
        list.forEach(this::d);
    }

    public <K, V, M extends Map<K, V>> M a(IntFunction<M> mapFactory, Function<PacketDataSerializer, K> keyParser, Function<PacketDataSerializer, V> valueParser) {
        int i2 = this.j();
        Map m0 = (Map)mapFactory.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            K k0 = keyParser.apply(this);
            V v0 = valueParser.apply(this);
            m0.put(k0, v0);
        }
        return (M)m0;
    }

    public <K, V> Map<K, V> a(Function<PacketDataSerializer, K> keyParser, Function<PacketDataSerializer, V> valueParser) {
        return this.a(Maps::newHashMapWithExpectedSize, keyParser, valueParser);
    }

    public <K, V> void a(Map<K, V> map, BiConsumer<PacketDataSerializer, K> keySerializer, BiConsumer<PacketDataSerializer, V> valueSerializer) {
        this.d(map.size());
        map.forEach((object, object1) -> {
            keySerializer.accept(this, object);
            valueSerializer.accept(this, object1);
        });
    }

    public void a(Consumer<PacketDataSerializer> consumer) {
        int i2 = this.j();
        for (int j2 = 0; j2 < i2; ++j2) {
            consumer.accept(this);
        }
    }

    public <T> void a(Optional<T> value, BiConsumer<PacketDataSerializer, T> serializer) {
        if (value.isPresent()) {
            this.writeBoolean(true);
            serializer.accept(this, (PacketDataSerializer)((Object)value.get()));
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> Optional<T> b(Function<PacketDataSerializer, T> parser) {
        return this.readBoolean() ? Optional.of(parser.apply(this)) : Optional.empty();
    }

    public byte[] b() {
        return this.b(this.readableBytes());
    }

    public PacketDataSerializer a(byte[] array) {
        this.d(array.length);
        this.writeBytes(array);
        return this;
    }

    public byte[] b(int maxSize) {
        int j2 = this.j();
        if (j2 > maxSize) {
            throw new DecoderException("ByteArray with size " + j2 + " is bigger than allowed " + maxSize);
        }
        byte[] abyte = new byte[j2];
        this.readBytes(abyte);
        return abyte;
    }

    public PacketDataSerializer a(int[] array) {
        this.d(array.length);
        int[] aint1 = array;
        int i2 = array.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint1[j2];
            this.d(k2);
        }
        return this;
    }

    public int[] c() {
        return this.c(this.readableBytes());
    }

    public int[] c(int maxSize) {
        int j2 = this.j();
        if (j2 > maxSize) {
            throw new DecoderException("VarIntArray with size " + j2 + " is bigger than allowed " + maxSize);
        }
        int[] aint = new int[j2];
        for (int k2 = 0; k2 < aint.length; ++k2) {
            aint[k2] = this.j();
        }
        return aint;
    }

    public PacketDataSerializer a(long[] array) {
        this.d(array.length);
        long[] along1 = array;
        int i2 = array.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            long k2 = along1[j2];
            this.writeLong(k2);
        }
        return this;
    }

    public long[] d() {
        return this.b((long[])null);
    }

    public long[] b(@Nullable long[] toArray) {
        return this.a(toArray, this.readableBytes() / 8);
    }

    public long[] a(@Nullable long[] toArray, int maxSize) {
        int j2 = this.j();
        if (toArray == null || toArray.length != j2) {
            if (j2 > maxSize) {
                throw new DecoderException("LongArray with size " + j2 + " is bigger than allowed " + maxSize);
            }
            toArray = new long[j2];
        }
        for (int k2 = 0; k2 < toArray.length; ++k2) {
            toArray[k2] = this.readLong();
        }
        return toArray;
    }

    @VisibleForTesting
    public byte[] e() {
        int i2 = this.writerIndex();
        byte[] abyte = new byte[i2];
        this.getBytes(0, abyte);
        return abyte;
    }

    public BlockPosition f() {
        return BlockPosition.d(this.readLong());
    }

    public PacketDataSerializer a(BlockPosition pos) {
        this.writeLong(pos.a());
        return this;
    }

    public ChunkCoordIntPair g() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer a(ChunkCoordIntPair pos) {
        this.writeLong(pos.a());
        return this;
    }

    public SectionPosition h() {
        return SectionPosition.a(this.readLong());
    }

    public PacketDataSerializer a(SectionPosition pos) {
        this.writeLong(pos.s());
        return this;
    }

    public IChatBaseComponent i() {
        return IChatBaseComponent.ChatSerializer.a(this.e(262144));
    }

    public PacketDataSerializer writeComponent(Component component) {
        return this.a(PaperAdventure.asJsonString(component, this.adventure$locale), 262144);
    }

    @Deprecated
    public PacketDataSerializer writeComponent(BaseComponent[] component) {
        return this.a(ComponentSerializer.toString((BaseComponent[])component), 262144);
    }

    public PacketDataSerializer a(IChatBaseComponent text) {
        return this.a(PaperAdventure.asJsonString(text, this.adventure$locale), 262144);
    }

    public <T extends Enum<T>> T a(Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[this.j()];
    }

    public PacketDataSerializer a(Enum<?> instance) {
        return this.d(instance.ordinal());
    }

    public int j() {
        byte b0;
        int i2 = 0;
        int j2 = 0;
        do {
            b0 = this.readByte();
            i2 |= (b0 & 0x7F) << j2++ * 7;
            if (j2 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i2;
    }

    public long k() {
        byte b0;
        long i2 = 0L;
        int j2 = 0;
        do {
            b0 = this.readByte();
            i2 |= (long)(b0 & 0x7F) << j2++ * 7;
            if (j2 <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i2;
    }

    public PacketDataSerializer a(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
        return this;
    }

    public UUID l() {
        return new UUID(this.readLong(), this.readLong());
    }

    public PacketDataSerializer d(int value) {
        while ((value & 0xFFFFFF80) != 0) {
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte(value);
        return this;
    }

    public PacketDataSerializer b(long value) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        this.writeByte((int)value);
        return this;
    }

    public PacketDataSerializer a(@Nullable NBTTagCompound compound) {
        if (compound == null) {
            this.writeByte(0);
        } else {
            try {
                NBTCompressedStreamTools.a(compound, (DataOutput)new ByteBufOutputStream((ByteBuf)this));
            }
            catch (Exception ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
        return this;
    }

    @Nullable
    public NBTTagCompound m() {
        return this.a(new NBTReadLimiter(0x200000L));
    }

    @Nullable
    public NBTTagCompound n() {
        return this.a(NBTReadLimiter.a);
    }

    @Nullable
    public NBTTagCompound a(NBTReadLimiter sizeTracker) {
        int i2 = this.readerIndex();
        byte b0 = this.readByte();
        if (b0 == 0) {
            return null;
        }
        this.readerIndex(i2);
        try {
            return NBTCompressedStreamTools.a((DataInput)new ByteBufInputStream((ByteBuf)this), sizeTracker);
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public PacketDataSerializer a(ItemStack stack) {
        if (stack.b() || stack.c() == null) {
            this.writeBoolean(false);
        } else {
            NBTTagCompound owner;
            this.writeBoolean(true);
            Item item = stack.c();
            this.d(Item.a(item));
            this.writeByte(stack.I());
            NBTTagCompound nbttagcompound = null;
            if ((item.n() || item.q()) && (nbttagcompound = (stack = stack.m()).s()) != null && nbttagcompound.b("SkullOwner", 10) && (owner = nbttagcompound.p("SkullOwner")).b("Id")) {
                nbttagcompound.a("SkullOwnerOrig", owner.a("Id"));
                TileEntitySkull.sanitizeUUID(owner);
            }
            this.a(nbttagcompound);
        }
        return this;
    }

    public ItemStack o() {
        if (!this.readBoolean()) {
            return ItemStack.b;
        }
        int i2 = this.j();
        byte b0 = this.readByte();
        ItemStack itemstack = new ItemStack(Item.b(i2), b0);
        itemstack.c(this.m());
        if (itemstack.s() != null && itemstack.u.e("SkullOwnerOrig")) {
            NBTTagCompound owner = itemstack.u.p("SkullOwner");
            if (itemstack.u.e("SkullOwnerOrig")) {
                owner.x.put("Id", itemstack.u.x.get("SkullOwnerOrig"));
                itemstack.u.r("SkullOwnerOrig");
            }
        }
        return itemstack;
    }

    public String p() {
        return this.e(Short.MAX_VALUE);
    }

    public String e(int maxLength) {
        int j2 = this.j();
        if (j2 > maxLength * 4) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + j2 + " > " + maxLength * 4 + ")");
        }
        if (j2 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s2 = this.toString(this.readerIndex(), j2, StandardCharsets.UTF_8);
        this.readerIndex(this.readerIndex() + j2);
        if (s2.length() > maxLength) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + j2 + " > " + maxLength + ")");
        }
        return s2;
    }

    public PacketDataSerializer a(String string) {
        return this.a(string, Short.MAX_VALUE);
    }

    public PacketDataSerializer a(String string, int maxLength) {
        byte[] abyte = string.getBytes(StandardCharsets.UTF_8);
        if (abyte.length > maxLength) {
            throw new EncoderException("String too big (was " + abyte.length + " bytes encoded, max " + maxLength + ")");
        }
        this.d(abyte.length);
        this.writeBytes(abyte);
        return this;
    }

    public MinecraftKey q() {
        return new MinecraftKey(this.e(Short.MAX_VALUE));
    }

    public PacketDataSerializer a(MinecraftKey id) {
        this.a(id.toString());
        return this;
    }

    public Date r() {
        return new Date(this.readLong());
    }

    public PacketDataSerializer a(Date date) {
        this.writeLong(date.getTime());
        return this;
    }

    public MovingObjectPositionBlock s() {
        BlockPosition blockposition = this.f();
        EnumDirection enumdirection = this.a(EnumDirection.class);
        float f2 = this.readFloat();
        float f1 = this.readFloat();
        float f22 = this.readFloat();
        boolean flag = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)blockposition.u() + (double)f2, (double)blockposition.v() + (double)f1, (double)blockposition.w() + (double)f22), enumdirection, blockposition, flag);
    }

    public void a(MovingObjectPositionBlock hitResult) {
        BlockPosition blockposition = hitResult.a();
        this.a(blockposition);
        this.a(hitResult.b());
        Vec3D vec3d = hitResult.e();
        this.writeFloat((float)(vec3d.b - (double)blockposition.u()));
        this.writeFloat((float)(vec3d.c - (double)blockposition.v()));
        this.writeFloat((float)(vec3d.d - (double)blockposition.w()));
        this.writeBoolean(hitResult.d());
    }

    public BitSet t() {
        return BitSet.valueOf(this.d());
    }

    public void a(BitSet bitSet) {
        this.a(bitSet.toLongArray());
    }

    public int capacity() {
        return this.f.capacity();
    }

    public ByteBuf capacity(int i2) {
        return this.f.capacity(i2);
    }

    public int maxCapacity() {
        return this.f.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.f.alloc();
    }

    public ByteOrder order() {
        return this.f.order();
    }

    public ByteBuf order(ByteOrder byteorder) {
        return this.f.order(byteorder);
    }

    public ByteBuf unwrap() {
        return this.f.unwrap();
    }

    public boolean isDirect() {
        return this.f.isDirect();
    }

    public boolean isReadOnly() {
        return this.f.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.f.asReadOnly();
    }

    public int readerIndex() {
        return this.f.readerIndex();
    }

    public ByteBuf readerIndex(int i2) {
        return this.f.readerIndex(i2);
    }

    public int writerIndex() {
        return this.f.writerIndex();
    }

    public ByteBuf writerIndex(int i2) {
        return this.f.writerIndex(i2);
    }

    public ByteBuf setIndex(int i2, int j2) {
        return this.f.setIndex(i2, j2);
    }

    public int readableBytes() {
        return this.f.readableBytes();
    }

    public int writableBytes() {
        return this.f.writableBytes();
    }

    public int maxWritableBytes() {
        return this.f.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.f.isReadable();
    }

    public boolean isReadable(int i2) {
        return this.f.isReadable(i2);
    }

    public boolean isWritable() {
        return this.f.isWritable();
    }

    public boolean isWritable(int i2) {
        return this.f.isWritable(i2);
    }

    public ByteBuf clear() {
        return this.f.clear();
    }

    public ByteBuf markReaderIndex() {
        return this.f.markReaderIndex();
    }

    public ByteBuf resetReaderIndex() {
        return this.f.resetReaderIndex();
    }

    public ByteBuf markWriterIndex() {
        return this.f.markWriterIndex();
    }

    public ByteBuf resetWriterIndex() {
        return this.f.resetWriterIndex();
    }

    public ByteBuf discardReadBytes() {
        return this.f.discardReadBytes();
    }

    public ByteBuf discardSomeReadBytes() {
        return this.f.discardSomeReadBytes();
    }

    public ByteBuf ensureWritable(int i2) {
        return this.f.ensureWritable(i2);
    }

    public int ensureWritable(int i2, boolean flag) {
        return this.f.ensureWritable(i2, flag);
    }

    public boolean getBoolean(int i2) {
        return this.f.getBoolean(i2);
    }

    public byte getByte(int i2) {
        return this.f.getByte(i2);
    }

    public short getUnsignedByte(int i2) {
        return this.f.getUnsignedByte(i2);
    }

    public short getShort(int i2) {
        return this.f.getShort(i2);
    }

    public short getShortLE(int i2) {
        return this.f.getShortLE(i2);
    }

    public int getUnsignedShort(int i2) {
        return this.f.getUnsignedShort(i2);
    }

    public int getUnsignedShortLE(int i2) {
        return this.f.getUnsignedShortLE(i2);
    }

    public int getMedium(int i2) {
        return this.f.getMedium(i2);
    }

    public int getMediumLE(int i2) {
        return this.f.getMediumLE(i2);
    }

    public int getUnsignedMedium(int i2) {
        return this.f.getUnsignedMedium(i2);
    }

    public int getUnsignedMediumLE(int i2) {
        return this.f.getUnsignedMediumLE(i2);
    }

    public int getInt(int i2) {
        return this.f.getInt(i2);
    }

    public int getIntLE(int i2) {
        return this.f.getIntLE(i2);
    }

    public long getUnsignedInt(int i2) {
        return this.f.getUnsignedInt(i2);
    }

    public long getUnsignedIntLE(int i2) {
        return this.f.getUnsignedIntLE(i2);
    }

    public long getLong(int i2) {
        return this.f.getLong(i2);
    }

    public long getLongLE(int i2) {
        return this.f.getLongLE(i2);
    }

    public char getChar(int i2) {
        return this.f.getChar(i2);
    }

    public float getFloat(int i2) {
        return this.f.getFloat(i2);
    }

    public double getDouble(int i2) {
        return this.f.getDouble(i2);
    }

    public ByteBuf getBytes(int i2, ByteBuf bytebuf) {
        return this.f.getBytes(i2, bytebuf);
    }

    public ByteBuf getBytes(int i2, ByteBuf bytebuf, int j2) {
        return this.f.getBytes(i2, bytebuf, j2);
    }

    public ByteBuf getBytes(int i2, ByteBuf bytebuf, int j2, int k2) {
        return this.f.getBytes(i2, bytebuf, j2, k2);
    }

    public ByteBuf getBytes(int i2, byte[] abyte) {
        return this.f.getBytes(i2, abyte);
    }

    public ByteBuf getBytes(int i2, byte[] abyte, int j2, int k2) {
        return this.f.getBytes(i2, abyte, j2, k2);
    }

    public ByteBuf getBytes(int i2, ByteBuffer bytebuffer) {
        return this.f.getBytes(i2, bytebuffer);
    }

    public ByteBuf getBytes(int i2, OutputStream outputstream, int j2) throws IOException {
        return this.f.getBytes(i2, outputstream, j2);
    }

    public int getBytes(int i2, GatheringByteChannel gatheringbytechannel, int j2) throws IOException {
        return this.f.getBytes(i2, gatheringbytechannel, j2);
    }

    public int getBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.f.getBytes(i2, filechannel, j2, k2);
    }

    public CharSequence getCharSequence(int i2, int j2, Charset charset) {
        return this.f.getCharSequence(i2, j2, charset);
    }

    public ByteBuf setBoolean(int i2, boolean flag) {
        return this.f.setBoolean(i2, flag);
    }

    public ByteBuf setByte(int i2, int j2) {
        return this.f.setByte(i2, j2);
    }

    public ByteBuf setShort(int i2, int j2) {
        return this.f.setShort(i2, j2);
    }

    public ByteBuf setShortLE(int i2, int j2) {
        return this.f.setShortLE(i2, j2);
    }

    public ByteBuf setMedium(int i2, int j2) {
        return this.f.setMedium(i2, j2);
    }

    public ByteBuf setMediumLE(int i2, int j2) {
        return this.f.setMediumLE(i2, j2);
    }

    public ByteBuf setInt(int i2, int j2) {
        return this.f.setInt(i2, j2);
    }

    public ByteBuf setIntLE(int i2, int j2) {
        return this.f.setIntLE(i2, j2);
    }

    public ByteBuf setLong(int i2, long j2) {
        return this.f.setLong(i2, j2);
    }

    public ByteBuf setLongLE(int i2, long j2) {
        return this.f.setLongLE(i2, j2);
    }

    public ByteBuf setChar(int i2, int j2) {
        return this.f.setChar(i2, j2);
    }

    public ByteBuf setFloat(int i2, float f2) {
        return this.f.setFloat(i2, f2);
    }

    public ByteBuf setDouble(int i2, double d0) {
        return this.f.setDouble(i2, d0);
    }

    public ByteBuf setBytes(int i2, ByteBuf bytebuf) {
        return this.f.setBytes(i2, bytebuf);
    }

    public ByteBuf setBytes(int i2, ByteBuf bytebuf, int j2) {
        return this.f.setBytes(i2, bytebuf, j2);
    }

    public ByteBuf setBytes(int i2, ByteBuf bytebuf, int j2, int k2) {
        return this.f.setBytes(i2, bytebuf, j2, k2);
    }

    public ByteBuf setBytes(int i2, byte[] abyte) {
        return this.f.setBytes(i2, abyte);
    }

    public ByteBuf setBytes(int i2, byte[] abyte, int j2, int k2) {
        return this.f.setBytes(i2, abyte, j2, k2);
    }

    public ByteBuf setBytes(int i2, ByteBuffer bytebuffer) {
        return this.f.setBytes(i2, bytebuffer);
    }

    public int setBytes(int i2, InputStream inputstream, int j2) throws IOException {
        return this.f.setBytes(i2, inputstream, j2);
    }

    public int setBytes(int i2, ScatteringByteChannel scatteringbytechannel, int j2) throws IOException {
        return this.f.setBytes(i2, scatteringbytechannel, j2);
    }

    public int setBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.f.setBytes(i2, filechannel, j2, k2);
    }

    public ByteBuf setZero(int i2, int j2) {
        return this.f.setZero(i2, j2);
    }

    public int setCharSequence(int i2, CharSequence charsequence, Charset charset) {
        return this.f.setCharSequence(i2, charsequence, charset);
    }

    public boolean readBoolean() {
        return this.f.readBoolean();
    }

    public byte readByte() {
        return this.f.readByte();
    }

    public short readUnsignedByte() {
        return this.f.readUnsignedByte();
    }

    public short readShort() {
        return this.f.readShort();
    }

    public short readShortLE() {
        return this.f.readShortLE();
    }

    public int readUnsignedShort() {
        return this.f.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.f.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.f.readMedium();
    }

    public int readMediumLE() {
        return this.f.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.f.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.f.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.f.readInt();
    }

    public int readIntLE() {
        return this.f.readIntLE();
    }

    public long readUnsignedInt() {
        return this.f.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.f.readUnsignedIntLE();
    }

    public long readLong() {
        return this.f.readLong();
    }

    public long readLongLE() {
        return this.f.readLongLE();
    }

    public char readChar() {
        return this.f.readChar();
    }

    public float readFloat() {
        return this.f.readFloat();
    }

    public double readDouble() {
        return this.f.readDouble();
    }

    public ByteBuf readBytes(int i2) {
        return this.f.readBytes(i2);
    }

    public ByteBuf readSlice(int i2) {
        return this.f.readSlice(i2);
    }

    public ByteBuf readRetainedSlice(int i2) {
        return this.f.readRetainedSlice(i2);
    }

    public ByteBuf readBytes(ByteBuf bytebuf) {
        return this.f.readBytes(bytebuf);
    }

    public ByteBuf readBytes(ByteBuf bytebuf, int i2) {
        return this.f.readBytes(bytebuf, i2);
    }

    public ByteBuf readBytes(ByteBuf bytebuf, int i2, int j2) {
        return this.f.readBytes(bytebuf, i2, j2);
    }

    public ByteBuf readBytes(byte[] abyte) {
        return this.f.readBytes(abyte);
    }

    public ByteBuf readBytes(byte[] abyte, int i2, int j2) {
        return this.f.readBytes(abyte, i2, j2);
    }

    public ByteBuf readBytes(ByteBuffer bytebuffer) {
        return this.f.readBytes(bytebuffer);
    }

    public ByteBuf readBytes(OutputStream outputstream, int i2) throws IOException {
        return this.f.readBytes(outputstream, i2);
    }

    public int readBytes(GatheringByteChannel gatheringbytechannel, int i2) throws IOException {
        return this.f.readBytes(gatheringbytechannel, i2);
    }

    public CharSequence readCharSequence(int i2, Charset charset) {
        return this.f.readCharSequence(i2, charset);
    }

    public int readBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.f.readBytes(filechannel, i2, j2);
    }

    public ByteBuf skipBytes(int i2) {
        return this.f.skipBytes(i2);
    }

    public ByteBuf writeBoolean(boolean flag) {
        return this.f.writeBoolean(flag);
    }

    public ByteBuf writeByte(int i2) {
        return this.f.writeByte(i2);
    }

    public ByteBuf writeShort(int i2) {
        return this.f.writeShort(i2);
    }

    public ByteBuf writeShortLE(int i2) {
        return this.f.writeShortLE(i2);
    }

    public ByteBuf writeMedium(int i2) {
        return this.f.writeMedium(i2);
    }

    public ByteBuf writeMediumLE(int i2) {
        return this.f.writeMediumLE(i2);
    }

    public ByteBuf writeInt(int i2) {
        return this.f.writeInt(i2);
    }

    public ByteBuf writeIntLE(int i2) {
        return this.f.writeIntLE(i2);
    }

    public ByteBuf writeLong(long i2) {
        return this.f.writeLong(i2);
    }

    public ByteBuf writeLongLE(long i2) {
        return this.f.writeLongLE(i2);
    }

    public ByteBuf writeChar(int i2) {
        return this.f.writeChar(i2);
    }

    public ByteBuf writeFloat(float f2) {
        return this.f.writeFloat(f2);
    }

    public ByteBuf writeDouble(double d0) {
        return this.f.writeDouble(d0);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf) {
        return this.f.writeBytes(bytebuf);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf, int i2) {
        return this.f.writeBytes(bytebuf, i2);
    }

    public ByteBuf writeBytes(ByteBuf bytebuf, int i2, int j2) {
        return this.f.writeBytes(bytebuf, i2, j2);
    }

    public ByteBuf writeBytes(byte[] abyte) {
        return this.f.writeBytes(abyte);
    }

    public ByteBuf writeBytes(byte[] abyte, int i2, int j2) {
        return this.f.writeBytes(abyte, i2, j2);
    }

    public ByteBuf writeBytes(ByteBuffer bytebuffer) {
        return this.f.writeBytes(bytebuffer);
    }

    public int writeBytes(InputStream inputstream, int i2) throws IOException {
        return this.f.writeBytes(inputstream, i2);
    }

    public int writeBytes(ScatteringByteChannel scatteringbytechannel, int i2) throws IOException {
        return this.f.writeBytes(scatteringbytechannel, i2);
    }

    public int writeBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.f.writeBytes(filechannel, i2, j2);
    }

    public ByteBuf writeZero(int i2) {
        return this.f.writeZero(i2);
    }

    public int writeCharSequence(CharSequence charsequence, Charset charset) {
        return this.f.writeCharSequence(charsequence, charset);
    }

    public int indexOf(int i2, int j2, byte b0) {
        return this.f.indexOf(i2, j2, b0);
    }

    public int bytesBefore(byte b0) {
        return this.f.bytesBefore(b0);
    }

    public int bytesBefore(int i2, byte b0) {
        return this.f.bytesBefore(i2, b0);
    }

    public int bytesBefore(int i2, int j2, byte b0) {
        return this.f.bytesBefore(i2, j2, b0);
    }

    public int forEachByte(ByteProcessor byteprocessor) {
        return this.f.forEachByte(byteprocessor);
    }

    public int forEachByte(int i2, int j2, ByteProcessor byteprocessor) {
        return this.f.forEachByte(i2, j2, byteprocessor);
    }

    public int forEachByteDesc(ByteProcessor byteprocessor) {
        return this.f.forEachByteDesc(byteprocessor);
    }

    public int forEachByteDesc(int i2, int j2, ByteProcessor byteprocessor) {
        return this.f.forEachByteDesc(i2, j2, byteprocessor);
    }

    public ByteBuf copy() {
        return this.f.copy();
    }

    public ByteBuf copy(int i2, int j2) {
        return this.f.copy(i2, j2);
    }

    public ByteBuf slice() {
        return this.f.slice();
    }

    public ByteBuf retainedSlice() {
        return this.f.retainedSlice();
    }

    public ByteBuf slice(int i2, int j2) {
        return this.f.slice(i2, j2);
    }

    public ByteBuf retainedSlice(int i2, int j2) {
        return this.f.retainedSlice(i2, j2);
    }

    public ByteBuf duplicate() {
        return this.f.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.f.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.f.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.f.nioBuffer();
    }

    public ByteBuffer nioBuffer(int i2, int j2) {
        return this.f.nioBuffer(i2, j2);
    }

    public ByteBuffer internalNioBuffer(int i2, int j2) {
        return this.f.internalNioBuffer(i2, j2);
    }

    public ByteBuffer[] nioBuffers() {
        return this.f.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int i2, int j2) {
        return this.f.nioBuffers(i2, j2);
    }

    public boolean hasArray() {
        return this.f.hasArray();
    }

    public byte[] array() {
        return this.f.array();
    }

    public int arrayOffset() {
        return this.f.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.f.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.f.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.f.toString(charset);
    }

    public String toString(int i2, int j2, Charset charset) {
        return this.f.toString(i2, j2, charset);
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public boolean equals(Object object) {
        return this.f.equals(object);
    }

    public int compareTo(ByteBuf bytebuf) {
        return this.f.compareTo(bytebuf);
    }

    public String toString() {
        return this.f.toString();
    }

    public ByteBuf retain(int i2) {
        return this.f.retain(i2);
    }

    public ByteBuf retain() {
        return this.f.retain();
    }

    public ByteBuf touch() {
        return this.f.touch();
    }

    public ByteBuf touch(Object object) {
        return this.f.touch(object);
    }

    public int refCnt() {
        return this.f.refCnt();
    }

    public boolean release() {
        return this.f.release();
    }

    public boolean release(int i2) {
        return this.f.release(i2);
    }
}

