/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.util.IntervalledCounter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.LazyInitVar;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftChatMessage;
import org.bukkit.event.player.PlayerQuitEvent;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float g = 0.75f;
    private static final Logger h = LogManager.getLogger();
    public static final Marker a = MarkerManager.getMarker((String)"NETWORK");
    public static final Marker b = MarkerManager.getMarker((String)"NETWORK_PACKETS", (Marker)a);
    public static final AttributeKey<EnumProtocol> c = AttributeKey.valueOf((String)"protocol");
    public static final LazyInitVar<NioEventLoopGroup> d = new LazyInitVar<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(h)).build()));
    public static final LazyInitVar<EpollEventLoopGroup> e = new LazyInitVar<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(h)).build()));
    public static final LazyInitVar<DefaultEventLoopGroup> f = new LazyInitVar<DefaultEventLoopGroup>(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(h)).build()));
    private final EnumProtocolDirection i;
    private final Queue<QueuedPacket> j = Queues.newConcurrentLinkedQueue();
    public Channel k;
    public SocketAddress l;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    private PacketListener m;
    private IChatBaseComponent n;
    private boolean o;
    private boolean p;
    private int q;
    private int r;
    private float s;
    private float t;
    private int u;
    private boolean v;
    public int protocolVersion;
    public InetSocketAddress virtualHost;
    private static boolean enableExplicitFlush = Boolean.getBoolean("paper.explicit-flush");
    public boolean isPending = true;
    public boolean queueImmunity = false;
    public EnumProtocol protocol;
    volatile boolean canFlush = true;
    private final AtomicInteger packetWrites = new AtomicInteger();
    private int flushPacketsStart;
    private final Object flushLock = new Object();
    protected final Object PACKET_LIMIT_LOCK = new Object();
    protected final IntervalledCounter allPacketCounts;
    protected final Map<Class<? extends Packet<?>>, IntervalledCounter> packetSpecificLimits;
    private boolean stopReadingPackets;
    private static final int MAX_PER_TICK = PaperConfig.maxJoinsPerTick;
    private static int joinAttemptsThisTick;
    private static int currTick;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAutomaticFlush() {
        Object object = this.flushLock;
        synchronized (object) {
            this.flushPacketsStart = this.packetWrites.get();
            this.canFlush = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAutomaticFlush() {
        Object object = this.flushLock;
        synchronized (object) {
            this.canFlush = true;
            if (this.packetWrites.get() != this.flushPacketsStart) {
                this.flush();
            }
        }
    }

    private final void flush() {
        if (this.k.eventLoop().inEventLoop()) {
            this.k.flush();
        } else {
            this.k.eventLoop().execute(() -> this.k.flush());
        }
    }

    private void killForPacketSpam() {
        this.b(new PacketPlayOutKickDisconnect(CraftChatMessage.fromString(PaperConfig.kickMessage, true)[0]), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.a(CraftChatMessage.fromString(PaperConfig.kickMessage, true)[0])));
        this.l();
        this.stopReadingPackets = true;
    }

    public NetworkManager(EnumProtocolDirection side) {
        this.allPacketCounts = PaperConfig.allPacketsLimit != null ? new IntervalledCounter((long)(PaperConfig.allPacketsLimit.packetLimitInterval * 1.0E9)) : null;
        this.packetSpecificLimits = new HashMap();
        this.i = side;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.k = channelhandlercontext.channel();
        this.l = this.k.remoteAddress();
        this.preparing = false;
        try {
            this.a(EnumProtocol.a);
        }
        catch (Throwable throwable) {
            h.fatal((Object)throwable);
        }
    }

    public void a(EnumProtocol state) {
        this.protocol = state;
        this.k.attr(c).set((Object)state);
        this.k.config().setAutoRead(true);
        h.debug("Enabled auto read");
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.a(new ChatMessage("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        if (throwable instanceof EncoderException && throwable.getCause() instanceof PacketEncoder.PacketTooLargeException) {
            if (((PacketEncoder.PacketTooLargeException)throwable.getCause()).getPacket().packetTooLarge(this)) {
                return;
            }
            throwable = throwable.getCause();
        }
        if (throwable instanceof SkipEncodeException) {
            h.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.v;
            this.v = true;
            if (this.k.isOpen()) {
                EntityPlayer player = this.getPlayer();
                if (throwable instanceof TimeoutException) {
                    h.debug("Timeout", throwable);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.TIMED_OUT;
                    }
                    this.a(new ChatMessage("disconnect.timeout"));
                } else {
                    ChatMessage chatmessage = new ChatMessage("disconnect.genericReason", "Internal Exception: " + throwable);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.ERRONEOUS_STATE;
                    }
                    if (flag) {
                        h.debug("Failed to sent packet", throwable);
                        EnumProtocol enumprotocol = this.p();
                        Packet<PacketLoginOutListener> packet = enumprotocol == EnumProtocol.d ? new PacketLoginOutDisconnect(chatmessage) : new PacketPlayOutKickDisconnect(chatmessage);
                        this.a(packet, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.a(chatmessage)));
                        this.l();
                    } else {
                        h.debug("Double fault", throwable);
                        this.a(chatmessage);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.k.isOpen()) {
            if (this.stopReadingPackets) {
                return;
            }
            if (this.allPacketCounts != null || PaperConfig.packetSpecificLimits.containsKey(packet.getClass())) {
                long time = System.nanoTime();
                Object object = this.PACKET_LIMIT_LOCK;
                synchronized (object) {
                    if (this.allPacketCounts != null) {
                        this.allPacketCounts.updateAndAdd(1, time);
                        if (this.allPacketCounts.getRate() >= PaperConfig.allPacketsLimit.maxPacketRate) {
                            this.killForPacketSpam();
                            return;
                        }
                    }
                    for (Class<?> check = packet.getClass(); check != Object.class; check = check.getSuperclass()) {
                        PaperConfig.PacketLimit packetSpecificLimit = PaperConfig.packetSpecificLimits.get(check);
                        if (packetSpecificLimit == null) continue;
                        IntervalledCounter counter = this.packetSpecificLimits.computeIfAbsent(check, clazz -> new IntervalledCounter((long)(packetSpecificLimit.packetLimitInterval * 1.0E9)));
                        counter.updateAndAdd(1, time);
                        if (!(counter.getRate() >= packetSpecificLimit.maxPacketRate)) continue;
                        switch (packetSpecificLimit.violateAction) {
                            case DROP: {
                                return;
                            }
                            case KICK: {
                                this.killForPacketSpam();
                                return;
                            }
                        }
                    }
                }
            }
            try {
                NetworkManager.a(packet, this.m);
            }
            catch (CancelledPacketHandleException time) {
            }
            catch (ClassCastException classcastexception) {
                h.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                this.a(new ChatMessage("multiplayer.disconnect.invalid_packet"));
            }
            ++this.q;
        }
    }

    private static <T extends PacketListener> void a(Packet<T> packet, PacketListener listener) {
        packet.a(listener);
    }

    public void a(PacketListener listener) {
        Validate.notNull((Object)listener, (String)"packetListener", (Object[])new Object[0]);
        this.m = listener;
    }

    public EntityPlayer getPlayer() {
        if (this.m instanceof PlayerConnection) {
            return ((PlayerConnection)this.m).b;
        }
        return null;
    }

    public void a(Packet<?> packet) {
        this.a(packet, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void a(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        boolean hasExtraPackets;
        boolean connected = this.h();
        if (!connected && !this.preparing) {
            return;
        }
        packet.onPacketDispatch(this.getPlayer());
        if (connected && (InnerUtil.canSendImmediate(this, packet) || MCUtil.isMainThread() && packet.isReady() && this.j.isEmpty() && (packet.getExtraPackets() == null || packet.getExtraPackets().isEmpty()))) {
            this.writePacket(packet, callback, null);
            return;
        }
        List<Packet> extraPackets = InnerUtil.buildExtraPackets(packet);
        boolean bl = hasExtraPackets = extraPackets != null && !extraPackets.isEmpty();
        if (!hasExtraPackets) {
            this.j.add(new QueuedPacket(packet, callback));
        } else {
            ArrayList<QueuedPacket> packets = new ArrayList<QueuedPacket>(1 + extraPackets.size());
            packets.add(new QueuedPacket(packet, null));
            int i2 = 0;
            int len = extraPackets.size();
            while (i2 < len) {
                Packet extra = extraPackets.get(i2);
                boolean end = ++i2 == len;
                packets.add(new QueuedPacket(extra, (GenericFutureListener<? extends Future<? super Void>>)(end ? callback : null)));
            }
            this.j.addAll(packets);
        }
        this.flushQueue();
    }

    private void b(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.writePacket(packet, callback, Boolean.TRUE);
    }

    private void writePacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, Boolean flushConditional) {
        this.packetWrites.getAndIncrement();
        boolean effectiveFlush = flushConditional == null ? this.canFlush : flushConditional;
        boolean flush = effectiveFlush || packet instanceof PacketPlayOutKeepAlive || packet instanceof PacketPlayOutKickDisconnect;
        EnumProtocol enumprotocol = EnumProtocol.a(packet);
        EnumProtocol enumprotocol1 = this.p();
        ++this.r;
        if (enumprotocol1 != enumprotocol) {
            h.debug("Disabled auto read");
            this.k.config().setAutoRead(false);
        }
        if (this.k.eventLoop().inEventLoop()) {
            this.doSendPacket(packet, callback, enumprotocol, enumprotocol1, flush);
        } else if (!flush) {
            AbstractEventExecutor.LazyRunnable run = () -> this.doSendPacket(packet, callback, enumprotocol, enumprotocol1, flush);
            this.k.eventLoop().execute((Runnable)run);
        } else {
            this.k.eventLoop().execute(() -> this.doSendPacket(packet, callback, enumprotocol, enumprotocol1, flush));
        }
    }

    private void a(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, EnumProtocol packetState, EnumProtocol currentState) {
        this.doSendPacket(packet, callback, packetState, currentState, true);
    }

    private void doSendPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback, EnumProtocol packetState, EnumProtocol currentState, boolean flush) {
        if (packetState != currentState) {
            this.a(packetState);
        }
        EntityPlayer player = this.getPlayer();
        if (!this.h()) {
            packet.onPacketDispatchFinish(player, null);
            return;
        }
        try {
            ChannelFuture channelfuture;
            ChannelFuture channelFuture2 = channelfuture = flush ? this.k.writeAndFlush(packet) : this.k.write(packet);
            if (callback != null) {
                channelfuture.addListener(callback);
            }
            if (packet.hasFinishListener()) {
                channelfuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> packet.onPacketDispatchFinish(player, (ChannelFuture)channelFuture)));
            }
            channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        catch (Exception e2) {
            h.error("NetworkException: " + player, (Throwable)e2);
            this.a(new ChatMessage("disconnect.genericReason", "Internal Exception: " + e2.getMessage()));
            packet.onPacketDispatchFinish(player, null);
        }
    }

    private EnumProtocol p() {
        return (EnumProtocol)((Object)this.k.attr(c).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushQueue() {
        if (!this.h()) {
            return true;
        }
        if (MCUtil.isMainThread()) {
            return this.processQueue();
        }
        if (this.isPending) {
            Queue<QueuedPacket> queue = this.j;
            synchronized (queue) {
                return this.processQueue();
            }
        }
        return false;
    }

    private boolean processQueue() {
        if (this.j.isEmpty()) {
            return true;
        }
        boolean needsFlush = this.canFlush;
        boolean hasWrotePacket = false;
        Iterator iterator = this.j.iterator();
        while (iterator.hasNext()) {
            QueuedPacket queued = (QueuedPacket)iterator.next();
            Packet<?> packet = queued.a;
            if (!packet.isReady()) {
                if (hasWrotePacket && (needsFlush || this.canFlush)) {
                    this.flush();
                }
                return false;
            }
            iterator.remove();
            this.writePacket(packet, queued.b, !iterator.hasNext() && (needsFlush || this.canFlush) ? Boolean.TRUE : Boolean.FALSE);
            hasWrotePacket = true;
        }
        return true;
    }

    public void a() {
        this.flushQueue();
        if (currTick != MinecraftServer.currentTick) {
            currTick = MinecraftServer.currentTick;
            joinAttemptsThisTick = 0;
        }
        if (this.m instanceof LoginListener && (((LoginListener)this.m).h != LoginListener.EnumProtocolState.e || joinAttemptsThisTick++ < MAX_PER_TICK)) {
            ((LoginListener)this.m).b();
        }
        if (this.m instanceof PlayerConnection) {
            PlayerConnectionUtils.packetProcessing.push(this.m);
            try {
                ((PlayerConnection)this.m).b();
            }
            finally {
                PlayerConnectionUtils.packetProcessing.pop();
            }
        }
        if (!this.h() && !this.p) {
            this.m();
        }
        if (this.k != null && enableExplicitFlush) {
            this.k.eventLoop().execute(() -> this.k.flush());
        }
        if (this.u++ % 20 == 0) {
            this.b();
        }
    }

    protected void b() {
        this.t = MathHelper.i(0.75f, this.r, this.t);
        this.s = MathHelper.i(0.75f, this.q, this.s);
        this.r = 0;
        this.q = 0;
    }

    public SocketAddress c() {
        return this.l;
    }

    public void clearPacketQueue() {
        EntityPlayer player = this.getPlayer();
        this.j.forEach(queuedPacket -> {
            Packet<?> packet = queuedPacket.a;
            if (packet.hasFinishListener()) {
                packet.onPacketDispatchFinish(player, null);
            }
        });
        this.j.clear();
    }

    public void a(IChatBaseComponent disconnectReason) {
        this.preparing = false;
        this.clearPacketQueue();
        if (this.k.isOpen()) {
            this.k.close();
            this.n = disconnectReason;
        }
    }

    public boolean d() {
        return this.k instanceof LocalChannel || this.k instanceof LocalServerChannel;
    }

    public EnumProtocolDirection e() {
        return this.i;
    }

    public EnumProtocolDirection f() {
        return this.i.a();
    }

    public static NetworkManager a(InetSocketAddress address, boolean useEpoll) {
        LazyInitVar<NioEventLoopGroup> lazyinitvar;
        Class<NioSocketChannel> oclass;
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        if (Epoll.isAvailable() && useEpoll) {
            oclass = EpollSocketChannel.class;
            lazyinitvar = e;
        } else {
            oclass = NioSocketChannel.class;
            lazyinitvar = d;
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)lazyinitvar.a())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("splitter", (ChannelHandler)new PacketSplitter()).addLast("decoder", (ChannelHandler)new PacketDecoder(EnumProtocolDirection.b)).addLast("prepender", (ChannelHandler)new PacketPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(EnumProtocolDirection.a)).addLast("packet_handler", (ChannelHandler)networkmanager);
            }
        })).channel(oclass)).connect(address.getAddress(), address.getPort()).syncUninterruptibly();
        return networkmanager;
    }

    public static NetworkManager a(SocketAddress address) {
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)f.a())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast("packet_handler", (ChannelHandler)networkmanager);
            }
        })).channel(LocalChannel.class)).connect(address).syncUninterruptibly();
        return networkmanager;
    }

    public void setupEncryption(SecretKey key) throws CryptographyException {
        if (!this.o) {
            try {
                VelocityCipher decryption = ((VelocityCipherFactory)Natives.cipher.get()).forDecryption(key);
                VelocityCipher encryption = ((VelocityCipherFactory)Natives.cipher.get()).forEncryption(key);
                this.o = true;
                this.k.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(decryption));
                this.k.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(encryption));
            }
            catch (GeneralSecurityException e2) {
                throw new CryptographyException(e2);
            }
        }
    }

    public boolean g() {
        return this.o;
    }

    public boolean h() {
        return this.k != null && this.k.isOpen();
    }

    public boolean i() {
        return this.k == null;
    }

    public PacketListener j() {
        return this.m;
    }

    @Nullable
    public IChatBaseComponent k() {
        return this.n;
    }

    public void l() {
        this.k.config().setAutoRead(false);
    }

    public void a(int compressionThreshold, boolean rejectsBadPackets) {
        if (compressionThreshold >= 0) {
            VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(-1);
            if (this.k.pipeline().get("decompress") instanceof PacketDecompressor) {
                ((PacketDecompressor)this.k.pipeline().get("decompress")).a(compressionThreshold, rejectsBadPackets);
            } else {
                this.k.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new PacketDecompressor(compressor, compressionThreshold, rejectsBadPackets));
            }
            if (this.k.pipeline().get("compress") instanceof PacketCompressor) {
                ((PacketCompressor)this.k.pipeline().get("compress")).a(compressionThreshold);
            } else {
                this.k.pipeline().addBefore("encoder", "compress", (ChannelHandler)new PacketCompressor(compressor, compressionThreshold));
            }
        } else {
            if (this.k.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.k.pipeline().remove("decompress");
            }
            if (this.k.pipeline().get("compress") instanceof PacketCompressor) {
                this.k.pipeline().remove("compress");
            }
        }
    }

    public void m() {
        if (this.k != null && !this.k.isOpen() && !this.p) {
            this.p = true;
            if (this.k() != null) {
                this.j().a(this.k());
            } else if (this.j() != null) {
                this.j().a(new ChatMessage("multiplayer.disconnect.generic"));
            }
            this.clearPacketQueue();
            PacketListener packetListener = this.j();
            if (packetListener instanceof PlayerConnection) {
                PlayerConnection playerConnection = (PlayerConnection)packetListener;
                new PlayerConnectionCloseEvent(playerConnection.b.cm(), playerConnection.b.co(), ((InetSocketAddress)this.l).getAddress(), false).callEvent();
            } else if (packetListener instanceof LoginListener) {
                LoginListener loginListener = (LoginListener)packetListener;
                switch (loginListener.h) {
                    case e: 
                    case f: 
                    case g: {
                        GameProfile profile = loginListener.j;
                        new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.l).getAddress(), false).callEvent();
                    }
                }
            }
        }
    }

    public float n() {
        return this.s;
    }

    public float o() {
        return this.t;
    }

    public SocketAddress getRawAddress() {
        if (this.k.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.k.remoteAddress();
    }

    private static class InnerUtil {
        private InnerUtil() {
        }

        private static List<Packet> buildExtraPackets(Packet packet) {
            List<Packet> extra = packet.getExtraPackets();
            if (extra == null || extra.isEmpty()) {
                return null;
            }
            ArrayList<Packet> ret = new ArrayList<Packet>(1 + extra.size());
            InnerUtil.buildExtraPackets0(extra, ret);
            return ret;
        }

        private static void buildExtraPackets0(List<Packet> extraPackets, List<Packet> into) {
            for (Packet extra : extraPackets) {
                into.add(extra);
                List<Packet> extraExtra = extra.getExtraPackets();
                if (extraExtra == null || extraExtra.isEmpty()) continue;
                InnerUtil.buildExtraPackets0(extraExtra, into);
            }
        }

        private static boolean canSendImmediate(NetworkManager networkManager, Packet<?> packet) {
            return networkManager.isPending || networkManager.protocol != EnumProtocol.b || packet instanceof PacketPlayOutKeepAlive || packet instanceof PacketPlayOutChat || packet instanceof PacketPlayOutTabComplete || packet instanceof ClientboundSetTitleTextPacket || packet instanceof ClientboundSetSubtitleTextPacket || packet instanceof ClientboundSetActionBarTextPacket || packet instanceof ClientboundSetTitlesAnimationPacket || packet instanceof ClientboundClearTitlesPacket || packet instanceof PacketPlayOutBoss;
        }
    }

    private static class QueuedPacket {
        final Packet<?> a;
        @Nullable
        final GenericFutureListener<? extends Future<? super Void>> b;

        public QueuedPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
            this.a = packet;
            this.b = callback;
        }
    }
}

