/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.network.chat.ChatMessage;

public class MojangsonParser {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)new ChatMessage("argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)new ChatMessage("argument.nbt.expected.value"));
    public static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((receivedType, expectedType) -> new ChatMessage("argument.nbt.list.mixed", receivedType, expectedType));
    public static final Dynamic2CommandExceptionType e = new Dynamic2CommandExceptionType((receivedType, expectedType) -> new ChatMessage("argument.nbt.array.mixed", receivedType, expectedType));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(type -> new ChatMessage("argument.nbt.array.invalid", type));
    public static final char g = ',';
    public static final char h = ':';
    private static final char i = '[';
    private static final char j = ']';
    private static final char k = '}';
    private static final char l = '{';
    private static final Pattern m = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern n = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern o = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern p = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern q = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern r = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern s = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final StringReader t;

    public static NBTTagCompound a(String string) throws CommandSyntaxException {
        return new MojangsonParser(new StringReader(string)).a();
    }

    @VisibleForTesting
    NBTTagCompound a() throws CommandSyntaxException {
        NBTTagCompound compoundTag = this.f();
        this.t.skipWhitespace();
        if (this.t.canRead()) {
            throw a.createWithContext((ImmutableStringReader)this.t);
        }
        return compoundTag;
    }

    public MojangsonParser(StringReader reader) {
        this.t = reader;
    }

    protected String b() throws CommandSyntaxException {
        this.t.skipWhitespace();
        if (!this.t.canRead()) {
            throw b.createWithContext((ImmutableStringReader)this.t);
        }
        return this.t.readString();
    }

    protected NBTBase c() throws CommandSyntaxException {
        this.t.skipWhitespace();
        int i2 = this.t.getCursor();
        if (StringReader.isQuotedStringStart((char)this.t.peek())) {
            return NBTTagString.a(this.t.readQuotedString());
        }
        String string = this.t.readUnquotedString();
        if (string.isEmpty()) {
            this.t.setCursor(i2);
            throw c.createWithContext((ImmutableStringReader)this.t);
        }
        return this.b(string);
    }

    public NBTBase b(String input) {
        try {
            if (o.matcher(input).matches()) {
                return NBTTagFloat.a(Float.parseFloat(input.substring(0, input.length() - 1)));
            }
            if (p.matcher(input).matches()) {
                return NBTTagByte.a(Byte.parseByte(input.substring(0, input.length() - 1)));
            }
            if (q.matcher(input).matches()) {
                return NBTTagLong.a(Long.parseLong(input.substring(0, input.length() - 1)));
            }
            if (r.matcher(input).matches()) {
                return NBTTagShort.a(Short.parseShort(input.substring(0, input.length() - 1)));
            }
            if (s.matcher(input).matches()) {
                return NBTTagInt.a(Integer.parseInt(input));
            }
            if (n.matcher(input).matches()) {
                return NBTTagDouble.a(Double.parseDouble(input.substring(0, input.length() - 1)));
            }
            if (m.matcher(input).matches()) {
                return NBTTagDouble.a(Double.parseDouble(input));
            }
            if ("true".equalsIgnoreCase(input)) {
                return NBTTagByte.c;
            }
            if ("false".equalsIgnoreCase(input)) {
                return NBTTagByte.b;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NBTTagString.a(input);
    }

    public NBTBase d() throws CommandSyntaxException {
        this.t.skipWhitespace();
        if (!this.t.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.t);
        }
        char c2 = this.t.peek();
        if (c2 == '{') {
            return this.f();
        }
        if (c2 == '[') {
            return this.e();
        }
        return this.c();
    }

    protected NBTBase e() throws CommandSyntaxException {
        if (this.t.canRead(3) && !StringReader.isQuotedStringStart((char)this.t.peek(1)) && this.t.peek(2) == ';') {
            return this.h();
        }
        return this.g();
    }

    public NBTTagCompound f() throws CommandSyntaxException {
        this.a('{');
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.t.skipWhitespace();
        while (this.t.canRead() && this.t.peek() != '}') {
            int i2 = this.t.getCursor();
            String string = this.b();
            if (string.isEmpty()) {
                this.t.setCursor(i2);
                throw b.createWithContext((ImmutableStringReader)this.t);
            }
            this.a(':');
            compoundTag.a(string, this.d());
            if (!this.i()) break;
            if (this.t.canRead()) continue;
            throw b.createWithContext((ImmutableStringReader)this.t);
        }
        this.a('}');
        return compoundTag;
    }

    private NBTBase g() throws CommandSyntaxException {
        this.a('[');
        this.t.skipWhitespace();
        if (!this.t.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.t);
        }
        NBTTagList listTag = new NBTTagList();
        NBTTagType<?> tagType = null;
        while (this.t.peek() != ']') {
            int i2 = this.t.getCursor();
            NBTBase tag = this.d();
            NBTTagType<?> tagType2 = tag.b();
            if (tagType == null) {
                tagType = tagType2;
            } else if (tagType2 != tagType) {
                this.t.setCursor(i2);
                throw d.createWithContext((ImmutableStringReader)this.t, (Object)tagType2.b(), (Object)tagType.b());
            }
            listTag.add(tag);
            if (!this.i()) break;
            if (this.t.canRead()) continue;
            throw c.createWithContext((ImmutableStringReader)this.t);
        }
        this.a(']');
        return listTag;
    }

    public NBTBase h() throws CommandSyntaxException {
        this.a('[');
        int i2 = this.t.getCursor();
        char c2 = this.t.read();
        this.t.read();
        this.t.skipWhitespace();
        if (!this.t.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.t);
        }
        if (c2 == 'B') {
            return new NBTTagByteArray(this.a(NBTTagByteArray.a, NBTTagByte.a));
        }
        if (c2 == 'L') {
            return new NBTTagLongArray(this.a(NBTTagLongArray.a, NBTTagLong.a));
        }
        if (c2 == 'I') {
            return new NBTTagIntArray(this.a(NBTTagIntArray.a, NBTTagInt.a));
        }
        this.t.setCursor(i2);
        throw f.createWithContext((ImmutableStringReader)this.t, (Object)String.valueOf(c2));
    }

    private <T extends Number> List<T> a(NBTTagType<?> arrayTypeReader, NBTTagType<?> typeReader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        while (this.t.peek() != ']') {
            int i2 = this.t.getCursor();
            NBTBase tag = this.d();
            NBTTagType<?> tagType = tag.b();
            if (tagType != typeReader) {
                this.t.setCursor(i2);
                throw e.createWithContext((ImmutableStringReader)this.t, (Object)tagType.b(), (Object)arrayTypeReader.b());
            }
            if (typeReader == NBTTagByte.a) {
                list.add(((NBTNumber)tag).h());
            } else if (typeReader == NBTTagLong.a) {
                list.add(((NBTNumber)tag).e());
            } else {
                list.add(((NBTNumber)tag).f());
            }
            if (!this.i()) break;
            if (this.t.canRead()) continue;
            throw c.createWithContext((ImmutableStringReader)this.t);
        }
        this.a(']');
        return list;
    }

    private boolean i() {
        this.t.skipWhitespace();
        if (this.t.canRead() && this.t.peek() == ',') {
            this.t.skip();
            this.t.skipWhitespace();
            return true;
        }
        return false;
    }

    private void a(char c2) throws CommandSyntaxException {
        this.t.skipWhitespace();
        this.t.expect(c2);
    }
}

