/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class DynamicOpsNBT
implements DynamicOps<NBTBase> {
    public static final DynamicOpsNBT a = new DynamicOpsNBT();

    protected DynamicOpsNBT() {
    }

    public NBTBase a() {
        return NBTTagEnd.b;
    }

    public <U> U a(DynamicOps<U> dynamicOps, NBTBase tag) {
        switch (tag.a()) {
            case 0: {
                return (U)dynamicOps.empty();
            }
            case 1: {
                return (U)dynamicOps.createByte(((NBTNumber)tag).h());
            }
            case 2: {
                return (U)dynamicOps.createShort(((NBTNumber)tag).g());
            }
            case 3: {
                return (U)dynamicOps.createInt(((NBTNumber)tag).f());
            }
            case 4: {
                return (U)dynamicOps.createLong(((NBTNumber)tag).e());
            }
            case 5: {
                return (U)dynamicOps.createFloat(((NBTNumber)tag).j());
            }
            case 6: {
                return (U)dynamicOps.createDouble(((NBTNumber)tag).i());
            }
            case 7: {
                return (U)dynamicOps.createByteList(ByteBuffer.wrap(((NBTTagByteArray)tag).d()));
            }
            case 8: {
                return (U)dynamicOps.createString(tag.e_());
            }
            case 9: {
                return (U)this.convertList(dynamicOps, tag);
            }
            case 10: {
                return (U)this.convertMap(dynamicOps, tag);
            }
            case 11: {
                return (U)dynamicOps.createIntList(Arrays.stream(((NBTTagIntArray)tag).f()));
            }
            case 12: {
                return (U)dynamicOps.createLongList(Arrays.stream(((NBTTagLongArray)tag).f()));
            }
        }
        throw new IllegalStateException("Unknown tag type: " + tag);
    }

    public DataResult<Number> a(NBTBase tag) {
        if (tag instanceof NBTNumber) {
            return DataResult.success((Object)((NBTNumber)tag).k());
        }
        return DataResult.error((String)"Not a number");
    }

    public NBTBase a(Number number) {
        return NBTTagDouble.a(number.doubleValue());
    }

    public NBTBase a(byte b2) {
        return NBTTagByte.a(b2);
    }

    public NBTBase a(short s2) {
        return NBTTagShort.a(s2);
    }

    public NBTBase a(int i2) {
        return NBTTagInt.a(i2);
    }

    public NBTBase a(long l2) {
        return NBTTagLong.a(l2);
    }

    public NBTBase a(float f2) {
        return NBTTagFloat.a(f2);
    }

    public NBTBase a(double d2) {
        return NBTTagDouble.a(d2);
    }

    public NBTBase a(boolean bl) {
        return NBTTagByte.a(bl);
    }

    public DataResult<String> b(NBTBase tag) {
        if (tag instanceof NBTTagString) {
            return DataResult.success((Object)tag.e_());
        }
        return DataResult.error((String)"Not a string");
    }

    public NBTBase a(String string) {
        return NBTTagString.a(string);
    }

    private static NBTList<?> a(byte knownType, byte valueType) {
        if (DynamicOpsNBT.a(knownType, valueType, (byte)4)) {
            return new NBTTagLongArray(new long[0]);
        }
        if (DynamicOpsNBT.a(knownType, valueType, (byte)1)) {
            return new NBTTagByteArray(new byte[0]);
        }
        if (DynamicOpsNBT.a(knownType, valueType, (byte)3)) {
            return new NBTTagIntArray(new int[0]);
        }
        return new NBTTagList();
    }

    private static boolean a(byte knownType, byte valueType, byte expectedType) {
        return knownType == expectedType && (valueType == expectedType || valueType == 0);
    }

    private static <T extends NBTBase> void a(NBTList<T> destination, NBTBase source, NBTBase additionalValue) {
        if (source instanceof NBTList) {
            NBTList collectionTag = (NBTList)source;
            collectionTag.forEach(nbt -> destination.add(nbt));
        }
        destination.add(additionalValue);
    }

    private static <T extends NBTBase> void a(NBTList<T> destination, NBTBase source, List<NBTBase> additionalValues) {
        if (source instanceof NBTList) {
            NBTList collectionTag = (NBTList)source;
            collectionTag.forEach(nbt -> destination.add(nbt));
        }
        additionalValues.forEach(nbt -> destination.add(nbt));
    }

    public DataResult<NBTBase> a(NBTBase tag, NBTBase tag2) {
        if (!(tag instanceof NBTList) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToList called with not a list: " + tag), (Object)tag);
        }
        NBTList<?> collectionTag = DynamicOpsNBT.a(tag instanceof NBTList ? ((NBTList)tag).e() : (byte)0, tag2.a());
        DynamicOpsNBT.a(collectionTag, tag, tag2);
        return DataResult.success(collectionTag);
    }

    public DataResult<NBTBase> a(NBTBase tag, List<NBTBase> list) {
        if (!(tag instanceof NBTList) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToList called with not a list: " + tag), (Object)tag);
        }
        NBTList<?> collectionTag = DynamicOpsNBT.a(tag instanceof NBTList ? ((NBTList)tag).e() : (byte)0, list.stream().findFirst().map(NBTBase::a).orElse((byte)0));
        DynamicOpsNBT.a(collectionTag, tag, list);
        return DataResult.success(collectionTag);
    }

    public DataResult<NBTBase> a(NBTBase tag, NBTBase tag2, NBTBase tag3) {
        if (!(tag instanceof NBTTagCompound) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + tag), (Object)tag);
        }
        if (!(tag2 instanceof NBTTagString)) {
            return DataResult.error((String)("key is not a string: " + tag2), (Object)tag);
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag2 = (NBTTagCompound)tag;
            compoundTag2.d().forEach(key -> compoundTag.a((String)key, compoundTag2.c((String)key)));
        }
        compoundTag.a(tag2.e_(), tag3);
        return DataResult.success((Object)compoundTag);
    }

    public DataResult<NBTBase> a(NBTBase tag, MapLike<NBTBase> mapLike) {
        if (!(tag instanceof NBTTagCompound) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + tag), (Object)tag);
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag2 = (NBTTagCompound)tag;
            compoundTag2.d().forEach(string -> compoundTag.a((String)string, compoundTag2.c((String)string)));
        }
        ArrayList list = Lists.newArrayList();
        mapLike.entries().forEach(pair -> {
            NBTBase tag = (NBTBase)pair.getFirst();
            if (!(tag instanceof NBTTagString)) {
                list.add(tag);
                return;
            }
            compoundTag.a(tag.e_(), (NBTBase)pair.getSecond());
        });
        if (!list.isEmpty()) {
            return DataResult.error((String)("some keys are not strings: " + list), (Object)compoundTag);
        }
        return DataResult.success((Object)compoundTag);
    }

    public DataResult<Stream<Pair<NBTBase, NBTBase>>> c(NBTBase tag) {
        if (!(tag instanceof NBTTagCompound)) {
            return DataResult.error((String)("Not a map: " + tag));
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        return DataResult.success(compoundTag.d().stream().map(key -> Pair.of((Object)this.a((String)key), (Object)compoundTag.c((String)key))));
    }

    public DataResult<Consumer<BiConsumer<NBTBase, NBTBase>>> d(NBTBase tag) {
        if (!(tag instanceof NBTTagCompound)) {
            return DataResult.error((String)("Not a map: " + tag));
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        return DataResult.success(entryConsumer -> compoundTag.d().forEach(key -> entryConsumer.accept(this.a((String)key), compoundTag.c((String)key))));
    }

    public DataResult<MapLike<NBTBase>> e(NBTBase tag) {
        if (!(tag instanceof NBTTagCompound)) {
            return DataResult.error((String)("Not a map: " + tag));
        }
        final NBTTagCompound compoundTag = (NBTTagCompound)tag;
        return DataResult.success((Object)new MapLike<NBTBase>(){

            @Nullable
            public NBTBase a(NBTBase tag) {
                return compoundTag.c(tag.e_());
            }

            @Nullable
            public NBTBase a(String string) {
                return compoundTag.c(string);
            }

            public Stream<Pair<NBTBase, NBTBase>> entries() {
                return compoundTag.d().stream().map(key -> Pair.of((Object)DynamicOpsNBT.this.a((String)key), (Object)compoundTag.c((String)key)));
            }

            @Override
            public String toString() {
                return "MapLike[" + compoundTag + "]";
            }

            @Nullable
            public /* synthetic */ Object get(String string) {
                return this.a(string);
            }

            @Nullable
            public /* synthetic */ Object get(Object object) {
                return this.a((NBTBase)object);
            }
        });
    }

    public NBTBase a(Stream<Pair<NBTBase, NBTBase>> stream) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        stream.forEach(entry -> compoundTag.a(((NBTBase)entry.getFirst()).e_(), (NBTBase)entry.getSecond()));
        return compoundTag;
    }

    public DataResult<Stream<NBTBase>> f(NBTBase tag) {
        if (tag instanceof NBTList) {
            return DataResult.success(((NBTList)tag).stream().map(nbt -> nbt));
        }
        return DataResult.error((String)"Not a list");
    }

    public DataResult<Consumer<Consumer<NBTBase>>> g(NBTBase tag) {
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            return DataResult.success(collectionTag::forEach);
        }
        return DataResult.error((String)("Not a list: " + tag));
    }

    public DataResult<ByteBuffer> h(NBTBase tag) {
        if (tag instanceof NBTTagByteArray) {
            return DataResult.success((Object)ByteBuffer.wrap(((NBTTagByteArray)tag).d()));
        }
        return super.getByteBuffer((Object)tag);
    }

    public NBTBase a(ByteBuffer byteBuffer) {
        return new NBTTagByteArray(DataFixUtils.toArray((ByteBuffer)byteBuffer));
    }

    public DataResult<IntStream> i(NBTBase tag) {
        if (tag instanceof NBTTagIntArray) {
            return DataResult.success((Object)Arrays.stream(((NBTTagIntArray)tag).f()));
        }
        return super.getIntStream((Object)tag);
    }

    public NBTBase a(IntStream intStream) {
        return new NBTTagIntArray(intStream.toArray());
    }

    public DataResult<LongStream> j(NBTBase tag) {
        if (tag instanceof NBTTagLongArray) {
            return DataResult.success((Object)Arrays.stream(((NBTTagLongArray)tag).f()));
        }
        return super.getLongStream((Object)tag);
    }

    public NBTBase a(LongStream longStream) {
        return new NBTTagLongArray(longStream.toArray());
    }

    public NBTBase b(Stream<NBTBase> stream) {
        PeekingIterator peekingIterator = Iterators.peekingIterator(stream.iterator());
        if (!peekingIterator.hasNext()) {
            return new NBTTagList();
        }
        NBTBase tag = (NBTBase)peekingIterator.peek();
        if (tag instanceof NBTTagByte) {
            ArrayList list = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, nbt -> ((NBTTagByte)nbt).h()));
            return new NBTTagByteArray(list);
        }
        if (tag instanceof NBTTagInt) {
            ArrayList list2 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, nbt -> ((NBTTagInt)nbt).f()));
            return new NBTTagIntArray(list2);
        }
        if (tag instanceof NBTTagLong) {
            ArrayList list3 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, nbt -> ((NBTTagLong)nbt).e()));
            return new NBTTagLongArray(list3);
        }
        NBTTagList listTag = new NBTTagList();
        while (peekingIterator.hasNext()) {
            NBTBase tag2 = (NBTBase)peekingIterator.next();
            if (tag2 instanceof NBTTagEnd) continue;
            listTag.add(tag2);
        }
        return listTag;
    }

    public NBTBase a(NBTBase tag, String string) {
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            NBTTagCompound compoundTag2 = new NBTTagCompound();
            compoundTag.d().stream().filter(k2 -> !Objects.equals(k2, string)).forEach(k2 -> compoundTag2.a((String)k2, compoundTag.c((String)k2)));
            return compoundTag2;
        }
        return tag;
    }

    @Override
    public String toString() {
        return "NBT";
    }

    public RecordBuilder<NBTBase> mapBuilder() {
        return new a();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.a((NBTBase)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.a(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.j((NBTBase)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.a(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.i((NBTBase)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.a(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.h((NBTBase)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.b(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.g((NBTBase)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.f((NBTBase)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.e((NBTBase)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.a(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.d((NBTBase)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.c((NBTBase)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.a((NBTBase)object, (MapLike<NBTBase>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.a((NBTBase)object, (NBTBase)object2, (NBTBase)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.a((NBTBase)object, list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.a((NBTBase)object, (NBTBase)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.a(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.b((NBTBase)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.a(bl);
    }

    public /* synthetic */ Object createDouble(double d2) {
        return this.a(d2);
    }

    public /* synthetic */ Object createFloat(float f2) {
        return this.a(f2);
    }

    public /* synthetic */ Object createLong(long l2) {
        return this.a(l2);
    }

    public /* synthetic */ Object createInt(int i2) {
        return this.a(i2);
    }

    public /* synthetic */ Object createShort(short s2) {
        return this.a(s2);
    }

    public /* synthetic */ Object createByte(byte b2) {
        return this.a(b2);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.a(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.a((NBTBase)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.a(dynamicOps, (NBTBase)object);
    }

    public /* synthetic */ Object empty() {
        return this.a();
    }

    class a
    extends RecordBuilder.AbstractStringBuilder<NBTBase, NBTTagCompound> {
        protected a() {
            super((DynamicOps)DynamicOpsNBT.this);
        }

        protected NBTTagCompound a() {
            return new NBTTagCompound();
        }

        protected NBTTagCompound a(String string, NBTBase tag, NBTTagCompound compoundTag) {
            compoundTag.a(string, tag);
            return compoundTag;
        }

        protected DataResult<NBTBase> a(NBTTagCompound compoundTag, NBTBase tag) {
            if (tag == null || tag == NBTTagEnd.b) {
                return DataResult.success((Object)compoundTag);
            }
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag2 = new NBTTagCompound(Maps.newHashMap(((NBTTagCompound)tag).h()));
                for (Map.Entry<String, NBTBase> entry : compoundTag.h().entrySet()) {
                    compoundTag2.a(entry.getKey(), entry.getValue());
                }
                return DataResult.success((Object)compoundTag2);
            }
            return DataResult.error((String)("mergeToMap called with not a map: " + tag), (Object)tag);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.a(string, (NBTBase)object, (NBTTagCompound)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.a((NBTTagCompound)object, (NBTBase)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.a();
        }
    }
}

