/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class GameTestHarnessHelper {
    private final GameTestHarnessInfo a;
    private boolean b;

    public GameTestHarnessHelper(GameTestHarnessInfo test) {
        this.a = test;
    }

    public WorldServer a() {
        return this.a.g();
    }

    public IBlockData a(BlockPosition pos) {
        return this.a().a_(this.i(pos));
    }

    @Nullable
    public TileEntity b(BlockPosition pos) {
        return this.a().c_(this.i(pos));
    }

    public void b() {
        AxisAlignedBB aABB = this.i();
        List<Entity> list = this.a().a(Entity.class, aABB.g(1.0), (? super T entity) -> !(entity instanceof EntityHuman));
        list.forEach(Entity::ag);
    }

    public EntityItem a(Item item, float x2, float y2, float z2) {
        WorldServer serverLevel = this.a();
        Vec3D vec3 = this.a(new Vec3D(x2, y2, z2));
        EntityItem itemEntity = new EntityItem(serverLevel, vec3.b, vec3.c, vec3.d, new ItemStack(item, 1));
        itemEntity.n(0.0, 0.0, 0.0);
        serverLevel.b(itemEntity);
        return itemEntity;
    }

    public <E extends Entity> E a(EntityTypes<E> type, BlockPosition pos) {
        return this.a(type, Vec3D.c(pos));
    }

    public <E extends Entity> E a(EntityTypes<E> type, Vec3D pos) {
        WorldServer serverLevel = this.a();
        E entity = type.a(serverLevel);
        if (entity instanceof EntityInsentient) {
            ((EntityInsentient)entity).fg();
        }
        Vec3D vec3 = this.a(pos);
        ((Entity)entity).b(vec3.b, vec3.c, vec3.d, ((Entity)entity).dm(), ((Entity)entity).dn());
        serverLevel.b((Entity)entity);
        return entity;
    }

    public <E extends Entity> E a(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.a(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends Entity> E a(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.a(type, new Vec3D(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, BlockPosition pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.fv();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.b(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, Vec3D pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.fv();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.b(type, new Vec3D(x2, y2, z2));
    }

    public GameTestHarnessSequence a(EntityInsentient entity, BlockPosition pos, float speed) {
        return this.f().a(2, () -> {
            PathEntity path = entity.D().a(this.i(pos), 0);
            entity.D().a(path, (double)speed);
        });
    }

    public void a(int x2, int y2, int z2) {
        this.c(new BlockPosition(x2, y2, z2));
    }

    public void c(BlockPosition pos) {
        this.b(pos, (IBlockData state) -> state.a(TagsBlock.f), () -> "Expected button");
        BlockPosition blockPos = this.i(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockButtonAbstract buttonBlock = (BlockButtonAbstract)blockState.b();
        buttonBlock.d(blockState, this.a(), blockPos);
    }

    public void d(BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        IBlockData blockState = this.a().a_(blockPos);
        blockState.a((World)this.a(), this.c(), EnumHand.a, new MovingObjectPositionBlock(Vec3D.a(blockPos), EnumDirection.c, blockPos, true));
    }

    public EntityLiving a(EntityLiving entity) {
        entity.i(0);
        entity.c(0.25f);
        return entity;
    }

    public EntityHuman c() {
        return new EntityHuman(this.a(), BlockPosition.b, 0.0f, new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            @Override
            public boolean B_() {
                return false;
            }

            @Override
            @Override
            public boolean f() {
                return true;
            }
        };
    }

    public void b(int x2, int y2, int z2) {
        this.e(new BlockPosition(x2, y2, z2));
    }

    public void e(BlockPosition pos) {
        this.a(Blocks.cw, pos);
        BlockPosition blockPos = this.i(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockLever leverBlock = (BlockLever)blockState.b();
        leverBlock.d(blockState, this.a(), blockPos);
    }

    public void a(BlockPosition pos, long delay) {
        this.a(pos, Blocks.fJ);
        this.b(delay, () -> this.a(pos, Blocks.a));
    }

    public void f(BlockPosition pos) {
        this.a().a(this.i(pos), false, null);
    }

    public void a(int x2, int y2, int z2, Block block) {
        this.a(new BlockPosition(x2, y2, z2), block);
    }

    public void a(int x2, int y2, int z2, IBlockData state) {
        this.a(new BlockPosition(x2, y2, z2), state);
    }

    public void a(BlockPosition pos, Block block) {
        this.a(pos, block.n());
    }

    public void a(BlockPosition pos, IBlockData state) {
        this.a().a(this.i(pos), state, 3);
    }

    public void d() {
        this.a(13000);
    }

    public void a(int timeOfDay) {
        this.a().b((long)timeOfDay);
    }

    public void a(Block block, int x2, int y2, int z2) {
        this.a(block, new BlockPosition(x2, y2, z2));
    }

    public void a(Block block, BlockPosition pos) {
        IBlockData blockState = this.a(pos);
        this.a((Entity)((Object)pos), (Predicate)block1 -> blockState.a(block), "Expected " + block.g().getString() + ", got " + blockState.b().g().getString());
    }

    public void b(Block block, int x2, int y2, int z2) {
        this.b(block, new BlockPosition(x2, y2, z2));
    }

    public void b(Block block, BlockPosition pos) {
        this.a((Entity)((Object)pos), (Predicate)block1 -> !this.a(pos).a(block), "Did not expect " + block.g().getString());
    }

    public void c(Block block, int x2, int y2, int z2) {
        this.c(block, new BlockPosition(x2, y2, z2));
    }

    public void c(Block block, BlockPosition pos) {
        this.b(() -> this.a(block, pos));
    }

    public void a(BlockPosition pos, Predicate<Block> predicate, String errorMessage) {
        this.a(pos, predicate, () -> errorMessage);
    }

    public void a(BlockPosition pos, Predicate<Block> predicate, Supplier<String> errorMessageSupplier) {
        this.b(pos, (IBlockData state) -> predicate.test(state.b()), errorMessageSupplier);
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, T value) {
        this.b(pos, (IBlockData state) -> state.b(property) && state.c(property).equals(value), () -> "Expected property " + property.f() + " to be " + value);
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, Predicate<T> predicate, String errorMessage) {
        this.b(pos, (IBlockData state) -> predicate.test(state.c(property)), () -> errorMessage);
    }

    public void b(BlockPosition pos, Predicate<IBlockData> predicate, Supplier<String> errorMessageSupplier) {
        IBlockData blockState = this.a(pos);
        if (!predicate.test(blockState)) {
            throw new GameTestHarnessAssertionPosition(errorMessageSupplier.get(), this.i(pos), pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type) {
        List<Entity> list = this.a().a(type, this.i(), Entity::bl);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + type.i() + " to exist");
        }
    }

    public void c(EntityTypes<?> type, int x2, int y2, int z2) {
        this.c(type, new BlockPosition(x2, y2, z2));
    }

    public void c(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bl);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.i(), blockPos, pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos).g(radius), Entity::bl);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.i(), blockPos, pos, this.a.p());
        }
    }

    public void a(Entity entity, int x2, int y2, int z2) {
        this.a(entity, new BlockPosition(x2, y2, z2));
    }

    public void a(Entity entity, BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(entity.ad(), new AxisAlignedBB(blockPos), Entity::bl);
        list.stream().filter(e2 -> e2 == entity).findFirst().orElseThrow(() -> new GameTestHarnessAssertionPosition("Expected " + entity.ad().i(), blockPos, pos, this.a.p()));
    }

    public void a(Item item, BlockPosition pos, double radius, int amount) {
        BlockPosition blockPos = this.i(pos);
        List<EntityItem> list = this.a().a(EntityTypes.Q, new AxisAlignedBB(blockPos).g(radius), Entity::bl);
        int i2 = 0;
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.h().c().equals(item)) continue;
            i2 += itemEntity.h().I();
        }
        if (i2 != amount) {
            throw new GameTestHarnessAssertionPosition("Expected " + amount + " " + item.o().getString() + " items to exist (found " + i2 + ")", blockPos, pos, this.a.p());
        }
    }

    public void a(Item item, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.i(pos);
        List<EntityItem> list = this.a().a(EntityTypes.Q, new AxisAlignedBB(blockPos).g(radius), Entity::bl);
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.h().c().equals(item)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Expected " + item.o().getString() + " item", blockPos, pos, this.a.p());
    }

    public void b(EntityTypes<?> type) {
        List<Entity> list = this.a().a(type, this.i(), Entity::bl);
        if (!list.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + type.i() + " to exist");
        }
    }

    public void d(EntityTypes<?> type, int x2, int y2, int z2) {
        this.d(type, new BlockPosition(x2, y2, z2));
    }

    public void d(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bl);
        if (!list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Did not expect " + type.i(), blockPos, pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec32 = this.a(vec3);
        Predicate<Entity> predicate = entity -> entity.cw().a(vec32, vec32);
        List<Entity> list = this.a().a(type, this.i(), predicate);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + type.i() + " to touch " + vec32 + " (relative " + vec3 + ")");
        }
    }

    public void b(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec32 = this.a(vec3);
        Predicate<Entity> predicate = entity -> !entity.cw().a(vec32, vec32);
        List<Entity> list = this.a().a(type, this.i(), predicate);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + type.i() + " to touch " + vec32 + " (relative " + vec3 + ")");
        }
    }

    public <E extends Entity, T> void a(BlockPosition pos, EntityTypes<E> type, Function<? super E, T> entityDataGetter, @Nullable T data) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bl);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.i(), blockPos, pos, this.a.p());
        }
        for (Entity entity : list) {
            T object = entityDataGetter.apply(entity);
            if (!(object == null ? data != null : !object.equals(data))) continue;
            throw new GameTestHarnessAssertion("Expected entity data to be: " + data + ", but was: " + object);
        }
    }

    public void g(BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        TileEntity blockEntity = this.a().c_(blockPos);
        if (blockEntity instanceof TileEntityContainer && !((TileEntityContainer)blockEntity).c()) {
            throw new GameTestHarnessAssertion("Container should be empty");
        }
    }

    public void a(BlockPosition pos, Item item) {
        BlockPosition blockPos = this.i(pos);
        TileEntity blockEntity = this.a().c_(blockPos);
        if (blockEntity instanceof TileEntityContainer && ((TileEntityContainer)blockEntity).a(item) != 1) {
            throw new GameTestHarnessAssertion("Container should contain: " + item);
        }
    }

    public void a(StructureBoundingBox checkedBlockBox, BlockPosition correctStatePos) {
        BlockPosition.a(checkedBlockBox).forEach(checkedPos -> {
            BlockPosition blockPos2 = correctStatePos.b(checkedPos.u() - checkedBlockBox.g(), checkedPos.v() - checkedBlockBox.h(), checkedPos.w() - checkedBlockBox.i());
            this.a((BlockPosition)checkedPos, blockPos2);
        });
    }

    public void a(BlockPosition checkedPos, BlockPosition correctStatePos) {
        IBlockData blockState2;
        IBlockData blockState = this.a(checkedPos);
        if (blockState != (blockState2 = this.a(correctStatePos))) {
            this.a("Incorrect state. Expected " + blockState2 + ", got " + blockState, checkedPos);
        }
    }

    public void a(long delay, BlockPosition pos, Item item) {
        this.a(delay, () -> this.a(pos, item));
    }

    public void a(long delay, BlockPosition pos) {
        this.a(delay, () -> this.g(pos));
    }

    public <E extends Entity, T> void b(BlockPosition pos, EntityTypes<E> type, Function<E, T> entityDataGetter, T data) {
        this.b(() -> this.a(pos, type, entityDataGetter, data));
    }

    public <E extends Entity> void a(E entity, Predicate<E> predicate, String testName) {
        if (!predicate.test(entity)) {
            throw new GameTestHarnessAssertion("Entity " + entity + " failed " + testName + " test");
        }
    }

    public <E extends Entity, T> void a(E entity, Function<E, T> propertyGetter, String propertyName, T expectedValue) {
        T object = propertyGetter.apply(entity);
        if (!object.equals(expectedValue)) {
            throw new GameTestHarnessAssertion("Entity " + entity + " value " + propertyName + "=" + object + " is not equal to expected " + expectedValue);
        }
    }

    public void e(EntityTypes<?> type, int x2, int y2, int z2) {
        this.e(type, new BlockPosition(x2, y2, z2));
    }

    public void e(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.c(type, pos));
    }

    public void f(EntityTypes<?> type, int x2, int y2, int z2) {
        this.f(type, new BlockPosition(x2, y2, z2));
    }

    public void f(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.d(type, pos));
    }

    public void e() {
        this.a.m();
    }

    private void h() {
        if (this.b) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.b = true;
    }

    public void a(Runnable runnable) {
        this.h();
        this.a.q().a(0L, runnable).a();
    }

    public void b(Runnable runnable) {
        this.h();
        this.a.q().a(runnable).a();
    }

    public void a(int duration, Runnable runnable) {
        this.h();
        this.a.q().a((long)duration, runnable).a();
    }

    public void a(long tick, Runnable runnable) {
        this.a.a(tick, runnable);
    }

    public void b(long ticks, Runnable runnable) {
        this.a(this.a.p() + ticks, runnable);
    }

    public void h(BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        WorldServer serverLevel = this.a();
        serverLevel.a_(blockPos).b(serverLevel, blockPos, serverLevel.w);
    }

    public void a(String message, BlockPosition pos) {
        throw new GameTestHarnessAssertionPosition(message, this.i(pos), pos, this.g());
    }

    public void a(String message, Entity entity) {
        throw new GameTestHarnessAssertionPosition(message, entity.cW(), this.j(entity.cW()), this.g());
    }

    public void a(String message) {
        throw new GameTestHarnessAssertion(message);
    }

    public void c(Runnable task) {
        this.a.q().a(task).a(() -> new GameTestHarnessAssertion("Fail conditions met"));
    }

    public void d(Runnable task) {
        LongStream.range(this.a.p(), this.a.w()).forEach(tick -> this.a.a(tick, task::run));
    }

    public GameTestHarnessSequence f() {
        return this.a.q();
    }

    public BlockPosition i(BlockPosition pos) {
        BlockPosition blockPos = this.a.d();
        BlockPosition blockPos2 = blockPos.a(pos);
        return DefinedStructure.a(blockPos2, EnumBlockMirror.a, this.a.u(), blockPos);
    }

    public BlockPosition j(BlockPosition pos) {
        BlockPosition blockPos = this.a.d();
        EnumBlockRotation rotation = this.a.u().a(EnumBlockRotation.c);
        BlockPosition blockPos2 = DefinedStructure.a(pos, EnumBlockMirror.a, rotation, blockPos);
        return blockPos2.b(blockPos);
    }

    public Vec3D a(Vec3D pos) {
        Vec3D vec3 = Vec3D.b(this.a.d());
        return DefinedStructure.a(vec3.e(pos), EnumBlockMirror.a, this.a.u(), this.a.d());
    }

    public long g() {
        return this.a.p();
    }

    private AxisAlignedBB i() {
        return this.a.f();
    }

    private AxisAlignedBB j() {
        AxisAlignedBB aABB = this.a.f();
        return aABB.a(BlockPosition.b.b(this.i(BlockPosition.b)));
    }

    public void a(Consumer<BlockPosition> posConsumer) {
        AxisAlignedBB aABB = this.j();
        BlockPosition.MutableBlockPosition.a(aABB.d(0.0, 1.0, 0.0)).forEach(posConsumer);
    }

    public void e(Runnable runnable) {
        LongStream.range(this.a.p(), this.a.w()).forEach(tick -> this.a.a(tick, runnable::run));
    }
}

