/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugReportNBT
implements DebugReportProvider {
    private static final Logger b = LogManager.getLogger();
    private final DebugReportGenerator c;

    public DebugReportNBT(DebugReportGenerator root) {
        this.c = root;
    }

    @Override
    @Override
    public void a(HashCache cache) throws IOException {
        Path path2 = this.c.b();
        for (Path path22 : this.c.a()) {
            Files.walk(path22, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".nbt")).forEach(path -> DebugReportNBT.a(path, this.a(path22, (Path)path), path2));
        }
    }

    @Override
    @Override
    public String a() {
        return "NBT to SNBT";
    }

    private String a(Path targetPath, Path rootPath) {
        String string = targetPath.relativize(rootPath).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".nbt".length());
    }

    @Nullable
    public static Path a(Path inputPath, String location, Path outputPath) {
        try {
            DebugReportNBT.a(outputPath.resolve(location + ".snbt"), GameProfileSerializer.d(NBTCompressedStreamTools.a(Files.newInputStream(inputPath, new OpenOption[0]))));
            b.info("Converted {} from NBT to SNBT", (Object)location);
            return outputPath.resolve(location + ".snbt");
        }
        catch (IOException iOException) {
            b.error("Couldn't convert {} from NBT to SNBT at {}", (Object)location, (Object)inputPath, (Object)iOException);
            return null;
        }
    }

    public static void a(Path file, String content) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file, new OpenOption[0]);){
            bufferedWriter.write(content);
            bufferedWriter.write(10);
        }
    }
}

