/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.IRegistry;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TextureMapping {
    private final Map<TextureSlot, MinecraftKey> a = Maps.newHashMap();
    private final Set<TextureSlot> b = Sets.newHashSet();

    public TextureMapping a(TextureSlot key, MinecraftKey id) {
        this.a.put(key, id);
        return this;
    }

    public TextureMapping b(TextureSlot key, MinecraftKey id) {
        this.a.put(key, id);
        this.b.add(key);
        return this;
    }

    public Stream<TextureSlot> a() {
        return this.b.stream();
    }

    public TextureMapping a(TextureSlot parent, TextureSlot child) {
        this.a.put(child, this.a.get(parent));
        return this;
    }

    public TextureMapping b(TextureSlot parent, TextureSlot child) {
        this.a.put(child, this.a.get(parent));
        this.b.add(child);
        return this;
    }

    public MinecraftKey a(TextureSlot key) {
        for (TextureSlot textureSlot = key; textureSlot != null; textureSlot = textureSlot.b()) {
            MinecraftKey resourceLocation = this.a.get(textureSlot);
            if (resourceLocation == null) continue;
            return resourceLocation;
        }
        throw new IllegalStateException("Can't find texture for slot " + key);
    }

    public TextureMapping c(TextureSlot key, MinecraftKey id) {
        TextureMapping textureMapping = new TextureMapping();
        textureMapping.a.putAll(this.a);
        textureMapping.b.addAll(this.b);
        textureMapping.a(key, id);
        return textureMapping;
    }

    public static TextureMapping a(Block block) {
        MinecraftKey resourceLocation = TextureMapping.C(block);
        return TextureMapping.b(resourceLocation);
    }

    public static TextureMapping b(Block block) {
        MinecraftKey resourceLocation = TextureMapping.C(block);
        return TextureMapping.a(resourceLocation);
    }

    public static TextureMapping a(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.b, id);
    }

    public static TextureMapping b(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.a, id);
    }

    public static TextureMapping c(Block block) {
        return TextureMapping.d(TextureSlot.p, TextureMapping.C(block));
    }

    public static TextureMapping c(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.p, id);
    }

    public static TextureMapping d(Block block) {
        return TextureMapping.d(TextureSlot.q, TextureMapping.C(block));
    }

    public static TextureMapping d(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.q, id);
    }

    public static TextureMapping e(Block block) {
        return TextureMapping.d(TextureSlot.s, TextureMapping.C(block));
    }

    public static TextureMapping e(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.s, id);
    }

    public static TextureMapping f(Block block) {
        return TextureMapping.d(TextureSlot.t, TextureMapping.C(block));
    }

    public static TextureMapping f(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.t, id);
    }

    public static TextureMapping g(Block block) {
        return TextureMapping.d(TextureSlot.y, TextureMapping.C(block));
    }

    public static TextureMapping a(Block stem, Block upper) {
        return new TextureMapping().a(TextureSlot.y, TextureMapping.C(stem)).a(TextureSlot.z, TextureMapping.C(upper));
    }

    public static TextureMapping h(Block block) {
        return TextureMapping.d(TextureSlot.u, TextureMapping.C(block));
    }

    public static TextureMapping i(Block block) {
        return TextureMapping.d(TextureSlot.x, TextureMapping.C(block));
    }

    public static TextureMapping g(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.A, id);
    }

    public static TextureMapping b(Block block, Block top) {
        return new TextureMapping().a(TextureSlot.v, TextureMapping.C(block)).a(TextureSlot.w, TextureMapping.a(top, "_top"));
    }

    public static TextureMapping d(TextureSlot key, MinecraftKey id) {
        return new TextureMapping().a(key, id);
    }

    public static TextureMapping j(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.d, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping k(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.f, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping l(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.C(block)).a(TextureSlot.d, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping a(MinecraftKey side, MinecraftKey end) {
        return new TextureMapping().a(TextureSlot.i, side).a(TextureSlot.d, end);
    }

    public static TextureMapping m(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping n(Block block) {
        MinecraftKey resourceLocation = TextureMapping.C(block);
        return new TextureMapping().a(TextureSlot.r, resourceLocation).a(TextureSlot.i, resourceLocation).a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping o(Block block) {
        MinecraftKey resourceLocation = TextureMapping.C(block);
        return new TextureMapping().a(TextureSlot.r, resourceLocation).a(TextureSlot.i, resourceLocation).a(TextureSlot.d, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping b(MinecraftKey top, MinecraftKey bottom) {
        return new TextureMapping().a(TextureSlot.f, top).a(TextureSlot.e, bottom);
    }

    public static TextureMapping p(Block block) {
        return new TextureMapping().a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping q(Block block) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.C(block));
    }

    public static TextureMapping h(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.c, id);
    }

    public static TextureMapping r(Block block) {
        return new TextureMapping().a(TextureSlot.C, TextureMapping.a(block, "_0"));
    }

    public static TextureMapping s(Block block) {
        return new TextureMapping().a(TextureSlot.C, TextureMapping.a(block, "_1"));
    }

    public static TextureMapping t(Block block) {
        return new TextureMapping().a(TextureSlot.D, TextureMapping.C(block));
    }

    public static TextureMapping u(Block block) {
        return new TextureMapping().a(TextureSlot.G, TextureMapping.C(block));
    }

    public static TextureMapping i(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.G, id);
    }

    public static TextureMapping a(Item item) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.c(item));
    }

    public static TextureMapping v(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.h, TextureMapping.a(block, "_back"));
    }

    public static TextureMapping w(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping x(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.f, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping y(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.d, TextureMapping.a(block, "_end"));
    }

    public static TextureMapping z(Block top) {
        return new TextureMapping().a(TextureSlot.f, TextureMapping.a(top, "_top"));
    }

    public static TextureMapping c(Block block, Block bottom) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(block, "_front")).a(TextureSlot.o, TextureMapping.C(bottom)).a(TextureSlot.n, TextureMapping.a(block, "_top")).a(TextureSlot.j, TextureMapping.a(block, "_front")).a(TextureSlot.l, TextureMapping.a(block, "_side")).a(TextureSlot.k, TextureMapping.a(block, "_side")).a(TextureSlot.m, TextureMapping.a(block, "_front"));
    }

    public static TextureMapping d(Block frontTopSideBlock, Block downBlock) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(frontTopSideBlock, "_front")).a(TextureSlot.o, TextureMapping.C(downBlock)).a(TextureSlot.n, TextureMapping.a(frontTopSideBlock, "_top")).a(TextureSlot.j, TextureMapping.a(frontTopSideBlock, "_front")).a(TextureSlot.k, TextureMapping.a(frontTopSideBlock, "_front")).a(TextureSlot.l, TextureMapping.a(frontTopSideBlock, "_side")).a(TextureSlot.m, TextureMapping.a(frontTopSideBlock, "_side"));
    }

    public static TextureMapping A(Block block) {
        return new TextureMapping().a(TextureSlot.I, TextureMapping.a(block, "_log_lit")).a(TextureSlot.C, TextureMapping.a(block, "_fire"));
    }

    public static TextureMapping a(Block block, boolean lit) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.de, "_side")).a(TextureSlot.e, TextureMapping.a(Blocks.de, "_bottom")).a(TextureSlot.f, TextureMapping.a(Blocks.de, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.de, "_side")).a(TextureSlot.J, TextureMapping.a(block, lit ? "_lit" : ""));
    }

    public static TextureMapping j(MinecraftKey content) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.ek, "_side")).a(TextureSlot.i, TextureMapping.a(Blocks.ek, "_side")).a(TextureSlot.f, TextureMapping.a(Blocks.ek, "_top")).a(TextureSlot.e, TextureMapping.a(Blocks.ek, "_bottom")).a(TextureSlot.K, TextureMapping.a(Blocks.ek, "_inner")).a(TextureSlot.L, content);
    }

    public static TextureMapping b(Item item) {
        return new TextureMapping().a(TextureSlot.H, TextureMapping.c(item));
    }

    public static TextureMapping B(Block block) {
        return new TextureMapping().a(TextureSlot.H, TextureMapping.C(block));
    }

    public static TextureMapping k(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.H, id);
    }

    public static MinecraftKey C(Block block) {
        MinecraftKey resourceLocation = IRegistry.X.b(block);
        return new MinecraftKey(resourceLocation.b(), "block/" + resourceLocation.a());
    }

    public static MinecraftKey a(Block block, String suffix) {
        MinecraftKey resourceLocation = IRegistry.X.b(block);
        return new MinecraftKey(resourceLocation.b(), "block/" + resourceLocation.a() + suffix);
    }

    public static MinecraftKey c(Item item) {
        MinecraftKey resourceLocation = IRegistry.aa.b(item);
        return new MinecraftKey(resourceLocation.b(), "item/" + resourceLocation.a());
    }

    public static MinecraftKey a(Item item, String suffix) {
        MinecraftKey resourceLocation = IRegistry.aa.b(item);
        return new MinecraftKey(resourceLocation.b(), "item/" + resourceLocation.a() + suffix);
    }
}

