/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.block.state.properties.Tilt;

public class BlockModelGenerators {
    final Consumer<BlockStateGenerator> b;
    final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;
    private final Consumer<Item> d;
    final List<Block> e = ImmutableList.of((Object)Blocks.dw, (Object)Blocks.dB, (Object)Blocks.gD);
    final Map<Block, c> f = ImmutableMap.builder().put((Object)Blocks.b, BlockModelGenerators::a).put((Object)Blocks.pN, BlockModelGenerators::b).build();
    final Map<Block, TexturedModel> g = ImmutableMap.builder().put((Object)Blocks.az, (Object)TexturedModel.t.get(Blocks.az)).put((Object)Blocks.hU, (Object)TexturedModel.t.get(Blocks.hU)).put((Object)Blocks.is, (Object)TexturedModel.a(TextureMapping.a(Blocks.az, "_top"))).put((Object)Blocks.iu, (Object)TexturedModel.a(TextureMapping.a(Blocks.hU, "_top"))).put((Object)Blocks.aB, (Object)TexturedModel.c.get(Blocks.az).a((TextureMapping textureMapping) -> textureMapping.a(TextureSlot.i, TextureMapping.C(Blocks.aB)))).put((Object)Blocks.hW, (Object)TexturedModel.c.get(Blocks.hU).a((TextureMapping textureMapping) -> textureMapping.a(TextureSlot.i, TextureMapping.C(Blocks.hW)))).put((Object)Blocks.fM, (Object)TexturedModel.c.get(Blocks.fM)).put((Object)Blocks.it, (Object)TexturedModel.a(TextureMapping.a(Blocks.fM, "_bottom"))).put((Object)Blocks.nD, (Object)TexturedModel.u.get(Blocks.nD)).put((Object)Blocks.pN, (Object)TexturedModel.u.get(Blocks.pN)).put((Object)Blocks.fN, (Object)TexturedModel.c.get(Blocks.fN).a((TextureMapping textureMapping) -> textureMapping.a(TextureSlot.i, TextureMapping.C(Blocks.fN)))).put((Object)Blocks.aA, (Object)TexturedModel.c.get(Blocks.aA).a((TextureMapping texture) -> {
        texture.a(TextureSlot.d, TextureMapping.a(Blocks.az, "_top"));
        texture.a(TextureSlot.i, TextureMapping.C(Blocks.aA));
    })).put((Object)Blocks.hV, (Object)TexturedModel.c.get(Blocks.hV).a((TextureMapping texture) -> {
        texture.a(TextureSlot.d, TextureMapping.a(Blocks.hU, "_top"));
        texture.a(TextureSlot.i, TextureMapping.C(Blocks.hV));
    })).build();
    static final Map<BlockFamily.b, BiConsumer<b, Block>> h = ImmutableMap.builder().put((Object)BlockFamily.b.a, b::a).put((Object)BlockFamily.b.e, b::j).put((Object)BlockFamily.b.b, b::i).put((Object)BlockFamily.b.c, b::i).put((Object)BlockFamily.b.f, b::c).put((Object)BlockFamily.b.g, b::d).put((Object)BlockFamily.b.h, b::f).put((Object)BlockFamily.b.i, b::g).put((Object)BlockFamily.b.j, b::h).put((Object)BlockFamily.b.k, b::e).put((Object)BlockFamily.b.m, b::k).put((Object)BlockFamily.b.n, b::b).build();
    public static final Map<BlockStateBoolean, Function<MinecraftKey, Variant>> a = SystemUtils.a(Maps.newHashMap(), (T map) -> {
        map.put(BlockProperties.J, id -> Variant.a().a(VariantProperties.c, id));
        map.put(BlockProperties.K, id -> Variant.a().a(VariantProperties.c, id).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true));
        map.put(BlockProperties.L, id -> Variant.a().a(VariantProperties.c, id).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true));
        map.put(BlockProperties.M, id -> Variant.a().a(VariantProperties.c, id).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
        map.put(BlockProperties.H, id -> Variant.a().a(VariantProperties.c, id).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true));
        map.put(BlockProperties.I, id -> Variant.a().a(VariantProperties.c, id).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true));
    });

    private static BlockStateGenerator a(Block block, MinecraftKey modelId, TextureMapping texture, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.d.a(block, texture, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation);
    }

    private static BlockStateGenerator b(Block block, MinecraftKey modelId, TextureMapping texture, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.g.a(block, texture, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation).a(BlockModelGenerators.f());
    }

    public BlockModelGenerators(Consumer<BlockStateGenerator> blockStateCollector, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector, Consumer<Item> simpleItemModelExemptionCollector) {
        this.b = blockStateCollector;
        this.c = modelCollector;
        this.d = simpleItemModelExemptionCollector;
    }

    void a(Block block) {
        this.d.accept(block.k());
    }

    void a(Block block, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(block.k()), new DelegatedModel(parentModelId));
    }

    private void a(Item item, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(item), new DelegatedModel(parentModelId));
    }

    void a(Item item) {
        ModelTemplates.aR.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void b(Block block) {
        Item item = block.k();
        if (item != Items.a) {
            ModelTemplates.aR.a(ModelLocationUtils.a(item), TextureMapping.B(block), this.c);
        }
    }

    private void a(Block block, String textureSuffix) {
        Item item = block.k();
        ModelTemplates.aR.a(ModelLocationUtils.a(item), TextureMapping.k(TextureMapping.a(block, textureSuffix)), this.c);
    }

    private static PropertyDispatch b() {
        return PropertyDispatch.a(BlockProperties.P).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a());
    }

    private static PropertyDispatch c() {
        return PropertyDispatch.a(BlockProperties.P).a(EnumDirection.d, Variant.a()).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch d() {
        return PropertyDispatch.a(BlockProperties.P).a(EnumDirection.f, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch e() {
        return PropertyDispatch.a(BlockProperties.N).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.b, Variant.a().a(VariantProperties.a, VariantProperties.a.d)).a(EnumDirection.c, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b));
    }

    private static MultiVariantGenerator b(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, BlockModelGenerators.a(modelId));
    }

    private static Variant[] a(MinecraftKey modelId) {
        return new Variant[]{Variant.a().a(VariantProperties.c, modelId), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.d)};
    }

    private static MultiVariantGenerator a(Block block, MinecraftKey firstModelId, MinecraftKey secondModelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, firstModelId), Variant.a().a(VariantProperties.c, secondModelId), Variant.a().a(VariantProperties.c, firstModelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, secondModelId).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static PropertyDispatch a(BlockStateBoolean property, MinecraftKey trueModel, MinecraftKey falseModel) {
        return PropertyDispatch.a(property).a((Boolean)true, Variant.a().a(VariantProperties.c, trueModel)).a((Boolean)false, Variant.a().a(VariantProperties.c, falseModel));
    }

    private void c(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.b.create(block, this.c);
        this.b.accept(BlockModelGenerators.a(block, resourceLocation, resourceLocation2));
    }

    private void d(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        this.b.accept(BlockModelGenerators.b(block, resourceLocation));
    }

    static BlockStateGenerator b(Block buttonBlock, MinecraftKey regularModelId, MinecraftKey pressedModelId) {
        return MultiVariantGenerator.a(buttonBlock).a(PropertyDispatch.a(BlockProperties.w).a((Boolean)false, Variant.a().a(VariantProperties.c, regularModelId)).a((Boolean)true, Variant.a().a(VariantProperties.c, pressedModelId))).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.P).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c)));
    }

    private static PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> a(PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> variantMap, BlockPropertyDoubleBlockHalf targetHalf, MinecraftKey regularModel, MinecraftKey hingeModel) {
        return variantMap.a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, regularModel)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, regularModel).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, regularModel).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, regularModel).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, hingeModel)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, hingeModel).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, hingeModel).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, hingeModel).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, hingeModel).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, hingeModel).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, hingeModel).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, hingeModel)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, regularModel).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, regularModel)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, regularModel).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, regularModel).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static BlockStateGenerator a(Block doorBlock, MinecraftKey bottomModelId, MinecraftKey bottomHingeModelId, MinecraftKey topModelId, MinecraftKey topHingeModelId) {
        return MultiVariantGenerator.a(doorBlock).a(BlockModelGenerators.a(BlockModelGenerators.a(PropertyDispatch.a(BlockProperties.P, BlockProperties.ab, BlockProperties.ba, BlockProperties.u), BlockPropertyDoubleBlockHalf.b, bottomModelId, bottomHingeModelId), BlockPropertyDoubleBlockHalf.a, topModelId, topHingeModelId));
    }

    static BlockStateGenerator c(Block fenceBlock, MinecraftKey postModelId, MinecraftKey sideModelId) {
        return MultiPartGenerator.a(fenceBlock).a(Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator a(Block wallBlock, MinecraftKey postModelId, MinecraftKey lowSideModelId, MinecraftKey tallSideModelId) {
        return MultiPartGenerator.a(wallBlock).a((Condition)Condition.a().a(BlockProperties.H, true), Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.U, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.T, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.V, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.W, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.U, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.T, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.V, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.W, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator b(Block fenceGateBlock, MinecraftKey openModelId, MinecraftKey closedModelId, MinecraftKey openWallModelId, MinecraftKey closedWallModelId) {
        return MultiVariantGenerator.a(fenceGateBlock, Variant.a().a(VariantProperties.d, true)).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.q, BlockProperties.u).a((Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, closedModelId)).a((Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, closedWallModelId)).a((Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a((Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, openWallModelId)));
    }

    static BlockStateGenerator b(Block stairsBlock, MinecraftKey innerModelId, MinecraftKey regularModelId, MinecraftKey outerModelId) {
        return MultiVariantGenerator.a(stairsBlock).a(PropertyDispatch.a(BlockProperties.P, BlockProperties.ac, BlockProperties.be).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)));
    }

    private static BlockStateGenerator c(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.P, BlockProperties.ac, BlockProperties.u).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.a)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private static BlockStateGenerator d(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.P, BlockProperties.ac, BlockProperties.u).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)));
    }

    static MultiVariantGenerator c(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId));
    }

    private static PropertyDispatch f() {
        return PropertyDispatch.a(BlockProperties.G).a(EnumDirection.EnumAxis.b, Variant.a()).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    static BlockStateGenerator d(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId)).a(BlockModelGenerators.f());
    }

    private void e(Block block, MinecraftKey modelId) {
        this.b.accept(BlockModelGenerators.d(block, modelId));
    }

    private void a(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation));
    }

    private void b(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    static BlockStateGenerator d(Block block, MinecraftKey verticalModelId, MinecraftKey horizontalModelId) {
        return MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.G).a(EnumDirection.EnumAxis.b, Variant.a().a(VariantProperties.c, verticalModelId)).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private void a(Block block, TexturedModel.a verticalModelFactory, TexturedModel.a horizontalModelFactory) {
        MinecraftKey resourceLocation = verticalModelFactory.create(block, this.c);
        MinecraftKey resourceLocation2 = horizontalModelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation, resourceLocation2));
    }

    private MinecraftKey a(Block block, String suffix, ModelTemplate model, Function<MinecraftKey, TextureMapping> textureFactory) {
        return model.a(block, suffix, textureFactory.apply(TextureMapping.a(block, suffix)), this.c);
    }

    static BlockStateGenerator e(Block pressurePlateBlock, MinecraftKey upModelId, MinecraftKey downModelId) {
        return MultiVariantGenerator.a(pressurePlateBlock).a(BlockModelGenerators.a(BlockProperties.w, downModelId, upModelId));
    }

    static BlockStateGenerator e(Block slabBlock, MinecraftKey bottomModelId, MinecraftKey topModelId, MinecraftKey fullModelId) {
        return MultiVariantGenerator.a(slabBlock).a(PropertyDispatch.a(BlockProperties.bd).a(BlockPropertySlabType.b, Variant.a().a(VariantProperties.c, bottomModelId)).a(BlockPropertySlabType.a, Variant.a().a(VariantProperties.c, topModelId)).a(BlockPropertySlabType.c, Variant.a().a(VariantProperties.c, fullModelId)));
    }

    private void e(Block block) {
        this.c(block, TexturedModel.a);
    }

    private void c(Block block, TexturedModel.a modelFactory) {
        this.b.accept(BlockModelGenerators.c(block, modelFactory.create(block, this.c)));
    }

    private void a(Block block, TextureMapping texture, ModelTemplate model) {
        MinecraftKey resourceLocation = model.a(block, texture, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private b f(Block block) {
        TexturedModel texturedModel = this.g.getOrDefault(block, TexturedModel.a.get(block));
        return new b(texturedModel.b()).a(block, texturedModel.a());
    }

    void g(Block doorBlock) {
        TextureMapping textureMapping = TextureMapping.p(doorBlock);
        MinecraftKey resourceLocation = ModelTemplates.p.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.q.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.r.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.s.a(doorBlock, textureMapping, this.c);
        this.a(doorBlock.k());
        this.b.accept(BlockModelGenerators.a(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
    }

    void h(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.Q.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.R.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.S.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    void i(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.N.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.O.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.P.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.d(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    private void g() {
        this.a(Blocks.pI);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.pI);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.pI, "_partial_tilt");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.pI, "_full_tilt");
        this.b.accept(MultiVariantGenerator.a(Blocks.pI).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.bh).a(Tilt.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.b, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(Tilt.d, Variant.a().a(VariantProperties.c, resourceLocation3))));
    }

    private e j(Block logBlock) {
        return new e(TextureMapping.l(logBlock));
    }

    private void k(Block block) {
        this.a(block, block);
    }

    private void a(Block block, Block modelReference) {
        this.b.accept(BlockModelGenerators.c(block, ModelLocationUtils.a(modelReference)));
    }

    private void a(Block block, d tintType) {
        this.b(block);
        this.b(block, tintType);
    }

    private void a(Block block, d tintType, TextureMapping texture) {
        this.b(block);
        this.b(block, tintType, texture);
    }

    private void b(Block block, d tintType) {
        TextureMapping textureMapping = TextureMapping.c(block);
        this.b(block, tintType, textureMapping);
    }

    private void b(Block block, d tintType, TextureMapping crossTexture) {
        MinecraftKey resourceLocation = tintType.a().a(block, crossTexture, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void a(Block plantBlock, Block flowerPotBlock, d tintType) {
        this.a(plantBlock, tintType);
        TextureMapping textureMapping = TextureMapping.d(plantBlock);
        MinecraftKey resourceLocation = tintType.b().a(flowerPotBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(flowerPotBlock, resourceLocation));
    }

    private void b(Block coralFanBlock, Block coralWallFanBlock) {
        TexturedModel texturedModel = TexturedModel.k.get(coralFanBlock);
        MinecraftKey resourceLocation = texturedModel.a(coralFanBlock, this.c);
        this.b.accept(BlockModelGenerators.c(coralFanBlock, resourceLocation));
        MinecraftKey resourceLocation2 = ModelTemplates.ae.a(coralWallFanBlock, texturedModel.b(), this.c);
        this.b.accept(MultiVariantGenerator.a(coralWallFanBlock, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockModelGenerators.b()));
        this.b(coralFanBlock);
    }

    private void c(Block stemBlock, Block attachedStemBlock) {
        this.a(stemBlock.k());
        TextureMapping textureMapping = TextureMapping.g(stemBlock);
        TextureMapping textureMapping2 = TextureMapping.a(stemBlock, attachedStemBlock);
        MinecraftKey resourceLocation = ModelTemplates.aq.a(attachedStemBlock, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(attachedStemBlock, Variant.a().a(VariantProperties.c, resourceLocation)).a(PropertyDispatch.a(BlockProperties.P).a(EnumDirection.e, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.c))));
        this.b.accept(MultiVariantGenerator.a(stemBlock).a(PropertyDispatch.a(BlockProperties.aq).a((T1 integer) -> Variant.a().a(VariantProperties.c, ModelTemplates.ap[integer].a(stemBlock, textureMapping, this.c)))));
    }

    private void a(Block coral, Block deadCoral, Block coralBlock, Block deadCoralBlock, Block coralFan, Block deadCoralFan, Block coralWallFan, Block deadCoralWallFan) {
        this.a(coral, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(deadCoral, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.e(coralBlock);
        this.e(deadCoralBlock);
        this.b(coralFan, coralWallFan);
        this.b(deadCoralFan, deadCoralWallFan);
    }

    private void c(Block doubleBlock, d tintType) {
        this.a(doubleBlock, "_top");
        MinecraftKey resourceLocation = this.a(doubleBlock, "_top", tintType.a(), TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(doubleBlock, "_bottom", tintType.a(), TextureMapping::c);
        this.f(doubleBlock, resourceLocation, resourceLocation2);
    }

    private void h() {
        this.a(Blocks.hi, "_front");
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.hi, "_top");
        MinecraftKey resourceLocation2 = this.a(Blocks.hi, "_bottom", net.minecraft.data.models.BlockModelGenerators$d.b.a(), TextureMapping::c);
        this.f(Blocks.hi, resourceLocation, resourceLocation2);
    }

    private void i() {
        MinecraftKey resourceLocation = this.a(Blocks.bb, "_top", ModelTemplates.aG, TextureMapping::a);
        MinecraftKey resourceLocation2 = this.a(Blocks.bb, "_bottom", ModelTemplates.aG, TextureMapping::a);
        this.f(Blocks.bb, resourceLocation, resourceLocation2);
    }

    private void j() {
        this.a(Blocks.pK);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.pK, "_top");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.pK, "_bottom");
        this.b.accept(MultiVariantGenerator.a(Blocks.pK).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.ab).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, resourceLocation))));
    }

    private void f(Block block, MinecraftKey upperHalfModelId, MinecraftKey lowerHalfModelId) {
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.ab).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, lowerHalfModelId)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, upperHalfModelId))));
    }

    private void l(Block rail) {
        TextureMapping textureMapping = TextureMapping.e(rail);
        TextureMapping textureMapping2 = TextureMapping.e(TextureMapping.a(rail, "_corner"));
        MinecraftKey resourceLocation = ModelTemplates.Y.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.Z.a(rail, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aa.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.ab.a(rail, textureMapping, this.c);
        this.b(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(PropertyDispatch.a(BlockProperties.ad).a(BlockPropertyTrackPosition.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockPropertyTrackPosition.b, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.e, Variant.a().a(VariantProperties.c, resourceLocation3)).a(BlockPropertyTrackPosition.f, Variant.a().a(VariantProperties.c, resourceLocation4)).a(BlockPropertyTrackPosition.g, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyTrackPosition.h, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.i, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyTrackPosition.j, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void m(Block rail) {
        MinecraftKey resourceLocation = this.a(rail, "", ModelTemplates.Y, TextureMapping::e);
        MinecraftKey resourceLocation2 = this.a(rail, "", ModelTemplates.aa, TextureMapping::e);
        MinecraftKey resourceLocation3 = this.a(rail, "", ModelTemplates.ab, TextureMapping::e);
        MinecraftKey resourceLocation4 = this.a(rail, "_on", ModelTemplates.Y, TextureMapping::e);
        MinecraftKey resourceLocation5 = this.a(rail, "_on", ModelTemplates.aa, TextureMapping::e);
        MinecraftKey resourceLocation6 = this.a(rail, "_on", ModelTemplates.ab, TextureMapping::e);
        PropertyDispatch propertyDispatch = PropertyDispatch.a(BlockProperties.w, BlockProperties.ae).a((T1 boolean_, T2 shape) -> {
            switch (shape) {
                case a: {
                    return Variant.a().a(VariantProperties.c, boolean_ != false ? resourceLocation4 : resourceLocation);
                }
                case b: {
                    return Variant.a().a(VariantProperties.c, boolean_ != false ? resourceLocation4 : resourceLocation).a(VariantProperties.b, VariantProperties.a.b);
                }
                case c: {
                    return Variant.a().a(VariantProperties.c, boolean_ != false ? resourceLocation5 : resourceLocation2).a(VariantProperties.b, VariantProperties.a.b);
                }
                case d: {
                    return Variant.a().a(VariantProperties.c, boolean_ != false ? resourceLocation6 : resourceLocation3).a(VariantProperties.b, VariantProperties.a.b);
                }
                case e: {
                    return Variant.a().a(VariantProperties.c, boolean_ != false ? resourceLocation5 : resourceLocation2);
                }
                case f: {
                    return Variant.a().a(VariantProperties.c, boolean_ != false ? resourceLocation6 : resourceLocation3);
                }
            }
            throw new UnsupportedOperationException("Fix you generator!");
        });
        this.b(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(propertyDispatch));
    }

    private a a(MinecraftKey modelId, Block particleBlock) {
        return new a(modelId, particleBlock);
    }

    private a d(Block block, Block particleBlock) {
        return new a(ModelLocationUtils.a(block), particleBlock);
    }

    private void a(Block block, Item particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.G.a(block, TextureMapping.a(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void f(Block block, MinecraftKey particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.G.a(block, TextureMapping.h(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void e(Block wool, Block carpet) {
        this.e(wool);
        MinecraftKey resourceLocation = TexturedModel.i.get(wool).a(carpet, this.c);
        this.b.accept(BlockModelGenerators.c(carpet, resourceLocation));
    }

    private void a(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(BlockModelGenerators.b(block, resourceLocation));
        }
    }

    private void b(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void f(Block glass, Block glassPane) {
        this.e(glass);
        TextureMapping textureMapping = TextureMapping.b(glass, glassPane);
        MinecraftKey resourceLocation = ModelTemplates.ak.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.al.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.am.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.ai.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.aj.a(glassPane, textureMapping, this.c);
        Item item = glassPane.k();
        ModelTemplates.aR.a(ModelLocationUtils.a(item), TextureMapping.B(glass), this.c);
        this.b.accept(MultiPartGenerator.a(glassPane).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.J, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void n(Block commandBlock) {
        TextureMapping textureMapping = TextureMapping.v(commandBlock);
        MinecraftKey resourceLocation = ModelTemplates.an.a(commandBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(commandBlock, "_conditional", ModelTemplates.an, (MinecraftKey id) -> textureMapping.c(TextureSlot.i, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(commandBlock).a(BlockModelGenerators.a(BlockProperties.c, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void o(Block anvil) {
        MinecraftKey resourceLocation = TexturedModel.m.create(anvil, this.c);
        this.b.accept(BlockModelGenerators.c(anvil, resourceLocation).a(BlockModelGenerators.c()));
    }

    private List<Variant> a(int age) {
        String string = "_age" + age;
        return IntStream.range(1, 5).mapToObj(i2 -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.lm, i2 + string))).collect(Collectors.toList());
    }

    private void k() {
        this.a(Blocks.lm);
        this.b.accept(MultiPartGenerator.a(Blocks.lm).a((Condition)Condition.a().a(BlockProperties.am, 0), this.a(0)).a((Condition)Condition.a().a(BlockProperties.am, 1), this.a(1)).a((Condition)Condition.a().a(BlockProperties.bg, BlockPropertyBambooSize.b), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.lm, "_small_leaves"))).a((Condition)Condition.a().a(BlockProperties.bg, BlockPropertyBambooSize.c), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.lm, "_large_leaves"))));
    }

    private PropertyDispatch l() {
        return PropertyDispatch.a(BlockProperties.N).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a()).a(EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    private void m() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.mg, "_top_open");
        this.b.accept(MultiVariantGenerator.a(Blocks.mg).a(this.l()).a(PropertyDispatch.a(BlockProperties.u).a((Boolean)false, Variant.a().a(VariantProperties.c, TexturedModel.e.create(Blocks.mg, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, TexturedModel.e.get(Blocks.mg).a((TextureMapping textureMapping) -> textureMapping.a(TextureSlot.f, resourceLocation)).a(Blocks.mg, "_open", this.c)))));
    }

    private static <T extends Comparable<T>> PropertyDispatch a(IBlockState<T> property, T fence, MinecraftKey higherOrEqualModelId, MinecraftKey lowerModelId) {
        Variant variant = Variant.a().a(VariantProperties.c, higherOrEqualModelId);
        Variant variant2 = Variant.a().a(VariantProperties.c, lowerModelId);
        return PropertyDispatch.a(property).a((T1 comparable2) -> {
            boolean bl = comparable2.compareTo(fence) >= 0;
            return bl ? variant : variant2;
        });
    }

    private void a(Block beehive, Function<Block, TextureMapping> textureGetter) {
        TextureMapping textureMapping = textureGetter.apply(beehive).b(TextureSlot.i, TextureSlot.c);
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.g, TextureMapping.a(beehive, "_front_honey"));
        MinecraftKey resourceLocation = ModelTemplates.k.a(beehive, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.k.a(beehive, "_honey", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(beehive).a(BlockModelGenerators.b()).a(BlockModelGenerators.a(BlockProperties.aI, 5, resourceLocation2, resourceLocation)));
    }

    private void a(Block crop, IBlockState<Integer> ageProperty, int ... ageTextureIndices) {
        if (ageProperty.a().size() != ageTextureIndices.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        PropertyDispatch propertyDispatch = PropertyDispatch.a(ageProperty).a(arg_0 -> this.a(ageTextureIndices, (Int2ObjectMap)int2ObjectMap, crop, arg_0));
        this.a(crop.k());
        this.b.accept(MultiVariantGenerator.a(crop).a(propertyDispatch));
    }

    private void n() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.mp, "_floor");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.mp, "_ceiling");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.mp, "_wall");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.mp, "_between_walls");
        this.a(Items.tl);
        this.b.accept(MultiVariantGenerator.a(Blocks.mp).a(PropertyDispatch.a(BlockProperties.P, BlockProperties.S).a(EnumDirection.c, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.d, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.d, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3)).a(EnumDirection.e, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4)).a(EnumDirection.e, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c))));
    }

    private void o() {
        this.b.accept(MultiVariantGenerator.a(Blocks.ml, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ml))).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.P).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void d(Block cooker, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(cooker, this.c);
        MinecraftKey resourceLocation2 = TextureMapping.a(cooker, "_front_on");
        MinecraftKey resourceLocation3 = modelFactory.get(cooker).a((TextureMapping texture) -> texture.a(TextureSlot.g, resourceLocation2)).a(cooker, "_on", this.c);
        this.b.accept(MultiVariantGenerator.a(cooker).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void a(Block ... blocks) {
        MinecraftKey resourceLocation = ModelLocationUtils.a("campfire_off");
        for (Block block : blocks) {
            MinecraftKey resourceLocation2 = ModelTemplates.ay.a(block, TextureMapping.A(block), this.c);
            this.a(block.k());
            this.b.accept(MultiVariantGenerator.a(block).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void p(Block block) {
        MinecraftKey resourceLocation = ModelTemplates.aP.a(block, TextureMapping.k(block), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void q(Block block) {
        MinecraftKey resourceLocation = ModelTemplates.aQ.a(block, TextureMapping.k(block), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void p() {
        TextureMapping textureMapping = TextureMapping.a(TextureMapping.C(Blocks.bO), TextureMapping.C(Blocks.n));
        MinecraftKey resourceLocation = ModelTemplates.e.a(Blocks.bO, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(Blocks.bO, resourceLocation));
    }

    private void q() {
        this.a(Items.kn);
        this.b.accept(MultiPartGenerator.a(Blocks.bY).a(Condition.b(Condition.a().a(BlockProperties.Y, BlockPropertyRedstoneSide.c).a(BlockProperties.X, BlockPropertyRedstoneSide.c).a(BlockProperties.Z, BlockPropertyRedstoneSide.c).a(BlockProperties.aa, BlockPropertyRedstoneSide.c), Condition.a().a(BlockProperties.Y, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.X, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.X, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.Z, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.Z, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.Y, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a})), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_dot"))).a((Condition)Condition.a().a(BlockProperties.Y, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side0"))).a((Condition)Condition.a().a(BlockProperties.Z, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt0"))).a((Condition)Condition.a().a(BlockProperties.X, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.Y, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up"))).a((Condition)Condition.a().a(BlockProperties.X, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.Z, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.aa, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void r() {
        this.a(Items.kr);
        this.b.accept(MultiVariantGenerator.a(Blocks.fH).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.aZ, BlockProperties.w).a(BlockPropertyComparatorMode.a, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH))).a(BlockPropertyComparatorMode.a, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_on"))).a(BlockPropertyComparatorMode.b, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_subtract"))).a(BlockPropertyComparatorMode.b, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_on_subtract")))));
    }

    private void s() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.ir);
        TextureMapping textureMapping2 = TextureMapping.a(TextureMapping.a(Blocks.if, "_side"), textureMapping.a(TextureSlot.f));
        MinecraftKey resourceLocation = ModelTemplates.H.a(Blocks.if, textureMapping2, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.I.a(Blocks.if, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.e.b(Blocks.if, "_double", textureMapping2, this.c);
        this.b.accept(BlockModelGenerators.e(Blocks.if, resourceLocation, resourceLocation2, resourceLocation3));
        this.b.accept(BlockModelGenerators.c(Blocks.ir, ModelTemplates.c.a(Blocks.ir, textureMapping, this.c)));
    }

    private void t() {
        this.a(Items.pL);
        this.b.accept(MultiPartGenerator.a(Blocks.ej).a(Variant.a().a(VariantProperties.c, TextureMapping.C(Blocks.ej))).a((Condition)Condition.a().a(BlockProperties.k, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.ej, "_bottle0"))).a((Condition)Condition.a().a(BlockProperties.l, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.ej, "_bottle1"))).a((Condition)Condition.a().a(BlockProperties.m, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.ej, "_bottle2"))).a((Condition)Condition.a().a(BlockProperties.k, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.ej, "_empty0"))).a((Condition)Condition.a().a(BlockProperties.l, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.ej, "_empty1"))).a((Condition)Condition.a().a(BlockProperties.m, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.ej, "_empty2"))));
    }

    private void r(Block mushroomBlock) {
        MinecraftKey resourceLocation = ModelTemplates.aL.a(mushroomBlock, TextureMapping.b(mushroomBlock), this.c);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a("mushroom_block_inside");
        this.b.accept(MultiPartGenerator.a(mushroomBlock).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.H, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.I, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.H, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.I, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, false)));
        this.a(mushroomBlock, TexturedModel.a.createWithSuffix(mushroomBlock, "_inventory", this.c));
    }

    private void u() {
        this.a(Items.oX);
        this.b.accept(MultiVariantGenerator.a(Blocks.de).a(PropertyDispatch.a(BlockProperties.at).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.de))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.de, "_slice1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.de, "_slice2"))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.de, "_slice3"))).a((Integer)4, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.de, "_slice4"))).a((Integer)5, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.de, "_slice5"))).a((Integer)6, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.de, "_slice6")))));
    }

    private void v() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.mj, "_side3")).a(TextureSlot.o, TextureMapping.C(Blocks.s)).a(TextureSlot.n, TextureMapping.a(Blocks.mj, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.mj, "_side3")).a(TextureSlot.l, TextureMapping.a(Blocks.mj, "_side3")).a(TextureSlot.k, TextureMapping.a(Blocks.mj, "_side1")).a(TextureSlot.m, TextureMapping.a(Blocks.mj, "_side2"));
        this.b.accept(BlockModelGenerators.c(Blocks.mj, ModelTemplates.a.a(Blocks.mj, textureMapping, this.c)));
    }

    private void w() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.mn, "_front")).a(TextureSlot.o, TextureMapping.a(Blocks.mn, "_bottom")).a(TextureSlot.n, TextureMapping.a(Blocks.mn, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.mn, "_front")).a(TextureSlot.k, TextureMapping.a(Blocks.mn, "_front")).a(TextureSlot.l, TextureMapping.a(Blocks.mn, "_side")).a(TextureSlot.m, TextureMapping.a(Blocks.mn, "_side"));
        this.b.accept(BlockModelGenerators.c(Blocks.mn, ModelTemplates.a.a(Blocks.mn, textureMapping, this.c)));
    }

    private void a(Block block, Block otherTextureSource, BiFunction<Block, Block, TextureMapping> textureFactory) {
        TextureMapping textureMapping = textureFactory.apply(block, otherTextureSource);
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.a.a(block, textureMapping, this.c)));
    }

    private void x() {
        TextureMapping textureMapping = TextureMapping.j(Blocks.cS);
        this.b.accept(BlockModelGenerators.c(Blocks.cS, ModelLocationUtils.a(Blocks.cS)));
        this.a(Blocks.dc, textureMapping);
        this.a(Blocks.dd, textureMapping);
    }

    private void a(Block block, TextureMapping texture) {
        MinecraftKey resourceLocation = ModelTemplates.j.a(block, texture.c(TextureSlot.g, TextureMapping.C(block)), this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void y() {
        this.a(Items.pM);
        this.k(Blocks.ek);
        this.b.accept(BlockModelGenerators.c(Blocks.em, ModelTemplates.aO.a(Blocks.em, TextureMapping.j(TextureMapping.a(Blocks.B, "_still")), this.c)));
        this.b.accept(MultiVariantGenerator.a(Blocks.el).a(PropertyDispatch.a(LayeredCauldronBlock.e).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.aM.a(Blocks.el, "_level1", TextureMapping.j(TextureMapping.a(Blocks.A, "_still")), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.aN.a(Blocks.el, "_level2", TextureMapping.j(TextureMapping.a(Blocks.A, "_still")), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.aO.a(Blocks.el, "_full", TextureMapping.j(TextureMapping.a(Blocks.A, "_still")), this.c)))));
        this.b.accept(MultiVariantGenerator.a(Blocks.en).a(PropertyDispatch.a(LayeredCauldronBlock.e).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.aM.a(Blocks.en, "_level1", TextureMapping.j(TextureMapping.C(Blocks.oO)), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.aN.a(Blocks.en, "_level2", TextureMapping.j(TextureMapping.C(Blocks.oO)), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.aO.a(Blocks.en, "_full", TextureMapping.j(TextureMapping.C(Blocks.oO)), this.c)))));
    }

    private void z() {
        TextureMapping textureMapping = TextureMapping.b(Blocks.iM);
        MinecraftKey resourceLocation = ModelTemplates.ag.a(Blocks.iM, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.iM, "_dead", ModelTemplates.ag, (MinecraftKey id) -> textureMapping.c(TextureSlot.b, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(Blocks.iM).a(BlockModelGenerators.a(BlockProperties.ap, 5, resourceLocation2, resourceLocation)));
    }

    private void s(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.cf, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.cf, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front"));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.i, TextureMapping.a(Blocks.cf, "_top")).a(TextureSlot.g, TextureMapping.a(block, "_front_vertical"));
        MinecraftKey resourceLocation = ModelTemplates.j.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.l.a(block, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.N).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void A() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.ep);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.ep, "_filled");
        this.b.accept(MultiVariantGenerator.a(Blocks.ep).a(PropertyDispatch.a(BlockProperties.h).a((Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation2))).a(BlockModelGenerators.c()));
    }

    private void B() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.iL, "_side");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.iL, "_noside");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.iL, "_noside1");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.iL, "_noside2");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.iL, "_noside3");
        this.b.accept(MultiPartGenerator.a(Blocks.iL).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.H, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.I, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2), Variant.a().a(VariantProperties.c, resourceLocation3), Variant.a().a(VariantProperties.c, resourceLocation4), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.H, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.I, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)));
    }

    private void C() {
        this.b.accept(MultiPartGenerator.a(Blocks.no).a(Variant.a().a(VariantProperties.c, TextureMapping.C(Blocks.no))).a((Condition)Condition.a().a(BlockProperties.aG, 1), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents1"))).a((Condition)Condition.a().a(BlockProperties.aG, 2), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents2"))).a((Condition)Condition.a().a(BlockProperties.aG, 3), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents3"))).a((Condition)Condition.a().a(BlockProperties.aG, 4), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents4"))).a((Condition)Condition.a().a(BlockProperties.aG, 5), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents5"))).a((Condition)Condition.a().a(BlockProperties.aG, 6), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents6"))).a((Condition)Condition.a().a(BlockProperties.aG, 7), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents7"))).a((Condition)Condition.a().a(BlockProperties.aG, 8), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.no, "_contents_ready"))));
    }

    private void t(Block block) {
        this.a(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelTemplates.U.a(block, TextureMapping.c(block), this.c))).a(this.l()));
    }

    private void D() {
        this.t(Blocks.oK);
        this.t(Blocks.oJ);
        this.t(Blocks.oI);
        this.t(Blocks.oH);
    }

    private void E() {
        this.a(Blocks.pz);
        PropertyDispatch.b<EnumDirection, DripstoneThickness> c2 = PropertyDispatch.a(BlockProperties.bi, BlockProperties.bj);
        for (DripstoneThickness dripstoneThickness : DripstoneThickness.values()) {
            c2.a(EnumDirection.b, dripstoneThickness, this.a(EnumDirection.b, dripstoneThickness));
        }
        for (DripstoneThickness dripstoneThickness2 : DripstoneThickness.values()) {
            c2.a(EnumDirection.a, dripstoneThickness2, this.a(EnumDirection.a, dripstoneThickness2));
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.pz).a(c2));
    }

    private Variant a(EnumDirection direction, DripstoneThickness thickness) {
        String string = "_" + direction.c() + "_" + thickness.c();
        TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(Blocks.pz, string));
        return Variant.a().a(VariantProperties.c, ModelTemplates.T.a(Blocks.pz, string, textureMapping, this.c));
    }

    private void u(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.C(Blocks.cT)).a(TextureSlot.f, TextureMapping.C(block)).a(TextureSlot.i, TextureMapping.a(block, "_side"));
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.i.a(block, textureMapping, this.c)));
    }

    private void F() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.fI, "_side");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.fI, "_top")).a(TextureSlot.i, resourceLocation);
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.fI, "_inverted_top")).a(TextureSlot.i, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.fI).a(PropertyDispatch.a(BlockProperties.p).a((Boolean)false, Variant.a().a(VariantProperties.c, ModelTemplates.ah.a(Blocks.fI, textureMapping, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, ModelTemplates.ah.a(ModelLocationUtils.a(Blocks.fI, "_inverted"), textureMapping2, this.c)))));
    }

    private void v(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.l()));
    }

    private void G() {
        Block block = Blocks.py;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block, "_on");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.l()).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation, resourceLocation2)));
    }

    private void H() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.B, TextureMapping.C(Blocks.j)).a(TextureSlot.f, TextureMapping.C(Blocks.ce));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.B, TextureMapping.C(Blocks.j)).a(TextureSlot.f, TextureMapping.a(Blocks.ce, "_moist"));
        MinecraftKey resourceLocation = ModelTemplates.as.a(Blocks.ce, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.as.a(TextureMapping.a(Blocks.ce, "_moist"), textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.ce).a(BlockModelGenerators.a(BlockProperties.aL, 7, resourceLocation2, resourceLocation)));
    }

    private List<MinecraftKey> w(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.at.a(ModelLocationUtils.a(texture, "_floor0"), TextureMapping.r(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.at.a(ModelLocationUtils.a(texture, "_floor1"), TextureMapping.s(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2);
    }

    private List<MinecraftKey> x(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.au.a(ModelLocationUtils.a(texture, "_side0"), TextureMapping.r(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.au.a(ModelLocationUtils.a(texture, "_side1"), TextureMapping.s(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.av.a(ModelLocationUtils.a(texture, "_side_alt0"), TextureMapping.r(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.av.a(ModelLocationUtils.a(texture, "_side_alt1"), TextureMapping.s(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private List<MinecraftKey> y(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aw.a(ModelLocationUtils.a(texture, "_up0"), TextureMapping.r(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aw.a(ModelLocationUtils.a(texture, "_up1"), TextureMapping.s(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.ax.a(ModelLocationUtils.a(texture, "_up_alt0"), TextureMapping.r(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.ax.a(ModelLocationUtils.a(texture, "_up_alt1"), TextureMapping.s(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private static List<Variant> a(List<MinecraftKey> modelIds, UnaryOperator<Variant> processor) {
        return modelIds.stream().map(resourceLocation -> Variant.a().a(VariantProperties.c, resourceLocation)).map(processor).collect(Collectors.toList());
    }

    private void I() {
        Condition.c condition = Condition.a().a(BlockProperties.J, false).a(BlockProperties.K, false).a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.H, false);
        List<MinecraftKey> list = this.w(Blocks.bT);
        List<MinecraftKey> list2 = this.x(Blocks.bT);
        List<MinecraftKey> list3 = this.y(Blocks.bT);
        this.b.accept(MultiPartGenerator.a(Blocks.bT).a((Condition)condition, BlockModelGenerators.a(list, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.J, true), condition), BlockModelGenerators.a(list2, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.K, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(Condition.b(Condition.a().a(BlockProperties.L, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(Condition.b(Condition.a().a(BlockProperties.M, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))).a((Condition)Condition.a().a(BlockProperties.H, true), BlockModelGenerators.a(list3, variant -> variant)));
    }

    private void J() {
        List<MinecraftKey> list = this.w(Blocks.bU);
        List<MinecraftKey> list2 = this.x(Blocks.bU);
        this.b.accept(MultiPartGenerator.a(Blocks.bU).a(BlockModelGenerators.a(list, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void z(Block lantern) {
        MinecraftKey resourceLocation = TexturedModel.o.create(lantern, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.p.create(lantern, this.c);
        this.a(lantern.k());
        this.b.accept(MultiVariantGenerator.a(lantern).a(BlockModelGenerators.a(BlockProperties.j, resourceLocation2, resourceLocation)));
    }

    private void K() {
        this.b.accept(MultiVariantGenerator.a(Blocks.iW).a(PropertyDispatch.a(BlockProperties.ao).a((Integer)0, Variant.a().a(VariantProperties.c, this.a(Blocks.iW, "_0", ModelTemplates.c, TextureMapping::b))).a((Integer)1, Variant.a().a(VariantProperties.c, this.a(Blocks.iW, "_1", ModelTemplates.c, TextureMapping::b))).a((Integer)2, Variant.a().a(VariantProperties.c, this.a(Blocks.iW, "_2", ModelTemplates.c, TextureMapping::b))).a((Integer)3, Variant.a().a(VariantProperties.c, this.a(Blocks.iW, "_3", ModelTemplates.c, TextureMapping::b)))));
    }

    private void L() {
        MinecraftKey resourceLocation = TextureMapping.C(Blocks.j);
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).b(TextureSlot.e, TextureSlot.c).a(TextureSlot.f, TextureMapping.a(Blocks.i, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.i, "_snow"));
        Variant variant = Variant.a().a(VariantProperties.c, ModelTemplates.i.a(Blocks.i, "_snow", textureMapping, this.c));
        this.a(Blocks.i, ModelLocationUtils.a(Blocks.i), variant);
        MinecraftKey resourceLocation2 = TexturedModel.e.get(Blocks.ec).a((TextureMapping texture) -> texture.a(TextureSlot.e, resourceLocation)).a(Blocks.ec, this.c);
        this.a(Blocks.ec, resourceLocation2, variant);
        MinecraftKey resourceLocation3 = TexturedModel.e.get(Blocks.l).a((TextureMapping texture) -> texture.a(TextureSlot.e, resourceLocation)).a(Blocks.l, this.c);
        this.a(Blocks.l, resourceLocation3, variant);
    }

    private void a(Block topSoil, MinecraftKey modelId, Variant snowyVariant) {
        List<Variant> list = Arrays.asList(BlockModelGenerators.a(modelId));
        this.b.accept(MultiVariantGenerator.a(topSoil).a(PropertyDispatch.a(BlockProperties.z).a((Boolean)true, snowyVariant).a((Boolean)false, list)));
    }

    private void M() {
        this.a(Items.oD);
        this.b.accept(MultiVariantGenerator.a(Blocks.et).a(PropertyDispatch.a(BlockProperties.an).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_stage0"))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_stage1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_stage2")))).a(BlockModelGenerators.c()));
    }

    private void N() {
        this.b.accept(BlockModelGenerators.b(Blocks.iS, ModelLocationUtils.a(Blocks.iS)));
    }

    private void g(Block pressurePlate, Block textureSource) {
        TextureMapping textureMapping = TextureMapping.b(textureSource);
        MinecraftKey resourceLocation = ModelTemplates.E.a(pressurePlate, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.F.a(pressurePlate, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(pressurePlate).a(BlockModelGenerators.a(BlockProperties.aO, 1, resourceLocation2, resourceLocation)));
    }

    private void O() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.fL);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.fL, "_side");
        this.a(Items.kx);
        this.b.accept(MultiVariantGenerator.a(Blocks.fL).a(PropertyDispatch.a(BlockProperties.O).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void h(Block modelSource, Block infested) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(modelSource);
        this.b.accept(MultiVariantGenerator.a(infested, Variant.a().a(VariantProperties.c, resourceLocation)));
        this.a(infested, resourceLocation);
    }

    private void P() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.dP, "_post_ends");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.dP, "_post");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.dP, "_cap");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.dP, "_cap_alt");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.dP, "_side");
        MinecraftKey resourceLocation6 = ModelLocationUtils.a(Blocks.dP, "_side_alt");
        this.b.accept(MultiPartGenerator.a(Blocks.dP).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.J, false).a(BlockProperties.K, false).a(BlockProperties.L, false).a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.J, true).a(BlockProperties.K, false).a(BlockProperties.L, false).a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.J, false).a(BlockProperties.K, true).a(BlockProperties.L, false).a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.J, false).a(BlockProperties.K, false).a(BlockProperties.L, true).a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.J, false).a(BlockProperties.K, false).a(BlockProperties.L, false).a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation6)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation6).a(VariantProperties.b, VariantProperties.a.b)));
        this.b(Blocks.dP);
    }

    private void A(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(BlockModelGenerators.b()));
    }

    private void Q() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.cw);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.cw, "_on");
        this.b(Blocks.cw);
        this.b.accept(MultiVariantGenerator.a(Blocks.cw).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation, resourceLocation2)).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.P).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void R() {
        this.b(Blocks.ed);
        this.b.accept(BlockModelGenerators.b(Blocks.ed, ModelLocationUtils.a(Blocks.ed)));
    }

    private void S() {
        this.b.accept(MultiVariantGenerator.a(Blocks.db).a(PropertyDispatch.a(BlockProperties.F).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.db, "_ns"))).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.db, "_ew")))));
    }

    private void T() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.cT, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.cT, Variant.a().a(VariantProperties.c, resourceLocation), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.d)));
    }

    private void U() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.jc);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.jc, "_on");
        this.b.accept(MultiVariantGenerator.a(Blocks.jc).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void V() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.a(Blocks.bc, "_bottom")).a(TextureSlot.i, TextureMapping.a(Blocks.bc, "_side"));
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.bc, "_top_sticky");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.bc, "_top");
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, resourceLocation);
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, resourceLocation2);
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.bc, "_base");
        this.a(Blocks.bc, resourceLocation3, textureMapping3);
        this.a(Blocks.aV, resourceLocation3, textureMapping2);
        MinecraftKey resourceLocation4 = ModelTemplates.i.a(Blocks.bc, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation2), this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.i.a(Blocks.aV, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation), this.c);
        this.a(Blocks.bc, resourceLocation4);
        this.a(Blocks.aV, resourceLocation5);
    }

    private void a(Block piston, MinecraftKey extendedModelId, TextureMapping texture) {
        MinecraftKey resourceLocation = ModelTemplates.aD.a(piston, texture, this.c);
        this.b.accept(MultiVariantGenerator.a(piston).a(BlockModelGenerators.a(BlockProperties.g, extendedModelId, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void W() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.F, TextureMapping.a(Blocks.bc, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.bc, "_side"));
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.bc, "_top_sticky"));
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.bc, "_top"));
        this.b.accept(MultiVariantGenerator.a(Blocks.bd).a(PropertyDispatch.a(BlockProperties.x, BlockProperties.bc).a((Boolean)false, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.aE.a(Blocks.bc, "_head", textureMapping3, this.c))).a((Boolean)false, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.aE.a(Blocks.bc, "_head_sticky", textureMapping2, this.c))).a((Boolean)true, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.aF.a(Blocks.bc, "_head_short", textureMapping3, this.c))).a((Boolean)true, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.aF.a(Blocks.bc, "_head_short_sticky", textureMapping2, this.c)))).a(BlockModelGenerators.e()));
    }

    private void X() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.oP, "_inactive");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.oP, "_active");
        this.a(Blocks.oP, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.oP).a(PropertyDispatch.a(BlockProperties.bk).a((T1 sculkSensorPhase) -> Variant.a().a(VariantProperties.c, sculkSensorPhase == SculkSensorPhase.b ? resourceLocation2 : resourceLocation))));
    }

    private void Y() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.me, "_stable");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.me, "_unstable");
        this.a(Blocks.me, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.me).a(BlockModelGenerators.a(BlockProperties.b, resourceLocation2, resourceLocation)));
    }

    private void Z() {
        MinecraftKey resourceLocation = this.a(Blocks.pB, "", ModelTemplates.U, TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(Blocks.pB, "_lit", ModelTemplates.U, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.pB).a(BlockModelGenerators.a(BlockProperties.E, resourceLocation2, resourceLocation)));
        MinecraftKey resourceLocation3 = this.a(Blocks.pC, "", ModelTemplates.U, TextureMapping::c);
        MinecraftKey resourceLocation4 = this.a(Blocks.pC, "_lit", ModelTemplates.U, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.pC).a(BlockModelGenerators.a(BlockProperties.E, resourceLocation4, resourceLocation3)));
    }

    private void aa() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.es, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.es, "_on", ModelTemplates.c, TextureMapping::b);
        this.b.accept(MultiVariantGenerator.a(Blocks.es).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)));
    }

    private void i(Block torch, Block wallTorch) {
        TextureMapping textureMapping = TextureMapping.u(torch);
        this.b.accept(BlockModelGenerators.c(torch, ModelTemplates.aB.a(torch, textureMapping, this.c)));
        this.b.accept(MultiVariantGenerator.a(wallTorch, Variant.a().a(VariantProperties.c, ModelTemplates.aC.a(wallTorch, textureMapping, this.c))).a(BlockModelGenerators.d()));
        this.b(torch);
        this.a(wallTorch);
    }

    private void ab() {
        TextureMapping textureMapping = TextureMapping.u(Blocks.cH);
        TextureMapping textureMapping2 = TextureMapping.i(TextureMapping.a(Blocks.cH, "_off"));
        MinecraftKey resourceLocation = ModelTemplates.aB.a(Blocks.cH, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aB.a(Blocks.cH, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.cH).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation, resourceLocation2)));
        MinecraftKey resourceLocation3 = ModelTemplates.aC.a(Blocks.cI, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.aC.a(Blocks.cI, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.cI).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation4)).a(BlockModelGenerators.d()));
        this.b(Blocks.cH);
        this.a(Blocks.cI);
    }

    private void ac() {
        this.a(Items.kq);
        this.b.accept(MultiVariantGenerator.a(Blocks.df).a(PropertyDispatch.a(BlockProperties.av, BlockProperties.s, BlockProperties.w).a((T1 integer, T2 boolean_, T3 boolean2) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('_').append(integer).append("tick");
            if (boolean2.booleanValue()) {
                stringBuilder.append("_on");
            }
            if (boolean_.booleanValue()) {
                stringBuilder.append("_locked");
            }
            return Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.df, stringBuilder.toString()));
        })).a(BlockModelGenerators.c()));
    }

    private void ad() {
        this.a(Items.ca);
        this.b.accept(MultiVariantGenerator.a(Blocks.li).a(PropertyDispatch.a(BlockProperties.aN, BlockProperties.C).a((Integer)1, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("dead_sea_pickle")))).a((Integer)2, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_dead_sea_pickles")))).a((Integer)3, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_dead_sea_pickles")))).a((Integer)4, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_dead_sea_pickles")))).a((Integer)1, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("sea_pickle")))).a((Integer)2, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_sea_pickles")))).a((Integer)3, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_sea_pickles")))).a((Integer)4, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_sea_pickles"))))));
    }

    private void ae() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.cK);
        MinecraftKey resourceLocation = ModelTemplates.c.a(Blocks.cM, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.cK).a(PropertyDispatch.a(BlockProperties.aA).a((T1 integer) -> Variant.a().a(VariantProperties.c, integer < 8 ? ModelLocationUtils.a(Blocks.cK, "_height" + integer * 2) : resourceLocation))));
        this.a(Blocks.cK, ModelLocationUtils.a(Blocks.cK, "_height2"));
        this.b.accept(BlockModelGenerators.c(Blocks.cM, resourceLocation));
    }

    private void af() {
        this.b.accept(MultiVariantGenerator.a(Blocks.mo, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.mo))).a(BlockModelGenerators.b()));
    }

    private void ag() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.nm, this.c);
        this.a(Blocks.nm, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.nm).a(PropertyDispatch.a(BlockProperties.bf).a((T1 structureMode) -> Variant.a().a(VariantProperties.c, this.a(Blocks.nm, "_" + structureMode.c(), ModelTemplates.c, TextureMapping::b)))));
    }

    private void ah() {
        this.a(Items.to);
        this.b.accept(MultiVariantGenerator.a(Blocks.mu).a(PropertyDispatch.a(BlockProperties.ao).a((T1 integer) -> Variant.a().a(VariantProperties.c, this.a(Blocks.mu, "_stage" + integer, ModelTemplates.U, TextureMapping::c)))));
    }

    private void ai() {
        this.a(Items.ne);
        this.b.accept(MultiVariantGenerator.a(Blocks.ez).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.K, BlockProperties.J, BlockProperties.L, BlockProperties.M).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_n"))).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_ne"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_nse"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_nsew"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_ns"))).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_n"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_ne"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_ns"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_nse"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ez, "_attached_nsew")))));
    }

    private void aj() {
        this.b(Blocks.ey);
        this.b.accept(MultiVariantGenerator.a(Blocks.ey).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.w).a((T1 boolean_, T2 boolean2) -> Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.ey, (boolean_ != false ? "_attached" : "") + (boolean2 != false ? "_on" : ""))))).a(BlockModelGenerators.b()));
    }

    private MinecraftKey a(int eggs, String prefix, TextureMapping texture) {
        switch (eggs) {
            case 1: {
                return ModelTemplates.aH.a(ModelLocationUtils.a(prefix + "turtle_egg"), texture, this.c);
            }
            case 2: {
                return ModelTemplates.aI.a(ModelLocationUtils.a("two_" + prefix + "turtle_eggs"), texture, this.c);
            }
            case 3: {
                return ModelTemplates.aJ.a(ModelLocationUtils.a("three_" + prefix + "turtle_eggs"), texture, this.c);
            }
            case 4: {
                return ModelTemplates.aK.a(ModelLocationUtils.a("four_" + prefix + "turtle_eggs"), texture, this.c);
            }
        }
        throw new UnsupportedOperationException();
    }

    private MinecraftKey a(Integer eggs, Integer hatch) {
        switch (hatch) {
            case 0: {
                return this.a(eggs, "", TextureMapping.b(TextureMapping.C(Blocks.kt)));
            }
            case 1: {
                return this.a(eggs, "slightly_cracked_", TextureMapping.b(TextureMapping.a(Blocks.kt, "_slightly_cracked")));
            }
            case 2: {
                return this.a(eggs, "very_cracked_", TextureMapping.b(TextureMapping.a(Blocks.kt, "_very_cracked")));
            }
        }
        throw new UnsupportedOperationException();
    }

    private void ak() {
        this.a(Items.iW);
        this.b.accept(MultiVariantGenerator.a(Blocks.kt).a(PropertyDispatch.a(BlockProperties.ay, BlockProperties.az).b((T1 integer, T2 integer2) -> Arrays.asList(BlockModelGenerators.a(this.a((Integer)integer, (Integer)integer2))))));
    }

    private void B(Block block) {
        this.b(block);
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        Condition.c terminalCondition2 = SystemUtils.a(Condition.a(), (T terminalCondition) -> a.forEach((property, function) -> {
            if (block.n().b(property)) {
                terminalCondition.a(property, false);
            }
        }));
        a.forEach((property, function) -> {
            if (block.n().b(property)) {
                multiPartGenerator.a((Condition)Condition.a().a(property, true), (Variant)function.apply(resourceLocation));
                multiPartGenerator.a((Condition)terminalCondition2, (Variant)function.apply(resourceLocation));
            }
        });
        this.b.accept(multiPartGenerator);
    }

    private void al() {
        this.b.accept(BlockModelGenerators.c(Blocks.iX, ModelTemplates.c.a(Blocks.iX, TextureMapping.b(ModelLocationUtils.a("magma")), this.c)));
    }

    private void C(Block shulkerBox) {
        this.c(shulkerBox, TexturedModel.l);
        ModelTemplates.aU.a(ModelLocationUtils.a(shulkerBox.k()), TextureMapping.q(shulkerBox), this.c);
    }

    private void b(Block plant, Block plantStem, d tintType) {
        this.b(plant, tintType);
        this.b(plantStem, tintType);
    }

    private void j(Block bed, Block particleSource) {
        ModelTemplates.aV.a(ModelLocationUtils.a(bed.k()), TextureMapping.q(particleSource), this.c);
    }

    private void am() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.b);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.b, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.dG, resourceLocation, resourceLocation2));
        this.a(Blocks.dG, resourceLocation);
    }

    private void an() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.pN);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.pN, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.qh, resourceLocation, resourceLocation2).a(BlockModelGenerators.f()));
        this.a(Blocks.qh, resourceLocation);
    }

    private void k(Block root, Block pottedRoot) {
        this.a(root, net.minecraft.data.models.BlockModelGenerators$d.b);
        TextureMapping textureMapping = TextureMapping.d(TextureMapping.a(root, "_pot"));
        MinecraftKey resourceLocation = net.minecraft.data.models.BlockModelGenerators$d.b.b().a(pottedRoot, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(pottedRoot, resourceLocation));
    }

    private void ao() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.nx, "_bottom");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.nx, "_top_off");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.nx, "_top");
        MinecraftKey[] resourceLocations = new MinecraftKey[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, i2 == 0 ? resourceLocation2 : resourceLocation3).a(TextureSlot.i, TextureMapping.a(Blocks.nx, "_side" + i2));
            resourceLocations[i2] = ModelTemplates.i.a(Blocks.nx, "_" + i2, textureMapping, this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.nx).a(PropertyDispatch.a(BlockProperties.aU).a((T1 integer) -> Variant.a().a(VariantProperties.c, resourceLocations[integer]))));
        this.a(Items.tM, resourceLocations[0]);
    }

    private Variant a(BlockPropertyJigsawOrientation orientation, Variant variant) {
        switch (orientation) {
            case b: {
                return variant.a(VariantProperties.a, VariantProperties.a.b);
            }
            case c: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c);
            }
            case d: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d);
            }
            case a: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b);
            }
            case f: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.c);
            }
            case g: {
                return variant.a(VariantProperties.a, VariantProperties.a.d);
            }
            case h: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.b);
            }
            case e: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.d);
            }
            case k: {
                return variant;
            }
            case l: {
                return variant.a(VariantProperties.b, VariantProperties.a.c);
            }
            case i: {
                return variant.a(VariantProperties.b, VariantProperties.a.d);
            }
            case j: {
                return variant.a(VariantProperties.b, VariantProperties.a.b);
            }
        }
        throw new UnsupportedOperationException("Rotation " + orientation + " can't be expressed with existing x and y values");
    }

    private void ap() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.nn, "_top");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.nn, "_bottom");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.nn, "_side");
        MinecraftKey resourceLocation4 = TextureMapping.a(Blocks.nn, "_lock");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.o, resourceLocation3).a(TextureSlot.m, resourceLocation3).a(TextureSlot.l, resourceLocation3).a(TextureSlot.c, resourceLocation).a(TextureSlot.j, resourceLocation).a(TextureSlot.k, resourceLocation2).a(TextureSlot.n, resourceLocation4);
        MinecraftKey resourceLocation5 = ModelTemplates.b.a(Blocks.nn, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.nn, Variant.a().a(VariantProperties.c, resourceLocation5)).a(PropertyDispatch.a(BlockProperties.Q).a((T1 frontAndTop) -> this.a((BlockPropertyJigsawOrientation)frontAndTop, Variant.a()))));
    }

    private void aq() {
        Block block = Blocks.n;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        TexturedModel texturedModel = TexturedModel.a.get(block);
        Block block2 = Blocks.ii;
        MinecraftKey resourceLocation2 = ModelTemplates.H.a(block2, texturedModel.b(), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.I.a(block2, texturedModel.b(), this.c);
        this.b.accept(BlockModelGenerators.e(block2, resourceLocation2, resourceLocation3, resourceLocation));
    }

    public void a() {
        BlockFamilies.a().filter(BlockFamily::c).forEach(family -> this.f(family.a()).a((BlockFamily)family));
        this.f(Blocks.oZ).a(BlockFamilies.r).a(new Block[]{Blocks.pp}).a(BlockFamilies.t);
        this.f(Blocks.oY).a(BlockFamilies.v).a(new Block[]{Blocks.po}).a(BlockFamilies.x);
        this.f(Blocks.oX).a(BlockFamilies.z).a(new Block[]{Blocks.pn}).a(BlockFamilies.B);
        this.f(Blocks.oW).a(BlockFamilies.D).a(new Block[]{Blocks.pm}).a(BlockFamilies.F);
        this.k(Blocks.a);
        this.a(Blocks.lp, Blocks.a);
        this.a(Blocks.lo, Blocks.a);
        this.k(Blocks.eF);
        this.k(Blocks.cN);
        this.a(Blocks.lq, Blocks.A);
        this.k(Blocks.er);
        this.k(Blocks.ks);
        this.k(Blocks.ei);
        this.k(Blocks.eI);
        this.a(Items.rk);
        this.k(Blocks.ns);
        this.k(Blocks.A);
        this.k(Blocks.B);
        this.k(Blocks.gA);
        this.a(Items.eK);
        this.l(Blocks.nY, Blocks.op);
        this.l(Blocks.nZ, Blocks.oq);
        this.l(Blocks.oa, Blocks.or);
        this.l(Blocks.ob, Blocks.os);
        this.l(Blocks.oc, Blocks.ot);
        this.l(Blocks.od, Blocks.ou);
        this.l(Blocks.oe, Blocks.ov);
        this.l(Blocks.of, Blocks.ow);
        this.l(Blocks.og, Blocks.ox);
        this.l(Blocks.oh, Blocks.oy);
        this.l(Blocks.oi, Blocks.oz);
        this.l(Blocks.oj, Blocks.oA);
        this.l(Blocks.ok, Blocks.oB);
        this.l(Blocks.ol, Blocks.oC);
        this.l(Blocks.om, Blocks.oD);
        this.l(Blocks.on, Blocks.oE);
        this.l(Blocks.nX, Blocks.oo);
        this.k(Blocks.ln);
        this.k(Blocks.fg);
        this.k(Blocks.oO);
        this.k(Blocks.pD);
        this.p(Blocks.pE);
        this.p(Blocks.pF);
        this.q(Blocks.qm);
        this.q(Blocks.qn);
        this.Z();
        this.e(Blocks.pH, Blocks.pG);
        this.a(Blocks.gB, Items.gg);
        this.a(Items.gg);
        this.ar();
        this.a(Blocks.jb, Items.hI);
        this.a(Items.hI);
        this.f(Blocks.bu, TextureMapping.a(Blocks.bc, "_side"));
        this.e(Blocks.J);
        this.e(Blocks.K);
        this.e(Blocks.hg);
        this.e(Blocks.bZ);
        this.e(Blocks.ca);
        this.e(Blocks.cb);
        this.e(Blocks.ev);
        this.e(Blocks.ew);
        this.e(Blocks.eA);
        this.e(Blocks.F);
        this.e(Blocks.L);
        this.e(Blocks.G);
        this.e(Blocks.bK);
        this.e(Blocks.H);
        this.e(Blocks.I);
        this.e(Blocks.bL);
        this.c(Blocks.nv, TexturedModel.c);
        this.e(Blocks.nu);
        this.e(Blocks.av);
        this.e(Blocks.aw);
        this.e(Blocks.ax);
        this.e(Blocks.fK);
        this.e(Blocks.cF);
        this.e(Blocks.cG);
        this.e(Blocks.fJ);
        this.e(Blocks.nO);
        this.e(Blocks.lj);
        this.e(Blocks.cO);
        this.e(Blocks.k);
        this.e(Blocks.nw);
        this.e(Blocks.eq);
        this.e(Blocks.da);
        this.e(Blocks.E);
        this.e(Blocks.nt);
        this.e(Blocks.cL);
        this.c(Blocks.cQ, TexturedModel.f);
        this.c(Blocks.nC, TexturedModel.c);
        this.c(Blocks.dS, TexturedModel.c);
        this.e(Blocks.iY);
        this.e(Blocks.aC);
        this.e(Blocks.hh);
        this.e(Blocks.bQ);
        this.e(Blocks.nW);
        this.e(Blocks.gN);
        this.e(Blocks.mK);
        this.e(Blocks.cU);
        this.e(Blocks.cV);
        this.e(Blocks.bV);
        this.e(Blocks.as);
        this.c(Blocks.ba, TexturedModel.q);
        this.a(Items.bZ);
        this.c(Blocks.bN, TexturedModel.e);
        this.c(Blocks.np, TexturedModel.c);
        this.e(Blocks.mB);
        this.e(Blocks.at);
        this.e(Blocks.oF);
        this.e(Blocks.oG);
        this.e(Blocks.oM);
        this.e(Blocks.oL);
        this.e(Blocks.pA);
        this.e(Blocks.qj);
        this.e(Blocks.qk);
        this.e(Blocks.ql);
        this.aq();
        this.e(Blocks.oU);
        this.e(Blocks.oV);
        this.e(Blocks.oT);
        this.e(Blocks.oS);
        this.e(Blocks.oR);
        this.e(Blocks.oQ);
        this.h(Blocks.oT, Blocks.pi);
        this.h(Blocks.oS, Blocks.pk);
        this.h(Blocks.oR, Blocks.pj);
        this.h(Blocks.oQ, Blocks.pl);
        this.g(Blocks.fF, Blocks.bK);
        this.g(Blocks.fG, Blocks.bL);
        this.D();
        this.p();
        this.t();
        this.u();
        this.a(new Block[]{Blocks.ms, Blocks.mt});
        this.v();
        this.y();
        this.z();
        this.B();
        this.C();
        this.F();
        this.A();
        this.v(Blocks.iK);
        this.G();
        this.H();
        this.I();
        this.J();
        this.K();
        this.L();
        this.M();
        this.N();
        this.o();
        this.O();
        this.P();
        this.Q();
        this.R();
        this.S();
        this.T();
        this.U();
        this.V();
        this.W();
        this.Y();
        this.ab();
        this.aa();
        this.ac();
        this.ad();
        this.w();
        this.ae();
        this.af();
        this.ag();
        this.ah();
        this.ai();
        this.aj();
        this.ak();
        this.B(Blocks.dX);
        this.B(Blocks.dY);
        this.al();
        this.ap();
        this.X();
        this.A(Blocks.cn);
        this.b(Blocks.cn);
        this.A(Blocks.mm);
        this.g();
        this.A(Blocks.pJ);
        this.i(Blocks.bR, Blocks.bS);
        this.i(Blocks.cY, Blocks.cZ);
        this.a(Blocks.cc, Blocks.n, TextureMapping::c);
        this.a(Blocks.mk, Blocks.p, TextureMapping::d);
        this.u(Blocks.mI);
        this.u(Blocks.mz);
        this.s(Blocks.ay);
        this.s(Blocks.fR);
        this.z(Blocks.mq);
        this.z(Blocks.mr);
        this.e(Blocks.dQ, ModelLocationUtils.a(Blocks.dQ));
        this.a(Blocks.cW, TexturedModel.c);
        this.a(Blocks.cX, TexturedModel.c);
        this.e(Blocks.qi);
        this.a(Blocks.ja, TexturedModel.c);
        this.d(Blocks.j);
        this.d(Blocks.pM);
        this.d(Blocks.C);
        this.d(Blocks.D);
        this.c(Blocks.z);
        this.a(Blocks.gO, TexturedModel.c, TexturedModel.d);
        this.a(Blocks.iO, TexturedModel.r, TexturedModel.s);
        this.a(Blocks.fO, TexturedModel.r, TexturedModel.s);
        this.b(Blocks.mf, TexturedModel.h);
        this.x();
        this.a(Blocks.nq, TextureMapping::w);
        this.a(Blocks.nr, TextureMapping::y);
        this.a(Blocks.iR, BlockProperties.ao, 0, 1, 2, 3);
        this.a(Blocks.fh, BlockProperties.aq, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.eh, BlockProperties.ao, 0, 1, 1, 2);
        this.a(Blocks.fi, BlockProperties.aq, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.cd, BlockProperties.aq, 0, 1, 2, 3, 4, 5, 6, 7);
        this.a(ModelLocationUtils.a("banner"), Blocks.n).a(ModelTemplates.aW, Blocks.ho, Blocks.hp, Blocks.hq, Blocks.hr, Blocks.hs, Blocks.ht, Blocks.hu, Blocks.hv, Blocks.hw, Blocks.hx, Blocks.hy, Blocks.hz, Blocks.hA, Blocks.hB, Blocks.hC, Blocks.hD).b(Blocks.hE, Blocks.hF, Blocks.hG, Blocks.hH, Blocks.hI, Blocks.hJ, Blocks.hK, Blocks.hL, Blocks.hM, Blocks.hN, Blocks.hO, Blocks.hP, Blocks.hQ, Blocks.hR, Blocks.hS, Blocks.hT);
        this.a(ModelLocationUtils.a("bed"), Blocks.n).b(Blocks.aD, Blocks.aE, Blocks.aF, Blocks.aG, Blocks.aH, Blocks.aI, Blocks.aJ, Blocks.aK, Blocks.aL, Blocks.aM, Blocks.aN, Blocks.aO, Blocks.aP, Blocks.aQ, Blocks.aR, Blocks.aS);
        this.j(Blocks.aD, Blocks.be);
        this.j(Blocks.aE, Blocks.bf);
        this.j(Blocks.aF, Blocks.bg);
        this.j(Blocks.aG, Blocks.bh);
        this.j(Blocks.aH, Blocks.bi);
        this.j(Blocks.aI, Blocks.bj);
        this.j(Blocks.aJ, Blocks.bk);
        this.j(Blocks.aK, Blocks.bl);
        this.j(Blocks.aL, Blocks.bm);
        this.j(Blocks.aM, Blocks.bn);
        this.j(Blocks.aN, Blocks.bo);
        this.j(Blocks.aO, Blocks.bp);
        this.j(Blocks.aP, Blocks.bq);
        this.j(Blocks.aQ, Blocks.br);
        this.j(Blocks.aR, Blocks.bs);
        this.j(Blocks.aS, Blocks.bt);
        this.a(ModelLocationUtils.a("skull"), Blocks.cU).a(ModelTemplates.aX, Blocks.fx, Blocks.fv, Blocks.ft, Blocks.fp, Blocks.fr).a(Blocks.fz).b(Blocks.fy, Blocks.fA, Blocks.fw, Blocks.fu, Blocks.fq, Blocks.fs);
        this.C(Blocks.jd);
        this.C(Blocks.je);
        this.C(Blocks.jf);
        this.C(Blocks.jg);
        this.C(Blocks.jh);
        this.C(Blocks.ji);
        this.C(Blocks.jj);
        this.C(Blocks.jk);
        this.C(Blocks.jl);
        this.C(Blocks.jm);
        this.C(Blocks.jn);
        this.C(Blocks.jo);
        this.C(Blocks.jp);
        this.C(Blocks.jq);
        this.C(Blocks.jr);
        this.C(Blocks.js);
        this.C(Blocks.jt);
        this.c(Blocks.lk, TexturedModel.l);
        this.a(Blocks.lk);
        this.a(ModelLocationUtils.a("chest"), Blocks.n).b(Blocks.bX, Blocks.fE);
        this.a(ModelLocationUtils.a("ender_chest"), Blocks.bQ).b(Blocks.ex);
        this.d(Blocks.eo, Blocks.bQ).a(Blocks.eo, Blocks.iT);
        this.e(Blocks.aq);
        this.e(Blocks.ar);
        this.e(Blocks.jK);
        this.e(Blocks.jL);
        this.e(Blocks.jM);
        this.e(Blocks.jN);
        this.e(Blocks.jO);
        this.e(Blocks.jP);
        this.e(Blocks.jQ);
        this.e(Blocks.jR);
        this.e(Blocks.jS);
        this.e(Blocks.jT);
        this.e(Blocks.jU);
        this.e(Blocks.jV);
        this.e(Blocks.jW);
        this.e(Blocks.jX);
        this.e(Blocks.jY);
        this.e(Blocks.jZ);
        this.a(TexturedModel.a, Blocks.ka, Blocks.kb, Blocks.kc, Blocks.kd, Blocks.ke, Blocks.kf, Blocks.kg, Blocks.kh, Blocks.ki, Blocks.kj, Blocks.kk, Blocks.kl, Blocks.km, Blocks.kn, Blocks.ko, Blocks.kp);
        this.e(Blocks.hf);
        this.e(Blocks.fS);
        this.e(Blocks.fT);
        this.e(Blocks.fU);
        this.e(Blocks.fV);
        this.e(Blocks.fW);
        this.e(Blocks.fX);
        this.e(Blocks.fY);
        this.e(Blocks.fZ);
        this.e(Blocks.ga);
        this.e(Blocks.gb);
        this.e(Blocks.gc);
        this.e(Blocks.gd);
        this.e(Blocks.ge);
        this.e(Blocks.gf);
        this.e(Blocks.gg);
        this.e(Blocks.gh);
        this.e(Blocks.oN);
        this.f(Blocks.au, Blocks.dR);
        this.f(Blocks.dg, Blocks.gi);
        this.f(Blocks.dh, Blocks.gj);
        this.f(Blocks.di, Blocks.gk);
        this.f(Blocks.dj, Blocks.gl);
        this.f(Blocks.dk, Blocks.gm);
        this.f(Blocks.dl, Blocks.gn);
        this.f(Blocks.dm, Blocks.go);
        this.f(Blocks.dn, Blocks.gp);
        this.f(Blocks.do, Blocks.gq);
        this.f(Blocks.dp, Blocks.gr);
        this.f(Blocks.dq, Blocks.gs);
        this.f(Blocks.dr, Blocks.gt);
        this.f(Blocks.ds, Blocks.gu);
        this.f(Blocks.dt, Blocks.gv);
        this.f(Blocks.du, Blocks.gw);
        this.f(Blocks.dv, Blocks.gx);
        this.b(TexturedModel.j, Blocks.ju, Blocks.jv, Blocks.jw, Blocks.jx, Blocks.jy, Blocks.jz, Blocks.jA, Blocks.jB, Blocks.jC, Blocks.jD, Blocks.jE, Blocks.jF, Blocks.jG, Blocks.jH, Blocks.jI, Blocks.jJ);
        this.e(Blocks.be, Blocks.gP);
        this.e(Blocks.bf, Blocks.gQ);
        this.e(Blocks.bg, Blocks.gR);
        this.e(Blocks.bh, Blocks.gS);
        this.e(Blocks.bi, Blocks.gT);
        this.e(Blocks.bj, Blocks.gU);
        this.e(Blocks.bk, Blocks.gV);
        this.e(Blocks.bl, Blocks.gW);
        this.e(Blocks.bm, Blocks.gX);
        this.e(Blocks.bn, Blocks.gY);
        this.e(Blocks.bo, Blocks.gZ);
        this.e(Blocks.bp, Blocks.ha);
        this.e(Blocks.bq, Blocks.hb);
        this.e(Blocks.br, Blocks.hc);
        this.e(Blocks.bs, Blocks.hd);
        this.e(Blocks.bt, Blocks.he);
        this.a(Blocks.aY, Blocks.eP, net.minecraft.data.models.BlockModelGenerators$d.a);
        this.a(Blocks.bv, Blocks.eQ, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bw, Blocks.eR, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bx, Blocks.eS, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.by, Blocks.eT, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bz, Blocks.eU, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bA, Blocks.eV, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bB, Blocks.eW, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bC, Blocks.eX, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bD, Blocks.eY, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bE, Blocks.eZ, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bF, Blocks.fa, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bH, Blocks.fb, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bG, Blocks.fc, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bJ, Blocks.fd, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.bI, Blocks.fe, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.aZ, Blocks.ff, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.E();
        this.r(Blocks.dM);
        this.r(Blocks.dN);
        this.r(Blocks.dO);
        this.a(Blocks.aX, net.minecraft.data.models.BlockModelGenerators$d.a);
        this.b(Blocks.cP, net.minecraft.data.models.BlockModelGenerators$d.a);
        this.a(Items.cO);
        this.b(Blocks.kq, Blocks.kr, net.minecraft.data.models.BlockModelGenerators$d.a);
        this.a(Items.cP);
        this.a(Blocks.kr);
        this.b(Blocks.pL, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.pL);
        this.a(Blocks.pC);
        this.b(Blocks.mL, Blocks.mM, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.b(Blocks.mN, Blocks.mO, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Blocks.mL, "_plant");
        this.a(Blocks.mM);
        this.a(Blocks.mN, "_plant");
        this.a(Blocks.mO);
        this.a(Blocks.ll, net.minecraft.data.models.BlockModelGenerators$d.a, TextureMapping.c(TextureMapping.a(Blocks.lm, "_stage0")));
        this.k();
        this.a(Blocks.aW, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.hj, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.hk, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.hl, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.hm, net.minecraft.data.models.BlockModelGenerators$d.a);
        this.c(Blocks.hn, net.minecraft.data.models.BlockModelGenerators$d.a);
        this.h();
        this.i();
        this.j();
        this.a(Blocks.kJ, Blocks.kE, Blocks.kz, Blocks.ku, Blocks.kT, Blocks.kO, Blocks.ld, Blocks.kY);
        this.a(Blocks.kK, Blocks.kF, Blocks.kA, Blocks.kv, Blocks.kU, Blocks.kP, Blocks.le, Blocks.kZ);
        this.a(Blocks.kL, Blocks.kG, Blocks.kB, Blocks.kw, Blocks.kV, Blocks.kQ, Blocks.lf, Blocks.la);
        this.a(Blocks.kM, Blocks.kH, Blocks.kC, Blocks.kx, Blocks.kW, Blocks.kR, Blocks.lg, Blocks.lb);
        this.a(Blocks.kN, Blocks.kI, Blocks.kD, Blocks.ky, Blocks.kX, Blocks.kS, Blocks.lh, Blocks.lc);
        this.c(Blocks.dW, Blocks.dU);
        this.c(Blocks.dV, Blocks.dT);
        this.j(Blocks.Q).c(Blocks.Q).a(Blocks.ac);
        this.j(Blocks.V).c(Blocks.V).a(Blocks.ai);
        this.a(Blocks.x, Blocks.eN, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.ao, TexturedModel.n);
        this.j(Blocks.O).c(Blocks.O).a(Blocks.aa);
        this.j(Blocks.T).c(Blocks.T).a(Blocks.ag);
        this.a(Blocks.v, Blocks.eL, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.am, TexturedModel.n);
        this.j(Blocks.M).c(Blocks.M).a(Blocks.Y);
        this.j(Blocks.X).c(Blocks.X).a(Blocks.ae);
        this.a(Blocks.t, Blocks.eJ, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.ak, TexturedModel.n);
        this.j(Blocks.N).c(Blocks.N).a(Blocks.Z);
        this.j(Blocks.S).c(Blocks.S).a(Blocks.af);
        this.a(Blocks.u, Blocks.eK, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.al, TexturedModel.n);
        this.j(Blocks.R).c(Blocks.R).a(Blocks.ad);
        this.j(Blocks.W).c(Blocks.W).a(Blocks.aj);
        this.a(Blocks.y, Blocks.eO, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.ap, TexturedModel.n);
        this.j(Blocks.P).c(Blocks.P).a(Blocks.ab);
        this.j(Blocks.U).c(Blocks.U).a(Blocks.ah);
        this.a(Blocks.w, Blocks.eM, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.c(Blocks.an, TexturedModel.n);
        this.j(Blocks.mE).b(Blocks.mE).a(Blocks.mG);
        this.j(Blocks.mF).b(Blocks.mF).a(Blocks.mH);
        this.a(Blocks.mJ, Blocks.ny, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.k(Blocks.mP, Blocks.nA);
        this.j(Blocks.mv).b(Blocks.mv).a(Blocks.mx);
        this.j(Blocks.mw).b(Blocks.mw).a(Blocks.my);
        this.a(Blocks.mA, Blocks.nz, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.k(Blocks.mC, Blocks.nB);
        this.b(Blocks.mD, net.minecraft.data.models.BlockModelGenerators$d.b);
        this.a(Items.cL);
        this.g(Blocks.cy);
        this.i(Blocks.gD);
        this.s();
        this.l(Blocks.co);
        this.m(Blocks.aT);
        this.m(Blocks.aU);
        this.m(Blocks.fQ);
        this.r();
        this.n(Blocks.eE);
        this.n(Blocks.iU);
        this.n(Blocks.iV);
        this.o(Blocks.fB);
        this.o(Blocks.fC);
        this.o(Blocks.fD);
        this.m();
        this.n();
        this.d(Blocks.cf, TexturedModel.g);
        this.d(Blocks.mi, TexturedModel.g);
        this.d(Blocks.mh, TexturedModel.h);
        this.q();
        this.ao();
        this.h(Blocks.dF, Blocks.dL);
        this.h(Blocks.m, Blocks.dH);
        this.h(Blocks.dE, Blocks.dK);
        this.h(Blocks.dD, Blocks.dJ);
        this.am();
        this.h(Blocks.dC, Blocks.dI);
        this.an();
        ItemMonsterEgg.i().forEach(item -> this.a((Item)item, ModelLocationUtils.b("template_spawn_egg")));
    }

    private void ar() {
        this.a(Blocks.gC);
        PropertyDispatch.a<Integer> c1 = PropertyDispatch.a(BlockProperties.aK);
        for (int i2 = 0; i2 < 16; ++i2) {
            String string = String.format("_%02d", i2);
            MinecraftKey resourceLocation = TextureMapping.a(Items.gh, string);
            c1.a((Integer)i2, Variant.a().a(VariantProperties.c, ModelTemplates.G.a(Blocks.gC, string, TextureMapping.h(resourceLocation), this.c)));
            ModelTemplates.aR.a(ModelLocationUtils.a(Items.gh, string), TextureMapping.k(resourceLocation), this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.gC).a(c1));
    }

    private void l(Block candle, Block cake) {
        this.a(candle.k());
        TextureMapping textureMapping = TextureMapping.b(TextureMapping.C(candle));
        TextureMapping textureMapping2 = TextureMapping.b(TextureMapping.a(candle, "_lit"));
        MinecraftKey resourceLocation = ModelTemplates.aY.a(candle, "_one_candle", textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aZ.a(candle, "_two_candles", textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.ba.a(candle, "_three_candles", textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bb.a(candle, "_four_candles", textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.aY.a(candle, "_one_candle_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.aZ.a(candle, "_two_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.ba.a(candle, "_three_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.bb.a(candle, "_four_candles_lit", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(candle).a(PropertyDispatch.a(BlockProperties.au, BlockProperties.r).a((Integer)1, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Integer)2, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation2)).a((Integer)3, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation3)).a((Integer)4, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation4)).a((Integer)1, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation5)).a((Integer)2, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation6)).a((Integer)3, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation7)).a((Integer)4, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation8))));
        MinecraftKey resourceLocation9 = ModelTemplates.bc.a(cake, TextureMapping.a(candle, false), this.c);
        MinecraftKey resourceLocation10 = ModelTemplates.bc.a(cake, "_lit", TextureMapping.a(candle, true), this.c);
        this.b.accept(MultiVariantGenerator.a(cake).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation10, resourceLocation9)));
    }

    private /* synthetic */ Variant a(int[] is, Int2ObjectMap int2ObjectMap, Block block, Integer integer) {
        int i2 = is[integer];
        MinecraftKey resourceLocation = (MinecraftKey)int2ObjectMap.computeIfAbsent(i2, j2 -> this.a(block, "_stage" + i2, ModelTemplates.ar, TextureMapping::g));
        return Variant.a().a(VariantProperties.c, resourceLocation);
    }

    @FunctionalInterface
    static interface c {
        public BlockStateGenerator create(Block var1, MinecraftKey var2, TextureMapping var3, BiConsumer<MinecraftKey, Supplier<JsonElement>> var4);
    }

    class b {
        private final TextureMapping b;
        private final Map<ModelTemplate, MinecraftKey> c = Maps.newHashMap();
        @Nullable
        private BlockFamily d;
        @Nullable
        private MinecraftKey e;

        public b(TextureMapping texture) {
            this.b = texture;
        }

        public b a(Block block, ModelTemplate model) {
            this.e = model.a(block, this.b, BlockModelGenerators.this.c);
            if (BlockModelGenerators.this.f.containsKey(block)) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.this.f.get(block).create(block, this.e, this.b, BlockModelGenerators.this.c));
            } else {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.e));
            }
            return this;
        }

        public b a(Block ... blocks) {
            if (this.e == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            for (Block block : blocks) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.e));
                BlockModelGenerators.this.a(block, this.e);
            }
            return this;
        }

        public b a(Block buttonBlock) {
            MinecraftKey resourceLocation = ModelTemplates.m.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.n.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(buttonBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.o.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(buttonBlock, resourceLocation3);
            return this;
        }

        public b b(Block wallBlock) {
            MinecraftKey resourceLocation = ModelTemplates.w.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.x.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.y.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(wallBlock, resourceLocation, resourceLocation2, resourceLocation3));
            MinecraftKey resourceLocation4 = ModelTemplates.z.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(wallBlock, resourceLocation4);
            return this;
        }

        public b c(Block fenceBlock) {
            MinecraftKey resourceLocation = ModelTemplates.t.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.u.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(fenceBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.v.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(fenceBlock, resourceLocation3);
            return this;
        }

        public b d(Block fenceGateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.B.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.A.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.D.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.C.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(fenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
            return this;
        }

        public b e(Block pressurePlateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.E.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.F.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(pressurePlateBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public b f(Block signBlock) {
            if (this.d == null) {
                throw new IllegalStateException("Family not defined");
            }
            Block block = this.d.b().get((Object)BlockFamily.b.o);
            MinecraftKey resourceLocation = ModelTemplates.G.a(signBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(signBlock, resourceLocation));
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, resourceLocation));
            BlockModelGenerators.this.a(signBlock.k());
            BlockModelGenerators.this.a(block);
            return this;
        }

        public b g(Block block) {
            if (this.e == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            MinecraftKey resourceLocation = this.a(ModelTemplates.H, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.I, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(block, resourceLocation, resourceLocation2, this.e));
            BlockModelGenerators.this.a(block, resourceLocation);
            return this;
        }

        public b h(Block block) {
            MinecraftKey resourceLocation = this.a(ModelTemplates.L, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.K, block);
            MinecraftKey resourceLocation3 = this.a(ModelTemplates.M, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(block, resourceLocation, resourceLocation2, resourceLocation3));
            BlockModelGenerators.this.a(block, resourceLocation2);
            return this;
        }

        private b i(Block block) {
            TexturedModel texturedModel = BlockModelGenerators.this.g.getOrDefault(block, TexturedModel.a.get(block));
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, texturedModel.a(block, BlockModelGenerators.this.c)));
            return this;
        }

        private b j(Block block) {
            BlockModelGenerators.this.g(block);
            return this;
        }

        private void k(Block block) {
            if (BlockModelGenerators.this.e.contains(block)) {
                BlockModelGenerators.this.i(block);
            } else {
                BlockModelGenerators.this.h(block);
            }
        }

        private MinecraftKey a(ModelTemplate model, Block block) {
            return this.c.computeIfAbsent(model, newModel -> newModel.a(block, this.b, BlockModelGenerators.this.c));
        }

        public b a(BlockFamily family) {
            this.d = family;
            family.b().forEach((variant, block) -> {
                BiConsumer<b, Block> biConsumer = h.get(variant);
                if (biConsumer != null) {
                    biConsumer.accept(this, (Block)block);
                }
            });
            return this;
        }
    }

    class e {
        private final TextureMapping b;

        public e(TextureMapping texture) {
            this.b = texture;
        }

        public e a(Block woodBlock) {
            TextureMapping textureMapping = this.b.c(TextureSlot.d, this.b.a(TextureSlot.i));
            MinecraftKey resourceLocation = ModelTemplates.e.a(woodBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(woodBlock, resourceLocation));
            return this;
        }

        public e b(Block stemBlock) {
            MinecraftKey resourceLocation = ModelTemplates.e.a(stemBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(stemBlock, resourceLocation));
            return this;
        }

        public e c(Block logBlock) {
            MinecraftKey resourceLocation = ModelTemplates.e.a(logBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.f.a(logBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(logBlock, resourceLocation, resourceLocation2));
            return this;
        }
    }

    static final class d
    extends Enum<d> {
        public static final /* enum */ d a = new d();
        public static final /* enum */ d b = new d();
        private static final /* synthetic */ d[] c;

        public static d[] values() {
            return (d[])c.clone();
        }

        public static d valueOf(String string) {
            return Enum.valueOf(d.class, string);
        }

        public ModelTemplate a() {
            return this == a ? ModelTemplates.V : ModelTemplates.U;
        }

        public ModelTemplate b() {
            return this == a ? ModelTemplates.X : ModelTemplates.W;
        }

        private static /* synthetic */ d[] c() {
            return new d[]{a, b};
        }

        static {
            c = net.minecraft.data.models.BlockModelGenerators$d.c();
        }
    }

    class a {
        private final MinecraftKey b;

        public a(MinecraftKey modelId, Block block) {
            this.b = ModelTemplates.G.a(modelId, TextureMapping.q(block), BlockModelGenerators.this.c);
        }

        public a a(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.b));
            }
            return this;
        }

        public a b(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.a(block);
            }
            return this.a(blocks);
        }

        public a a(ModelTemplate model, Block ... blocks) {
            for (Block block : blocks) {
                model.a(ModelLocationUtils.a(block.k()), TextureMapping.q(block), BlockModelGenerators.this.c);
            }
            return this.a(blocks);
        }
    }
}

