/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashCache {
    private static final Logger a = LogManager.getLogger();
    private final Path b;
    private final Path c;
    private int d;
    private final Map<Path, String> e = Maps.newHashMap();
    private final Map<Path, String> f = Maps.newHashMap();
    private final Set<Path> g = Sets.newHashSet();

    public HashCache(Path root, String name) throws IOException {
        this.b = root;
        Path path2 = root.resolve(".cache");
        Files.createDirectories(path2, new FileAttribute[0]);
        this.c = path2.resolve(name);
        this.c().forEach(path -> this.e.put((Path)path, ""));
        if (Files.isReadable(this.c)) {
            IOUtils.readLines((InputStream)Files.newInputStream(this.c, new OpenOption[0]), (Charset)Charsets.UTF_8).forEach(string -> {
                int i2 = string.indexOf(32);
                this.e.put(root.resolve(string.substring(i2 + 1)), string.substring(0, i2));
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void a() throws IOException {
        void writer2;
        this.b();
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.c, new OpenOption[0]);
        }
        catch (IOException iOException) {
            a.warn("Unable write cachefile {}: {}", (Object)this.c, (Object)iOException.toString());
            return;
        }
        IOUtils.writeLines((Collection)this.f.entrySet().stream().map(entry -> (String)entry.getValue() + " " + this.b.relativize((Path)entry.getKey())).collect(Collectors.toList()), (String)System.lineSeparator(), (Writer)writer2);
        writer2.close();
        a.debug("Caching: cache hits: {}, created: {} removed: {}", (Object)this.d, (Object)(this.f.size() - this.d), (Object)this.e.size());
    }

    @Nullable
    public String a(Path path) {
        return this.e.get(path);
    }

    public void a(Path path, String sha1) {
        this.f.put(path, sha1);
        if (Objects.equals(this.e.remove(path), sha1)) {
            ++this.d;
        }
    }

    public boolean b(Path path) {
        return this.e.containsKey(path);
    }

    public void c(Path path) {
        this.g.add(path);
    }

    private void b() throws IOException {
        this.c().forEach(path -> {
            if (this.b((Path)path) && !this.g.contains(path)) {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    a.debug("Unable to delete: {} ({})", path, (Object)iOException.toString());
                }
            }
        });
    }

    private Stream<Path> c() throws IOException {
        return Files.walk(this.b, new FileVisitOption[0]).filter(path -> !Objects.equals(this.c, path) && !Files.isDirectory(path, new LinkOption[0]));
    }
}

