/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryDataPackCodec;
import net.minecraft.resources.ResourceKey;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryMaterials<T>
extends IRegistryWritable<T> {
    protected static final Logger b = LogManager.getLogger();
    private final ObjectList<T> bz = new ObjectArrayList(256);
    private final Reference2IntOpenHashMap<T> bA = new Reference2IntOpenHashMap(2048);
    private final BiMap<MinecraftKey, T> bB = HashBiMap.create((int)2048);
    private final BiMap<ResourceKey<T>, T> bC = HashBiMap.create((int)2048);
    private final Map<T, Lifecycle> bD = new IdentityHashMap<T, Lifecycle>(2048);
    private Lifecycle bE;
    @Nullable
    protected Object[] c;
    private int bF;

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle) {
        super(key, lifecycle);
        this.bE = lifecycle;
        this.bA.defaultReturnValue(-1);
    }

    public static <T> MapCodec<a<T>> a(ResourceKey<? extends IRegistry<T>> key, MapCodec<T> entryCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinecraftKey.a.xmap(ResourceKey.d(key), ResourceKey::a).fieldOf("name").forGetter(a::a), (App)Codec.INT.fieldOf("id").forGetter(a::b), (App)entryCodec.forGetter(a::c)).apply((Applicative)instance, a::new));
    }

    @Override
    public <V extends T> V a(int rawId, ResourceKey<T> key, V entry, Lifecycle lifecycle) {
        return this.a(rawId, key, entry, lifecycle, true);
    }

    private <V extends T> V a(int rawId, ResourceKey<T> key, V entry, Lifecycle lifecycle, boolean checkDuplicateKeys) {
        Validate.notNull(key);
        Validate.notNull(entry);
        this.bz.size(Math.max(this.bz.size(), rawId + 1));
        this.bz.set(rawId, entry);
        this.bA.put(entry, rawId);
        this.c = null;
        if (checkDuplicateKeys && this.bC.containsKey(key)) {
            SystemUtils.a("Adding duplicate key '" + key + "' to registry");
        }
        if (this.bB.containsValue(entry)) {
            SystemUtils.a("Adding duplicate value '" + entry + "' to registry");
        }
        this.bB.put((Object)key.a(), entry);
        this.bC.put(key, entry);
        this.bD.put(entry, lifecycle);
        this.bE = this.bE.add(lifecycle);
        if (this.bF <= rawId) {
            this.bF = rawId + 1;
        }
        return entry;
    }

    @Override
    public <V extends T> V a(ResourceKey<T> key, V entry, Lifecycle lifecycle) {
        return this.a(this.bF, key, entry, lifecycle);
    }

    @Override
    public <V extends T> V a(OptionalInt rawId, ResourceKey<T> key, V newEntry, Lifecycle lifecycle) {
        int i2;
        Validate.notNull(key);
        Validate.notNull(newEntry);
        Object object = this.bC.get(key);
        if (object == null) {
            i2 = rawId.isPresent() ? rawId.getAsInt() : this.bF;
        } else {
            i2 = this.bA.getInt(object);
            if (rawId.isPresent() && rawId.getAsInt() != i2) {
                throw new IllegalStateException("ID mismatch");
            }
            this.bA.removeInt(object);
            this.bD.remove(object);
        }
        return this.a(i2, key, newEntry, lifecycle, false);
    }

    @Override
    @Nullable
    public MinecraftKey b(T entry) {
        return (MinecraftKey)this.bB.inverse().get(entry);
    }

    @Override
    public Optional<ResourceKey<T>> c(T entry) {
        return Optional.ofNullable((ResourceKey)this.bC.inverse().get(entry));
    }

    @Override
    public int a(@Nullable T entry) {
        return this.bA.getInt(entry);
    }

    @Override
    @Nullable
    public T a(@Nullable ResourceKey<T> key) {
        return (T)this.bC.get(key);
    }

    @Override
    @Nullable
    public T a(int index) {
        return (T)(index >= 0 && index < this.bz.size() ? this.bz.get(index) : null);
    }

    @Override
    public int b() {
        return this.bB.size();
    }

    @Override
    public Lifecycle d(T entry) {
        return this.bD.get(entry);
    }

    @Override
    public Lifecycle c() {
        return this.bE;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.bz.iterator(), Objects::nonNull);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey id) {
        return (T)this.bB.get((Object)id);
    }

    @Override
    public Set<MinecraftKey> d() {
        return Collections.unmodifiableSet(this.bB.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> e() {
        return Collections.unmodifiableMap(this.bC).entrySet();
    }

    @Override
    public boolean f() {
        return this.bB.isEmpty();
    }

    @Override
    @Nullable
    public T a(Random random) {
        if (this.c == null) {
            Set collection = this.bB.values();
            if (collection.isEmpty()) {
                return null;
            }
            this.c = collection.toArray(Object[]::new);
        }
        return (T)SystemUtils.a(this.c, random);
    }

    @Override
    public boolean c(MinecraftKey id) {
        return this.bB.containsKey((Object)id);
    }

    @Override
    public boolean b(ResourceKey<T> key) {
        return this.bC.containsKey(key);
    }

    public static <T> Codec<RegistryMaterials<T>> a(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, Codec<T> entryCodec) {
        return RegistryMaterials.a(key, entryCodec.fieldOf("element")).codec().listOf().xmap(list -> {
            RegistryMaterials mappedRegistry = new RegistryMaterials(key, lifecycle);
            for (a registryEntry : list) {
                mappedRegistry.a(registryEntry.b(), registryEntry.a(), registryEntry.c(), lifecycle);
            }
            return mappedRegistry;
        }, mappedRegistry -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object object : mappedRegistry) {
                builder.add(new a(mappedRegistry.c(object).get(), mappedRegistry.a(object), object));
            }
            return builder.build();
        });
    }

    public static <T> Codec<RegistryMaterials<T>> b(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, Codec<T> entryCodec) {
        return RegistryDataPackCodec.a(registryRef, lifecycle, entryCodec);
    }

    public static <T> Codec<RegistryMaterials<T>> c(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, Codec<T> entryCodec) {
        return Codec.unboundedMap((Codec)MinecraftKey.a.xmap(ResourceKey.d(key), ResourceKey::a), entryCodec).xmap(map -> {
            RegistryMaterials mappedRegistry = new RegistryMaterials(key, lifecycle);
            map.forEach((? super K resourceKey, ? super V object) -> mappedRegistry.a((ResourceKey)resourceKey, (Object)object, lifecycle));
            return mappedRegistry;
        }, mappedRegistry -> ImmutableMap.copyOf(mappedRegistry.bC));
    }

    record a<T>(ResourceKey<T> a, int b, T c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this, o2);
        }
    }
}

