/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IRegistryCustom {
    static final Logger a = LogManager.getLogger();
    static final Map<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> b = (Map)SystemUtils.a(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        IRegistryCustom.a(builder, IRegistry.Q, DimensionManager.k, DimensionManager.k);
        IRegistryCustom.a(builder, IRegistry.aR, BiomeBase.b, BiomeBase.c);
        IRegistryCustom.a(builder, IRegistry.aL, WorldGenCarverWrapper.a);
        IRegistryCustom.a(builder, IRegistry.aM, WorldGenFeatureConfigured.a);
        IRegistryCustom.a(builder, IRegistry.aN, PlacedFeature.a);
        IRegistryCustom.a(builder, IRegistry.aO, StructureFeature.a);
        IRegistryCustom.a(builder, IRegistry.aP, DefinedStructureStructureProcessorType.m);
        IRegistryCustom.a(builder, IRegistry.aQ, WorldGenFeatureDefinedStructurePoolTemplate.a);
        IRegistryCustom.a(builder, IRegistry.aK, GeneratorSettingBase.a);
        IRegistryCustom.a(builder, IRegistry.aS, NoiseGeneratorNormal.a.a);
        return builder.build();
    });
    private static final Dimension c = SystemUtils.a(() -> {
        Dimension registryHolder = new Dimension();
        DimensionManager.a(registryHolder);
        b.keySet().stream().filter(resourceKey -> !resourceKey.equals(IRegistry.Q)).forEach(resourceKey -> IRegistryCustom.a(registryHolder, resourceKey));
        return registryHolder;
    });

    public abstract <E> Optional<IRegistryWritable<E>> a(ResourceKey<? extends IRegistry<? extends E>> var1);

    public <E> IRegistryWritable<E> b(ResourceKey<? extends IRegistry<? extends E>> key) {
        return this.a(key).orElseThrow(() -> new IllegalStateException("Missing registry: " + key));
    }

    public <E> Optional<? extends IRegistry<E>> c(ResourceKey<? extends IRegistry<? extends E>> key) {
        Optional<IRegistryWritable<E>> optional = this.a(key);
        if (optional.isPresent()) {
            return optional;
        }
        return IRegistry.g.b(key.a());
    }

    public <E> IRegistry<E> d(ResourceKey<? extends IRegistry<? extends E>> key) {
        return this.c(key).orElseThrow(() -> new IllegalStateException("Missing registry: " + key));
    }

    private static <E> void a(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> infosBuilder, ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> entryCodec) {
        infosBuilder.put(registryRef, new RegistryData<E>(registryRef, entryCodec, null));
    }

    private static <E> void a(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> infosBuilder, ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> entryCodec, Codec<E> networkEntryCodec) {
        infosBuilder.put(registryRef, new RegistryData<E>(registryRef, entryCodec, networkEntryCodec));
    }

    public static Iterable<RegistryData<?>> a() {
        return b.values();
    }

    public static Dimension b() {
        Dimension registryHolder = new Dimension();
        RegistryResourceAccess.InMemoryStorage inMemoryStorage = new RegistryResourceAccess.InMemoryStorage();
        for (RegistryData<?> registryData : b.values()) {
            IRegistryCustom.a(registryHolder, inMemoryStorage, registryData);
        }
        RegistryReadOps.a(JsonOps.INSTANCE, inMemoryStorage, (IRegistryCustom)registryHolder);
        return registryHolder;
    }

    private static <E> void a(Dimension registryManager, RegistryResourceAccess.InMemoryStorage entryLoader, RegistryData<E> info) {
        ResourceKey<IRegistry<E>> resourceKey = info.b();
        boolean bl = !resourceKey.equals(IRegistry.aK) && !resourceKey.equals(IRegistry.Q);
        IRegistry<E> registry = c.d(resourceKey);
        IRegistryWritable<E> writableRegistry = registryManager.b(resourceKey);
        for (Map.Entry<ResourceKey<E>, E> entry : registry.e()) {
            ResourceKey<E> resourceKey2 = entry.getKey();
            E object = entry.getValue();
            if (bl) {
                entryLoader.a(c, resourceKey2, info.c(), registry.a(object), object, registry.d(object));
                continue;
            }
            writableRegistry.a(registry.a(object), resourceKey2, object, registry.d(object));
        }
    }

    private static <R extends IRegistry<?>> void a(Dimension manager, ResourceKey<R> registryRef) {
        IRegistry<IRegistry<?>> registry = RegistryGeneration.b;
        IRegistry<?> registry2 = registry.d(registryRef);
        IRegistryCustom.a(manager, registry2);
    }

    private static <E> void a(Dimension manager, IRegistry<E> registry) {
        IRegistryWritable<E> writableRegistry = manager.b(registry.g());
        for (Map.Entry<ResourceKey<E>, E> entry : registry.e()) {
            E object = entry.getValue();
            writableRegistry.a(registry.a(object), entry.getKey(), object, registry.d(object));
        }
    }

    public static void a(IRegistryCustom manager, RegistryReadOps<?> ops) {
        for (RegistryData<?> registryData : b.values()) {
            IRegistryCustom.a(ops, manager, registryData);
        }
    }

    private static <E> void a(RegistryReadOps<?> ops, IRegistryCustom manager, RegistryData<E> info) {
        ResourceKey<IRegistry<E>> resourceKey = info.b();
        RegistryMaterials mappedRegistry = (RegistryMaterials)manager.b(resourceKey);
        DataResult<RegistryMaterials<E>> dataResult = ops.a(mappedRegistry, info.b(), info.c());
        dataResult.error().ifPresent(partialResult -> {
            throw new JsonParseException("Error loading registry data: " + partialResult.message());
        });
    }

    public record RegistryData<E>(ResourceKey<? extends IRegistry<E>> a, Codec<E> b, @Nullable Codec<E> c) {
        private final ResourceKey<? extends IRegistry<E>> a;
        private final Codec<E> b;
        @Nullable
        private final Codec<E> c;

        public boolean a() {
            return this.c != null;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "a", "b", "c"}, this, object);
        }

        public ResourceKey<? extends IRegistry<E>> b() {
            return this.a;
        }

        public Codec<E> c() {
            return this.b;
        }

        @Nullable
        public Codec<E> d() {
            return this.c;
        }
    }

    public static final class Dimension
    extends IRegistryCustom {
        public static final Codec<Dimension> a = Dimension.c();
        private final Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends RegistryMaterials<?>> b;

        private static <E> Codec<Dimension> c() {
            Codec codec = MinecraftKey.a.xmap(ResourceKey::a, ResourceKey::a);
            Codec codec2 = codec.partialDispatch("type", mappedRegistry -> DataResult.success(mappedRegistry.g()), resourceKey -> Dimension.e(resourceKey).map(codec -> RegistryMaterials.a(resourceKey, Lifecycle.experimental(), codec)));
            UnboundedMapCodec unboundedMapCodec = Codec.unboundedMap((Codec)codec, (Codec)codec2);
            return Dimension.a(unboundedMapCodec);
        }

        private static <K extends ResourceKey<? extends IRegistry<?>>, V extends RegistryMaterials<?>> Codec<Dimension> a(UnboundedMapCodec<K, V> unboundedMapCodec) {
            return unboundedMapCodec.xmap(Dimension::new, registryHolder -> (Map)registryHolder.b.entrySet().stream().filter(entry -> b.get(entry.getKey()).a()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private static <E> DataResult<? extends Codec<E>> e(ResourceKey<? extends IRegistry<E>> registryRef) {
            return Optional.ofNullable(b.get(registryRef)).map(registryData -> registryData.d()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + registryRef)));
        }

        public Dimension() {
            this(b.keySet().stream().collect(Collectors.toMap(Function.identity(), Dimension::f)));
        }

        public static IRegistryCustom a(Dynamic<?> dynamic) {
            return new Dimension(b.keySet().stream().collect(Collectors.toMap(Function.identity(), resourceKey -> Dimension.a(resourceKey, dynamic))));
        }

        private static <E> RegistryMaterials<?> a(ResourceKey<? extends IRegistry<?>> resourceKey, Dynamic<?> dynamic) {
            return (RegistryMaterials)RegistryLookupCodec.a(resourceKey).codec().parse(dynamic).resultOrPartial(SystemUtils.a(resourceKey + " registry: ", arg_0 -> ((Logger)a).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get " + resourceKey + " registry"));
        }

        private Dimension(Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends RegistryMaterials<?>> registries) {
            this.b = registries;
        }

        private static <E> RegistryMaterials<?> f(ResourceKey<? extends IRegistry<?>> registryRef) {
            return new RegistryMaterials(registryRef, Lifecycle.stable());
        }

        @Override
        @Override
        public <E> Optional<IRegistryWritable<E>> a(ResourceKey<? extends IRegistry<? extends E>> key) {
            return Optional.ofNullable(this.b.get(key)).map(mappedRegistry -> mappedRegistry);
        }
    }
}

