/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;

public final class EnumDirection
extends Enum<EnumDirection>
implements INamable {
    public static final /* enum */ EnumDirection a = new EnumDirection(0, 1, -1, "down", EnumAxisDirection.b, EnumAxis.b, new BaseBlockPosition(0, -1, 0));
    public static final /* enum */ EnumDirection b = new EnumDirection(1, 0, -1, "up", EnumAxisDirection.a, EnumAxis.b, new BaseBlockPosition(0, 1, 0));
    public static final /* enum */ EnumDirection c = new EnumDirection(2, 3, 2, "north", EnumAxisDirection.b, EnumAxis.c, new BaseBlockPosition(0, 0, -1));
    public static final /* enum */ EnumDirection d = new EnumDirection(3, 2, 0, "south", EnumAxisDirection.a, EnumAxis.c, new BaseBlockPosition(0, 0, 1));
    public static final /* enum */ EnumDirection e = new EnumDirection(4, 5, 1, "west", EnumAxisDirection.b, EnumAxis.a, new BaseBlockPosition(-1, 0, 0));
    public static final /* enum */ EnumDirection f = new EnumDirection(5, 4, 3, "east", EnumAxisDirection.a, EnumAxis.a, new BaseBlockPosition(1, 0, 0));
    public static final Codec<EnumDirection> g;
    public static final Codec<EnumDirection> h;
    private final int i;
    private final int j;
    private final int k;
    private final String l;
    private final EnumAxis m;
    private final EnumAxisDirection n;
    private final BaseBlockPosition o;
    private static final EnumDirection[] p;
    private static final Map<String, EnumDirection> q;
    private static final EnumDirection[] r;
    private static final EnumDirection[] s;
    private static final Long2ObjectMap<EnumDirection> t;
    private final int adjX;
    private final int adjY;
    private final int adjZ;
    private static final /* synthetic */ EnumDirection[] u;

    public static EnumDirection[] values() {
        return (EnumDirection[])u.clone();
    }

    public static EnumDirection valueOf(String name) {
        return Enum.valueOf(EnumDirection.class, name);
    }

    private EnumDirection(int id, int idOpposite, int idHorizontal, String name, EnumAxisDirection direction, EnumAxis axis, BaseBlockPosition vector) {
        this.i = id;
        this.k = idHorizontal;
        this.j = idOpposite;
        this.l = name;
        this.m = axis;
        this.n = direction;
        this.o = vector;
        this.adjX = vector.u();
        this.adjY = vector.v();
        this.adjZ = vector.w();
    }

    public static EnumDirection[] a(Entity entity) {
        EnumDirection direction3;
        float f2 = entity.f(1.0f) * ((float)Math.PI / 180);
        float g2 = -entity.g(1.0f) * ((float)Math.PI / 180);
        float h2 = MathHelper.a(f2);
        float i2 = MathHelper.b(f2);
        float j2 = MathHelper.a(g2);
        float k2 = MathHelper.b(g2);
        boolean bl = j2 > 0.0f;
        boolean bl2 = h2 < 0.0f;
        boolean bl3 = k2 > 0.0f;
        float l2 = bl ? j2 : -j2;
        float m2 = bl2 ? -h2 : h2;
        float n2 = bl3 ? k2 : -k2;
        float o2 = l2 * i2;
        float p2 = n2 * i2;
        EnumDirection direction = bl ? f : e;
        EnumDirection direction2 = bl2 ? b : a;
        EnumDirection enumDirection = direction3 = bl3 ? d : c;
        if (l2 > n2) {
            if (m2 > o2) {
                return EnumDirection.a(direction2, direction, direction3);
            }
            return p2 > m2 ? EnumDirection.a(direction, direction3, direction2) : EnumDirection.a(direction, direction2, direction3);
        }
        if (m2 > p2) {
            return EnumDirection.a(direction2, direction3, direction);
        }
        return o2 > m2 ? EnumDirection.a(direction3, direction, direction2) : EnumDirection.a(direction3, direction2, direction);
    }

    private static EnumDirection[] a(EnumDirection first, EnumDirection second, EnumDirection third) {
        return new EnumDirection[]{first, second, third, third.f(), second.f(), first.f()};
    }

    public static EnumDirection a(Matrix4f matrix, EnumDirection direction) {
        BaseBlockPosition vec3i = direction.p();
        Vector4f vector4f = new Vector4f(vec3i.u(), vec3i.v(), vec3i.w(), 0.0f);
        vector4f.a(matrix);
        return EnumDirection.a(vector4f.a(), vector4f.b(), vector4f.c());
    }

    public Quaternion a() {
        Quaternion quaternion = Vector3fa.c.c(90.0f);
        return switch (this) {
            case a -> Vector3fa.c.c(180.0f);
            case b -> Quaternion.a.k();
            case c -> {
                quaternion.a(Vector3fa.g.c(180.0f));
                yield quaternion;
            }
            case d -> quaternion;
            case e -> {
                quaternion.a(Vector3fa.g.c(90.0f));
                yield quaternion;
            }
            case f -> {
                quaternion.a(Vector3fa.g.c(-90.0f));
                yield quaternion;
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public int b() {
        return this.i;
    }

    public int d() {
        return this.k;
    }

    public EnumAxisDirection e() {
        return this.n;
    }

    public static EnumDirection a(Entity entity, EnumAxis axis) {
        return switch (axis) {
            case EnumAxis.a -> f.a(entity.g(1.0f)) ? f : e;
            case EnumAxis.c -> d.a(entity.g(1.0f)) ? d : c;
            case EnumAxis.b -> entity.f(1.0f) < 0.0f ? b : a;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public EnumDirection f() {
        return EnumDirection.a(this.j);
    }

    public EnumDirection a(EnumAxis axis) {
        return switch (axis) {
            case EnumAxis.a -> this != e && this != f ? this.q() : this;
            case EnumAxis.c -> this != c && this != d ? this.s() : this;
            case EnumAxis.b -> this != b && this != a ? this.g() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public EnumDirection b(EnumAxis axis) {
        return switch (axis) {
            case EnumAxis.a -> this != e && this != f ? this.r() : this;
            case EnumAxis.c -> this != c && this != d ? this.t() : this;
            case EnumAxis.b -> this != b && this != a ? this.h() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public EnumDirection g() {
        return switch (this) {
            case c -> f;
            case d -> e;
            case e -> c;
            case f -> d;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
        };
    }

    private EnumDirection q() {
        return switch (this) {
            case a -> d;
            case b -> c;
            case c -> a;
            case d -> b;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private EnumDirection r() {
        return switch (this) {
            case a -> c;
            case b -> d;
            case c -> b;
            case d -> a;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private EnumDirection s() {
        return switch (this) {
            case a -> e;
            case b -> f;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case e -> b;
            case f -> a;
        };
    }

    private EnumDirection t() {
        return switch (this) {
            case a -> f;
            case b -> e;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case e -> a;
            case f -> b;
        };
    }

    public EnumDirection h() {
        return switch (this) {
            case c -> e;
            case d -> f;
            case e -> d;
            case f -> c;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + this);
        };
    }

    public int i() {
        return this.adjX;
    }

    public int j() {
        return this.adjY;
    }

    public int k() {
        return this.adjZ;
    }

    public Vector3fa l() {
        return new Vector3fa(this.i(), this.j(), this.k());
    }

    public String m() {
        return this.l;
    }

    public EnumAxis n() {
        return this.m;
    }

    @Nullable
    public static EnumDirection a(@Nullable String name) {
        return name == null ? null : q.get(name.toLowerCase(Locale.ROOT));
    }

    public static EnumDirection a(int id) {
        return r[MathHelper.a(id % r.length)];
    }

    public static EnumDirection b(int value) {
        return s[MathHelper.a(value % s.length)];
    }

    @Nullable
    public static EnumDirection a(BlockPosition pos) {
        return (EnumDirection)t.get(pos.a());
    }

    @Nullable
    public static EnumDirection a(int x2, int y2, int z2) {
        return (EnumDirection)t.get(BlockPosition.a(x2, y2, z2));
    }

    public static EnumDirection a(double rotation) {
        return EnumDirection.b(MathHelper.b(rotation / 90.0 + 0.5) & 3);
    }

    public static EnumDirection a(EnumAxis axis, EnumAxisDirection direction) {
        return switch (axis) {
            case EnumAxis.a -> direction == EnumAxisDirection.a ? f : e;
            case EnumAxis.c -> direction == EnumAxisDirection.a ? d : c;
            case EnumAxis.b -> direction == EnumAxisDirection.a ? b : a;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public float o() {
        return (this.k & 3) * 90;
    }

    public static EnumDirection a(Random random) {
        return SystemUtils.a(p, random);
    }

    public static EnumDirection a(double x2, double y2, double z2) {
        return EnumDirection.a((float)x2, (float)y2, (float)z2);
    }

    public static EnumDirection a(float x2, float y2, float z2) {
        EnumDirection direction = c;
        float f2 = Float.MIN_VALUE;
        for (EnumDirection direction2 : p) {
            float g2 = x2 * (float)direction2.o.u() + y2 * (float)direction2.o.v() + z2 * (float)direction2.o.w();
            if (!(g2 > f2)) continue;
            f2 = g2;
            direction = direction2;
        }
        return direction;
    }

    public String toString() {
        return this.l;
    }

    @Override
    public String c() {
        return this.l;
    }

    private static DataResult<EnumDirection> a(EnumDirection direction) {
        return direction.n().b() ? DataResult.success((Object)direction) : DataResult.error((String)"Expected a vertical direction");
    }

    public static EnumDirection a(EnumAxisDirection direction, EnumAxis axis) {
        for (EnumDirection direction2 : p) {
            if (direction2.e() != direction || direction2.n() != axis) continue;
            return direction2;
        }
        throw new IllegalArgumentException("No such direction: " + direction + " " + axis);
    }

    public BaseBlockPosition p() {
        return this.o;
    }

    public boolean a(float yaw) {
        float f2 = yaw * ((float)Math.PI / 180);
        float g2 = -MathHelper.a(f2);
        float h2 = MathHelper.b(f2);
        return (float)this.o.u() * g2 + (float)this.o.w() * h2 > 0.0f;
    }

    private static /* synthetic */ EnumDirection[] u() {
        return new EnumDirection[]{a, b, c, d, e, f};
    }

    static {
        u = EnumDirection.u();
        g = INamable.a(EnumDirection::values, EnumDirection::a);
        h = g.flatXmap(EnumDirection::a, EnumDirection::a);
        p = EnumDirection.values();
        q = Arrays.stream(p).collect(Collectors.toMap(EnumDirection::m, direction -> direction));
        r = (EnumDirection[])Arrays.stream(p).sorted(Comparator.comparingInt(direction -> direction.i)).toArray(EnumDirection[]::new);
        s = (EnumDirection[])Arrays.stream(p).filter(direction -> direction.n().d()).sorted(Comparator.comparingInt(direction -> direction.k)).toArray(EnumDirection[]::new);
        t = (Long2ObjectMap)Arrays.stream(p).collect(Collectors.toMap(direction -> new BlockPosition(direction.p()).a(), direction -> direction, (direction1, direction2) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class EnumAxis
    extends Enum<EnumAxis>
    implements INamable,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumAxis a = new EnumAxis("x"){

            @Override
            public int a(int x2, int y2, int z2) {
                return x2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return x2;
            }
        };
        public static final /* enum */ EnumAxis b = new EnumAxis("y"){

            @Override
            public int a(int x2, int y2, int z2) {
                return y2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return y2;
            }
        };
        public static final /* enum */ EnumAxis c = new EnumAxis("z"){

            @Override
            public int a(int x2, int y2, int z2) {
                return z2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return z2;
            }
        };
        public static final EnumAxis[] d;
        public static final Codec<EnumAxis> e;
        private static final Map<String, EnumAxis> f;
        private final String g;
        private static final /* synthetic */ EnumAxis[] h;

        public static EnumAxis[] values() {
            return (EnumAxis[])h.clone();
        }

        public static EnumAxis valueOf(String name) {
            return Enum.valueOf(EnumAxis.class, name);
        }

        private EnumAxis(String name) {
            this.g = name;
        }

        @Nullable
        public static EnumAxis a(String name) {
            return f.get(name.toLowerCase(Locale.ROOT));
        }

        public String a() {
            return this.g;
        }

        public boolean b() {
            return this == b;
        }

        public boolean d() {
            return this == a || this == c;
        }

        public String toString() {
            return this.g;
        }

        public static EnumAxis a(Random random) {
            return SystemUtils.a(d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.n() == this;
        }

        public EnumDirectionLimit e() {
            return switch (this) {
                case a, c -> EnumDirectionLimit.a;
                case b -> EnumDirectionLimit.b;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @Override
        public String c() {
            return this.g;
        }

        public abstract int a(int var1, int var2, int var3);

        public abstract double a(double var1, double var3, double var5);

        private static /* synthetic */ EnumAxis[] f() {
            return new EnumAxis[]{a, b, c};
        }

        static {
            h = EnumAxis.f();
            d = EnumAxis.values();
            e = INamable.a(EnumAxis::values, EnumAxis::a);
            f = Arrays.stream(d).collect(Collectors.toMap(EnumAxis::a, axis -> axis));
        }
    }

    public static final class EnumAxisDirection
    extends Enum<EnumAxisDirection> {
        public static final /* enum */ EnumAxisDirection a = new EnumAxisDirection(1, "Towards positive");
        public static final /* enum */ EnumAxisDirection b = new EnumAxisDirection(-1, "Towards negative");
        private final int c;
        private final String d;
        private static final /* synthetic */ EnumAxisDirection[] e;

        public static EnumAxisDirection[] values() {
            return (EnumAxisDirection[])e.clone();
        }

        public static EnumAxisDirection valueOf(String name) {
            return Enum.valueOf(EnumAxisDirection.class, name);
        }

        private EnumAxisDirection(int offset, String description) {
            this.c = offset;
            this.d = description;
        }

        public int a() {
            return this.c;
        }

        public String b() {
            return this.d;
        }

        public String toString() {
            return this.d;
        }

        public EnumAxisDirection c() {
            return this == a ? b : a;
        }

        private static /* synthetic */ EnumAxisDirection[] d() {
            return new EnumAxisDirection[]{a, b};
        }

        static {
            e = EnumAxisDirection.d();
        }
    }

    public static final class EnumDirectionLimit
    extends Enum<EnumDirectionLimit>
    implements Iterable<EnumDirection>,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumDirectionLimit a = new EnumDirectionLimit(new EnumDirection[]{c, f, d, e}, new EnumAxis[]{EnumAxis.a, EnumAxis.c});
        public static final /* enum */ EnumDirectionLimit b = new EnumDirectionLimit(new EnumDirection[]{b, a}, new EnumAxis[]{EnumAxis.b});
        private final EnumDirection[] c;
        private final EnumAxis[] d;
        private static final /* synthetic */ EnumDirectionLimit[] e;

        public static EnumDirectionLimit[] values() {
            return (EnumDirectionLimit[])e.clone();
        }

        public static EnumDirectionLimit valueOf(String name) {
            return Enum.valueOf(EnumDirectionLimit.class, name);
        }

        private EnumDirectionLimit(EnumDirection[] facingArray, EnumAxis[] axisArray) {
            this.c = facingArray;
            this.d = axisArray;
        }

        public EnumDirection a(Random random) {
            return SystemUtils.a(this.c, random);
        }

        public EnumAxis b(Random random) {
            return SystemUtils.a(this.d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.n().e() == this;
        }

        @Override
        public Iterator<EnumDirection> iterator() {
            return Iterators.forArray((Object[])this.c);
        }

        public Stream<EnumDirection> a() {
            return Arrays.stream(this.c);
        }

        private static /* synthetic */ EnumDirectionLimit[] b() {
            return new EnumDirectionLimit[]{a, b};
        }

        static {
            e = EnumDirectionLimit.b();
        }
    }
}

