/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionRange;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class ArgumentParserSelector {
    public static final char a = '@';
    private static final char p = '[';
    private static final char q = ']';
    public static final char b = '=';
    private static final char r = ',';
    public static final char c = '!';
    public static final char d = '#';
    private static final char s = 'p';
    private static final char t = 'a';
    private static final char u = 'r';
    private static final char v = 's';
    private static final char w = 'e';
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.invalid"));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(object -> new ChatMessage("argument.entity.selector.unknown", object));
    public static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.selector.not_allowed"));
    public static final SimpleCommandExceptionType h = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.selector.missing"));
    public static final SimpleCommandExceptionType i = new SimpleCommandExceptionType((Message)new ChatMessage("argument.entity.options.unterminated"));
    public static final DynamicCommandExceptionType j = new DynamicCommandExceptionType(object -> new ChatMessage("argument.entity.options.valueless", object));
    public static final BiConsumer<Vec3D, List<? extends Entity>> k = (vec3d, list) -> {};
    public static final BiConsumer<Vec3D, List<? extends Entity>> l = (vec3d, list) -> list.sort((entity, entity1) -> Doubles.compare((double)entity.f((Vec3D)vec3d), (double)entity1.f((Vec3D)vec3d)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> m = (vec3d, list) -> list.sort((entity, entity1) -> Doubles.compare((double)entity1.f((Vec3D)vec3d), (double)entity.f((Vec3D)vec3d)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> n = (vec3d, list) -> Collections.shuffle(list);
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> o = (suggestionsbuilder, consumer) -> suggestionsbuilder.buildFuture();
    private final StringReader x;
    private final boolean y;
    private int z;
    private boolean A;
    private boolean B;
    private CriterionConditionValue.DoubleRange C;
    private CriterionConditionValue.IntegerRange D;
    @Nullable
    private Double E;
    @Nullable
    private Double F;
    @Nullable
    private Double G;
    @Nullable
    private Double H;
    @Nullable
    private Double I;
    @Nullable
    private Double J;
    private CriterionConditionRange K;
    private CriterionConditionRange L;
    private Predicate<Entity> M;
    private BiConsumer<Vec3D, List<? extends Entity>> N;
    private boolean O;
    @Nullable
    private String P;
    private int Q;
    @Nullable
    private UUID R;
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> S;
    private boolean T;
    private boolean U;
    private boolean V;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    private boolean aa;
    @Nullable
    private EntityTypes<?> ab;
    private boolean ac;
    private boolean ad;
    private boolean ae;
    private boolean af;
    public boolean parsingEntityArgumentSuggestions;

    public ArgumentParserSelector(StringReader reader) {
        this(reader, true);
    }

    public ArgumentParserSelector(StringReader reader, boolean atAllowed) {
        this(reader, atAllowed, false);
    }

    public ArgumentParserSelector(StringReader reader, boolean atAllowed, boolean parsingEntityArgumentSuggestions) {
        this.parsingEntityArgumentSuggestions = parsingEntityArgumentSuggestions;
        this.C = CriterionConditionValue.DoubleRange.e;
        this.D = CriterionConditionValue.IntegerRange.e;
        this.K = CriterionConditionRange.a;
        this.L = CriterionConditionRange.a;
        this.M = entity -> true;
        this.N = k;
        this.S = o;
        this.x = reader;
        this.y = atAllowed;
    }

    public EntitySelector a() {
        AxisAlignedBB axisalignedbb;
        if (this.H == null && this.I == null && this.J == null) {
            if (this.C.b() != null) {
                double d0 = (Double)this.C.b();
                axisalignedbb = new AxisAlignedBB(-d0, -d0, -d0, d0 + 1.0, d0 + 1.0, d0 + 1.0);
            } else {
                axisalignedbb = null;
            }
        } else {
            axisalignedbb = this.a(this.H == null ? 0.0 : this.H, this.I == null ? 0.0 : this.I, this.J == null ? 0.0 : this.J);
        }
        Function<Vec3D, Vec3D> function = this.E == null && this.F == null && this.G == null ? vec3d -> vec3d : vec3d -> new Vec3D(this.E == null ? vec3d.b : this.E, this.F == null ? vec3d.c : this.F, this.G == null ? vec3d.d : this.G);
        return new EntitySelector(this.z, this.A, this.B, this.M, this.C, function, axisalignedbb, this.N, this.O, this.P, this.R, this.ab, this.af);
    }

    private AxisAlignedBB a(double x2, double y2, double z2) {
        boolean flag = x2 < 0.0;
        boolean flag1 = y2 < 0.0;
        boolean flag2 = z2 < 0.0;
        double d3 = flag ? x2 : 0.0;
        double d4 = flag1 ? y2 : 0.0;
        double d5 = flag2 ? z2 : 0.0;
        double d6 = (flag ? 0.0 : x2) + 1.0;
        double d7 = (flag1 ? 0.0 : y2) + 1.0;
        double d8 = (flag2 ? 0.0 : z2) + 1.0;
        return new AxisAlignedBB(d3, d4, d5, d6, d7, d8);
    }

    private void I() {
        if (this.K != CriterionConditionRange.a) {
            this.M = this.M.and(this.a(this.K, Entity::dn));
        }
        if (this.L != CriterionConditionRange.a) {
            this.M = this.M.and(this.a(this.L, Entity::dm));
        }
        if (!this.D.c()) {
            this.M = this.M.and(entity -> !(entity instanceof EntityPlayer) ? false : this.D.d(((EntityPlayer)entity).cj));
        }
    }

    private Predicate<Entity> a(CriterionConditionRange angleRange, ToDoubleFunction<Entity> entityToAngle) {
        double d0 = MathHelper.g(angleRange.a() == null ? 0.0f : angleRange.a().floatValue());
        double d1 = MathHelper.g(angleRange.b() == null ? 359.0f : angleRange.b().floatValue());
        return entity -> {
            double d2 = MathHelper.f(entityToAngle.applyAsDouble((Entity)entity));
            return d0 > d1 ? d2 >= d0 || d2 <= d1 : d2 >= d0 && d2 <= d1;
        };
    }

    protected void parseSelector(boolean overridePermissions) throws CommandSyntaxException {
        this.af = !overridePermissions;
        this.S = this::d;
        if (!this.x.canRead()) {
            throw h.createWithContext((ImmutableStringReader)this.x);
        }
        int i2 = this.x.getCursor();
        char c0 = this.x.read();
        if (c0 == 'p') {
            this.z = 1;
            this.A = false;
            this.N = l;
            this.a(EntityTypes.bi);
        } else if (c0 == 'a') {
            this.z = Integer.MAX_VALUE;
            this.A = false;
            this.N = k;
            this.a(EntityTypes.bi);
        } else if (c0 == 'r') {
            this.z = 1;
            this.A = false;
            this.N = n;
            this.a(EntityTypes.bi);
        } else if (c0 == 's') {
            this.z = 1;
            this.A = true;
            this.O = true;
        } else {
            if (c0 != 'e') {
                this.x.setCursor(i2);
                throw f.createWithContext((ImmutableStringReader)this.x, (Object)("@" + String.valueOf(c0)));
            }
            this.z = Integer.MAX_VALUE;
            this.A = true;
            this.N = k;
            this.M = Entity::bl;
        }
        this.S = this::e;
        if (this.x.canRead() && this.x.peek() == '[') {
            this.x.skip();
            this.S = this::f;
            this.d();
        }
    }

    protected void c() throws CommandSyntaxException {
        if (this.x.canRead()) {
            this.S = this::c;
        }
        int i2 = this.x.getCursor();
        String s2 = this.x.readString();
        try {
            this.R = UUID.fromString(s2);
            this.A = true;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            if (s2.isEmpty() || s2.length() > 16) {
                this.x.setCursor(i2);
                throw e.createWithContext((ImmutableStringReader)this.x);
            }
            this.A = false;
            this.P = s2;
        }
        this.z = 1;
    }

    protected void d() throws CommandSyntaxException {
        this.S = this::g;
        this.x.skipWhitespace();
        while (this.x.canRead() && this.x.peek() != ']') {
            this.x.skipWhitespace();
            int i2 = this.x.getCursor();
            String s2 = this.x.readString();
            PlayerSelector.a playerselector_a = PlayerSelector.a(this, s2, i2);
            this.x.skipWhitespace();
            if (!this.x.canRead() || this.x.peek() != '=') {
                this.x.setCursor(i2);
                throw j.createWithContext((ImmutableStringReader)this.x, (Object)s2);
            }
            this.x.skip();
            this.x.skipWhitespace();
            this.S = o;
            playerselector_a.handle(this);
            this.x.skipWhitespace();
            this.S = this::h;
            if (!this.x.canRead()) continue;
            if (this.x.peek() == ',') {
                this.x.skip();
                this.S = this::g;
                continue;
            }
            if (this.x.peek() == ']') break;
            throw i.createWithContext((ImmutableStringReader)this.x);
        }
        if (this.x.canRead()) {
            this.x.skip();
            this.S = o;
            return;
        }
        throw i.createWithContext((ImmutableStringReader)this.x);
    }

    public boolean e() {
        this.x.skipWhitespace();
        if (this.x.canRead() && this.x.peek() == '!') {
            this.x.skip();
            this.x.skipWhitespace();
            return true;
        }
        return false;
    }

    public boolean f() {
        this.x.skipWhitespace();
        if (this.x.canRead() && this.x.peek() == '#') {
            this.x.skip();
            this.x.skipWhitespace();
            return true;
        }
        return false;
    }

    public StringReader g() {
        return this.x;
    }

    public void a(Predicate<Entity> predicate) {
        this.M = this.M.and(predicate);
    }

    public void h() {
        this.B = true;
    }

    public CriterionConditionValue.DoubleRange i() {
        return this.C;
    }

    public void a(CriterionConditionValue.DoubleRange distance) {
        this.C = distance;
    }

    public CriterionConditionValue.IntegerRange j() {
        return this.D;
    }

    public void a(CriterionConditionValue.IntegerRange experienceRange) {
        this.D = experienceRange;
    }

    public CriterionConditionRange k() {
        return this.K;
    }

    public void a(CriterionConditionRange pitchRange) {
        this.K = pitchRange;
    }

    public CriterionConditionRange l() {
        return this.L;
    }

    public void b(CriterionConditionRange yawRange) {
        this.L = yawRange;
    }

    @Nullable
    public Double m() {
        return this.E;
    }

    @Nullable
    public Double n() {
        return this.F;
    }

    @Nullable
    public Double o() {
        return this.G;
    }

    public void a(double x2) {
        this.E = x2;
    }

    public void b(double y2) {
        this.F = y2;
    }

    public void c(double z2) {
        this.G = z2;
    }

    public void d(double dx) {
        this.H = dx;
    }

    public void e(double dy) {
        this.I = dy;
    }

    public void f(double dz) {
        this.J = dz;
    }

    @Nullable
    public Double p() {
        return this.H;
    }

    @Nullable
    public Double q() {
        return this.I;
    }

    @Nullable
    public Double r() {
        return this.J;
    }

    public void a(int limit) {
        this.z = limit;
    }

    public void a(boolean includesNonPlayers) {
        this.A = includesNonPlayers;
    }

    public BiConsumer<Vec3D, List<? extends Entity>> s() {
        return this.N;
    }

    public void a(BiConsumer<Vec3D, List<? extends Entity>> sorter) {
        this.N = sorter;
    }

    public EntitySelector t() throws CommandSyntaxException {
        return this.parse(false);
    }

    public EntitySelector parse(boolean overridePermissions) throws CommandSyntaxException {
        this.Q = this.x.getCursor();
        this.S = this::b;
        if (this.x.canRead() && this.x.peek() == '@') {
            if (!this.y) {
                throw g.createWithContext((ImmutableStringReader)this.x);
            }
            this.x.skip();
            this.parseSelector(overridePermissions);
        } else {
            this.c();
        }
        this.I();
        return this.a();
    }

    private static void a(SuggestionsBuilder builder) {
        builder.suggest("@p", (Message)new ChatMessage("argument.entity.selector.nearestPlayer"));
        builder.suggest("@a", (Message)new ChatMessage("argument.entity.selector.allPlayers"));
        builder.suggest("@r", (Message)new ChatMessage("argument.entity.selector.randomPlayer"));
        builder.suggest("@s", (Message)new ChatMessage("argument.entity.selector.self"));
        builder.suggest("@e", (Message)new ChatMessage("argument.entity.selector.allEntities"));
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        consumer.accept(builder);
        if (this.y) {
            ArgumentParserSelector.a(builder);
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsbuilder1 = builder.createOffset(this.Q);
        consumer.accept(suggestionsbuilder1);
        return builder.add(suggestionsbuilder1).buildFuture();
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsbuilder1 = builder.createOffset(builder.getStart() - 1);
        ArgumentParserSelector.a(suggestionsbuilder1);
        builder.add(suggestionsbuilder1);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> e(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('['));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> f(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(']'));
        PlayerSelector.a(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> g(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        PlayerSelector.a(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> h(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(','));
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> i(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('='));
        return builder.buildFuture();
    }

    public boolean u() {
        return this.O;
    }

    public void a(BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestionProvider) {
        this.S = suggestionProvider;
    }

    public CompletableFuture<Suggestions> a(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        return this.S.apply(builder.createOffset(this.x.getCursor()), consumer);
    }

    public boolean v() {
        return this.T;
    }

    public void b(boolean selectsName) {
        this.T = selectsName;
    }

    public boolean w() {
        return this.U;
    }

    public void c(boolean excludesName) {
        this.U = excludesName;
    }

    public boolean x() {
        return this.V;
    }

    public void d(boolean hasLimit) {
        this.V = hasLimit;
    }

    public boolean y() {
        return this.W;
    }

    public void e(boolean hasSorter) {
        this.W = hasSorter;
    }

    public boolean z() {
        return this.X;
    }

    public void f(boolean selectsGameMode) {
        this.X = selectsGameMode;
    }

    public boolean A() {
        return this.Y;
    }

    public void g(boolean hasNegatedGameMode) {
        this.Y = hasNegatedGameMode;
    }

    public boolean B() {
        return this.Z;
    }

    public void h(boolean selectsTeam) {
        this.Z = selectsTeam;
    }

    public boolean C() {
        return this.aa;
    }

    public void i(boolean excludesTeam) {
        this.aa = excludesTeam;
    }

    public void a(EntityTypes<?> entityType) {
        this.ab = entityType;
    }

    public void D() {
        this.ac = true;
    }

    public boolean E() {
        return this.ab != null;
    }

    public boolean F() {
        return this.ac;
    }

    public boolean G() {
        return this.ad;
    }

    public void j(boolean selectsScores) {
        this.ad = selectsScores;
    }

    public boolean H() {
        return this.ae;
    }

    public void k(boolean selectsAdvancements) {
        this.ae = selectsAdvancements;
    }
}

