/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.Tags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlock {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)new ChatMessage("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> new ChatMessage("argument.block.id.invalid", object));
    public static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((object, object1) -> new ChatMessage("argument.block.property.unknown", object, object1));
    public static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((object, object1) -> new ChatMessage("argument.block.property.duplicate", object1, object));
    public static final Dynamic3CommandExceptionType e = new Dynamic3CommandExceptionType((object, object1, object2) -> new ChatMessage("argument.block.property.invalid", object, object2, object1));
    public static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((object, object1) -> new ChatMessage("argument.block.property.novalue", object, object1));
    public static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)new ChatMessage("argument.block.property.unclosed"));
    private static final char h = '[';
    private static final char i = '{';
    private static final char j = ']';
    private static final char k = '=';
    private static final char l = ',';
    private static final char m = '#';
    private static final BiFunction<SuggestionsBuilder, Tags<Block>, CompletableFuture<Suggestions>> n = (suggestionsbuilder, tags) -> suggestionsbuilder.buildFuture();
    private final StringReader o;
    private final boolean p;
    private final Map<IBlockState<?>, Comparable<?>> q = Maps.newLinkedHashMap();
    private final Map<String, String> r = Maps.newHashMap();
    public MinecraftKey s = new MinecraftKey("");
    private BlockStateList<Block, IBlockData> t;
    private IBlockData u;
    @Nullable
    private NBTTagCompound v;
    private MinecraftKey w = new MinecraftKey("");
    private int x;
    private BiFunction<SuggestionsBuilder, Tags<Block>, CompletableFuture<Suggestions>> y = n;

    public ArgumentBlock(StringReader reader, boolean allowTag) {
        this.o = reader;
        this.p = allowTag;
    }

    public Map<IBlockState<?>, Comparable<?>> a() {
        return this.q;
    }

    @Nullable
    public IBlockData b() {
        return this.u;
    }

    @Nullable
    public NBTTagCompound c() {
        return this.v;
    }

    @Nullable
    public MinecraftKey d() {
        return this.w;
    }

    public ArgumentBlock a(boolean allowNbt) throws CommandSyntaxException {
        this.y = this::l;
        if (this.o.canRead() && this.o.peek() == '#') {
            this.f();
            this.y = this::i;
            if (this.o.canRead() && this.o.peek() == '[') {
                this.h();
                this.y = this::f;
            }
        } else {
            this.e();
            this.y = this::j;
            if (this.o.canRead() && this.o.peek() == '[') {
                this.g();
                this.y = this::f;
            }
        }
        if (allowNbt && this.o.canRead() && this.o.peek() == '{') {
            this.y = n;
            this.i();
        }
        return this;
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.d(builder, tagGroup);
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.e(builder, tagGroup);
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        String s2 = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (IBlockState<?> iblockstate : this.u.s()) {
            if (this.q.containsKey(iblockstate) || !iblockstate.f().startsWith(s2)) continue;
            builder.suggest(iblockstate.f() + "=");
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> e(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        Tag<Block> tag;
        String s2 = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (this.w != null && !this.w.a().isEmpty() && (tag = tagGroup.a(this.w)) != null) {
            for (Block block : tag.b()) {
                for (IBlockState<?> iblockstate : block.m().d()) {
                    if (this.r.containsKey(iblockstate.f()) || !iblockstate.f().startsWith(s2)) continue;
                    builder.suggest(iblockstate.f() + "=");
                }
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> f(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        if (builder.getRemaining().isEmpty() && this.a(tagGroup)) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private boolean a(Tags<Block> tagGroup) {
        Tag<Block> tag;
        if (this.u != null) {
            return this.u.m();
        }
        if (this.w != null && (tag = tagGroup.a(this.w)) != null) {
            for (Block block : tag.b()) {
                if (!block.n().m()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> g(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('='));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> h(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        if (builder.getRemaining().isEmpty() && this.q.size() < this.u.s().size()) {
            builder.suggest(String.valueOf(','));
        }
        return builder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder a(SuggestionsBuilder builder, IBlockState<T> property) {
        for (Comparable t0 : property.a()) {
            if (t0 instanceof Integer) {
                builder.suggest(((Integer)t0).intValue());
                continue;
            }
            builder.suggest(property.a(t0));
        }
        return builder;
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder builder, Tags<Block> tagGroup, String propertyName) {
        Tag<Block> tag;
        boolean flag = false;
        if (this.w != null && !this.w.a().isEmpty() && (tag = tagGroup.a(this.w)) != null) {
            block0: for (Block block : tag.b()) {
                IBlockState<?> iblockstate = block.m().a(propertyName);
                if (iblockstate != null) {
                    ArgumentBlock.a(builder, iblockstate);
                }
                if (flag) continue;
                for (IBlockState<?> iblockstate1 : block.m().d()) {
                    if (this.r.containsKey(iblockstate1.f())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            builder.suggest(String.valueOf(','));
        }
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> i(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        Tag<Block> tag;
        if (builder.getRemaining().isEmpty() && (tag = tagGroup.a(this.w)) != null) {
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator<Block> iterator = tag.b().iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = iterator.next()).m().d().isEmpty()) && (flag1 |= block.n().m()))) {
            }
            if (flag) {
                builder.suggest(String.valueOf('['));
            }
            if (flag1) {
                builder.suggest(String.valueOf('{'));
            }
        }
        return this.k(builder, tagGroup);
    }

    private CompletableFuture<Suggestions> j(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        if (builder.getRemaining().isEmpty()) {
            if (!this.u.b().m().d().isEmpty()) {
                builder.suggest(String.valueOf('['));
            }
            if (this.u.m()) {
                builder.suggest(String.valueOf('{'));
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> k(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        return ICompletionProvider.a(tagGroup.b(), builder.createOffset(this.x).add(builder));
    }

    private CompletableFuture<Suggestions> l(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        if (this.p) {
            ICompletionProvider.a(tagGroup.b(), builder, String.valueOf('#'));
        }
        ICompletionProvider.a(IRegistry.X.d(), builder);
        return builder.buildFuture();
    }

    public void e() throws CommandSyntaxException {
        int i2 = this.o.getCursor();
        this.s = MinecraftKey.a(this.o);
        Block block = IRegistry.X.b(this.s).orElseThrow(() -> {
            this.o.setCursor(i2);
            return b.createWithContext((ImmutableStringReader)this.o, (Object)this.s.toString());
        });
        this.t = block.m();
        this.u = block.n();
    }

    public void f() throws CommandSyntaxException {
        if (!this.p) {
            throw a.create();
        }
        this.y = this::k;
        this.o.expect('#');
        this.x = this.o.getCursor();
        this.w = MinecraftKey.a(this.o);
    }

    public void g() throws CommandSyntaxException {
        this.o.skip();
        this.y = this::b;
        this.o.skipWhitespace();
        while (this.o.canRead() && this.o.peek() != ']') {
            this.o.skipWhitespace();
            int i2 = this.o.getCursor();
            String s2 = this.o.readString();
            IBlockState<?> iblockstate = this.t.a(s2);
            if (iblockstate == null) {
                this.o.setCursor(i2);
                throw c.createWithContext((ImmutableStringReader)this.o, (Object)this.s.toString(), (Object)s2);
            }
            if (this.q.containsKey(iblockstate)) {
                this.o.setCursor(i2);
                throw d.createWithContext((ImmutableStringReader)this.o, (Object)this.s.toString(), (Object)s2);
            }
            this.o.skipWhitespace();
            this.y = this::g;
            if (!this.o.canRead() || this.o.peek() != '=') {
                throw f.createWithContext((ImmutableStringReader)this.o, (Object)this.s.toString(), (Object)s2);
            }
            this.o.skip();
            this.o.skipWhitespace();
            this.y = (suggestionsbuilder, tags) -> ArgumentBlock.a(suggestionsbuilder, iblockstate).buildFuture();
            int j2 = this.o.getCursor();
            this.a(iblockstate, this.o.readString(), j2);
            this.y = this::h;
            this.o.skipWhitespace();
            if (!this.o.canRead()) continue;
            if (this.o.peek() == ',') {
                this.o.skip();
                this.y = this::d;
                continue;
            }
            if (this.o.peek() == ']') break;
            throw g.createWithContext((ImmutableStringReader)this.o);
        }
        if (this.o.canRead()) {
            this.o.skip();
            return;
        }
        throw g.createWithContext((ImmutableStringReader)this.o);
    }

    public void h() throws CommandSyntaxException {
        this.o.skip();
        this.y = this::c;
        int i2 = -1;
        this.o.skipWhitespace();
        while (this.o.canRead() && this.o.peek() != ']') {
            this.o.skipWhitespace();
            int j2 = this.o.getCursor();
            String s2 = this.o.readString();
            if (this.r.containsKey(s2)) {
                this.o.setCursor(j2);
                throw d.createWithContext((ImmutableStringReader)this.o, (Object)this.s.toString(), (Object)s2);
            }
            this.o.skipWhitespace();
            if (!this.o.canRead() || this.o.peek() != '=') {
                this.o.setCursor(j2);
                throw f.createWithContext((ImmutableStringReader)this.o, (Object)this.s.toString(), (Object)s2);
            }
            this.o.skip();
            this.o.skipWhitespace();
            this.y = (suggestionsbuilder, tags) -> this.a((SuggestionsBuilder)suggestionsbuilder, (Tags<Block>)tags, s2);
            i2 = this.o.getCursor();
            String s1 = this.o.readString();
            this.r.put(s2, s1);
            this.o.skipWhitespace();
            if (!this.o.canRead()) continue;
            i2 = -1;
            if (this.o.peek() == ',') {
                this.o.skip();
                this.y = this::e;
                continue;
            }
            if (this.o.peek() == ']') break;
            throw g.createWithContext((ImmutableStringReader)this.o);
        }
        if (this.o.canRead()) {
            this.o.skip();
            return;
        }
        if (i2 >= 0) {
            this.o.setCursor(i2);
        }
        throw g.createWithContext((ImmutableStringReader)this.o);
    }

    public void i() throws CommandSyntaxException {
        this.v = new MojangsonParser(this.o).f();
    }

    private <T extends Comparable<T>> void a(IBlockState<T> property, String value, int cursor) throws CommandSyntaxException {
        Optional<T> optional = property.b(value);
        if (!optional.isPresent()) {
            this.o.setCursor(cursor);
            throw e.createWithContext((ImmutableStringReader)this.o, (Object)this.s.toString(), (Object)property.f(), (Object)value);
        }
        this.u = (IBlockData)this.u.a(property, (Comparable)optional.get());
        this.q.put(property, (Comparable)optional.get());
    }

    public static String a(IBlockData state) {
        StringBuilder stringbuilder = new StringBuilder(IRegistry.X.b(state.b()).toString());
        if (!state.s().isEmpty()) {
            stringbuilder.append('[');
            boolean flag = false;
            for (Map.Entry entry : state.t().entrySet()) {
                if (flag) {
                    stringbuilder.append(',');
                }
                ArgumentBlock.a(stringbuilder, (IBlockState)entry.getKey(), (Comparable)entry.getValue());
                flag = true;
            }
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> void a(StringBuilder builder, IBlockState<T> property, Comparable<?> value) {
        builder.append(property.f());
        builder.append('=');
        builder.append(property.a(value));
    }

    public CompletableFuture<Suggestions> a(SuggestionsBuilder builder, Tags<Block> tagGroup) {
        return this.y.apply(builder.createOffset(this.o.getCursor()), tagGroup);
    }

    public Map<String, String> j() {
        return this.r;
    }
}

