/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;

public interface ICompletionProvider {
    public Collection<String> l();

    default public Collection<String> r() {
        return Collections.emptyList();
    }

    public Collection<String> m();

    public Collection<MinecraftKey> n();

    public Stream<MinecraftKey> o();

    public CompletableFuture<Suggestions> a(CommandContext<ICompletionProvider> var1, SuggestionsBuilder var2);

    default public Collection<a> s() {
        return Collections.singleton(a.b);
    }

    default public Collection<a> t() {
        return Collections.singleton(a.b);
    }

    public Set<ResourceKey<World>> p();

    public IRegistryCustom q();

    public boolean c(int var1);

    public static <T> void a(Iterable<T> candidates, String remaining, Function<T, MinecraftKey> identifier, Consumer<T> action) {
        boolean bl = remaining.indexOf(58) > -1;
        for (T object : candidates) {
            MinecraftKey resourceLocation = identifier.apply(object);
            if (bl) {
                String string = resourceLocation.toString();
                if (!ICompletionProvider.a(remaining, string)) continue;
                action.accept(object);
                continue;
            }
            if (!ICompletionProvider.a(remaining, resourceLocation.b()) && (!resourceLocation.b().equals("minecraft") || !ICompletionProvider.a(remaining, resourceLocation.a()))) continue;
            action.accept(object);
        }
    }

    public static <T> void a(Iterable<T> candidates, String remaining, String prefix, Function<T, MinecraftKey> identifier, Consumer<T> action) {
        if (remaining.isEmpty()) {
            candidates.forEach(action);
        } else {
            String string = Strings.commonPrefix((CharSequence)remaining, (CharSequence)prefix);
            if (!string.isEmpty()) {
                String string2 = remaining.substring(string.length());
                ICompletionProvider.a(candidates, string2, identifier, action);
            }
        }
    }

    public static CompletableFuture<Suggestions> a(Iterable<MinecraftKey> candidates, SuggestionsBuilder builder, String prefix) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.a(candidates, string, prefix, id -> id, id -> builder.suggest(prefix + id));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> a(Iterable<MinecraftKey> candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.a(candidates, string, (T id) -> id, (T id) -> builder.suggest(id.toString()));
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> a(Iterable<T> candidates, SuggestionsBuilder builder, Function<T, MinecraftKey> identifier, Function<T, Message> tooltip) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.a(candidates, string, identifier, (T object) -> builder.suggest(((MinecraftKey)identifier.apply(object)).toString(), (Message)tooltip.apply(object)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> a(Stream<MinecraftKey> candidates, SuggestionsBuilder builder) {
        return ICompletionProvider.a(candidates::iterator, builder);
    }

    public static <T> CompletableFuture<Suggestions> a(Stream<T> candidates, SuggestionsBuilder builder, Function<T, MinecraftKey> identifier, Function<T, Message> tooltip) {
        return ICompletionProvider.a(candidates::iterator, builder, identifier, tooltip);
    }

    public static CompletableFuture<Suggestions> a(String remaining, Collection<a> candidates, SuggestionsBuilder builder, Predicate<String> predicate) {
        ArrayList list;
        block4: {
            String[] strings;
            block5: {
                block3: {
                    list = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)remaining)) break block3;
                    for (a textCoordinates : candidates) {
                        String string = textCoordinates.c + " " + textCoordinates.d + " " + textCoordinates.e;
                        if (!predicate.test(string)) continue;
                        list.add(textCoordinates.c);
                        list.add(textCoordinates.c + " " + textCoordinates.d);
                        list.add(string);
                    }
                    break block4;
                }
                strings = remaining.split(" ");
                if (strings.length != 1) break block5;
                for (a textCoordinates2 : candidates) {
                    String string2 = strings[0] + " " + textCoordinates2.d + " " + textCoordinates2.e;
                    if (!predicate.test(string2)) continue;
                    list.add(strings[0] + " " + textCoordinates2.d);
                    list.add(string2);
                }
                break block4;
            }
            if (strings.length != 2) break block4;
            for (a textCoordinates3 : candidates) {
                String string3 = strings[0] + " " + strings[1] + " " + textCoordinates3.e;
                if (!predicate.test(string3)) continue;
                list.add(string3);
            }
        }
        return ICompletionProvider.b(list, builder);
    }

    public static CompletableFuture<Suggestions> b(String remaining, Collection<a> candidates, SuggestionsBuilder builder, Predicate<String> predicate) {
        ArrayList list;
        block3: {
            block2: {
                list = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)remaining)) break block2;
                for (a textCoordinates : candidates) {
                    String string = textCoordinates.c + " " + textCoordinates.e;
                    if (!predicate.test(string)) continue;
                    list.add(textCoordinates.c);
                    list.add(string);
                }
                break block3;
            }
            String[] strings = remaining.split(" ");
            if (strings.length != 1) break block3;
            for (a textCoordinates2 : candidates) {
                String string2 = strings[0] + " " + textCoordinates2.e;
                if (!predicate.test(string2)) continue;
                list.add(string2);
            }
        }
        return ICompletionProvider.b(list, builder);
    }

    public static CompletableFuture<Suggestions> b(Iterable<String> candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : candidates) {
            if (!ICompletionProvider.a(string, string2.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string2);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> b(Stream<String> candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        candidates.filter(candidate -> ICompletionProvider.a(string, candidate.toLowerCase(Locale.ROOT))).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> a(String[] candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : candidates) {
            if (!ICompletionProvider.a(string, string2.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string2);
        }
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> b(Iterable<T> candidates, SuggestionsBuilder builder, Function<T, String> suggestionText, Function<T, Message> tooltip) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (T object : candidates) {
            String string2 = suggestionText.apply(object);
            if (!ICompletionProvider.a(string, string2.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string2, tooltip.apply(object));
        }
        return builder.buildFuture();
    }

    public static boolean a(String remaining, String candidate) {
        int i2 = 0;
        while (!candidate.startsWith(remaining, i2)) {
            if ((i2 = candidate.indexOf(95, i2)) < 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static class a {
        public static final a a = new a("^", "^", "^");
        public static final a b = new a("~", "~", "~");
        public final String c;
        public final String d;
        public final String e;

        public a(String x2, String y2, String z2) {
            this.c = x2;
            this.d = y2;
            this.e = z2;
        }
    }
}

